/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.db;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.filesys.DirectoryNotEmptyException;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.db.DBDeviceContext;
import org.alfresco.jlan.server.filesys.db.DBException;
import org.alfresco.jlan.server.filesys.db.DBFileInfo;
import org.alfresco.jlan.server.filesys.db.DBSearchContext;
import org.alfresco.jlan.server.filesys.db.RetentionDetails;
import org.alfresco.jlan.smb.server.ntfs.StreamInfo;
import org.alfresco.jlan.smb.server.ntfs.StreamInfoList;
import org.springframework.extensions.config.ConfigElement;

public interface DBInterface {
    public static final int FeatureNTFS = 1;
    public static final int FeatureRetention = 2;
    public static final int FeatureQueue = 4;
    public static final int FeatureData = 8;
    public static final int FeatureJarData = 16;
    public static final int FeatureObjectId = 32;
    public static final int FeatureSymLinks = 64;
    public static final int FeatureSecDescriptor = 128;
    public static final int FileNameOnly = 0;
    public static final int FileIds = 1;
    public static final int FileAll = 2;
    public static final int StreamNameOnly = 0;
    public static final int StreamIds = 1;
    public static final int StreamAll = 2;

    public String getDBInterfaceName();

    public boolean supportsFeature(int var1);

    public void requestFeatures(int var1) throws DBException;

    public void initializeDatabase(DBDeviceContext var1, ConfigElement var2) throws InvalidConfigurationException;

    public void shutdownDatabase(DBDeviceContext var1);

    public boolean isOnline();

    public int fileExists(int var1, String var2) throws DBException;

    public int createFileRecord(String var1, int var2, FileOpenParams var3, boolean var4) throws DBException, FileExistsException;

    public int createStreamRecord(String var1, int var2) throws DBException;

    public void deleteFileRecord(int var1, int var2, boolean var3) throws DBException, IOException, DirectoryNotEmptyException;

    public void deleteStreamRecord(int var1, int var2, boolean var3) throws DBException;

    public void setFileInformation(int var1, int var2, FileInfo var3) throws DBException;

    public void setStreamInformation(int var1, int var2, int var3, StreamInfo var4) throws DBException;

    public int getFileId(int var1, String var2, boolean var3, boolean var4) throws DBException;

    public DBFileInfo getFileInformation(int var1, int var2, int var3) throws DBException;

    public StreamInfo getStreamInformation(int var1, int var2, int var3) throws DBException;

    public StreamInfoList getStreamsList(int var1, int var2) throws DBException;

    public void renameFileRecord(int var1, int var2, String var3, int var4) throws DBException, FileNotFoundException;

    public void renameStreamRecord(int var1, int var2, int var3, String var4) throws DBException;

    public RetentionDetails getFileRetentionDetails(int var1, int var2) throws DBException;

    public DBSearchContext startSearch(int var1, String var2, int var3, int var4, int var5) throws DBException;

    public String readSymbolicLink(int var1, int var2) throws DBException;

    public void deleteSymbolicLinkRecord(int var1, int var2) throws DBException;

    public long getUsedFileSpace();
}

