/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.passthru;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.NetBIOSNameList;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.server.auth.passthru.AuthSessionFactory;
import org.alfresco.jlan.server.auth.passthru.AuthenticateSession;
import org.alfresco.jlan.server.auth.passthru.PassthruServerDetails;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.util.IPAddress;

public class PassthruServers {
    private static final int DefaultConnectTimeout = 5000;
    private static final long DefaultOfflineCheckInterval = 300000L;
    private List<PassthruServerDetails> m_onlineList;
    private List<PassthruServerDetails> m_offlineList;
    private int m_tmo = 5000;
    private String m_domain;
    private long m_offlineCheckInterval = 300000L;
    PassthruOfflineChecker m_offlineChecker;
    private boolean m_debug;
    private boolean m_nullDomainUseAnyServer;

    public PassthruServers() {
        this.commonInit();
    }

    public PassthruServers(int checkInterval) {
        this.m_offlineCheckInterval = (long)checkInterval * 1000L;
        this.commonInit();
    }

    private void commonInit() {
        this.m_onlineList = new ArrayList<PassthruServerDetails>();
        this.m_offlineList = new ArrayList<PassthruServerDetails>();
        this.m_offlineChecker = new PassthruOfflineChecker();
    }

    public final int getOnlineServerCount() {
        return this.m_onlineList.size();
    }

    public final int getOfflineServerCount() {
        return this.m_offlineList.size();
    }

    public final int getTotalServerCount() {
        return this.m_onlineList.size() + this.m_offlineList.size();
    }

    public final boolean hasOnlineServers() {
        return this.m_onlineList.size() > 0;
    }

    public final int getConnectionTimeout() {
        return this.m_tmo;
    }

    public final boolean isDomainAuthentication() {
        return this.m_domain != null;
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final boolean getNullDomainUseAnyServer() {
        return this.m_nullDomainUseAnyServer;
    }

    public final AuthenticateSession openSession() {
        return this.openSession(false, null);
    }

    public final AuthenticateSession openSession(boolean useExtSec, String clientDomain) {
        PassthruServerDetails passthruServer = null;
        passthruServer = clientDomain != null ? this.getAuthenticationServer(clientDomain) : this.getAuthenticationServer();
        if (passthruServer == null) {
            return null;
        }
        if (this.hasDebug()) {
            Debug.println("Open authenticate session to " + passthruServer + (clientDomain != null ? " (routed for client domain " + clientDomain + ")" : ""));
        }
        AuthenticateSession authSess = null;
        while (authSess == null && passthruServer != null && this.hasOnlineServers()) {
            PCShare authShare = new PCShare(passthruServer.getAddress().getHostAddress(), "IPC$", "", "");
            try {
                authSess = AuthSessionFactory.OpenAuthenticateSession(authShare, this.getConnectionTimeout());
                passthruServer.incrementAuthenticationCount();
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    Debug.println("Failed to connect to " + passthruServer + " : " + ex.getMessage());
                }
                this.serverOffline(passthruServer);
            }
            if (authSess != null) continue;
            passthruServer = this.getAuthenticationServer();
            if (!this.hasDebug()) continue;
            Debug.println("Trying authentication server " + passthruServer);
        }
        return authSess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PassthruServerDetails getAuthenticationServer() {
        PassthruServerDetails passthruServer = null;
        if (this.getNullDomainUseAnyServer()) {
            List<PassthruServerDetails> list = this.m_onlineList;
            synchronized (list) {
                if (this.m_onlineList.size() > 1) {
                    this.m_onlineList.add(this.m_onlineList.remove(0));
                }
                if (this.m_onlineList.size() > 0) {
                    passthruServer = this.m_onlineList.get(0);
                }
            }
        }
        List<PassthruServerDetails> list = this.m_onlineList;
        synchronized (list) {
            for (int idx = 0; idx < this.m_onlineList.size() && passthruServer == null; ++idx) {
                PassthruServerDetails curServer = this.m_onlineList.get(idx);
                if (curServer.getDomain() != null && curServer.getDomain().length() != 0) continue;
                passthruServer = curServer;
                this.m_onlineList.add(this.m_onlineList.remove(idx));
            }
        }
        return passthruServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PassthruServerDetails getAuthenticationServer(String clientDomain) {
        PassthruServerDetails passthruServer = null;
        List<PassthruServerDetails> list = this.m_onlineList;
        synchronized (list) {
            for (int idx = 0; idx < this.m_onlineList.size() && passthruServer == null; ++idx) {
                PassthruServerDetails curServer = this.m_onlineList.get(idx);
                if (curServer.getDomain() == null || !curServer.getDomain().equals(clientDomain)) continue;
                passthruServer = curServer;
                this.m_onlineList.add(this.m_onlineList.remove(idx));
            }
        }
        if (passthruServer == null) {
            Debug.println("No server found for domain " + clientDomain);
        }
        return passthruServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void serverOffline(PassthruServerDetails server) {
        server.setOnline(false);
        List<PassthruServerDetails> list = this.m_onlineList;
        synchronized (list) {
            this.m_onlineList.remove(server);
        }
        list = this.m_offlineList;
        synchronized (list) {
            this.m_offlineList.add(server);
        }
        if (this.hasDebug()) {
            Debug.println("Passthru server offline, " + server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void serverOnline(PassthruServerDetails server) {
        server.setOnline(true);
        List<PassthruServerDetails> list = this.m_offlineList;
        synchronized (list) {
            this.m_offlineList.remove(server);
        }
        list = this.m_onlineList;
        synchronized (list) {
            this.m_onlineList.add(server);
        }
        if (this.hasDebug()) {
            Debug.println("Passthru server online, " + server);
        }
    }

    public final void setConnectionTimeout(int tmo) {
        this.m_tmo = tmo;
    }

    public final void setOfflineCheckInterval(long interval) {
        this.m_offlineCheckInterval = interval * 1000L;
        this.m_offlineChecker.processOfflineServers();
    }

    public final void setServerList(String servers) {
        StringTokenizer tokens = new StringTokenizer(servers, ",");
        while (tokens.hasMoreTokens()) {
            InetAddress srvAddr;
            String domain;
            String srvName;
            block8: {
                srvName = tokens.nextToken().trim();
                domain = null;
                int pos = srvName.indexOf(92);
                if (pos != -1) {
                    domain = srvName.substring(0, pos);
                    srvName = srvName.substring(pos + 1);
                }
                srvAddr = null;
                if (IPAddress.isNumericAddress(srvName)) {
                    try {
                        srvAddr = InetAddress.getByName(srvName);
                        srvName = srvAddr.getHostName();
                    }
                    catch (UnknownHostException ex) {
                        if (this.hasDebug()) {
                            Debug.println("Passthru failed to find name/address for " + srvName);
                        }
                        break block8;
                    }
                }
                try {
                    srvAddr = InetAddress.getByName(srvName);
                }
                catch (UnknownHostException ex) {
                    if (!this.hasDebug()) break block8;
                    Debug.println("Passthru failed to find address for " + srvName);
                }
            }
            if (srvName == null || srvAddr == null) continue;
            PassthruServerDetails passthruServer = new PassthruServerDetails(srvName, domain, srvAddr, false);
            this.m_offlineList.add(passthruServer);
            if (!this.hasDebug()) continue;
            Debug.println("Added passthru server " + passthruServer);
        }
        this.m_offlineChecker.processOfflineServers();
    }

    public final void setDomain(String domain) throws IOException {
        if (this.hasDebug()) {
            Debug.println("Passthru finding domain controller for " + domain + " ...");
        }
        NetBIOSName nbName = null;
        try {
            nbName = NetBIOSSession.FindName(domain, '\u001c', this.getConnectionTimeout());
            if (this.hasDebug()) {
                Debug.println("  Found " + nbName.numberOfAddresses() + " domain controller(s)");
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (nbName == null) {
            try {
                nbName = NetBIOSSession.FindName(domain, '\u001d', this.getConnectionTimeout());
                if (this.hasDebug()) {
                    Debug.println("  Found browse master at " + nbName.getIPAddressString(0));
                }
            }
            catch (IOException ex) {
                throw new IOException("Failed to find domain controller or browse master for " + domain);
            }
        }
        for (int i = 0; i < nbName.numberOfAddresses(); ++i) {
            String dcName;
            InetAddress dcAddr;
            block14: {
                dcAddr = null;
                dcName = null;
                try {
                    dcAddr = InetAddress.getByName(nbName.getIPAddressString(i));
                    NetBIOSNameList nameList = NetBIOSSession.FindNamesForAddress(dcAddr.getHostAddress());
                    NetBIOSName dcNBName = nameList.findName(' ', false);
                    if (dcNBName != null) {
                        dcName = dcNBName.getName();
                    }
                }
                catch (UnknownHostException ex) {
                    if (this.hasDebug()) {
                        Debug.println("Invalid address for server " + nbName.getIPAddressString(i));
                    }
                }
                catch (Exception ex) {
                    dcName = dcAddr.getHostAddress();
                    if (!this.hasDebug()) break block14;
                    Debug.println("Failed to get NetBIOS name for server " + dcAddr);
                }
            }
            if (dcAddr == null) continue;
            PassthruServerDetails passthruServer = new PassthruServerDetails(dcName, domain, dcAddr, false);
            this.m_offlineList.add(passthruServer);
            if (!this.hasDebug()) continue;
            Debug.println("Added passthru server " + passthruServer);
        }
        this.m_offlineChecker.processOfflineServers();
    }

    public final void setNullDomainUseAnyServer(boolean nullDomain) {
        this.m_nullDomainUseAnyServer = nullDomain;
    }

    public final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    public final void shutdown() {
        this.m_offlineChecker.shutdownRequest();
        this.m_onlineList.clear();
        this.m_offlineList.clear();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        if (this.isDomainAuthentication()) {
            str.append("Domain:");
            str.append(this.getDomain());
        } else {
            str.append("Servers:");
        }
        str.append(",Online=");
        str.append(this.getOnlineServerCount());
        str.append(",Offline=");
        str.append(this.getOfflineServerCount());
        str.append(",nullDomain=");
        str.append(this.getNullDomainUseAnyServer() ? "On" : "Off");
        str.append("]");
        return str.toString();
    }

    class PassthruOfflineChecker
    extends Thread {
        private boolean m_ishutdown;

        PassthruOfflineChecker() {
            this.setDaemon(true);
            this.setName("PassthruOfflineChecker");
            this.start();
        }

        @Override
        public void run() {
            this.m_ishutdown = false;
            while (!this.m_ishutdown) {
                try {
                    PassthruOfflineChecker.sleep(PassthruServers.this.m_offlineCheckInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (this.m_ishutdown || PassthruServers.this.getOfflineServerCount() <= 0) continue;
                int idx = 0;
                PassthruServerDetails offlineServer = null;
                PCShare authShare = new PCShare("", "IPC$", "", "");
                AuthenticateSession authSess = null;
                while (idx < PassthruServers.this.getOfflineServerCount()) {
                    block9: {
                        offlineServer = (PassthruServerDetails)PassthruServers.this.m_offlineList.get(idx);
                        if (offlineServer == null) continue;
                        try {
                            authShare.setNodeName(offlineServer.getAddress().getHostAddress());
                            authSess = AuthSessionFactory.OpenAuthenticateSession(authShare, PassthruServers.this.getConnectionTimeout());
                            try {
                                authSess.CloseSession();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            PassthruServers.this.serverOnline(offlineServer);
                        }
                        catch (Exception ex) {
                            if (!PassthruServers.this.hasDebug()) break block9;
                            Debug.println("Passthru offline check failed for " + offlineServer.getName());
                        }
                    }
                    if (offlineServer.isOnline()) continue;
                    ++idx;
                }
            }
            if (PassthruServers.this.hasDebug()) {
                Debug.println("Passthru offline checker thread closed");
            }
        }

        public final void shutdownRequest() {
            this.m_ishutdown = true;
            this.interrupt();
        }

        public final void processOfflineServers() {
            this.interrupt();
        }
    }
}

