/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.asn;

import java.io.IOException;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERObject;

public class DERBitString
extends DERObject {
    private long m_bits;

    public DERBitString() {
    }

    public DERBitString(long bits) {
        this.m_bits = bits;
    }

    public final long getValue() {
        return this.m_bits;
    }

    public final int intValue() {
        return (int)this.m_bits;
    }

    @Override
    public void derDecode(DERBuffer buf) throws IOException {
        if (buf.unpackType() == 3) {
            int len = buf.unpackLength();
            int lastBits = buf.unpackByte();
            this.m_bits = 0L;
            long curByt = 0L;
            for (int idx = --len - 1; idx >= 0; --idx) {
                curByt = buf.unpackByte();
                this.m_bits += curByt << idx * 8;
            }
        } else {
            throw new IOException("Wrong DER type, expected BitString");
        }
    }

    @Override
    public void derEncode(DERBuffer buf) throws IOException {
        buf.packByte(3);
        buf.packByte(0);
        buf.packLength(8);
        for (int idx = 7; idx >= 0; --idx) {
            long bytVal = this.m_bits >> idx * 8;
            buf.packByte((int)(this.m_bits & 0xFFL));
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[BitString:0x");
        str.append(Long.toHexString(this.m_bits));
        str.append("]");
        return str.toString();
    }
}

