/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import org.alfresco.jlan.client.AuthenticateSession;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.CIFSPipeSession;
import org.alfresco.jlan.client.CIFSPrintSession;
import org.alfresco.jlan.client.CoreDiskSession;
import org.alfresco.jlan.client.CorePrintSession;
import org.alfresco.jlan.client.DataPipeFile;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.IPCSession;
import org.alfresco.jlan.client.PasswordEncryptor;
import org.alfresco.jlan.client.PrintSession;
import org.alfresco.jlan.client.SMBPacket;
import org.alfresco.jlan.client.Session;
import org.alfresco.jlan.client.SessionSettings;
import org.alfresco.jlan.client.TcpipSMBNetworkSession;
import org.alfresco.jlan.client.admin.AdminSession;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.client.info.RAPServerInfo;
import org.alfresco.jlan.client.info.ServerList;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.NetBIOSNameList;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.netbios.NetworkSession;
import org.alfresco.jlan.smb.Dialect;
import org.alfresco.jlan.smb.DialectSelector;
import org.alfresco.jlan.smb.NTTime;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.Protocol;
import org.alfresco.jlan.smb.SMBErrorText;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.smb.UnknownLocalDomainException;
import org.alfresco.jlan.smb.UnsupportedDeviceTypeException;
import org.alfresco.jlan.smb.dcerpc.info.WorkstationInfo;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.HexDump;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.jlan.util.StringList;

public final class SessionFactory {
    private static final int BROADCAST_LOOKUP_TIMEOUT = 4000;
    private static int m_sessIdx;
    private static String m_localDomain;
    private static String m_localBrowseMaster;
    private static int m_defPktSize;
    private static InetAddress[] m_localAddrList;
    private static PasswordEncryptor m_encryptor;
    private static boolean m_smbSigningEnabled;
    private static boolean m_smbSigningCheckRx;
    private static String m_defUserName;
    private static String m_defPassword;
    private static String m_defDomain;
    private static SessionSettings m_defaultSettings;
    private static boolean m_debug;
    private static boolean m_localChecked;
    private static boolean m_globalPID;

    private static final StringList BuildNegotiatePacket(SMBPacket pkt, DialectSelector dlct, int pid) {
        pkt.setCommand(114);
        pkt.setProcessId(pid);
        int flags2 = 0;
        if (dlct.hasDialect(7)) {
            flags2 += 32768;
        }
        if (SessionFactory.isSMBSigningEnabled()) {
            flags2 += 4;
        }
        pkt.setFlags2(flags2);
        StringBuffer dia = new StringBuffer();
        StringList vec = new StringList();
        for (int d = 0; d < 8; ++d) {
            if (!dlct.hasDialect(d)) continue;
            for (int i = 0; i < Dialect.NumberOfDialects(); ++i) {
                if (Dialect.DialectType(i) != d) continue;
                String curDialect = Dialect.DialectString(i);
                vec.addString(curDialect);
                dia.append('\u0002');
                dia.append(curDialect);
                dia.append('\u0000');
            }
        }
        pkt.setBytes(dia.toString().getBytes());
        return vec;
    }

    private static void CheckLocalNode() {
        try {
            m_localChecked = true;
            PCShare shr = new PCShare(InetAddress.getLocalHost().getHostName().toUpperCase(), "IPC$", SessionFactory.getDefaultUserName(), SessionFactory.getDefaultPassword());
            AdminSession admSess = SessionFactory.OpenAdminSession(shr);
            WorkstationInfo wrkInfo = admSess.getWorkstationInfo();
            if (wrkInfo != null) {
                m_localDomain = wrkInfo.getDomain();
            }
            admSess.CloseSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final int ConnectDevice(PCShare shr, Session sess, int devtyp) throws IOException, UnsupportedDeviceTypeException, SMBException {
        if (SessionFactory.hasSessionDebug()) {
            Debug.println("** Connecting to " + shr.getNodeName() + " " + shr.getShareName() + " (" + shr.getUserName() + "/********)");
        }
        SMBPacket pkt = new SMBPacket();
        pkt.setProcessId(sess.getProcessId());
        pkt.setFlags(sess.getDefaultFlags());
        pkt.setFlags2(sess.getDefaultFlags2());
        pkt.setUserId(sess.getUserId());
        if (pkt.isUnicode()) {
            pkt.setCommand(117);
            pkt.setParameterCount(4);
            pkt.setAndXCommand(255);
            pkt.setParameter(1, 0);
            pkt.setParameter(2, 0);
            pkt.setParameter(3, 1);
            pkt.resetBytePointer();
            pkt.packByte(0);
            StringBuffer uncPath = new StringBuffer();
            uncPath.append("\\\\");
            uncPath.append(shr.getNodeName());
            uncPath.append("\\");
            uncPath.append(shr.getShareName());
            pkt.packString(uncPath.toString(), true);
            switch (devtyp) {
                case 0: {
                    pkt.packString("A:", false);
                    break;
                }
                case 1: {
                    pkt.packString("LPT1:", false);
                    break;
                }
                case 3: {
                    pkt.packString("IPC", false);
                }
            }
            pkt.setByteCount();
        } else {
            pkt.setCommand(112);
            pkt.setParameterCount(0);
            StringBuffer shrbuf = new StringBuffer();
            shrbuf.append('\u0004');
            shrbuf.append("\\\\");
            shrbuf.append(shr.getNodeName().toUpperCase());
            shrbuf.append("\\");
            shrbuf.append(shr.getShareName().toUpperCase());
            shrbuf.append('\u0000');
            shrbuf.append('\u0004');
            shrbuf.append(shr.getPassword());
            shrbuf.append('\u0000');
            shrbuf.append('\u0004');
            switch (devtyp) {
                case 0: {
                    shrbuf.append("A:");
                    break;
                }
                case 1: {
                    shrbuf.append("LPT1:");
                    break;
                }
                case 3: {
                    shrbuf.append("IPC");
                }
            }
            shrbuf.append('\u0000');
            pkt.setBytes(shrbuf.toString().getBytes());
        }
        pkt.ExchangeSMB(sess, pkt);
        if (pkt.isValidResponse()) {
            if (pkt.getCommand() == 112 && pkt.getParameterCount() == 2) {
                return pkt.getParameter(1);
            }
            if (pkt.getCommand() == 117 && pkt.getParameterCount() == 3) {
                return pkt.getTreeId();
            }
        }
        if (pkt.isLongErrorCode()) {
            throw new SMBException(6, pkt.getLongErrorCode());
        }
        throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
    }

    /*
     * Unable to fully structure code
     */
    private static final void ConnectSession(PCShare shr, Session sess, SMBPacket negpkt, SessionSettings settings) throws IOException, SMBException {
        sess.setProcessId(negpkt.getProcessId());
        keyLen = 0;
        unicodeStr = false;
        encAlgorithm = 0;
        defFlags2 = 0;
        if (sess.getDialect() == 7) {
            negpkt.resetParameterPointer();
            negpkt.skipBytes(2);
            sess.setSecurityMode(negpkt.unpackByte());
            sess.setMaximumMultiplexedRequests(negpkt.unpackWord());
            sess.setMaximumVirtualCircuits(negpkt.unpackWord());
            sess.setMaximumPacketSize(negpkt.unpackInt());
            negpkt.skipBytes(8);
            sess.setCapabilities(negpkt.unpackInt());
            srvTime = NTTime.toSMBDate(negpkt.unpackLong());
            tzone = negpkt.unpackWord();
            keyLen = negpkt.unpackByte();
            unicodeStr = true;
            encAlgorithm = 1;
            defFlags2 = 16385;
            if (sess.supportsUnicode()) {
                defFlags2 += 32768;
            }
            if (SessionFactory.isSMBSigningEnabled()) {
                defFlags2 += 4;
            }
        } else if (sess.getDialect() > 1) {
            secMode = negpkt.getParameter(1);
            sess.setSecurityMode((secMode & 1) != 0 ? 1 : 2);
            if (negpkt.getParameterCount() >= 11) {
                keyLen = negpkt.getParameter(11) & 255;
            }
            sess.setMaximumMultiplexedRequests(negpkt.getParameter(3));
            sess.setMaximumVirtualCircuits(negpkt.getParameter(4));
            if (negpkt.isUnicode()) {
                unicodeStr = true;
            }
            defFlags2 = 1;
        }
        sess.setDefaultFlags2(defFlags2);
        if (negpkt.getByteCount() > 0) {
            bytsiz = negpkt.getByteCount();
            bytpos = negpkt.getByteOffset();
            buf = negpkt.getBuffer();
            if (keyLen > 0) {
                encryptKey = new byte[keyLen];
                System.arraycopy(buf, bytpos, encryptKey, 0, keyLen);
                bytpos += keyLen;
                sess.setEncryptionKey(encryptKey);
                if (Session.hasDebugOption(2)) {
                    Debug.print("** Encryption Key: ");
                    Debug.print(HexDump.hexString(encryptKey));
                    Debug.println(", length = " + keyLen);
                }
            }
            dom = unicodeStr == false ? DataPacker.getString(buf, bytpos, bytsiz) : DataPacker.getUnicodeString(buf, bytpos, bytsiz / 2);
            sess.setDomain(dom);
            if (Session.hasDebugOption(2)) {
                Debug.println("** Server domain : " + sess.getDomain() + ".");
            }
        }
        password = null;
        if (sess.hasEncryptionKey() && !shr.isNullLogon()) {
            try {
                password = SessionFactory.m_encryptor.generateEncryptedPassword(sess.getPassword(), sess.getEncryptionKey(), encAlgorithm);
                if (Session.hasDebugOption(2)) {
                    Debug.print("** Encrypted Password (");
                    Debug.print(PasswordEncryptor.getAlgorithmName(encAlgorithm));
                    Debug.print(") : ");
                    Debug.println(HexDump.hexString(password));
                }
                if ((defFlags2 & 4) == 0) ** GOTO lbl72
                sessKey = SessionFactory.m_encryptor.generateSessionKey(sess.getPassword(), sess.getEncryptionKey(), 1);
                sess.enableSMBSigning(sessKey);
                if (!Session.hasDebugOption(8)) ** GOTO lbl72
                Debug.print("** SMB signing enabled, session key=" + HexDump.hexString(sessKey, " "));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IOException("Missing security provider - " + ex.toString());
            }
        } else {
            password = sess.getPassword().getBytes();
        }
lbl72:
        // 4 sources

        pkt = new SMBPacket();
        pkt.setCommand(115);
        pkt.setFlags(sess.getDefaultFlags());
        pkt.setFlags2(sess.getDefaultFlags2());
        if (sess.getDialect() == 7) {
            pkt.setParameterCount(13);
            pkt.setAndXCommand(255);
            pkt.setParameter(1, 0);
            pkt.setParameter(2, SessionFactory.DefaultPacketSize());
            pkt.setParameter(3, sess.getMaximumMultiplexedRequests());
            pkt.setParameter(4, settings.getVirtualCircuit());
            pkt.setParameterLong(5, 0);
            pkt.setParameter(7, shr.isNullLogon() != false ? 1 : 0);
            pkt.setParameter(8, shr.isNullLogon() != false ? 0 : password.length);
            pkt.setParameter(9, 0);
            pkt.setParameter(10, 0);
            caps = 124;
            pkt.setParameterLong(11, caps);
            pkt.setPosition(pkt.getByteOffset());
            if (shr.isNullLogon()) {
                pos = pkt.getByteOffset();
                pkt.getBuffer()[pos++] = 0;
                pkt.setPosition(pos);
            } else {
                pkt.packBytes(password, password.length);
            }
            pkt.packString(shr.getUserName(), sess.supportsUnicode());
            if (shr.isNullLogon()) {
                pkt.packString("", sess.supportsUnicode());
            } else if (shr.hasDomain()) {
                pkt.packString(shr.getDomain(), sess.supportsUnicode());
            } else {
                pkt.packString(SessionFactory.getDefaultDomain(), sess.supportsUnicode());
            }
            pkt.packString("Java VM", sess.supportsUnicode());
            pkt.packString("Alfresco-JLAN", sess.supportsUnicode());
            pkt.setByteCount();
        } else {
            pkt.setUserId(1);
            pkt.setParameterCount(10);
            pkt.setAndXCommand(255);
            pkt.setParameter(1, 0);
            pkt.setParameter(2, SessionFactory.DefaultPacketSize());
            pkt.setParameter(3, 2);
            pkt.setParameter(4, 0);
            pkt.setParameter(5, 0);
            pkt.setParameter(6, 0);
            pkt.setParameter(7, shr.isNullLogon() != false ? 0 : password.length);
            pkt.setParameter(8, 0);
            pkt.setParameter(9, 0);
            buf = pkt.getBuffer();
            pos = pkt.getByteOffset();
            if (shr.isNullLogon()) {
                buf[pos++] = 0;
            } else {
                for (i = 0; i < password.length; ++i) {
                    buf[pos++] = password[i];
                }
            }
            clbuf = new StringBuffer();
            clbuf.append(shr.getUserName());
            clbuf.append('\u0000');
            if (shr.isNullLogon()) {
                clbuf.append("");
            } else if (shr.hasDomain()) {
                clbuf.append(shr.getDomain());
            } else {
                clbuf.append(SessionFactory.getDefaultDomain());
            }
            clbuf.append('\u0000');
            clbuf.append("Java VM");
            clbuf.append('\u0000');
            clbuf.append("Alfresco-JLAN");
            clbuf.append('\u0000');
            byts = clbuf.toString().getBytes();
            for (i = 0; i < byts.length; ++i) {
                buf[pos++] = byts[i];
            }
            pkt.setByteCount(password.length + byts.length);
        }
        pkt.setProcessId(sess.getProcessId());
        pkt.ExchangeSMB(sess, pkt, true);
        sess.setUserId(pkt.getUserId());
        if (pkt.hasSecuritySignature()) {
            // empty if block
        }
        if (pkt.getParameterCount() >= 3) {
            sess.setGuest(pkt.getParameter(2) != 0);
        }
        if (pkt.getByteCount() > 0) {
            pkt.setPosition(pkt.getByteOffset());
            srvOS = pkt.unpackString(unicodeStr);
            sess.setOperatingSystem(srvOS);
            lanman = pkt.unpackString(unicodeStr);
            sess.setLANManagerType(lanman);
            domain = pkt.unpackString(unicodeStr);
            if (domain != null && domain.length() > 0 && (sess.getDomain() == null || sess.getDomain().length() == 0)) {
                sess.setDomain(domain);
            }
        }
        if (sess.getDialect() == 0 || sess.getDialect() == 1) {
            sess.setMaximumPacketSize(pkt.getParameter(2));
        }
    }

    private static final DiskSession CreateDiskSession(PCShare shr, SMBPacket pkt, NetworkSession netSess, int dialect, SessionSettings settings) throws IOException, SMBException {
        DiskSession sess;
        if (dialect == 0 || dialect == 1) {
            sess = new CoreDiskSession(shr, dialect);
        } else {
            sess = new CIFSDiskSession(shr, dialect);
            sess.setMaximumPacketSize(pkt.getParameter(2));
        }
        sess.setSession(netSess);
        SessionFactory.ConnectSession(shr, sess, pkt, settings);
        try {
            int treeId = SessionFactory.ConnectDevice(shr, sess, 0);
            if (treeId != -1) {
                sess.setTreeId(treeId);
                return sess;
            }
        }
        catch (UnsupportedDeviceTypeException ex) {
            // empty catch block
        }
        return null;
    }

    private static final IPCSession CreatePipeSession(PCShare shr, SMBPacket pkt, NetworkSession netSess, int dialect, SessionSettings settings) throws IOException, SMBException {
        CIFSPipeSession sess = new CIFSPipeSession(shr, dialect);
        sess.setSession(netSess);
        if (dialect > 1) {
            sess.setMaximumPacketSize(pkt.getParameter(2));
        }
        SessionFactory.ConnectSession(shr, sess, pkt, settings);
        try {
            int treeId = SessionFactory.ConnectDevice(shr, sess, 3);
            if (treeId != -1) {
                sess.setTreeId(treeId);
                return sess;
            }
        }
        catch (UnsupportedDeviceTypeException ex) {
            // empty catch block
        }
        return null;
    }

    private static final PrintSession CreatePrinterSession(PCShare shr, SMBPacket pkt, NetworkSession netSess, int dialect, SessionSettings settings) throws IOException, SMBException {
        PrintSession sess = null;
        if (dialect == 0 || dialect == 1) {
            sess = new CorePrintSession(shr, dialect);
        } else {
            sess = new CIFSPrintSession(shr, dialect);
            sess.setMaximumPacketSize(pkt.getParameter(2));
        }
        sess.setSession(netSess);
        SessionFactory.ConnectSession(shr, sess, pkt, settings);
        try {
            int treeId = SessionFactory.ConnectDevice(shr, sess, 1);
            if (treeId != -1) {
                sess.setTreeId(treeId);
                return sess;
            }
        }
        catch (UnsupportedDeviceTypeException ex) {
            // empty catch block
        }
        return null;
    }

    private static final Session CreateSession(PCShare shr, SMBPacket pkt, NetworkSession netSess, int dialect, SessionSettings settings) throws IOException, SMBException {
        Session sess = new Session(shr, dialect, null);
        sess.setSession(netSess);
        SessionFactory.ConnectSession(shr, sess, pkt, settings);
        return sess;
    }

    protected static final int DefaultPacketSize() {
        return m_defPktSize;
    }

    public static final void disableDebug() {
        m_debug = false;
    }

    public static final void disableDialect(int d) {
        if (m_defaultSettings.getDialects().hasDialect(d)) {
            m_defaultSettings.getDialects().RemoveDialect(d);
        }
    }

    public static final void enableDebug() {
        m_debug = true;
    }

    public static final void enableDialect(int d) {
        if (m_defaultSettings.getDialects().hasDialect(d)) {
            return;
        }
        m_defaultSettings.getDialects().AddDialect(d);
    }

    public static final NetBIOSName findBrowseMaster() throws SMBException, IOException {
        int retry = 0;
        NetBIOSName netName = null;
        while (retry++ < 5 && netName == null) {
            try {
                netName = NetBIOSSession.FindName("\u0001\u0002__MSBROWSE__\u0002", '\u0001', 4000);
            }
            catch (Exception exception) {}
        }
        return netName;
    }

    public static final DialectSelector getDefaultDialects() {
        return m_defaultSettings.getDialects();
    }

    public static String getDefaultDomain() {
        return m_defDomain;
    }

    public static String getDefaultPassword() {
        return m_defPassword;
    }

    public static String getDefaultUserName() {
        return m_defUserName;
    }

    public static SessionSettings getDefaultSettings() {
        return m_defaultSettings;
    }

    public static final ServerList getDomainList() throws SMBException, IOException {
        PCShare admShr = null;
        AdminSession admSess = null;
        try {
            String localHost = InetAddress.getLocalHost().getHostAddress();
            admShr = new PCShare(localHost, "", SessionFactory.getDefaultUserName(), SessionFactory.getDefaultPassword());
            admSess = SessionFactory.OpenAdminSession(admShr);
            ServerList domList = admSess.getServerList(Integer.MIN_VALUE);
            admSess.CloseSession();
            return domList;
        }
        catch (SMBException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        NetBIOSName browseMaster = NetBIOSSession.FindName("\u0001\u0002__MSBROWSE__\u0002", '\u0001', 2000);
        if (browseMaster == null) {
            return null;
        }
        String browseAddr = null;
        if (browseMaster.numberOfAddresses() > 1) {
            int addrIdx = browseMaster.findBestMatchAddress(SessionFactory.getLocalTcpipAddresses());
            if (addrIdx != -1) {
                browseAddr = browseMaster.getIPAddressString(addrIdx);
            }
        } else {
            browseAddr = browseMaster.getIPAddressString(0);
        }
        admShr = new PCShare(browseAddr, "", SessionFactory.getDefaultUserName(), SessionFactory.getDefaultPassword());
        admSess = SessionFactory.OpenAdminSession(admShr);
        ServerList domList = null;
        try {
            domList = admSess.getServerList(Integer.MIN_VALUE);
        }
        catch (SMBException ex) {
            domList = new ServerList();
            domList.addServerInfo(new RAPServerInfo(admSess.getSession().getDomain(), true));
        }
        admSess.CloseSession();
        return domList;
    }

    private String getLocalBrowser() {
        return m_localBrowseMaster;
    }

    public static String getLocalDomain() {
        if (!m_localChecked) {
            SessionFactory.CheckLocalNode();
        }
        return m_localDomain;
    }

    public static ServerList getLocalServerList() throws SMBException, IOException, UnknownLocalDomainException {
        if (!m_localChecked) {
            SessionFactory.CheckLocalNode();
        }
        if (SessionFactory.getLocalDomain().length() == 0) {
            throw new UnknownLocalDomainException();
        }
        return SessionFactory.getServerList(SessionFactory.getLocalDomain());
    }

    public static String getNetBIOSNameScope() {
        return m_defaultSettings.getNetBIOSNameScope();
    }

    public static int getNetBIOSPort() {
        return m_defaultSettings.getNetBIOSSessionPort();
    }

    public static final int getPrimaryProtocol() {
        return m_defaultSettings.getPrimaryProtocol();
    }

    public static final int getSecondaryProtocol() {
        return m_defaultSettings.getSecondaryProtocol();
    }

    public static final ServerList getServerList(String domnam) throws IOException, SMBException {
        return SessionFactory.getServerList(domnam, 0xFFFFFFF);
    }

    public static final ServerList getServerList(String domnam, int srvFlags) throws SMBException, IOException {
        String browseMaster;
        AdminSession admSess;
        PCShare admShr;
        block17: {
            admShr = null;
            admSess = null;
            browseMaster = null;
            try {
                String localHost = InetAddress.getLocalHost().getHostAddress();
                admShr = new PCShare(localHost, "", SessionFactory.getDefaultUserName(), SessionFactory.getDefaultPassword());
                admSess = SessionFactory.OpenAdminSession(admShr);
                if (admSess.getSession().getDomain() != null && admSess.getSession().getDomain().compareTo(domnam) == 0) {
                    ServerList srvList = admSess.getServerList(srvFlags & 0xFFFFFFF);
                    admSess.CloseSession();
                    return srvList;
                }
                ServerList domList = admSess.getServerList(Integer.MIN_VALUE);
                if (domList != null) {
                    int i = 0;
                    while (i < domList.NumberOfServers() && browseMaster == null) {
                        RAPServerInfo srvInfo = domList.getServerInfo(i);
                        if (srvInfo.getServerName().compareTo(domnam) == 0 && srvInfo.getComment().length() > 0) {
                            browseMaster = srvInfo.getComment();
                            continue;
                        }
                        ++i;
                    }
                    if (browseMaster != null && browseMaster.compareTo(localHost) != 0) {
                        admSess.CloseSession();
                        admSess = null;
                    }
                }
            }
            catch (SMBException ex) {
                if (SessionFactory.hasDebug()) {
                    Debug.println("getServerList (): " + ex.toString());
                }
                if (admSess != null) {
                    admSess.CloseSession();
                    admSess = null;
                }
            }
            catch (IOException ex) {
                if (SessionFactory.hasDebug()) {
                    Debug.println("getServerList (): " + ex.toString());
                }
                if (admSess == null) break block17;
                admSess.CloseSession();
                admSess = null;
            }
        }
        if (browseMaster == null) {
            int retry = 0;
            while (retry++ < 5 && browseMaster == null) {
                try {
                    NetBIOSName netName = NetBIOSSession.FindName(domnam.toUpperCase(), '\u001d', 4000);
                    if (netName == null) continue;
                    if (netName.numberOfAddresses() > 1) {
                        int addrIdx = netName.findBestMatchAddress(SessionFactory.getLocalTcpipAddresses());
                        if (addrIdx == -1) continue;
                        browseMaster = netName.getIPAddressString(addrIdx);
                        continue;
                    }
                    browseMaster = netName.getIPAddressString(0);
                }
                catch (Exception ex) {}
            }
        }
        if (admSess == null) {
            admShr = new PCShare(browseMaster, "", SessionFactory.getDefaultUserName(), SessionFactory.getDefaultPassword());
            admSess = SessionFactory.OpenAdminSession(admShr);
        }
        ServerList srvList = admSess.getServerList(srvFlags & 0xFFFFFFF);
        admSess.CloseSession();
        return srvList;
    }

    private static synchronized int getSessionId() {
        int sessId = m_sessIdx++ + NetBIOSSession.getJVMIndex() * 100;
        return sessId;
    }

    private static synchronized InetAddress[] getLocalTcpipAddresses() {
        if (m_localAddrList == null) {
            try {
                m_localAddrList = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return m_localAddrList;
    }

    public static final boolean hasDebug() {
        return m_debug;
    }

    public static final boolean hasGlobalProcessId() {
        return m_globalPID;
    }

    public static final boolean hasNetBIOSNameScope() {
        return m_defaultSettings.hasNetBIOSNameScope();
    }

    public static final boolean hasSessionDebug() {
        return Session.hasDebug();
    }

    public static final boolean isSMBSigningEnabled() {
        return m_smbSigningEnabled;
    }

    public static final boolean isReceivedSMBSigningEnabled() {
        return m_smbSigningCheckRx;
    }

    public static final String isVersion() {
        return "4.0.0";
    }

    public static final AdminSession OpenAdminSession(PCShare shr) throws IOException, UnknownHostException, SMBException {
        return SessionFactory.OpenAdminSession(shr, SessionFactory.getDefaultSettings());
    }

    public static final AdminSession OpenAdminSession(PCShare shr, SessionSettings settings) throws IOException, UnknownHostException, SMBException {
        shr.setShareName("IPC$");
        IPCSession sess = (IPCSession)SessionFactory.OpenSession(shr, 3, settings);
        return new AdminSession(sess);
    }

    public static final DiskSession OpenDisk(PCShare shr) throws IOException, UnknownHostException, SMBException {
        return (DiskSession)SessionFactory.OpenSession(shr, 0, SessionFactory.getDefaultSettings());
    }

    public static final DiskSession OpenDisk(PCShare shr, SessionSettings settings) throws IOException, UnknownHostException, SMBException {
        return (DiskSession)SessionFactory.OpenSession(shr, 0, settings);
    }

    public static final DiskSession OpenDisk(PCShare shr, Session sess) throws IOException, UnknownHostException, SMBException {
        DiskSession diskSess;
        if (sess.getDialect() == 0 || sess.getDialect() == 1) {
            diskSess = new CoreDiskSession(shr, sess.getDialect());
        } else {
            diskSess = new CIFSDiskSession(shr, sess.getDialect());
            diskSess.setMaximumPacketSize(sess.getMaximumPacketSize());
        }
        diskSess.setSession(sess.getSession());
        diskSess.setUserId(sess.getUserId());
        diskSess.setProcessId(sess.getProcessId());
        try {
            int treeId = SessionFactory.ConnectDevice(shr, sess, 0);
            if (treeId != -1) {
                diskSess.setTreeId(treeId);
                return diskSess;
            }
        }
        catch (UnsupportedDeviceTypeException unsupportedDeviceTypeException) {
            // empty catch block
        }
        return null;
    }

    public static final IPCSession OpenPipe(PCShare shr) throws IOException, UnknownHostException, SMBException {
        return (IPCSession)SessionFactory.OpenSession(shr, 3, SessionFactory.getDefaultSettings());
    }

    public static final IPCSession OpenPipe(PCShare shr, SessionSettings settings) throws IOException, UnknownHostException, SMBException {
        return (IPCSession)SessionFactory.OpenSession(shr, 3, settings);
    }

    public static final DataPipeFile OpenDataPipe(PCShare shr, String pipeName) throws IOException, UnknownHostException, SMBException {
        return SessionFactory.OpenDataPipe(shr, pipeName, SessionFactory.getDefaultSettings());
    }

    public static final DataPipeFile OpenDataPipe(PCShare shr, String pipeName, SessionSettings settings) throws IOException, UnknownHostException, SMBException {
        IPCSession sess = (IPCSession)SessionFactory.OpenSession(shr, 3, settings);
        if (sess.getDialect() != 7) {
            throw new SMBException(4, 50);
        }
        SMBPacket smbPkt = sess.m_pkt;
        smbPkt.setFlags(sess.getDefaultFlags());
        smbPkt.setFlags2(sess.getDefaultFlags2());
        smbPkt.setCommand(162);
        smbPkt.setUserId(sess.getUserId());
        smbPkt.setTreeId(sess.getTreeId());
        smbPkt.setParameterCount(24);
        smbPkt.resetParameterPointer();
        smbPkt.packByte(255);
        smbPkt.packByte(0);
        smbPkt.packWord(0);
        smbPkt.packByte(0);
        smbPkt.packWord(pipeName.length() * 2 + 2);
        smbPkt.packInt(0);
        smbPkt.packInt(0);
        smbPkt.packInt(3);
        smbPkt.packLong(0L);
        smbPkt.packInt(0);
        smbPkt.packInt(3);
        smbPkt.packInt(1);
        smbPkt.packInt(0);
        smbPkt.packInt(2);
        smbPkt.packByte(0);
        smbPkt.resetBytePointer();
        smbPkt.packString(pipeName, smbPkt.isUnicode());
        smbPkt.setByteCount();
        smbPkt.ExchangeSMB(sess, smbPkt, true);
        smbPkt.resetParameterPointer();
        smbPkt.skipBytes(5);
        int fid = smbPkt.unpackWord();
        int createAction = smbPkt.unpackInt();
        long createTime = smbPkt.unpackLong();
        long lastAccessTime = smbPkt.unpackLong();
        long lastWriteTime = smbPkt.unpackLong();
        long changeTime = smbPkt.unpackLong();
        int attr = smbPkt.unpackInt();
        long allocSize = smbPkt.unpackLong();
        long eofOffset = smbPkt.unpackLong();
        int devType = smbPkt.unpackWord();
        FileInfo finfo = new FileInfo(pipeName, eofOffset, attr);
        finfo.setFileId(fid);
        return new DataPipeFile(sess, finfo, fid);
    }

    public static final PrintSession OpenPrinter(PCShare shr, SessionSettings settings) throws IOException, UnknownHostException, SMBException {
        return (PrintSession)SessionFactory.OpenSession(shr, 1, settings);
    }

    private static Session OpenSession(PCShare shr, int devtyp, SessionSettings settings) throws IOException, UnknownHostException, SMBException {
        NetworkSession netSession;
        String localName;
        int pid;
        block29: {
            pid = SessionFactory.getSessionId();
            StringBuffer nameBuf = new StringBuffer(InetAddress.getLocalHost().getHostName() + "_" + pid);
            localName = nameBuf.toString();
            if (Session.hasDebug()) {
                Debug.println("** New session from " + localName + " to " + shr.toString());
                Debug.println("** os.arch = " + System.getProperty("os.arch") + ", java.version: " + System.getProperty("java.version"));
                Debug.println("** JLAN version is " + SessionFactory.isVersion());
                Debug.println("** Trying primary protocol - " + Protocol.asString(settings.getPrimaryProtocol()));
            }
            netSession = null;
            try {
                switch (settings.getPrimaryProtocol()) {
                    case 1: {
                        netSession = SessionFactory.connectNetBIOSSession(shr.getNodeName(), localName, settings);
                        break;
                    }
                    case 2: {
                        netSession = SessionFactory.connectNativeSMBSession(shr.getNodeName(), localName, settings);
                    }
                }
            }
            catch (IOException ex) {
                if (settings.getSecondaryProtocol() != -1) break block29;
                throw ex;
            }
        }
        if (netSession == null) {
            if (Session.hasDebug()) {
                Debug.println("** Trying secondary protocol - " + Protocol.asString(settings.getSecondaryProtocol()));
            }
            switch (settings.getSecondaryProtocol()) {
                case 1: {
                    netSession = SessionFactory.connectNetBIOSSession(shr.getNodeName(), localName, settings);
                    break;
                }
                case 2: {
                    netSession = SessionFactory.connectNativeSMBSession(shr.getNodeName(), localName, settings);
                }
            }
            if (settings.hasUpdateProtocol() && netSession != null) {
                settings.setPrimaryProtocol(settings.getSecondaryProtocol());
                settings.setSecondaryProtocol(-1);
                if (Session.hasDebug()) {
                    Debug.println("** Updated primary protocol : " + Protocol.asString(settings.getPrimaryProtocol()));
                }
            }
        }
        if (netSession == null) {
            throw new IOException("Failed to connect to host, " + shr.getNodeName());
        }
        if (Session.hasDebug()) {
            Debug.println("** Connected session, protocol : " + netSession.getProtocolName());
        }
        SMBPacket pkt = new SMBPacket();
        DialectSelector selDialect = settings.getDialects();
        if (selDialect == null) {
            selDialect = new DialectSelector();
            selDialect.copyFrom(m_defaultSettings.getDialects());
        }
        StringList diaList = SessionFactory.BuildNegotiatePacket(pkt, selDialect, SessionFactory.hasGlobalProcessId() ? 1 : pid);
        pkt.ExchangeLowLevelSMB(netSession, pkt, true);
        String diaStr = diaList.getStringAt(pkt.getParameter(0));
        int dialectId = Dialect.DialectType(diaStr);
        if (Session.hasDebug()) {
            Debug.println("** SessionFactory: Negotiated SMB dialect " + diaStr);
        }
        if (dialectId == -1) {
            netSession.Close();
            throw new IOException("Unknown SMB dialect");
        }
        Session sess = null;
        try {
            switch (devtyp) {
                case 0: {
                    sess = SessionFactory.CreateDiskSession(shr, pkt, netSession, dialectId, settings);
                    break;
                }
                case 1: {
                    sess = SessionFactory.CreatePrinterSession(shr, pkt, netSession, dialectId, settings);
                    break;
                }
                case 3: {
                    sess = SessionFactory.CreatePipeSession(shr, pkt, netSession, dialectId, settings);
                }
            }
        }
        catch (SMBException ex) {
            netSession.Close();
            throw ex;
        }
        catch (IOException ex) {
            netSession.Close();
            throw ex;
        }
        if (sess != null) {
            sess.setDialectString(diaStr);
        }
        return sess;
    }

    public static AuthenticateSession OpenAuthenticateSession(PCShare shr) throws IOException, UnknownHostException, SMBException {
        return SessionFactory.OpenAuthenticateSession(shr, m_defaultSettings);
    }

    public static AuthenticateSession OpenAuthenticateSession(PCShare shr, SessionSettings settings) throws IOException, UnknownHostException, SMBException {
        NetworkSession netSession;
        String localName;
        int pid;
        block20: {
            pid = SessionFactory.getSessionId();
            StringBuffer nameBuf = new StringBuffer(InetAddress.getLocalHost().getHostName() + "_" + pid);
            localName = nameBuf.toString();
            if (Session.hasDebug()) {
                Debug.println("** New auth session from " + localName + " to " + shr.toString());
                Debug.println("** os.arch = " + System.getProperty("os.arch") + ", java.version: " + System.getProperty("java.version"));
                Debug.println("** JLAN version is " + SessionFactory.isVersion());
            }
            netSession = null;
            try {
                switch (settings.getPrimaryProtocol()) {
                    case 1: {
                        netSession = SessionFactory.connectNetBIOSSession(shr.getNodeName(), localName, settings);
                        break;
                    }
                    case 2: {
                        netSession = SessionFactory.connectNativeSMBSession(shr.getNodeName(), localName, settings);
                    }
                }
            }
            catch (IOException ex) {
                if (settings.getSecondaryProtocol() != -1) break block20;
                throw ex;
            }
        }
        if (netSession == null) {
            if (Session.hasDebug()) {
                Debug.println("** Trying secondary protocol - " + Protocol.asString(settings.getSecondaryProtocol()));
            }
            switch (settings.getSecondaryProtocol()) {
                case 1: {
                    netSession = SessionFactory.connectNetBIOSSession(shr.getNodeName(), localName, settings);
                    break;
                }
                case 2: {
                    netSession = SessionFactory.connectNativeSMBSession(shr.getNodeName(), localName, settings);
                }
            }
            if (settings.hasUpdateProtocol() && netSession != null) {
                settings.setPrimaryProtocol(settings.getSecondaryProtocol());
                settings.setSecondaryProtocol(-1);
                if (Session.hasDebug()) {
                    Debug.println("** Updated primary protocol : " + Protocol.asString(settings.getPrimaryProtocol()));
                }
            }
        }
        if (netSession == null) {
            throw new IOException("Failed to connect to host, " + shr.getNodeName());
        }
        if (Session.hasDebug()) {
            Debug.println("** Connected session, protocol : " + netSession.getProtocolName());
        }
        SMBPacket pkt = new SMBPacket();
        DialectSelector selDialect = settings.getDialects();
        if (selDialect == null) {
            selDialect = new DialectSelector();
            selDialect.copyFrom(m_defaultSettings.getDialects());
        }
        StringList diaList = SessionFactory.BuildNegotiatePacket(pkt, selDialect, SessionFactory.hasGlobalProcessId() ? 1 : pid);
        pkt.ExchangeLowLevelSMB(netSession, pkt, true);
        String diaStr = diaList.getStringAt(pkt.getParameter(0));
        int dialectId = Dialect.DialectType(diaStr);
        if (Session.hasDebug()) {
            Debug.println("** SessionFactory: Negotiated SMB dialect " + diaStr);
        }
        if (dialectId == -1) {
            throw new IOException("Unknown SMB dialect");
        }
        AuthenticateSession authSess = new AuthenticateSession(shr, netSession, dialectId, pkt);
        return authSess;
    }

    public static final void SendMessage(String dNode, String msg, int tmo) throws SMBException, IOException, UnknownHostException {
        String remName = dNode;
        if (IPAddress.isNumericAddress(remName)) {
            NetBIOSNameList nameList = NetBIOSSession.FindNamesForAddress(dNode);
            NetBIOSName nbName = nameList.findName('\u0003', false);
            if (nbName == null) {
                throw new IOException("Messenger service not running");
            }
            remName = nbName.getName();
        }
        String localName = InetAddress.getLocalHost().getHostName().toUpperCase();
        if (Session.hasDebug()) {
            Debug.println("** New session from " + localName + " to " + dNode);
            Debug.println("** os.arch = " + System.getProperty("os.arch") + ", java.version: " + System.getProperty("java.version"));
        }
        NetBIOSSession nbSession = new NetBIOSSession(tmo);
        nbSession.setLocalNameType('\u0001');
        nbSession.setRemoteNameType('\u0003');
        nbSession.Open(remName, localName, dNode);
        SMBPacket pkt = new SMBPacket();
        pkt.setCommand(208);
        pkt.setFlags(0);
        pkt.setParameterCount(0);
        pkt.setSID(0);
        pkt.setSeqNo(0);
        pkt.resetBytePointer();
        pkt.packByte(4);
        pkt.packString(localName, false);
        pkt.packByte(4);
        pkt.packString(remName.toUpperCase(), false);
        pkt.packByte(1);
        pkt.packWord(msg.length());
        pkt.packBytes(msg.getBytes(), msg.length());
        pkt.setByteCount();
        pkt.ExchangeLowLevelSMB(nbSession, pkt, false);
        nbSession.Close();
        if (pkt.getErrorClass() != 0 && pkt.getErrorCode() != 0) {
            throw new IOException(SMBErrorText.ErrorString(pkt.getErrorClass(), pkt.getErrorCode()));
        }
    }

    public static final void SendMessage(String dNode, String msg) throws SMBException, IOException, UnknownHostException {
        SessionFactory.SendMessage(dNode, msg, 30000);
    }

    public static final void setDefaultDialects(DialectSelector dialist) {
        m_defaultSettings.setDialects(dialist);
    }

    public static void setDefaultDomain(String domain) {
        m_defDomain = domain;
    }

    public static void setDefaultPassword(String pwd) {
        m_defPassword = pwd;
    }

    public static void setDefaultUserName(String user) {
        m_defUserName = user;
    }

    public static final void setGlobalProcessId(boolean ena) {
        m_globalPID = ena;
    }

    public static void setNetBIOSPort(int port) {
        m_defaultSettings.setNetBIOSSessionPort(port);
    }

    public static void setNetBIOSNameScope(String scope) {
        String nbScope = scope;
        if (nbScope != null && nbScope.startsWith(".")) {
            nbScope = nbScope.substring(1);
        }
        m_defaultSettings.setNetBIOSNameScope(nbScope);
    }

    public static final boolean setProtocolOrder(int pri, int sec) {
        if (pri != 1 && pri != 2) {
            return false;
        }
        if (pri == sec) {
            return false;
        }
        m_defaultSettings.setPrimaryProtocol(pri);
        m_defaultSettings.setSecondaryProtocol(sec);
        return true;
    }

    public static final void setSMBSigningEnabled(boolean ena) {
        m_smbSigningEnabled = ena;
    }

    public static final void setReceivedSMBSigningEnabled(boolean ena) {
        m_smbSigningCheckRx = ena;
    }

    public static final void setSessionDebug(boolean dbg) {
        if (dbg) {
            Session.setDebug(1);
        } else {
            Session.setDebug(0);
        }
    }

    public static final void setSubnetMask(String subnet) {
        NetBIOSSession.setDefaultSubnetMask(subnet);
    }

    private static void SetupDefaultDialects() {
        DialectSelector dialects = new DialectSelector();
        dialects.AddDialect(0);
        dialects.AddDialect(1);
        try {
            Class.forName("org.alfresco.jlan.client.CIFSDiskSession");
            Class.forName("org.alfresco.jlan.client.CIFSPrintSession");
            dialects.AddDialect(2);
            dialects.AddDialect(4);
            dialects.AddDialect(3);
            dialects.AddDialect(5);
            dialects.AddDialect(6);
            dialects.AddDialect(7);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (ExceptionInInitializerError ex) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        m_defaultSettings.setDialects(dialects);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final NetworkSession connectNetBIOSSession(String toName, String fromName, SessionSettings settings) throws IOException {
        String ipAddr;
        InetAddress[] addrList;
        int addrIdx;
        NetBIOSSession nbSession = new NetBIOSSession(settings.getSessionTimeout(), settings.getNetBIOSSessionPort(), settings.getNetBIOSNamePort());
        nbSession.setSubnetMask(settings.getSubnetMask());
        nbSession.setWildcardFileServerName(settings.useWildcardServerName());
        nbSession.setWINSServer(settings.getWINSServer());
        nbSession.setLookupType(settings.getLookupType());
        nbSession.setLookupTimeout(settings.getLookupTimeout());
        toName = toName.toUpperCase();
        NetBIOSName nbName = null;
        if (IPAddress.isNumericAddress(toName)) {
            nbName = NetBIOSSession.ConvertAddressToName(toName, ' ', false, nbSession);
        } else {
            NetBIOSName srvName;
            IOException savedException = null;
            try {
                nbName = NetBIOSSession.FindName(toName, ' ', 500, nbSession);
                if (nbSession.getLookupType() == 1 && nbName != null && nbName.hasNameScope()) {
                    srvName = nbName;
                    srvName.setType(' ');
                    nbName = null;
                    nbName = NetBIOSSession.FindName(srvName, 500, 2, nbSession);
                }
            }
            catch (IOException ex) {
                savedException = ex;
            }
            if (nbName == null && toName.indexOf(46) != -1 && (srvName = new NetBIOSName(toName)).hasNameScope()) {
                srvName.setNameScope(null);
                toName = srvName.getName();
                try {
                    nbName = NetBIOSSession.FindName(toName, ' ', 500, nbSession);
                }
                catch (IOException ex) {
                    savedException = ex;
                }
            }
            if (nbName == null) {
                if (nbSession.getLookupType() == 1) throw savedException;
                NetBIOSNameList localList = NetBIOSSession.FindNamesForAddress(InetAddress.getLocalHost().getHostAddress());
                if (localList != null) {
                    nbName = localList.findName(toName, ' ', false);
                    if (nbName == null) throw savedException;
                    nbName.addIPAddress(InetAddress.getLocalHost().getAddress());
                }
            }
        }
        if (nbName.hasNameScope()) {
            toName = nbName.getFullName();
            fromName = fromName + "." + nbName.getNameScope();
        } else if (settings.hasNetBIOSNameScope()) {
            toName = toName + "." + settings.getNetBIOSNameScope();
            fromName = fromName + "." + settings.getNetBIOSNameScope();
        }
        if (nbName.numberOfAddresses() > 1 && (addrIdx = nbName.findBestMatchAddress(addrList = SessionFactory.getLocalTcpipAddresses())) != -1) {
            try {
                ipAddr = nbName.getIPAddressString(addrIdx);
                if (SessionFactory.hasSessionDebug()) {
                    Debug.println("** Server is multi-homed, trying to connect to " + ipAddr);
                }
                nbSession.Open(toName, fromName, ipAddr);
                if (!nbSession.isConnected()) {
                    try {
                        nbSession.Close();
                    }
                    catch (Exception ex) {}
                } else if (SessionFactory.hasSessionDebug() && nbSession.isConnected()) {
                    Debug.println("** Connected to address " + ipAddr);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (SessionFactory.hasSessionDebug() && !nbSession.isConnected() && nbName.numberOfAddresses() > 1) {
            Debug.println("** Server is multi-homed, trying all addresses");
        }
        IOException lastException = null;
        addrIdx = 0;
        while (!nbSession.isConnected() && addrIdx < nbName.numberOfAddresses()) {
            try {
                ipAddr = nbName.getIPAddressString(addrIdx++);
                if (SessionFactory.hasSessionDebug()) {
                    Debug.println("** Trying address " + ipAddr);
                }
                nbSession.Open(toName, fromName, ipAddr);
                if (!nbSession.isConnected()) {
                    try {
                        nbSession.Close();
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if (!SessionFactory.hasSessionDebug() || !nbSession.isConnected()) continue;
                Debug.println("** Connected to address " + ipAddr);
            }
            catch (IOException ex) {
                lastException = ex;
            }
        }
        if (nbSession.isConnected()) return nbSession;
        if (lastException == null) return null;
        throw lastException;
    }

    private static final NetworkSession connectNativeSMBSession(String toName, String fromName, SessionSettings settings) throws IOException {
        TcpipSMBNetworkSession tcpSession;
        block6: {
            tcpSession = new TcpipSMBNetworkSession(settings.getSessionTimeout(), settings.getNativeSMBPort());
            try {
                tcpSession.Open(toName, fromName, null);
                if (tcpSession.isConnected()) break block6;
                try {
                    tcpSession.Close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return null;
            }
            catch (Exception ex) {
                try {
                    tcpSession.Close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                tcpSession = null;
            }
        }
        return tcpSession;
    }

    static {
        Object pwdEncObj;
        m_sessIdx = 1;
        m_localDomain = null;
        m_localBrowseMaster = null;
        m_defPktSize = 4100;
        m_smbSigningEnabled = true;
        m_smbSigningCheckRx = true;
        m_defUserName = "";
        m_defPassword = "";
        m_defDomain = "?";
        m_debug = false;
        m_localChecked = false;
        m_globalPID = false;
        try {
            pwdEncObj = Class.forName("org.alfresco.jlan.client.JCEPasswordEncryptor").newInstance();
            if (pwdEncObj != null) {
                m_encryptor = (PasswordEncryptor)pwdEncObj;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (m_encryptor == null) {
            try {
                pwdEncObj = Class.forName("org.alfresco.jlan.client.j2me.J2MEPasswordEncryptor").newInstance();
                if (pwdEncObj != null) {
                    m_encryptor = (PasswordEncryptor)pwdEncObj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        m_defaultSettings = new SessionSettings(1, 2);
        SessionFactory.SetupDefaultDialects();
    }
}

