/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.Utils;

public abstract class Javadoc
implements OptionHandler,
RevisionHandler {
    protected String[] m_StartTag = null;
    protected String[] m_EndTag = null;
    protected String m_Classname = Javadoc.class.getName();
    protected boolean m_UseStars = true;
    protected String m_Dir = "";
    protected boolean m_Silent = false;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe class to load.", "W", 1, "-W <classname>"));
        result.addElement(new Option("\tSuppresses the '*' in the Javadoc.", "nostars", 0, "-nostars"));
        result.addElement(new Option("\tThe directory above the package hierarchy of the class.", "dir", 1, "-dir <dir>"));
        result.addElement(new Option("\tSuppresses printing in the console.", "silent", 0, "-silent"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() > 0) {
            this.setClassname(tmpStr);
        } else {
            this.setClassname(this.getClass().getName());
        }
        this.setUseStars(!Utils.getFlag("nostars", options));
        this.setDir(Utils.getOption("dir", options));
        this.setSilent(Utils.getFlag("silent", options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-W");
        result.add(this.getClassname());
        if (!this.getUseStars()) {
            result.add("-nostars");
        }
        if (this.getDir().length() != 0) {
            result.add("-dir");
            result.add(this.getDir());
        }
        if (this.getSilent()) {
            result.add("-silent");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setClassname(String value) {
        this.m_Classname = value;
    }

    public String getClassname() {
        return this.m_Classname;
    }

    public void setUseStars(boolean value) {
        this.m_UseStars = value;
    }

    public boolean getUseStars() {
        return this.m_UseStars;
    }

    public void setDir(String value) {
        this.m_Dir = value;
    }

    public String getDir() {
        return this.m_Dir;
    }

    public void setSilent(boolean value) {
        this.m_Silent = value;
    }

    public boolean getSilent() {
        return this.m_Silent;
    }

    protected void println(Object o) {
        if (!this.getSilent()) {
            System.err.println(o.toString());
        }
    }

    protected boolean canInstantiateClass() {
        boolean result = true;
        Class<?> cls = null;
        try {
            cls = Class.forName(this.getClassname());
        }
        catch (Exception e) {
            result = false;
            this.println("Cannot instantiate '" + this.getClassname() + "'! Class in CLASSPATH?");
        }
        if (result) {
            try {
                cls.newInstance();
            }
            catch (Exception e) {
                result = false;
                this.println("Cannot instantiate '" + this.getClassname() + "'! Missing default constructor?");
            }
        }
        return result;
    }

    protected Object getInstance() {
        Object result = null;
        try {
            Class<?> cls = Class.forName(this.getClassname());
            result = cls.newInstance();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    protected String toHTML(String s) {
        String result = s;
        result = result.replaceAll("&", "&amp;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("@", "&#64;");
        result = result.replaceAll("\n", "<br>\n");
        return result;
    }

    protected String indent(String content, int count, String indentStr) {
        StringTokenizer tok = new StringTokenizer(content, "\n", true);
        String result = "";
        while (tok.hasMoreTokens()) {
            if (result.endsWith("\n") || result.length() == 0) {
                for (int i = 0; i < count; ++i) {
                    result = result + indentStr;
                }
            }
            result = result + tok.nextToken();
        }
        return result;
    }

    protected abstract String generateJavadoc(int var1) throws Exception;

    protected String generateJavadoc() throws Exception {
        String result = "";
        for (int i = 0; i < this.m_StartTag.length; ++i) {
            if (i > 0) {
                result = result + "\n\n";
            }
            result = result + this.generateJavadoc(i).trim();
        }
        return result;
    }

    protected String getIndentionString(String str) {
        String result = str.replaceAll(" ", "").length() == 0 ? " " : (str.replaceAll("\t", "").length() == 0 ? "\t" : str);
        return result;
    }

    protected int getIndentionLength(String str) {
        int result = str.replaceAll(" ", "").length() == 0 ? str.length() : (str.replaceAll("\t", "").length() == 0 ? str.length() : 1);
        return result;
    }

    protected String updateJavadoc(String content, int index) throws Exception {
        if (content.indexOf(this.m_StartTag[index]) == -1 || content.indexOf(this.m_EndTag[index]) == -1) {
            this.println("No start and/or end tags found: " + this.m_StartTag[index] + "/" + this.m_EndTag[index]);
            return content;
        }
        StringBuffer resultBuf = new StringBuffer();
        while (content.length() > 0) {
            if (content.indexOf(this.m_StartTag[index]) > -1) {
                String part = content.substring(0, content.indexOf(this.m_StartTag[index]));
                if (part.endsWith("\"")) {
                    resultBuf.append(part);
                    resultBuf.append(this.m_StartTag[index]);
                    content = content.substring(part.length() + this.m_StartTag[index].length());
                    continue;
                }
                String tmpStr = part.substring(part.lastIndexOf("\n") + 1);
                int indentionLen = this.getIndentionLength(tmpStr);
                String indentionStr = this.getIndentionString(tmpStr);
                part = part.substring(0, part.lastIndexOf("\n") + 1);
                resultBuf.append(part);
                resultBuf.append(this.indent(this.m_StartTag[index], indentionLen, indentionStr) + "\n");
                resultBuf.append(this.indent(this.generateJavadoc(index), indentionLen, indentionStr));
                resultBuf.append(this.indent(this.m_EndTag[index], indentionLen, indentionStr));
                content = content.substring(content.indexOf(this.m_EndTag[index]));
                content = content.substring(this.m_EndTag[index].length());
                continue;
            }
            resultBuf.append(content);
            content = "";
        }
        return resultBuf.toString().trim();
    }

    protected String updateJavadoc(String content) throws Exception {
        String result = content;
        for (int i = 0; i < this.m_StartTag.length; ++i) {
            result = this.updateJavadoc(result, i);
        }
        return result;
    }

    public String updateJavadoc() throws Exception {
        String result = "";
        File file = new File(this.getDir() + "/" + this.getClassname().replaceAll("\\.", "/") + ".java");
        if (!file.exists()) {
            this.println("File '" + file.getAbsolutePath() + "' doesn't exist!");
            return result;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuffer contentBuf = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                contentBuf.append(line + "\n");
            }
            reader.close();
            result = this.updateJavadoc(contentBuf.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    public String generate() throws Exception {
        if (this.getDir().length() == 0) {
            return this.generateJavadoc();
        }
        return this.updateJavadoc();
    }

    public String generateHelp() {
        String result = this.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
        Enumeration<Option> enm = this.listOptions();
        while (enm.hasMoreElements()) {
            Option option = enm.nextElement();
            result = result + option.synopsis() + "\n" + option.description() + "\n";
        }
        return result;
    }

    protected static void runJavadoc(Javadoc javadoc, String[] options) {
        try {
            try {
                if (Utils.getFlag('h', options)) {
                    throw new Exception("Help requested");
                }
                javadoc.setOptions(options);
                Utils.checkForRemainingOptions(options);
                if (javadoc.getDir().length() == 0) {
                    throw new Exception("No directory provided!");
                }
            }
            catch (Exception ex) {
                String result = "\n" + ex.getMessage() + "\n\n" + javadoc.generateHelp();
                throw new Exception(result);
            }
            System.out.println(javadoc.generate() + "\n");
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }
}

