/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAxiomFilter;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxObjectRenderer;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxPrefixNameShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RendererEvent;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RendererListener;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RenderingDirector;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.SectionMap;

public class ManchesterOWLSyntaxFrameRenderer
extends ManchesterOWLSyntaxObjectRenderer
implements OWLEntityVisitor {
    private Set<OWLOntology> ontologies;
    private OntologyIRIShortFormProvider shortFormProvider = new OntologyIRIShortFormProvider();
    private Set<AxiomType<?>> filteredAxiomTypes = new HashSet();
    private boolean renderExtensions = false;
    private boolean renderOntologyLists = false;
    private List<RendererListener> listeners = new ArrayList<RendererListener>();
    private OWLAxiomFilter axiomFilter = new OWLAxiomFilter(){

        public boolean passes(OWLAxiom axiom) {
            return true;
        }
    };
    private RenderingDirector renderingDirector = new DefaultRenderingDirector();
    private RendererEvent event;

    @Deprecated
    public ManchesterOWLSyntaxFrameRenderer(OWLOntologyManager owlOntologyManager, OWLOntology ontology, Writer writer, ShortFormProvider entityShortFormProvider) {
        this(Collections.singleton(ontology), writer, entityShortFormProvider);
    }

    public ManchesterOWLSyntaxFrameRenderer(Set<OWLOntology> ontologies, Writer writer, ShortFormProvider entityShortFormProvider) {
        super(writer, entityShortFormProvider);
        this.ontologies = new LinkedHashSet<OWLOntology>(ontologies);
    }

    public ManchesterOWLSyntaxFrameRenderer(OWLOntology ontology, Writer writer, ShortFormProvider entityShortFormProvider) {
        this(Collections.singleton(ontology), writer, entityShortFormProvider);
    }

    @Deprecated
    public ManchesterOWLSyntaxFrameRenderer(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies, OWLOntology defaultOntology, Writer writer, ShortFormProvider entityShortFormProvider) {
        this(ontologies, writer, entityShortFormProvider);
    }

    @Deprecated
    public ManchesterOWLSyntaxFrameRenderer(Set<OWLOntology> ontologies, OWLOntology defaultOntology, Writer writer, ShortFormProvider entityShortFormProvider) {
        super(writer, entityShortFormProvider);
        this.ontologies = new LinkedHashSet<OWLOntology>(ontologies);
    }

    public void setRenderingDirector(RenderingDirector renderingDirector) {
        this.renderingDirector = renderingDirector;
    }

    public void setOntologyIRIShortFormProvider(OntologyIRIShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    public void addRendererListener(RendererListener listener) {
        this.listeners.add(listener);
    }

    public void removeRendererListener(RendererListener listener) {
        this.listeners.remove(listener);
    }

    public void setAxiomFilter(OWLAxiomFilter axiomFilter) {
        this.axiomFilter = axiomFilter;
    }

    public void clearFilteredAxiomTypes() {
        this.filteredAxiomTypes.clear();
    }

    public void addFilteredAxiomType(AxiomType<?> axiomType) {
        this.filteredAxiomTypes.add(axiomType);
    }

    public void setRenderExtensions(boolean renderExtensions) {
        this.renderExtensions = renderExtensions;
    }

    public void setRenderOntologyLists(boolean renderOntologyList) {
        this.renderOntologyLists = renderOntologyList;
    }

    public void writeOntology() throws OWLRendererException {
        if (this.ontologies.size() != 1) {
            throw new OWLRuntimeException("Can only render one ontology");
        }
        OWLOntology ontology = this.getOntologies().iterator().next();
        this.writePrefixMap();
        this.writeNewLine();
        this.writeOntologyHeader(ontology);
        for (OWLAnnotationProperty prop : ontology.getAnnotationPropertiesInSignature()) {
            this.write(prop);
        }
        for (OWLDatatype datatype : ontology.getDatatypesInSignature()) {
            this.write(datatype);
        }
        for (OWLAnnotationProperty prop : ontology.getObjectPropertiesInSignature()) {
            this.write((OWLObjectPropertyExpression)prop);
            OWLObjectPropertyExpression invProp = prop.getInverseProperty();
            if (ontology.getAxioms(invProp).isEmpty()) continue;
            this.write(invProp);
        }
        for (OWLAnnotationProperty prop : ontology.getDataPropertiesInSignature()) {
            this.write((OWLDataProperty)prop);
        }
        for (OWLClass cls : ontology.getClassesInSignature()) {
            this.write(cls);
        }
        for (OWLNamedIndividual ind : ontology.getIndividualsInSignature()) {
            this.write((OWLIndividual)ind);
        }
        for (OWLNamedIndividual ind : ontology.getReferencedAnonymousIndividuals()) {
            this.write((OWLIndividual)ind);
        }
        this.writeAllNaryAxiomsInOntology(ontology);
        Set rules = ontology.getAxioms(AxiomType.SWRL_RULE);
        this.writeRules(rules, new OWLOntology[0]);
        this.flush();
    }

    public void writeRules(Set<SWRLRule> rules, OWLOntology ... ontologiesToWrite) {
        for (SWRLRule rule : rules) {
            this.writeSection(ManchesterOWLSyntax.RULE, Collections.singleton(rule), ", ", false, ontologiesToWrite);
        }
    }

    private void writeAllNaryAxiomsInOntology(OWLOntology ontology) {
        this.event = new RendererEvent(this, (OWLObject)ontology);
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (ax.getClassExpressions().size() <= 2) continue;
            this.writeDisjointClassesFrame(ax, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
            if (ax.getClassExpressions().size() <= 2) continue;
            this.writeEquivalentClassesFrame((OWLEquivalentClassesAxiom)ax, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            if (ax.getProperties().size() <= 2) continue;
            this.writeDisjointObjectPropertiesFrame((OWLDisjointObjectPropertiesAxiom)ax, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            if (ax.getProperties().size() <= 2) continue;
            this.writeEquivalentObjectPropertiesFrame((OWLEquivalentObjectPropertiesAxiom)ax, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            if (ax.getProperties().size() <= 2) continue;
            this.writeDisjointDataPropertiesFrame((OWLDisjointDataPropertiesAxiom)ax, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            if (ax.getProperties().size() <= 2) continue;
            this.writeEquivalentDataPropertiesFrame((OWLEquivalentDataPropertiesAxiom)ax, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS)) {
            if (ax.getIndividuals().size() <= 2) continue;
            this.writeDifferentIndividualsFrame((OWLDifferentIndividualsAxiom)ax, ontology);
        }
    }

    public void writeEntityNaryAxioms(OWLEntity entity) {
        entity.accept(new OWLEntityVisitor(){

            public void visit(OWLClass cls) {
                ManchesterOWLSyntaxFrameRenderer.this.writeClassNaryAxiomFrames(cls);
            }

            public void visit(OWLObjectProperty property) {
                ManchesterOWLSyntaxFrameRenderer.this.writeObjectPropertyNaryAxiomFrames(property);
            }

            public void visit(OWLDataProperty property) {
                ManchesterOWLSyntaxFrameRenderer.this.writeDataPropertyNaryAxiomFrames(property);
            }

            public void visit(OWLNamedIndividual individual) {
                ManchesterOWLSyntaxFrameRenderer.this.writeIndividualNaryAxiomFrames((OWLIndividual)individual);
            }

            public void visit(OWLDatatype datatype) {
            }

            public void visit(OWLAnnotationProperty property) {
            }
        });
    }

    void writeClassNaryAxiomFrames(OWLClass cls) {
        for (OWLOntology ontology : this.ontologies) {
            for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(cls)) {
                if (ax.getClassExpressions().size() <= 2) continue;
                this.writeDisjointClassesFrame(ax, ontology);
            }
        }
        for (OWLOntology ontology : this.ontologies) {
            for (OWLDisjointClassesAxiom ax : ontology.getEquivalentClassesAxioms(cls)) {
                if (ax.getClassExpressions().size() <= 2) continue;
                this.writeEquivalentClassesFrame((OWLEquivalentClassesAxiom)ax, ontology);
            }
        }
    }

    private void writeObjectPropertyNaryAxiomFrames(OWLObjectProperty property) {
        for (OWLOntology ontology : this.ontologies) {
            for (OWLEquivalentObjectPropertiesAxiom ax : ontology.getEquivalentObjectPropertiesAxioms((OWLObjectPropertyExpression)property)) {
                if (ax.getProperties().size() <= 2) continue;
                this.writeEquivalentObjectPropertiesFrame(ax, ontology);
            }
        }
        for (OWLOntology ontology : this.ontologies) {
            for (OWLEquivalentObjectPropertiesAxiom ax : ontology.getDisjointObjectPropertiesAxioms((OWLObjectPropertyExpression)property)) {
                if (ax.getProperties().size() <= 2) continue;
                this.writeDisjointObjectPropertiesFrame((OWLDisjointObjectPropertiesAxiom)ax, ontology);
            }
        }
    }

    private void writeDataPropertyNaryAxiomFrames(OWLDataProperty property) {
        for (OWLOntology ontology : this.ontologies) {
            for (OWLEquivalentDataPropertiesAxiom ax : ontology.getEquivalentDataPropertiesAxioms(property)) {
                if (ax.getProperties().size() <= 2) continue;
                this.writeEquivalentDataPropertiesFrame(ax, ontology);
            }
        }
        for (OWLOntology ontology : this.ontologies) {
            for (OWLEquivalentDataPropertiesAxiom ax : ontology.getDisjointDataPropertiesAxioms(property)) {
                if (ax.getProperties().size() <= 2) continue;
                this.writeDisjointDataPropertiesFrame((OWLDisjointDataPropertiesAxiom)ax, ontology);
            }
        }
    }

    void writeIndividualNaryAxiomFrames(OWLIndividual ind) {
        for (OWLOntology ontology : this.ontologies) {
            for (OWLSameIndividualAxiom ax : ontology.getSameIndividualAxioms(ind)) {
                if (ax.getIndividuals().size() <= 2) continue;
                this.writeSameIndividualFrame(ax, ontology);
            }
        }
        for (OWLOntology ontology : this.ontologies) {
            for (OWLSameIndividualAxiom ax : ontology.getDifferentIndividualAxioms(ind)) {
                if (ax.getIndividuals().size() <= 2) continue;
                this.writeDifferentIndividualsFrame((OWLDifferentIndividualsAxiom)ax, ontology);
            }
        }
    }

    private void writeSameIndividualFrame(OWLSameIndividualAxiom ax, OWLOntology ... o) {
        SectionMap map = new SectionMap();
        map.add(ax.getIndividuals(), (OWLAxiom)ax);
        this.writeSection(ManchesterOWLSyntax.SAME_INDIVIDUAL, map, ", ", false, o);
    }

    private void writeDifferentIndividualsFrame(OWLDifferentIndividualsAxiom ax, OWLOntology ... o) {
        SectionMap map = new SectionMap();
        map.add(ax.getIndividuals(), (OWLAxiom)ax);
        this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, map, ", ", false, o);
    }

    private void writeEquivalentDataPropertiesFrame(OWLEquivalentDataPropertiesAxiom ax, OWLOntology ... o) {
        SectionMap map = new SectionMap();
        map.add(ax.getProperties(), (OWLAxiom)ax);
        this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ", ", false, o);
    }

    private void writeDisjointDataPropertiesFrame(OWLDisjointDataPropertiesAxiom ax, OWLOntology ... o) {
        SectionMap map = new SectionMap();
        map.add(ax.getProperties(), (OWLAxiom)ax);
        this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ", ", false, o);
    }

    private void writeEquivalentObjectPropertiesFrame(OWLEquivalentObjectPropertiesAxiom ax, OWLOntology ... o) {
        SectionMap map = new SectionMap();
        map.add(ax.getProperties(), (OWLAxiom)ax);
        this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ", ", false, o);
    }

    private void writeDisjointObjectPropertiesFrame(OWLDisjointObjectPropertiesAxiom ax, OWLOntology ... o) {
        SectionMap map = new SectionMap();
        map.add(ax.getProperties(), (OWLAxiom)ax);
        this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ", ", false, o);
    }

    private void writeEquivalentClassesFrame(OWLEquivalentClassesAxiom ax, OWLOntology ... ontologies) {
        SectionMap map = new SectionMap();
        map.add(ax.getClassExpressions(), (OWLAxiom)ax);
        this.writeSection(ManchesterOWLSyntax.EQUIVALENT_CLASSES, map, ", ", false, ontologies);
    }

    private void writeDisjointClassesFrame(OWLDisjointClassesAxiom ax, OWLOntology ... ontologies) {
        SectionMap map = new SectionMap();
        map.add(ax.getClassExpressions(), (OWLAxiom)ax);
        this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, map, ", ", false, ontologies);
    }

    public void writeOntologyHeader(OWLOntology ontology) {
        this.event = new RendererEvent(this, (OWLObject)ontology);
        this.fireFrameRenderingPrepared(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(":");
        this.writeSpace();
        if (!ontology.isAnonymous()) {
            int indent = this.getIndent();
            this.writeFullURI(ontology.getOntologyID().getOntologyIRI().toString());
            this.writeNewLine();
            this.pushTab(indent);
            if (ontology.getOntologyID().getVersionIRI() != null) {
                this.writeFullURI(ontology.getOntologyID().getVersionIRI().toString());
            }
            this.popTab();
        }
        this.fireFrameRenderingStarted(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.writeNewLine();
        for (OWLImportsDeclaration decl : ontology.getImportsDeclarations()) {
            this.fireSectionItemPrepared(ManchesterOWLSyntax.IMPORT.toString());
            this.write(ManchesterOWLSyntax.IMPORT.toString());
            this.write(":");
            this.writeSpace();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.IMPORT.toString());
            this.writeFullURI(decl.getURI().toString());
            this.writeNewLine();
            this.fireSectionRenderingFinished(ManchesterOWLSyntax.IMPORT.toString());
        }
        this.writeNewLine();
        this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, ontology.getAnnotations(), ",", true, new OWLOntology[0]);
        this.fireFrameRenderingFinished(ManchesterOWLSyntax.ONTOLOGY.toString());
    }

    public void writePrefixMap() {
        ShortFormProvider sfp = this.getShortFormProvider();
        if (!(sfp instanceof ManchesterOWLSyntaxPrefixNameShortFormProvider)) {
            return;
        }
        ManchesterOWLSyntaxPrefixNameShortFormProvider prov = (ManchesterOWLSyntaxPrefixNameShortFormProvider)sfp;
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        PrefixManager prefixManager = prov.getPrefixManager();
        for (String prefixName : prefixManager.getPrefixName2PrefixMap().keySet()) {
            String prefix = prefixManager.getPrefix(prefixName);
            prefixMap.put(prefixName, prefix);
            this.write(ManchesterOWLSyntax.PREFIX.toString());
            this.write(": ");
            this.write(prefixName);
            this.write(" ");
            this.writeFullURI(prefix);
            this.writeNewLine();
        }
        if (!prefixMap.isEmpty()) {
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeFullURI(String uri) {
        this.write("<");
        this.write(uri);
        this.write(">");
    }

    public boolean isFiltered(AxiomType<?> axiomType) {
        return this.filteredAxiomTypes.contains(axiomType);
    }

    public boolean isDisplayed(OWLAxiom axiom) {
        if (axiom == null) {
            return false;
        }
        return this.axiomFilter.passes(axiom);
    }

    public Set<OWLAxiom> writeFrame(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.write(entity.asOWLClass());
        }
        if (entity.isOWLObjectProperty()) {
            return this.write((OWLObjectPropertyExpression)entity.asOWLObjectProperty());
        }
        if (entity.isOWLDataProperty()) {
            return this.write(entity.asOWLDataProperty());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.write((OWLIndividual)entity.asOWLNamedIndividual());
        }
        if (entity.isOWLAnnotationProperty()) {
            return this.write(entity.asOWLAnnotationProperty());
        }
        if (entity.isOWLDatatype()) {
            return this.write(entity.asOWLDatatype());
        }
        return Collections.emptySet();
    }

    public Set<OWLAxiom> write(OWLClass cls) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        writtenAxioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.CLASS, (OWLObject)cls));
        this.writeClassEquivalentToIfNotFiltered(cls, writtenAxioms);
        this.writeClassSubClassOfIfNotFiltered(cls, writtenAxioms);
        this.writeClassDisjointUnionOfIfNotFiltered(cls, writtenAxioms);
        this.writeClassDisjointWithIfNotFiltered(cls, writtenAxioms);
        this.writeClassHasKeyIfNotFiltered(cls, writtenAxioms);
        if (this.renderExtensions) {
            this.writeExtensionClassSuperClassOfIfNotFiltered(cls, writtenAxioms);
            this.writeExtensionClassIndividualsIfNotFiltered(cls, writtenAxioms);
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.CLASS.toString());
        return writtenAxioms;
    }

    private void writeClassEquivalentToIfNotFiltered(OWLClass cls, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.EQUIVALENT_CLASSES)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap equivalentClasses = new SectionMap();
            for (OWLEquivalentClassesAxiom ax : ontology.getEquivalentClassesAxioms(cls)) {
                if (ax.getClassExpressions().size() != 2 || !this.isDisplayed((OWLAxiom)ax)) continue;
                for (OWLClassExpression equivCls : ax.getClassExpressionsMinus(new OWLClassExpression[]{cls})) {
                    equivalentClasses.add(equivCls, (OWLAxiom)ax);
                }
                writtenAxioms.add((OWLAxiom)ax);
            }
            equivalentClasses.remove(cls);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, equivalentClasses, ",", true, ontology);
        }
    }

    private void writeClassSubClassOfIfNotFiltered(OWLClass cls, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.SUBCLASS_OF)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap superclasses = new SectionMap();
            for (OWLSubClassOfAxiom ax : ontology.getSubClassAxiomsForSubClass(cls)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                superclasses.add(ax.getSuperClass(), (OWLAxiom)ax);
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.SUBCLASS_OF, superclasses, ",", true, ontology);
        }
    }

    private void writeClassDisjointUnionOfIfNotFiltered(OWLClass cls, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.DISJOINT_UNION)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            for (OWLDisjointUnionAxiom ax : ontology.getDisjointUnionAxioms(cls)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                TreeSet allDisjointClasses = this.createTreeSet(ax.getClassExpressions());
                writtenAxioms.add((OWLAxiom)ax);
                this.writeSection(ManchesterOWLSyntax.DISJOINT_UNION_OF, allDisjointClasses, ", ", false, ontology);
            }
        }
    }

    private void writeClassDisjointWithIfNotFiltered(OWLClass cls, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.DISJOINT_CLASSES)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap disjointClasses = new SectionMap();
            Set disjointClassesAxioms = ontology.getDisjointClassesAxioms(cls);
            for (OWLDisjointClassesAxiom ax : disjointClassesAxioms) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                if (ax.getClassExpressions().size() == 2) {
                    OWLClassExpression disjointWith = (OWLClassExpression)ax.getClassExpressionsMinus(new OWLClassExpression[]{cls}).iterator().next();
                    disjointClasses.add(disjointWith, (OWLAxiom)ax);
                }
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, disjointClasses, ", ", false, ontology);
        }
    }

    private void writeClassHasKeyIfNotFiltered(OWLClass cls, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.HAS_KEY)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            for (OWLHasKeyAxiom ax : ontology.getHasKeyAxioms(cls)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                SectionMap map = new SectionMap();
                map.add(ax.getPropertyExpressions(), (OWLAxiom)ax);
                this.writeSection(ManchesterOWLSyntax.HAS_KEY, map, ", ", true, ontology);
                writtenAxioms.add((OWLAxiom)ax);
            }
        }
    }

    public void writeRulesContainingPredicate(OWLObject predicate) {
        if (this.isFiltered(AxiomType.SWRL_RULE)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            for (SWRLRule rule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                if (!this.isDisplayed((OWLAxiom)rule) || !this.containsPredicate(predicate, rule)) continue;
                this.writeSection(ManchesterOWLSyntax.RULE, Collections.singleton(rule), ", ", true, ontology);
            }
        }
    }

    private boolean containsPredicate(OWLObject predicate, SWRLRule rule) {
        for (SWRLAtom atom : rule.getHead()) {
            if (!atom.getPredicate().equals(predicate)) continue;
            return true;
        }
        for (SWRLAtom atom : rule.getBody()) {
            if (!atom.getPredicate().equals(predicate)) continue;
            return true;
        }
        return false;
    }

    private void writeExtensionClassIndividualsIfNotFiltered(OWLClass cls, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap individuals = new SectionMap();
            for (OWLClassAssertionAxiom ax : ontology.getClassAssertionAxioms((OWLClassExpression)cls)) {
                if (!this.isDisplayed((OWLAxiom)ax) || !this.renderExtensions && !ax.getIndividual().isAnonymous()) continue;
                individuals.add(ax.getIndividual(), (OWLAxiom)ax);
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.INDIVIDUALS, individuals, ",", true, ontology);
        }
    }

    private void writeExtensionClassSuperClassOfIfNotFiltered(OWLClass cls, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.SUBCLASS_OF)) {
            return;
        }
        for (OWLOntology ont : this.getOntologies()) {
            SectionMap subClasses = new SectionMap();
            for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSuperClass(cls)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                subClasses.add(ax.getSubClass(), (OWLAxiom)ax);
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.SUPERCLASS_OF, subClasses, ",", true, ont);
        }
    }

    protected void writeEntitySectionEnd(String type) {
        this.fireFrameRenderingFinished(type);
        this.popTab();
        this.writeNewLine();
    }

    public Set<OWLAxiom> write(OWLObjectPropertyExpression property) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        writtenAxioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.OBJECT_PROPERTY, (OWLObject)property));
        this.writeObjectPropertyDomainIfNotFiltered(property, writtenAxioms);
        this.writeObjectPropertyRangeIfNotFiltered(property, writtenAxioms);
        this.writeObjectPropertyCharacteristicsIfNotFiltered(property, writtenAxioms);
        this.writeObjectPropertySubPropertyOfIfNotFiltered(property, writtenAxioms);
        this.writeObjectPropertyEquivalentToIfNotFiltered(property, writtenAxioms);
        this.writeObjectPropertyDisjointWithIfNotFiltered(property, writtenAxioms);
        this.writeObjectPropertyInverseOfIfNotFiltered(property, writtenAxioms);
        this.writeObjectPropertySubPropertyChainIfNotFiltered(property, writtenAxioms);
        if (this.renderExtensions) {
            this.writeExtensionObjectPropertySuperPropertyOfIfNotFiltered(property, writtenAxioms);
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.OBJECT_PROPERTY.toString());
        return writtenAxioms;
    }

    private void writeObjectPropertyInverseOfIfNotFiltered(OWLObjectPropertyExpression property, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            TreeSet<OWLObjectPropertyExpression> properties = this.createTreeSet();
            for (OWLInverseObjectPropertiesAxiom ax : ontology.getInverseObjectPropertyAxioms(property)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                if (ax.getFirstProperty().equals(property)) {
                    properties.add(ax.getSecondProperty());
                } else {
                    properties.add(ax.getFirstProperty());
                }
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.INVERSE_OF, properties, ",", true, ontology);
        }
    }

    private void writeObjectPropertyRangeIfNotFiltered(OWLObjectPropertyExpression property, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.OBJECT_PROPERTY_RANGE)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap expressions = new SectionMap();
            for (OWLObjectPropertyRangeAxiom ax : ontology.getObjectPropertyRangeAxioms(property)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                expressions.add(ax.getRange(), (OWLAxiom)ax);
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.RANGE, expressions, ",", true, ontology);
        }
    }

    private void writeObjectPropertyDomainIfNotFiltered(OWLObjectPropertyExpression property, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.OBJECT_PROPERTY_DOMAIN)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap expressions = new SectionMap();
            for (OWLObjectPropertyDomainAxiom ax : ontology.getObjectPropertyDomainAxioms(property)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                expressions.add(ax.getDomain(), (OWLAxiom)ax);
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.DOMAIN, expressions, ",", true, ontology);
        }
    }

    private void writeObjectPropertyCharacteristicsIfNotFiltered(OWLObjectPropertyExpression property, Set<OWLAxiom> writtenAxioms) {
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap characteristics = new SectionMap();
            if (!this.isFiltered(AxiomType.FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLFunctionalObjectPropertyAxiom ax : ontology.getFunctionalObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.FUNCTIONAL.toString(), (OWLAxiom)ax);
                    writtenAxioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLFunctionalObjectPropertyAxiom ax : ontology.getInverseFunctionalObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString(), (OWLAxiom)ax);
                    writtenAxioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.SYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLFunctionalObjectPropertyAxiom ax : ontology.getSymmetricObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.SYMMETRIC.toString(), (OWLAxiom)ax);
                    writtenAxioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.TRANSITIVE_OBJECT_PROPERTY)) {
                for (OWLFunctionalObjectPropertyAxiom ax : ontology.getTransitiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.TRANSITIVE.toString(), (OWLAxiom)ax);
                    writtenAxioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.REFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLFunctionalObjectPropertyAxiom ax : ontology.getReflexiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.REFLEXIVE.toString(), (OWLAxiom)ax);
                    writtenAxioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLFunctionalObjectPropertyAxiom ax : ontology.getIrreflexiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.IRREFLEXIVE.toString(), (OWLAxiom)ax);
                    writtenAxioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.ASYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLFunctionalObjectPropertyAxiom ax : ontology.getAsymmetricObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.ASYMMETRIC.toString(), (OWLAxiom)ax);
                    writtenAxioms.add((OWLAxiom)ax);
                }
            }
            this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
        }
    }

    private void writeObjectPropertySubPropertyChainIfNotFiltered(OWLObjectPropertyExpression property, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            for (OWLSubPropertyChainOfAxiom ax : ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                if (!ax.getSuperProperty().equals(property) || !this.isDisplayed((OWLAxiom)ax)) continue;
                SectionMap map = new SectionMap();
                map.add(ax.getPropertyChain(), (OWLAxiom)ax);
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_CHAIN, map, " o ", false, ontology);
                writtenAxioms.add((OWLAxiom)ax);
            }
        }
    }

    private void writeObjectPropertyDisjointWithIfNotFiltered(OWLObjectPropertyExpression property, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap properties = new SectionMap();
            for (OWLDisjointObjectPropertiesAxiom ax : ontology.getDisjointObjectPropertiesAxioms(property)) {
                if (ax.getProperties().size() != 2 || !this.isDisplayed((OWLAxiom)ax)) continue;
                Set props = ax.getPropertiesMinus((OWLPropertyExpression)property);
                properties.add(props.iterator().next(), (OWLAxiom)ax);
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, properties, ",", true, ontology);
        }
    }

    private void writeObjectPropertyEquivalentToIfNotFiltered(OWLObjectPropertyExpression property, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap properties = new SectionMap();
            for (OWLEquivalentObjectPropertiesAxiom ax : ontology.getEquivalentObjectPropertiesAxioms(property)) {
                if (!this.isDisplayed((OWLAxiom)ax) || ax.getProperties().size() != 2) continue;
                Set props = ax.getPropertiesMinus((OWLPropertyExpression)property);
                properties.add(props.iterator().next(), (OWLAxiom)ax);
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, properties, ",", true, ontology);
        }
    }

    private void writeObjectPropertySubPropertyOfIfNotFiltered(OWLObjectPropertyExpression property, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.SUB_OBJECT_PROPERTY)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap properties = new SectionMap();
            for (OWLSubObjectPropertyOfAxiom ax : ontology.getObjectSubPropertyAxiomsForSubProperty(property)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                properties.add(ax.getSuperProperty(), (OWLAxiom)ax);
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, properties, ",", true, ontology);
        }
    }

    private void writeExtensionObjectPropertySuperPropertyOfIfNotFiltered(OWLObjectPropertyExpression property, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.SUB_OBJECT_PROPERTY)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap properties = new SectionMap();
            for (OWLSubObjectPropertyOfAxiom ax : ontology.getObjectSubPropertyAxiomsForSuperProperty(property)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                properties.add(ax.getSubProperty(), (OWLAxiom)ax);
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.SUPER_PROPERTY_OF, properties, ",", true, ontology);
        }
    }

    public Set<OWLAxiom> write(OWLDataProperty property) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        writtenAxioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATA_PROPERTY, (OWLObject)property));
        this.writeDataPropertyDomainIfNotFiltered(property, writtenAxioms);
        this.writeDataPropertyRangeIfNotFiltered(property, writtenAxioms);
        this.writeDataPropertyCharacteristicsIfNotFiltered(property, writtenAxioms);
        this.writeDataPropertySubPropertyOfIfNotFiltered(property, writtenAxioms);
        this.writeDataPropertyEquivalentToIfNotFiltered(property, writtenAxioms);
        this.writeDataPropertyDisjointWithIfNotFiltered(property, writtenAxioms);
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATA_PROPERTY.toString());
        return writtenAxioms;
    }

    private void writeDataPropertyDisjointWithIfNotFiltered(OWLDataProperty property, Set<OWLAxiom> axioms) {
        if (this.isFiltered(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap props = new SectionMap();
            for (OWLDisjointDataPropertiesAxiom ax : ontology.getDisjointDataPropertiesAxioms(property)) {
                if (ax.getProperties().size() != 2 || !this.isDisplayed((OWLAxiom)ax)) continue;
                props.add(ax.getPropertiesMinus((OWLPropertyExpression)property).iterator().next(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            }
            props.remove(property);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, props, ",", true, ontology);
        }
    }

    private void writeDataPropertyEquivalentToIfNotFiltered(OWLDataProperty property, Set<OWLAxiom> axioms) {
        if (this.isFiltered(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap props = new SectionMap();
            for (OWLEquivalentDataPropertiesAxiom ax : ontology.getEquivalentDataPropertiesAxioms(property)) {
                if (!this.isDisplayed((OWLAxiom)ax) || ax.getProperties().size() != 2) continue;
                props.add(ax.getPropertiesMinus((OWLPropertyExpression)property).iterator().next(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, props, ",", true, ontology);
        }
    }

    private void writeDataPropertySubPropertyOfIfNotFiltered(OWLDataProperty property, Set<OWLAxiom> axioms) {
        if (this.isFiltered(AxiomType.SUB_DATA_PROPERTY)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap supers = new SectionMap();
            for (OWLSubDataPropertyOfAxiom ax : ontology.getDataSubPropertyAxiomsForSubProperty(property)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                supers.add(ax.getSuperProperty(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, supers, ",", true, ontology);
        }
    }

    private void writeDataPropertyRangeIfNotFiltered(OWLDataProperty property, Set<OWLAxiom> axioms) {
        if (this.isFiltered(AxiomType.DATA_PROPERTY_RANGE)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap ranges = new SectionMap();
            for (OWLDataPropertyRangeAxiom ax : ontology.getDataPropertyRangeAxioms(property)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                ranges.add(ax.getRange(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.RANGE, ranges, ",", true, ontology);
        }
    }

    private void writeDataPropertyDomainIfNotFiltered(OWLDataProperty property, Set<OWLAxiom> axioms) {
        if (this.isFiltered(AxiomType.DATA_PROPERTY_DOMAIN)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap domains = new SectionMap();
            for (OWLDataPropertyDomainAxiom ax : ontology.getDataPropertyDomainAxioms(property)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                domains.add(ax.getDomain(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.DOMAIN, domains, ",", true, ontology);
        }
    }

    private void writeDataPropertyCharacteristicsIfNotFiltered(OWLDataProperty property, Set<OWLAxiom> axioms) {
        if (this.isFiltered(AxiomType.FUNCTIONAL_DATA_PROPERTY)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap characteristics = new SectionMap();
            for (OWLAxiom ax : ontology.getFunctionalDataPropertyAxioms((OWLDataPropertyExpression)property)) {
                if (!this.isDisplayed(ax)) continue;
                characteristics.add(ManchesterOWLSyntax.FUNCTIONAL.toString(), ax);
                axioms.add(ax);
            }
            this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
        }
    }

    public Set<OWLAxiom> write(OWLIndividual individual) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        writtenAxioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.INDIVIDUAL, (OWLObject)individual));
        this.writeIndividualTypesIfNotFiltered(individual, writtenAxioms);
        this.writeIndividualFactsIfNotFiltered(individual);
        this.writeIndividualSameAsIfNotFiltered(individual, writtenAxioms);
        this.writeIndividualDifferentFromIfNotFiltered(individual, writtenAxioms);
        this.writeEntitySectionEnd(ManchesterOWLSyntax.INDIVIDUAL.toString());
        return writtenAxioms;
    }

    private void writeIndividualDifferentFromIfNotFiltered(OWLIndividual individual, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.DIFFERENT_INDIVIDUALS)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            TreeSet inds = this.createTreeSet();
            for (OWLDifferentIndividualsAxiom ax : ontology.getDifferentIndividualAxioms(individual)) {
                if (ax.getIndividuals().size() != 2 || !this.isDisplayed((OWLAxiom)ax)) continue;
                inds.addAll(ax.getIndividuals());
                writtenAxioms.add((OWLAxiom)ax);
            }
            inds.remove(individual);
            this.writeSection(ManchesterOWLSyntax.DIFFERENT_FROM, inds, ",", true, ontology);
        }
    }

    private void writeIndividualSameAsIfNotFiltered(OWLIndividual individual, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.SAME_INDIVIDUAL)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            TreeSet inds = this.createTreeSet();
            for (OWLSameIndividualAxiom ax : ontology.getSameIndividualAxioms(individual)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                inds.addAll(ax.getIndividuals());
                writtenAxioms.add((OWLAxiom)ax);
            }
            inds.remove(individual);
            this.writeSection(ManchesterOWLSyntax.SAME_AS, inds, ",", true, ontology);
        }
    }

    private void writeIndividualFactsIfNotFiltered(OWLIndividual individual) {
        for (OWLOntology ontology : this.getOntologies()) {
            ArrayList assertions = new ArrayList();
            if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
                assertions.addAll(ontology.getObjectPropertyAssertionAxioms(individual));
            }
            if (!this.isFiltered(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION)) {
                assertions.addAll(ontology.getNegativeObjectPropertyAssertionAxioms(individual));
            }
            if (!this.isFiltered(AxiomType.DATA_PROPERTY_ASSERTION)) {
                assertions.addAll(ontology.getDataPropertyAssertionAxioms(individual));
            }
            if (!this.isFiltered(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION)) {
                assertions.addAll(ontology.getNegativeDataPropertyAssertionAxioms(individual));
            }
            if (assertions.isEmpty()) continue;
            this.fireSectionRenderingPrepared(ManchesterOWLSyntax.FACTS.toString());
            this.writeSection(ManchesterOWLSyntax.FACTS);
            this.writeSpace();
            this.writeOntologiesList(ontology);
            this.incrementTab(1);
            this.writeNewLine();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.FACTS.toString());
            Iterator it = assertions.iterator();
            while (it.hasNext()) {
                OWLPropertyAssertionAxiom ax = (OWLPropertyAssertionAxiom)it.next();
                this.fireSectionItemPrepared(ManchesterOWLSyntax.FACTS.toString());
                Set annos = ax.getAnnotations();
                if (!annos.isEmpty()) {
                    this.writeAnnotations(annos);
                    this.pushTab(this.getIndent() + 1);
                }
                if (ax instanceof OWLNegativeDataPropertyAssertionAxiom || ax instanceof OWLNegativeObjectPropertyAssertionAxiom) {
                    this.write(ManchesterOWLSyntax.NOT);
                    this.writeSpace();
                }
                ax.getProperty().accept((OWLObjectVisitor)this);
                this.writeSpace();
                this.writeSpace();
                ax.getObject().accept((OWLObjectVisitor)this);
                if (!annos.isEmpty()) {
                    this.popTab();
                }
                this.fireSectionItemFinished(ManchesterOWLSyntax.FACTS.toString());
                if (!it.hasNext()) continue;
                this.write(",");
                this.writeNewLine();
            }
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    private void writeIndividualTypesIfNotFiltered(OWLIndividual individual, Set<OWLAxiom> writtenAxioms) {
        if (this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            return;
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap expressions = new SectionMap();
            for (OWLClassAssertionAxiom ax : ontology.getClassAssertionAxioms(individual)) {
                if (!this.isDisplayed((OWLAxiom)ax)) continue;
                expressions.add(ax.getClassExpression(), (OWLAxiom)ax);
                writtenAxioms.add((OWLAxiom)ax);
            }
            this.writeSection(ManchesterOWLSyntax.TYPES, expressions, ",", true, ontology);
        }
    }

    public Set<OWLAxiom> write(OWLDatatype datatype) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATATYPE, (OWLObject)datatype));
        if (!this.isFiltered(AxiomType.DATATYPE_DEFINITION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeSet<OWLDataRange> dataRanges = this.createTreeSet();
                for (OWLDatatypeDefinitionAxiom ax : ontology.getDatatypeDefinitions(datatype)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    axioms.add((OWLAxiom)ax);
                    dataRanges.add(ax.getDataRange());
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, dataRanges, ",", true, ontology);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATATYPE.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(SWRLRule rule) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>(1);
        for (OWLOntology ontology : this.getOntologies()) {
            if (!ontology.containsAxiom((OWLAxiom)rule)) continue;
            this.writeSection(ManchesterOWLSyntax.RULE, Collections.singleton(rule), "", true, ontology);
            axioms.add((OWLAxiom)rule);
        }
        return axioms;
    }

    public Set<OWLOntology> getOntologies() {
        return this.ontologies;
    }

    public void writeSection(ManchesterOWLSyntax keyword, Collection<?> content, String delimeter, boolean newline, OWLOntology ... ontologiesList) {
        String sec = keyword.toString();
        if (!content.isEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologiesList)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologiesList);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<?> it = content.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                this.fireSectionItemPrepared(sec);
                if (obj instanceof OWLObject) {
                    ((OWLObject)obj).accept((OWLObjectVisitor)this);
                } else {
                    this.write(obj.toString());
                }
                if (it.hasNext()) {
                    this.write(delimeter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeSection(ManchesterOWLSyntax keyword) {
        this.write("", keyword, "");
        this.write(":");
        this.writeSpace();
    }

    private void writeOntologiesList(OWLOntology ... ontologiesList) {
        if (!this.shouldRenderOntologyLists()) {
            return;
        }
        if (ontologiesList.length == 0) {
            return;
        }
        this.write("[in ");
        int count = 0;
        for (OWLOntology ont : ontologiesList) {
            this.write(this.shortFormProvider.getShortForm(ont));
            if (++count >= ontologiesList.length) continue;
            this.write(", ");
        }
        this.write("]");
    }

    private boolean shouldRenderOntologyLists() {
        return this.renderOntologyLists || this.renderExtensions;
    }

    private void fireSectionRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingPrepared(section, this.event);
        }
    }

    private void fireSectionRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingStarted(section, this.event);
        }
    }

    private void fireSectionRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingFinished(section, this.event);
        }
    }

    private void fireSectionItemPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemPrepared(section, this.event);
        }
    }

    private void fireSectionItemFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemFinished(section, this.event);
        }
    }

    public Set<OWLAxiom> write(OWLAnnotationProperty property) {
        TreeSet<IRI> iris;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.ANNOTATION_PROPERTY, (OWLObject)property));
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            for (OWLOntology ont : this.getOntologies()) {
                TreeSet<OWLAnnotation> annos = this.createTreeSet();
                for (OWLAnnotationAssertionAxiom ax : ont.getAnnotationAssertionAxioms((OWLAnnotationSubject)property.getIRI())) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    annos.add(ax.getAnnotation());
                }
                this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, annos, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            for (OWLOntology ont : this.getOntologies()) {
                TreeSet<OWLAnnotationProperty> props = this.createTreeSet();
                for (OWLAnnotationAssertionAxiom ax : ont.getSubAnnotationPropertyOfAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    props.add(ax.getSuperProperty());
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, props, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            for (OWLOntology ont : this.getOntologies()) {
                iris = this.createTreeSet();
                for (OWLAnnotationAssertionAxiom ax : ont.getAnnotationPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    iris.add(ax.getDomain());
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, iris, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            for (OWLOntology ont : this.getOntologies()) {
                iris = this.createTreeSet();
                for (OWLAnnotationAssertionAxiom ax : ont.getAnnotationPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    iris.add(ax.getRange());
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, iris, ",", true, ont);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.ANNOTATION_PROPERTY.toString());
        return axioms;
    }

    private Set<OWLAnnotationAssertionAxiom> writeEntityStart(ManchesterOWLSyntax keyword, OWLObject entity) {
        this.event = new RendererEvent(this, entity);
        String kw = keyword.toString();
        this.fireFrameRenderingPrepared(kw);
        this.writeSection(keyword);
        entity.accept((OWLObjectVisitor)this);
        this.fireFrameRenderingStarted(kw);
        this.writeNewLine();
        this.incrementTab(4);
        this.writeNewLine();
        if (entity instanceof OWLEntity) {
            return this.writeAnnotations((OWLAnnotationSubject)((OWLEntity)entity).getIRI());
        }
        if (entity instanceof OWLAnonymousIndividual) {
            return this.writeAnnotations((OWLAnnotationSubject)((OWLAnonymousIndividual)entity));
        }
        return Collections.emptySet();
    }

    public Set<OWLAnnotationAssertionAxiom> writeAnnotations(OWLAnnotationSubject subject) {
        HashSet<OWLAnnotationAssertionAxiom> axioms = new HashSet<OWLAnnotationAssertionAxiom>();
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap sectionMap = new SectionMap();
                for (OWLAnnotationAssertionAxiom ax : ontology.getAnnotationAssertionAxioms(subject)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    axioms.add(ax);
                    sectionMap.add(ax.getAnnotation(), (OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, sectionMap, ",", true, ontology);
            }
        }
        return axioms;
    }

    public void writeSection(ManchesterOWLSyntax keyword, SectionMap content, String delimeter, boolean newline, OWLOntology ... ontologiesList) {
        String sec = keyword.toString();
        if (!content.isEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologiesList)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologiesList);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<Object> it = content.getSectionObjects().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                Set<Set<OWLAnnotation>> annotationSets = content.getAnnotationsForSectionObject(obj);
                Iterator<Set<OWLAnnotation>> annosSetIt = annotationSets.iterator();
                while (annosSetIt.hasNext()) {
                    Set<OWLAnnotation> annos = annosSetIt.next();
                    this.fireSectionItemPrepared(sec);
                    if (!annos.isEmpty()) {
                        this.incrementTab(4);
                        this.writeNewLine();
                        this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
                        this.write(": ");
                        this.pushTab(this.getIndent() + 1);
                        Iterator<OWLAnnotation> annoIt = annos.iterator();
                        while (annoIt.hasNext()) {
                            annoIt.next().accept((OWLObjectVisitor)this);
                            if (!annoIt.hasNext()) continue;
                            this.write(", ");
                            this.writeNewLine();
                        }
                        this.popTab();
                        this.popTab();
                        this.writeNewLine();
                    }
                    if (obj instanceof OWLObject) {
                        ((OWLObject)obj).accept((OWLObjectVisitor)this);
                    } else if (obj instanceof Collection) {
                        Iterator listIt = ((Collection)obj).iterator();
                        while (listIt.hasNext()) {
                            Object o = listIt.next();
                            if (o instanceof OWLObject) {
                                ((OWLObject)o).accept((OWLObjectVisitor)this);
                            } else {
                                this.write(o.toString());
                            }
                            if (!listIt.hasNext()) continue;
                            this.write(delimeter);
                            if (!newline) continue;
                            this.writeNewLine();
                        }
                    } else {
                        this.write(obj.toString());
                    }
                    if (!annosSetIt.hasNext()) continue;
                    this.write(",");
                    this.writeNewLine();
                }
                if (it.hasNext()) {
                    this.write(delimeter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeComment(String comment, boolean placeOnNewline) {
        this.writeComment("#", comment, placeOnNewline);
    }

    public void writeComment(String commentDelim, String comment, boolean placeOnNewline) {
        if (placeOnNewline) {
            this.writeNewLine();
        }
        this.write(commentDelim);
        this.write(comment);
        this.writeNewLine();
    }

    private void fireFrameRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingPrepared(section, this.event);
        }
    }

    private void fireFrameRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingStarted(section, this.event);
        }
    }

    private void fireFrameRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingFinished(section, this.event);
        }
    }

    private <E extends OWLObject> TreeSet<E> createTreeSet() {
        return new TreeSet();
    }

    private <E extends OWLObject> TreeSet<E> createTreeSet(Collection<? extends E> fromCollection) {
        return new TreeSet<E>(fromCollection);
    }

    private static class DefaultRenderingDirector
    implements RenderingDirector {
        @Override
        public boolean renderEmptyFrameSection(ManchesterOWLSyntax frameSectionKeyword, OWLOntology ... ontologies) {
            return false;
        }
    }
}

