/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.rdfxml;

import java.util.HashSet;
import java.util.Set;
import org.coode.xml.OWLOntologyXMLNamespaceManager;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class RDFXMLNamespaceManager
extends OWLOntologyXMLNamespaceManager {
    public RDFXMLNamespaceManager(OWLOntologyManager man, OWLOntology ontology) {
        super(man, ontology);
    }

    public RDFXMLNamespaceManager(OWLOntology ontology, OWLOntologyFormat format) {
        super(ontology, format);
    }

    @Override
    protected Set<OWLEntity> getEntitiesThatRequireNamespaces() {
        HashSet<OWLEntity> entities = new HashSet<OWLEntity>();
        for (OWLObjectPropertyAssertionAxiom ax : this.getOntology().getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
            entities.addAll(((OWLObjectPropertyExpression)ax.getProperty()).getSignature());
        }
        for (OWLObjectPropertyAssertionAxiom ax : this.getOntology().getAxioms(AxiomType.DATA_PROPERTY_ASSERTION)) {
            entities.add((OWLEntity)((OWLDataPropertyExpression)ax.getProperty()).asOWLDataProperty());
        }
        entities.addAll(this.getOntology().getAnnotationPropertiesInSignature());
        return entities;
    }

    public Set<OWLEntity> getEntitiesWithInvalidQNames() {
        HashSet<OWLEntity> result = new HashSet<OWLEntity>();
        for (OWLEntity entity : this.getEntitiesThatRequireNamespaces()) {
            IRI iri = entity.getIRI();
            if (iri.getFragment() != null && !iri.getFragment().isEmpty()) continue;
            result.add(entity);
        }
        return result;
    }
}

