/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kaczmarzyk.spring.data.jpa.domain.Conjunction;
import net.kaczmarzyk.spring.data.jpa.web.EnhancerUtil;
import net.kaczmarzyk.spring.data.jpa.web.MethodParameterUtil;
import net.kaczmarzyk.spring.data.jpa.web.RecursiveHandlerMethodArgumentResolver;
import net.kaczmarzyk.spring.data.jpa.web.SpecificationArgumentResolver;
import net.kaczmarzyk.spring.data.jpa.web.WebRequestQueryContext;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Join;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class JoinSpecificationResolver
implements RecursiveHandlerMethodArgumentResolver {
    private SpecificationArgumentResolver parentResolver;

    public JoinSpecificationResolver(SpecificationArgumentResolver parentResolver) {
        this.parentResolver = parentResolver;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binder) throws Exception {
        return this.resolveArgument(parameter, mavContainer, request, binder, new ArrayList<HandlerMethodArgumentResolver>());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binder, List<HandlerMethodArgumentResolver> recursiveCallers) throws Exception {
        Conjunction spec;
        recursiveCallers.add(this);
        Conjunction joinSpec = this.resolveJoin(parameter, request);
        Specification regularSpec = (Specification)this.parentResolver.resolveArgument(parameter, mavContainer, request, binder, recursiveCallers);
        Conjunction conjunction = spec = regularSpec == null ? joinSpec : new Conjunction(Arrays.asList(joinSpec, regularSpec));
        if (Specification.class == parameter.getParameterType()) {
            return spec;
        }
        return EnhancerUtil.wrapWithIfaceImplementation(parameter.getParameterType(), spec);
    }

    private Specification<Object> resolveJoin(MethodParameter parameter, NativeWebRequest request) {
        if (MethodParameterUtil.isAnnotatedWith(Join.class, parameter)) {
            Join fetchDef = MethodParameterUtil.getAnnotation(Join.class, parameter);
            return this.newJoin(fetchDef, request);
        }
        throw new IllegalArgumentException("@Join was expected!");
    }

    private net.kaczmarzyk.spring.data.jpa.domain.Join<Object> newJoin(Join joinDef, NativeWebRequest request) {
        return new net.kaczmarzyk.spring.data.jpa.domain.Join<Object>(new WebRequestQueryContext(request), joinDef.path(), joinDef.alias(), joinDef.type(), joinDef.distinct());
    }

    public boolean supportsParameter(MethodParameter param) {
        Class paramType = param.getParameterType();
        return paramType.isInterface() && Specification.class.isAssignableFrom(paramType) && MethodParameterUtil.isAnnotatedWith(Join.class, param);
    }
}

