/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.utils.normalizers.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Normalizer<O> {
    private static final Logger LOG = LoggerFactory.getLogger(Normalizer.class);
    private static final Map<Class<? extends Normalizer<?>>, Normalizer<?>> NORMALIZERS = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T normalize(Class<? extends Normalizer<T>> normalizerClass, T object) {
        Normalizer<Object> normalizer;
        Map<Class<? extends Normalizer<?>>, Normalizer<?>> map = NORMALIZERS;
        synchronized (map) {
            normalizer = NORMALIZERS.get(normalizerClass);
            if (normalizer == null) {
                try {
                    normalizer = normalizerClass.newInstance();
                }
                catch (InstantiationException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new UnexpectedException((Exception)e);
                }
                catch (IllegalAccessException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new UnexpectedException((Exception)e);
                }
                NORMALIZERS.put(normalizerClass, normalizer);
            }
        }
        return (T)normalizer.normalize(object);
    }

    protected abstract O normalize(O var1);
}

