/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.SpecimenDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.SpecimenService;
import nc.ird.cantharella.utils.AssertTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class SpecimenServiceImpl
implements SpecimenService {
    private static final Logger LOG = LoggerFactory.getLogger(SpecimenServiceImpl.class);
    @Autowired
    private GenericDao dao;

    @Override
    public long countSpecimens() {
        return this.dao.count(Specimen.class);
    }

    @Override
    public void createSpecimen(Specimen specimen) throws DataConstraintException {
        LOG.info("createSpecimen: " + specimen.getRef());
        this.dao.create((AbstractModel)specimen);
    }

    @Override
    public void deleteSpecimen(Specimen specimen) throws DataConstraintException {
        AssertTools.assertNotNull((Object)specimen);
        LOG.info("deleteSpecimen " + specimen.getRef());
        try {
            this.dao.delete((AbstractModel)specimen);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<Specimen> listSpecimens(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.readList(Specimen.class, new String[]{"ref"});
        }
        SortedSet<Specimen> specimens = this.listSpecimensForUser(utilisateur);
        return new ArrayList<Specimen>(specimens);
    }

    @Override
    public SortedSet<Specimen> listSpecimensForUser(Utilisateur utilisateur) {
        TreeSet<Specimen> specimens = new TreeSet<Specimen>();
        specimens.addAll(utilisateur.getSpecimensCrees());
        ArrayList campagnes = new ArrayList();
        campagnes.addAll(utilisateur.getCampagnesCreees());
        campagnes.addAll(utilisateur.getCampagnesDroits().keySet());
        for (Campagne c : campagnes) {
            for (Station st : c.getStations()) {
                specimens.addAll(st.getSpecimensRattaches());
            }
        }
        ArrayList lots = new ArrayList();
        lots.addAll(utilisateur.getLotsCrees());
        lots.addAll(utilisateur.getLotsDroits().keySet());
        for (Lot l : lots) {
            if (l.getSpecimenRef().getStation() == null) continue;
            specimens.add(l.getSpecimenRef());
        }
        return specimens;
    }

    @Override
    public List<String> listSpecimenEmbranchements() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_EMBRANCHEMENTS);
    }

    @Override
    public List<String> listSpecimenFamilles() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_FAMILLES);
    }

    @Override
    public List<String> listSpecimenGenres() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_GENRES);
    }

    @Override
    public List<String> listSpecimenEspeces() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_ESPECES);
    }

    @Override
    public List<String> listSpecimenSousEspeces() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_SOUSESPECES);
    }

    @Override
    public List<String> listSpecimenVarietes() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_VARIETES);
    }

    @Override
    public List<String> listLieuxDepot() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_LIEUX_DEPOT);
    }

    @Override
    public Specimen loadSpecimen(Integer idSpecimen) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)idSpecimen);
        return (Specimen)this.dao.read(Specimen.class, (Serializable)idSpecimen);
    }

    @Override
    public Specimen loadSpecimen(String ref) throws DataNotFoundException {
        AssertTools.assertNotEmpty((String)ref);
        return (Specimen)this.dao.read(Specimen.class, "ref", (Serializable)((Object)ref));
    }

    @Override
    public boolean updateOrdeleteSpecimenEnabled(Specimen specimen, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == specimen.getCreateur().getIdPersonne();
    }

    @Override
    public void updateSpecimen(Specimen specimen) throws DataConstraintException {
        LOG.info("updateSpecimen " + specimen.getIdSpecimen());
        try {
            this.dao.update((AbstractModel)specimen);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }
}

