/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services;

import java.util.List;
import java.util.SortedSet;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.utils.normalizers.SpecimenNormalizer;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import org.springframework.transaction.annotation.Transactional;

public interface SpecimenService {
    public long countSpecimens();

    public void createSpecimen(@Normalize(value=SpecimenNormalizer.class) Specimen var1) throws DataConstraintException;

    public void deleteSpecimen(Specimen var1) throws DataConstraintException;

    @Transactional(readOnly=true)
    public List<Specimen> listSpecimens(Utilisateur var1);

    public SortedSet<Specimen> listSpecimensForUser(Utilisateur var1);

    @Transactional(readOnly=true)
    public List<String> listSpecimenEmbranchements();

    @Transactional(readOnly=true)
    public List<String> listSpecimenFamilles();

    @Transactional(readOnly=true)
    public List<String> listSpecimenGenres();

    @Transactional(readOnly=true)
    public List<String> listSpecimenEspeces();

    @Transactional(readOnly=true)
    public List<String> listSpecimenSousEspeces();

    @Transactional(readOnly=true)
    public List<String> listSpecimenVarietes();

    @Transactional(readOnly=true)
    public List<String> listLieuxDepot();

    public Specimen loadSpecimen(Integer var1) throws DataNotFoundException;

    public Specimen loadSpecimen(@Normalize(value=UniqueFieldNormalizer.class) String var1) throws DataNotFoundException;

    public boolean updateOrdeleteSpecimenEnabled(Specimen var1, Utilisateur var2);

    public void updateSpecimen(@Normalize(value=SpecimenNormalizer.class) Specimen var1) throws DataConstraintException;
}

