/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.MoleculeDao;
import nc.ird.cantharella.data.dao.impl.PersonneDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Molecule;
import nc.ird.cantharella.data.model.MoleculeProvenance;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.model.MoleculeProvenanceBean;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.MoleculeService;
import nc.ird.cantharella.utils.AssertTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class MoleculeServiceImpl
implements MoleculeService {
    private static final Logger LOG = LoggerFactory.getLogger(MoleculeServiceImpl.class);
    @Autowired
    private GenericDao dao;
    @Autowired
    private LotService lotService;

    @Override
    public long countMolecules() {
        return this.dao.count(Molecule.class);
    }

    @Override
    public void createMolecule(Molecule molecule) throws DataConstraintException {
        LOG.info("createMolecule " + molecule.getFormuleBrute());
        this.dao.create((AbstractModel)molecule);
    }

    @Override
    public void deleteMolecule(Molecule molecule) throws DataConstraintException {
        AssertTools.assertNotNull((Object)molecule);
        LOG.info("deleteMolecule " + molecule.getIdMolecule());
        try {
            this.dao.delete((AbstractModel)molecule);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<Molecule> listMolecules() {
        return this.dao.readList(Molecule.class, new String[]{"idMolecule"});
    }

    @Override
    public List<MoleculeProvenanceBean> listMoleculeProvenances(Utilisateur utilisateur) {
        List<Molecule> molecules = this.listMolecules();
        List<MoleculeProvenanceBean> result = this.listMoleculeProvenances(molecules, utilisateur);
        return result;
    }

    @Override
    public List<MoleculeProvenanceBean> listMoleculeProvenances(List<Molecule> molecules, Utilisateur utilisateur) {
        ArrayList<MoleculeProvenanceBean> result = new ArrayList<MoleculeProvenanceBean>();
        for (Molecule molecule : molecules) {
            boolean isOneProductVisible = false;
            List moleculeProvenances = molecule.getProvenances();
            for (MoleculeProvenance moleculeProvenance : moleculeProvenances) {
                if (!this.isMoleculeProvenanceAccessibleByUser(moleculeProvenance, utilisateur)) continue;
                result.add(new MoleculeProvenanceBean(moleculeProvenance));
                isOneProductVisible = true;
            }
            if (isOneProductVisible) continue;
            result.add(new MoleculeProvenanceBean(molecule));
        }
        return result;
    }

    @Override
    public Molecule loadMolecule(Integer numero) throws DataNotFoundException {
        return (Molecule)this.dao.read(Molecule.class, (Serializable)numero);
    }

    @Override
    public void updateMolecule(Molecule molecule) throws DataConstraintException {
        LOG.info("updateMolecule: " + molecule.getIdMolecule());
        try {
            this.dao.update((AbstractModel)molecule);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public boolean updateOrdeleteMoleculeEnabled(Molecule molecule, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == molecule.getCreateur().getIdPersonne();
    }

    @Override
    public List<String> listMoleculeOrganisme() {
        HashSet organismes = new HashSet();
        organismes.addAll(this.dao.list(MoleculeDao.CRITERIA_DISTINCT_MOLECULE_ORGANISMES));
        organismes.addAll(this.dao.list(PersonneDao.CRITERIA_DISTINCT_PERSONNE_ORGANISMES));
        ArrayList<String> result = new ArrayList<String>(organismes);
        result.remove(null);
        Collections.sort(result);
        return result;
    }

    @Override
    public boolean isMoleculeProvenanceAccessibleByUser(MoleculeProvenance moleculeProvenance, Utilisateur utilisateur) {
        Produit produit = moleculeProvenance.getProduit();
        Lot lot = produit instanceof Extrait ? ((Extrait)produit).getExtraction().getLot() : ((Fraction)produit).getPurification().getLotSource();
        return this.lotService.isLotAccessibleByUser(lot, utilisateur);
    }
}

