/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.TestBioDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.ErreurTestBio;
import nc.ird.cantharella.data.model.MethodeTestBio;
import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.TestBio;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.TestBioService;
import nc.ird.cantharella.utils.AssertTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class TestBioServiceImpl
implements TestBioService {
    private static final Logger LOG = LoggerFactory.getLogger(TestBioServiceImpl.class);
    @Autowired
    private LotService lotService;
    @Autowired
    private GenericDao dao;

    @Override
    public long countResultatsTestsBio() {
        return this.dao.count(TestBioDao.CRITERIA_COUNT_RESULTATS_TYPE_PRODUIT);
    }

    @Override
    public void createTestBio(TestBio testBio) throws DataConstraintException {
        LOG.info("createTestBio: " + testBio.getRef());
        this.dao.create((AbstractModel)testBio);
    }

    @Override
    public void deleteTestBio(TestBio testBio) throws DataConstraintException {
        AssertTools.assertNotNull((Object)testBio);
        LOG.info("deleteTestBio: " + testBio.getRef());
        try {
            this.dao.delete((AbstractModel)testBio);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<ResultatTestBio> listResultatsTestBio(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.list(TestBioDao.CRITERIA_LIST_RESULTATS_TYPE_PRODUIT);
        }
        return new ArrayList<ResultatTestBio>(this.listResultatsTestBioForUser(utilisateur));
    }

    @Override
    public SortedSet<ResultatTestBio> listResultatsTestBioForUser(Utilisateur utilisateur) {
        TreeSet<ResultatTestBio> resultats = new TreeSet<ResultatTestBio>();
        List allResultTests = this.dao.list(TestBioDao.CRITERIA_LIST_RESULTATS_TYPE_PRODUIT);
        for (ResultatTestBio curRes : allResultTests) {
            if (!this.lotService.isLotAccessibleByUser(curRes.getLotSource(), utilisateur)) continue;
            resultats.add(curRes);
        }
        return resultats;
    }

    @Override
    public List<String> listProduitsTemoins() {
        return this.dao.list(TestBioDao.CRITERIA_DISTINCT_PRODUITS_TEMOINS);
    }

    @Override
    public boolean isResultatTestBioAccessibleByUser(ResultatTestBio resultatTestBio, Utilisateur utilisateur) {
        return this.lotService.isLotAccessibleByUser(resultatTestBio.getLotSource(), utilisateur);
    }

    @Override
    public boolean isResultatTestBioUniqueInList(ResultatTestBio resultatTestBio, List<ResultatTestBio> list) {
        AssertTools.assertNotNull((Object)resultatTestBio.getTypeResultat());
        AssertTools.assertNotNull((Object)resultatTestBio.getRepere());
        int count = 0;
        for (ResultatTestBio curRes : list) {
            if (resultatTestBio.getTypeResultat() == ResultatTestBio.TypeResultat.BLANC && resultatTestBio.getRepere().equals(curRes.getRepere())) {
                ++count;
                continue;
            }
            if (resultatTestBio.getTypeResultat() == ResultatTestBio.TypeResultat.TEMOIN && resultatTestBio.getRepere().equals(curRes.getRepere()) && resultatTestBio.getProduitTemoin().equals(curRes.getProduitTemoin())) {
                ++count;
                continue;
            }
            if (resultatTestBio.getTypeResultat() != ResultatTestBio.TypeResultat.PRODUIT || !resultatTestBio.getRepere().equals(curRes.getRepere()) || !resultatTestBio.getProduit().getRef().equals(curRes.getProduit().getRef())) continue;
            ++count;
        }
        return count <= 1;
    }

    @Override
    public boolean isTestBioUnique(TestBio testBio) {
        TestBio puriWithSameVal;
        AssertTools.assertNotNull((Object)testBio);
        if (!this.dao.exists(TestBio.class, "ref", (Serializable)((Object)testBio.getRef()))) {
            return true;
        }
        try {
            puriWithSameVal = (TestBio)this.dao.read(TestBio.class, "ref", (Serializable)((Object)testBio.getRef()));
            this.dao.evict((AbstractModel)puriWithSameVal);
        }
        catch (DataNotFoundException e) {
            return true;
        }
        return testBio.getIdTestBio() != null && testBio.getIdTestBio().equals(puriWithSameVal.getIdTestBio());
    }

    @Override
    public TestBio loadTestBio(Integer idTestBio) throws DataNotFoundException {
        return (TestBio)this.dao.read(TestBio.class, (Serializable)idTestBio);
    }

    @Override
    public TestBio loadTestBio(String nom) throws DataNotFoundException {
        return (TestBio)this.dao.read(TestBio.class, "nom", (Serializable)((Object)nom));
    }

    @Override
    public void updateTestBio(TestBio testBio) throws DataConstraintException {
        LOG.info("updateTestBio: " + testBio.getRef());
        try {
            this.dao.update((AbstractModel)testBio);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void refreshTestBio(TestBio testBio) {
        this.dao.refresh((AbstractModel)testBio);
    }

    @Override
    public boolean updateOrdeleteTestBioEnabled(TestBio testBio, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == testBio.getCreateur().getIdPersonne();
    }

    @Override
    public void createMethodeTestBio(MethodeTestBio methode) throws DataConstraintException {
        LOG.info("createMethodeTest: " + methode.getNom());
        this.dao.create((AbstractModel)methode);
    }

    @Override
    public void deleteMethodeTestBio(MethodeTestBio methode) throws DataConstraintException {
        AssertTools.assertNotNull((Object)methode);
        LOG.info("deleteMethodeTest: " + methode.getNom());
        try {
            this.dao.delete((AbstractModel)methode);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<MethodeTestBio> listMethodesTestBio() {
        return this.dao.readList(MethodeTestBio.class, new String[]{"nom"});
    }

    @Override
    public List<String> listDomainesMethodes() {
        return this.dao.list(TestBioDao.CRITERIA_DISTINCT_DOMAINES_METHODES);
    }

    @Override
    public List<String> listUnitesResultatMethodes() {
        return this.dao.list(TestBioDao.CRITERIA_DISTINCT_UNITES_RESULTAT_METHODES);
    }

    @Override
    public MethodeTestBio loadMethodeTest(Integer idMethode) throws DataNotFoundException {
        return (MethodeTestBio)this.dao.read(MethodeTestBio.class, (Serializable)idMethode);
    }

    @Override
    public MethodeTestBio loadMethodeTest(String nom) throws DataNotFoundException {
        return (MethodeTestBio)this.dao.read(MethodeTestBio.class, "nom", (Serializable)((Object)nom));
    }

    @Override
    public void updateMethodeTest(MethodeTestBio methode) throws DataConstraintException {
        LOG.info("updateMethodeTest: " + methode.getNom());
        try {
            this.dao.update((AbstractModel)methode);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void refreshMethodeTestBio(MethodeTestBio methode) {
        AssertTools.assertNotNull((Object)methode);
        this.dao.refresh((AbstractModel)methode);
    }

    @Override
    public void createErreurTest(ErreurTestBio erreurTest) throws DataConstraintException {
        LOG.info("createErreurTest: " + erreurTest.getNom());
        this.dao.create((AbstractModel)erreurTest);
    }

    @Override
    public void deleteErreurTest(ErreurTestBio erreurTest) throws DataConstraintException {
        AssertTools.assertNotNull((Object)erreurTest);
        LOG.info("deleteErreurTest: " + erreurTest.getNom());
        try {
            this.dao.delete((AbstractModel)erreurTest);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<ErreurTestBio> listErreursTestBio() {
        return this.dao.readList(ErreurTestBio.class, new String[]{"nom"});
    }

    @Override
    public ErreurTestBio loadErreurTestBio(Integer idErreurTest) throws DataNotFoundException {
        return (ErreurTestBio)this.dao.read(ErreurTestBio.class, (Serializable)idErreurTest);
    }

    @Override
    public ErreurTestBio loadErreurTestBio(String nom) throws DataNotFoundException {
        return (ErreurTestBio)this.dao.read(ErreurTestBio.class, "nom", (Serializable)((Object)nom));
    }

    @Override
    public void updateErreurTestBio(ErreurTestBio erreurTest) throws DataConstraintException {
        LOG.info("updateErreurTest: " + erreurTest.getNom());
        try {
            this.dao.update((AbstractModel)erreurTest);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }
}

