/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.ExtractionDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.MethodeExtraction;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.utils.AssertTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ExtractionServiceImpl
implements ExtractionService {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractionServiceImpl.class);
    @Autowired
    private GenericDao dao;
    @Autowired
    private LotService lotService;

    @Override
    public long countExtractions() {
        return this.dao.count(Extraction.class);
    }

    @Override
    public void createExtraction(Extraction extraction) throws DataConstraintException {
        LOG.info("createExtraction: " + extraction.getRef());
        this.dao.create((AbstractModel)extraction);
    }

    @Override
    public void deleteExtraction(Extraction extraction) throws DataConstraintException {
        AssertTools.assertNotNull((Object)extraction);
        LOG.info("deleteExtraction: " + extraction.getRef());
        try {
            this.dao.delete((AbstractModel)extraction);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<Extraction> listExtractions(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            TreeSet extractions = new TreeSet(this.dao.readList(Extraction.class));
            return new ArrayList<Extraction>(extractions);
        }
        return new ArrayList<Extraction>(this.listExtractionsForUser(utilisateur));
    }

    @Override
    public SortedSet<Extraction> listExtractionsForUser(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        TreeSet<Extraction> extractions = new TreeSet<Extraction>();
        extractions.addAll(utilisateur.getExtractionsCrees());
        SortedSet<Lot> lotsAllowed = this.lotService.listLotsForUser(utilisateur);
        for (Lot l : lotsAllowed) {
            extractions.addAll(l.getExtractions());
        }
        return extractions;
    }

    @Override
    public boolean isExtractionUnique(Extraction extraction) {
        Extraction extrWithSameVal;
        AssertTools.assertNotNull((Object)extraction);
        if (!this.dao.exists(Extraction.class, "ref", (Serializable)((Object)extraction.getRef()))) {
            return true;
        }
        try {
            extrWithSameVal = (Extraction)this.dao.read(Extraction.class, "ref", (Serializable)((Object)extraction.getRef()));
            this.dao.evict((AbstractModel)extrWithSameVal);
        }
        catch (DataNotFoundException e) {
            return true;
        }
        return extraction.getIdExtraction() != null && extraction.getIdExtraction().equals(extrWithSameVal.getIdExtraction());
    }

    @Override
    public Extraction loadExtraction(Integer idExtraction) throws DataNotFoundException {
        LOG.debug("read Extraction");
        return (Extraction)this.dao.read(Extraction.class, (Serializable)idExtraction);
    }

    @Override
    public Extraction loadExtraction(String ref) throws DataNotFoundException {
        return (Extraction)this.dao.read(Extraction.class, "ref", (Serializable)((Object)ref));
    }

    @Override
    public void updateExtraction(Extraction extraction) throws DataConstraintException {
        LOG.info("updateExtraction: " + extraction.getRef());
        try {
            this.dao.update((AbstractModel)extraction);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public boolean updateOrdeleteExtractionEnabled(Extraction extraction, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == extraction.getCreateur().getIdPersonne();
    }

    @Override
    public void createMethodeExtraction(MethodeExtraction methode) throws DataConstraintException {
        LOG.info("createMethodeExtraction: " + methode.getNom());
        this.dao.create((AbstractModel)methode);
    }

    @Override
    public void deleteMethodeExtraction(MethodeExtraction methode) throws DataConstraintException {
        AssertTools.assertNotNull((Object)methode);
        LOG.info("deleteMethodeExtraction: " + methode.getNom());
        try {
            this.dao.delete((AbstractModel)methode);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<MethodeExtraction> listMethodesExtraction() {
        return this.dao.readList(MethodeExtraction.class, new String[]{"nom"});
    }

    @Override
    public MethodeExtraction loadMethodeExtraction(Integer idMethode) throws DataNotFoundException {
        return (MethodeExtraction)this.dao.read(MethodeExtraction.class, (Serializable)idMethode);
    }

    @Override
    public MethodeExtraction loadMethodeExtraction(String nom) throws DataNotFoundException {
        return (MethodeExtraction)this.dao.read(MethodeExtraction.class, "nom", (Serializable)((Object)nom));
    }

    @Override
    public void updateMethodeExtraction(MethodeExtraction methode) throws DataConstraintException {
        LOG.info("updateMethodeExtraction: " + methode.getNom());
        try {
            this.dao.update((AbstractModel)methode);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void refreshMethodeExtraction(MethodeExtraction methode) {
        AssertTools.assertNotNull((Object)methode);
        this.dao.refresh((AbstractModel)methode);
    }

    @Override
    public boolean isTypeExtraitReferenced(TypeExtrait typeExtrait) {
        AssertTools.assertNotNull((Object)typeExtrait);
        AssertTools.assertNotNull((Object)typeExtrait.getIdTypeExtrait());
        return this.dao.count(ExtractionDao.getCriteriaCountExtraitOfTypeExtrait((Integer)typeExtrait.getIdTypeExtrait())) > 0L;
    }

    @Override
    public boolean isExtraitUnique(Extrait extrait) {
        Extrait extrWithSameVal;
        AssertTools.assertNotNull((Object)extrait);
        if (!this.dao.exists(Extrait.class, "ref", (Serializable)((Object)extrait.getRef()))) {
            return true;
        }
        try {
            extrWithSameVal = (Extrait)this.dao.read(Extrait.class, "ref", (Serializable)((Object)extrait.getRef()));
            this.dao.evict((AbstractModel)extrWithSameVal);
        }
        catch (DataNotFoundException e) {
            return true;
        }
        return extrait.getId() != null && extrait.getId().equals(extrWithSameVal.getId());
    }
}

