/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.utils.normalizers;

import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.TestBio;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.StringTransformer;

public final class TestBioNormalizer
extends Normalizer<TestBio> {
    @Override
    protected TestBio normalize(TestBio testBio) {
        AssertTools.assertNotNull((Object)testBio);
        testBio.setRef(Normalizer.normalize(UniqueFieldNormalizer.class, testBio.getRef()));
        testBio.setOrganismeTesteur(new StringTransformer(testBio.getOrganismeTesteur()).replaceConsecutiveWhitespaces().trimToNull().capitalizeFully().toString());
        for (ResultatTestBio resultatTestBio : testBio.getResultats()) {
            resultatTestBio.setRepere(Normalizer.normalize(UniqueFieldNormalizer.class, resultatTestBio.getRepere()));
            resultatTestBio.setProduitTemoin(new StringTransformer(resultatTestBio.getProduitTemoin()).replaceConsecutiveWhitespaces().trimToNull().capitalizeFully().toString());
        }
        return testBio;
    }
}

