/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.utils.normalizers;

import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.StringTransformer;

public final class SpecimenNormalizer
extends Normalizer<Specimen> {
    @Override
    protected Specimen normalize(Specimen specimen) {
        AssertTools.assertNotNull((Object)specimen);
        specimen.setRef(SpecimenNormalizer.normalize(UniqueFieldNormalizer.class, specimen.getRef()));
        specimen.setEmbranchement(new StringTransformer(specimen.getEmbranchement()).replaceConsecutiveWhitespaces().trimToNull().toLowerCase().capitalize().toString());
        specimen.setFamille(new StringTransformer(specimen.getFamille()).replaceConsecutiveWhitespaces().trimToNull().toLowerCase().capitalize().toString());
        specimen.setGenre(new StringTransformer(specimen.getGenre()).replaceConsecutiveWhitespaces().trimToNull().toLowerCase().capitalize().toString());
        specimen.setEspece(new StringTransformer(specimen.getEspece()).replaceConsecutiveWhitespaces().trimToNull().toLowerCase().toString());
        specimen.setSousEspece(new StringTransformer(specimen.getSousEspece()).replaceConsecutiveWhitespaces().trimToNull().toLowerCase().toString());
        specimen.setVariete(new StringTransformer(specimen.getVariete()).replaceConsecutiveWhitespaces().trimToNull().toLowerCase().toString());
        specimen.setLieuDepot(new StringTransformer(specimen.getLieuDepot()).trimToNull().replaceConsecutiveWhitespaces().toString());
        return specimen;
    }
}

