/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.TestBioDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.ErreurTestBio;
import nc.ird.cantharella.data.model.MethodeTestBio;
import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.TestBio;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.TestBioService;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class TestBioServiceImpl
implements TestBioService {
    private static final Log LOG = LogTools.getLog();
    @Autowired
    private LotService lotService;
    @Autowired
    private GenericDao dao;

    @Override
    public long countResultatsTestsBio() {
        return this.dao.count(TestBioDao.CRITERIA_COUNT_RESULTATS_TYPE_PRODUIT);
    }

    @Override
    public void createTestBio(TestBio testBio) throws DataConstraintException {
        LOG.info((Object)("createTestBio: " + testBio.getRef()));
        this.dao.create((AbstractModel)testBio);
    }

    @Override
    public void deleteTestBio(TestBio testBio) throws DataConstraintException {
        AssertTools.assertNotNull((Object)testBio);
        LOG.info((Object)("deleteTestBio: " + testBio.getRef()));
        try {
            this.dao.delete((AbstractModel)testBio);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<ResultatTestBio> listResultatsTestBio(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.list(TestBioDao.CRITERIA_LIST_RESULTATS_TYPE_PRODUIT);
        }
        return new ArrayList<ResultatTestBio>(this.listResultatsTestBioForUser(utilisateur));
    }

    @Override
    public SortedSet<ResultatTestBio> listResultatsTestBioForUser(Utilisateur utilisateur) {
        TreeSet<ResultatTestBio> treeSet = new TreeSet<ResultatTestBio>();
        List list = this.dao.list(TestBioDao.CRITERIA_LIST_RESULTATS_TYPE_PRODUIT);
        for (ResultatTestBio resultatTestBio : list) {
            if (!this.lotService.isLotAccessibleByUser(resultatTestBio.getLotSource(), utilisateur)) continue;
            treeSet.add(resultatTestBio);
        }
        return treeSet;
    }

    @Override
    public List<String> listProduitsTemoins() {
        return this.dao.list(TestBioDao.CRITERIA_DISTINCT_PRODUITS_TEMOINS);
    }

    @Override
    public boolean isResultatTestBioAccessibleByUser(ResultatTestBio resultatTestBio, Utilisateur utilisateur) {
        return this.lotService.isLotAccessibleByUser(resultatTestBio.getLotSource(), utilisateur);
    }

    @Override
    public boolean isResultatTestBioUniqueInList(ResultatTestBio resultatTestBio, List<ResultatTestBio> list) {
        AssertTools.assertNotNull((Object)resultatTestBio.getTypeResultat());
        AssertTools.assertNotNull((Object)resultatTestBio.getRepere());
        int n = 0;
        for (ResultatTestBio resultatTestBio2 : list) {
            if (resultatTestBio.getTypeResultat() == ResultatTestBio.TypeResultat.BLANC && resultatTestBio.getRepere().equals(resultatTestBio2.getRepere())) {
                ++n;
                continue;
            }
            if (resultatTestBio.getTypeResultat() == ResultatTestBio.TypeResultat.TEMOIN && resultatTestBio.getRepere().equals(resultatTestBio2.getRepere()) && resultatTestBio.getProduitTemoin().equals(resultatTestBio2.getProduitTemoin())) {
                ++n;
                continue;
            }
            if (resultatTestBio.getTypeResultat() != ResultatTestBio.TypeResultat.PRODUIT || !resultatTestBio.getRepere().equals(resultatTestBio2.getRepere()) || !resultatTestBio.getProduit().getRef().equals(resultatTestBio2.getProduit().getRef())) continue;
            ++n;
        }
        return n <= 1;
    }

    @Override
    public boolean isTestBioUnique(TestBio testBio) {
        TestBio testBio2;
        AssertTools.assertNotNull((Object)testBio);
        if (!this.dao.exists(TestBio.class, "ref", (Serializable)((Object)testBio.getRef()))) {
            return true;
        }
        try {
            testBio2 = (TestBio)this.dao.read(TestBio.class, "ref", (Serializable)((Object)testBio.getRef()));
            this.dao.evict((AbstractModel)testBio2);
        }
        catch (DataNotFoundException dataNotFoundException) {
            return true;
        }
        return testBio.getIdTestBio() != null && testBio.getIdTestBio().equals(testBio2.getIdTestBio());
    }

    @Override
    public TestBio loadTestBio(Integer n) throws DataNotFoundException {
        return (TestBio)this.dao.read(TestBio.class, (Serializable)n);
    }

    @Override
    public TestBio loadTestBio(String string) throws DataNotFoundException {
        return (TestBio)this.dao.read(TestBio.class, "nom", (Serializable)((Object)string));
    }

    @Override
    public void updateTestBio(TestBio testBio) throws DataConstraintException {
        LOG.info((Object)("updateTestBio: " + testBio.getRef()));
        try {
            this.dao.update((AbstractModel)testBio);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public void refreshTestBio(TestBio testBio) {
        this.dao.refresh((AbstractModel)testBio);
    }

    @Override
    public boolean updateOrdeleteTestBioEnabled(TestBio testBio, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == testBio.getCreateur().getIdPersonne();
    }

    @Override
    public void createMethodeTestBio(MethodeTestBio methodeTestBio) throws DataConstraintException {
        LOG.info((Object)("createMethodeTest: " + methodeTestBio.getNom()));
        this.dao.create((AbstractModel)methodeTestBio);
    }

    @Override
    public void deleteMethodeTestBio(MethodeTestBio methodeTestBio) throws DataConstraintException {
        AssertTools.assertNotNull((Object)methodeTestBio);
        LOG.info((Object)("deleteMethodeTest: " + methodeTestBio.getNom()));
        try {
            this.dao.delete((AbstractModel)methodeTestBio);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<MethodeTestBio> listMethodesTestBio() {
        return this.dao.readList(MethodeTestBio.class, new String[]{"nom"});
    }

    @Override
    public List<String> listDomainesMethodes() {
        return this.dao.list(TestBioDao.CRITERIA_DISTINCT_DOMAINES_METHODES);
    }

    @Override
    public List<String> listUnitesResultatMethodes() {
        return this.dao.list(TestBioDao.CRITERIA_DISTINCT_UNITES_RESULTAT_METHODES);
    }

    @Override
    public MethodeTestBio loadMethodeTest(Integer n) throws DataNotFoundException {
        return (MethodeTestBio)this.dao.read(MethodeTestBio.class, (Serializable)n);
    }

    @Override
    public MethodeTestBio loadMethodeTest(String string) throws DataNotFoundException {
        return (MethodeTestBio)this.dao.read(MethodeTestBio.class, "nom", (Serializable)((Object)string));
    }

    @Override
    public void updateMethodeTest(MethodeTestBio methodeTestBio) throws DataConstraintException {
        LOG.info((Object)("updateMethodeTest: " + methodeTestBio.getNom()));
        try {
            this.dao.update((AbstractModel)methodeTestBio);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public void refreshMethodeTestBio(MethodeTestBio methodeTestBio) {
        AssertTools.assertNotNull((Object)methodeTestBio);
        this.dao.refresh((AbstractModel)methodeTestBio);
    }

    @Override
    public void createErreurTest(ErreurTestBio erreurTestBio) throws DataConstraintException {
        LOG.info((Object)("createErreurTest: " + erreurTestBio.getNom()));
        this.dao.create((AbstractModel)erreurTestBio);
    }

    @Override
    public void deleteErreurTest(ErreurTestBio erreurTestBio) throws DataConstraintException {
        AssertTools.assertNotNull((Object)erreurTestBio);
        LOG.info((Object)("deleteErreurTest: " + erreurTestBio.getNom()));
        try {
            this.dao.delete((AbstractModel)erreurTestBio);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<ErreurTestBio> listErreursTestBio() {
        return this.dao.readList(ErreurTestBio.class, new String[]{"nom"});
    }

    @Override
    public ErreurTestBio loadErreurTestBio(Integer n) throws DataNotFoundException {
        return (ErreurTestBio)this.dao.read(ErreurTestBio.class, (Serializable)n);
    }

    @Override
    public ErreurTestBio loadErreurTestBio(String string) throws DataNotFoundException {
        return (ErreurTestBio)this.dao.read(ErreurTestBio.class, "nom", (Serializable)((Object)string));
    }

    @Override
    public void updateErreurTestBio(ErreurTestBio erreurTestBio) throws DataConstraintException {
        LOG.info((Object)("updateErreurTest: " + erreurTestBio.getNom()));
        try {
            this.dao.update((AbstractModel)erreurTestBio);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }
}

