/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.SpecimenDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.SpecimenService;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class SpecimenServiceImpl
implements SpecimenService {
    private static final Log LOG = LogTools.getLog();
    @Autowired
    private GenericDao dao;

    @Override
    public long countSpecimens() {
        return this.dao.count(Specimen.class);
    }

    @Override
    public void createSpecimen(Specimen specimen) throws DataConstraintException {
        LOG.info((Object)("createSpecimen: " + specimen.getRef()));
        this.dao.create((AbstractModel)specimen);
    }

    @Override
    public void deleteSpecimen(Specimen specimen) throws DataConstraintException {
        AssertTools.assertNotNull((Object)specimen);
        LOG.info((Object)("deleteSpecimen " + specimen.getRef()));
        try {
            this.dao.delete((AbstractModel)specimen);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<Specimen> listSpecimens(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.readList(Specimen.class, new String[]{"ref"});
        }
        SortedSet<Specimen> sortedSet = this.listSpecimensForUser(utilisateur);
        return new ArrayList<Specimen>(sortedSet);
    }

    @Override
    public SortedSet<Specimen> listSpecimensForUser(Utilisateur utilisateur) {
        Object object2;
        TreeSet<Specimen> treeSet = new TreeSet<Specimen>();
        treeSet.addAll(utilisateur.getSpecimensCrees());
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(utilisateur.getCampagnesCreees());
        arrayList.addAll(utilisateur.getCampagnesDroits().keySet());
        for (Object object2 : arrayList) {
            for (Station station : object2.getStations()) {
                treeSet.addAll(station.getSpecimensRattaches());
            }
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(utilisateur.getLotsCrees());
        arrayList2.addAll(utilisateur.getLotsDroits().keySet());
        object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            Lot lot = (Lot)object2.next();
            if (lot.getSpecimenRef().getStation() == null) continue;
            treeSet.add(lot.getSpecimenRef());
        }
        return treeSet;
    }

    @Override
    public List<String> listSpecimenEmbranchements() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_EMBRANCHEMENTS);
    }

    @Override
    public List<String> listSpecimenFamilles() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_FAMILLES);
    }

    @Override
    public List<String> listSpecimenGenres() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_GENRES);
    }

    @Override
    public List<String> listSpecimenEspeces() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_ESPECES);
    }

    @Override
    public List<String> listSpecimenSousEspeces() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_SOUSESPECES);
    }

    @Override
    public List<String> listSpecimenVarietes() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_SPECIMEN_VARIETES);
    }

    @Override
    public List<String> listLieuxDepot() {
        return this.dao.list(SpecimenDao.CRITERIA_DISTINCT_LIEUX_DEPOT);
    }

    @Override
    public Specimen loadSpecimen(Integer n) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)n);
        return (Specimen)this.dao.read(Specimen.class, (Serializable)n);
    }

    @Override
    public Specimen loadSpecimen(String string) throws DataNotFoundException {
        AssertTools.assertNotEmpty((String)string);
        return (Specimen)this.dao.read(Specimen.class, "ref", (Serializable)((Object)string));
    }

    @Override
    public boolean updateOrdeleteSpecimenEnabled(Specimen specimen, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == specimen.getCreateur().getIdPersonne();
    }

    @Override
    public void updateSpecimen(Specimen specimen) throws DataConstraintException {
        LOG.info((Object)("updateSpecimen " + specimen.getIdSpecimen()));
        try {
            this.dao.update((AbstractModel)specimen);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }
}

