/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.ParamMethoPuri;
import nc.ird.cantharella.data.model.ParamMethoPuriEffectif;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.service.services.PurificationService;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class PurificationServiceImpl
implements PurificationService {
    private static final Log LOG = LogTools.getLog();
    @Autowired
    private GenericDao dao;
    @Autowired
    private ExtractionService extractionService;

    @Override
    public long countPurifications() {
        return this.dao.count(Purification.class);
    }

    @Override
    public void createPurification(Purification purification) throws DataConstraintException {
        LOG.info((Object)("createPurification: " + purification.getRef()));
        this.dao.create((AbstractModel)purification);
    }

    @Override
    public void initParamsMethoPuriEffectif(Purification purification) {
        AssertTools.assertNotNull((Object)purification);
        if (purification.getMethode() != null) {
            this.refreshMethodePurification(purification.getMethode());
            this.refreshMethodePurification(purification.getMethode());
            purification.getParamsMetho().clear();
            for (int i = 0; i < purification.getMethode().getParametres().size(); ++i) {
                ParamMethoPuri paramMethoPuri = (ParamMethoPuri)purification.getMethode().getParametres().get(i);
                ParamMethoPuriEffectif paramMethoPuriEffectif = new ParamMethoPuriEffectif();
                paramMethoPuriEffectif.setParam(paramMethoPuri);
                paramMethoPuriEffectif.setPurification(purification);
                purification.getParamsMetho().add(paramMethoPuriEffectif);
            }
        }
    }

    @Override
    public void deletePurification(Purification purification) throws DataConstraintException {
        AssertTools.assertNotNull((Object)purification);
        LOG.info((Object)("deletePurification: " + purification.getRef()));
        try {
            this.dao.delete((AbstractModel)purification);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<Purification> listPurifications(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.readList(Purification.class, new String[]{"produit", "ref"});
        }
        return new ArrayList<Purification>(this.listPurificationsForUser(utilisateur));
    }

    @Override
    public SortedSet<Purification> listPurificationsForUser(Utilisateur utilisateur) {
        TreeSet<Purification> treeSet = new TreeSet<Purification>();
        treeSet.addAll(utilisateur.getPurificationsCrees());
        this.addAllPurificationsOfExtractions(treeSet, this.extractionService.listExtractionsForUser(utilisateur));
        return treeSet;
    }

    private void addAllPurificationsOfExtractions(Set<Purification> set, Set<Extraction> set2) {
        for (Extraction extraction : set2) {
            for (Extrait extrait : extraction.getExtraits()) {
                for (Purification purification : extrait.getPurificationsSuivantes()) {
                    set.add(purification);
                    LinkedList linkedList = new LinkedList(purification.getFractions());
                    while (!linkedList.isEmpty()) {
                        Fraction fraction = (Fraction)linkedList.remove();
                        for (Purification purification2 : fraction.getPurificationsSuivantes()) {
                            set.add(purification2);
                            linkedList.addAll(purification2.getFractions());
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isPurificationUnique(Purification purification) {
        Purification purification2;
        AssertTools.assertNotNull((Object)purification);
        if (!this.dao.exists(Purification.class, "ref", (Serializable)((Object)purification.getRef()))) {
            return true;
        }
        try {
            purification2 = (Purification)this.dao.read(Purification.class, "ref", (Serializable)((Object)purification.getRef()));
            this.dao.evict((AbstractModel)purification2);
        }
        catch (DataNotFoundException dataNotFoundException) {
            return true;
        }
        return purification.getIdPurification() != null && purification.getIdPurification().equals(purification2.getIdPurification());
    }

    @Override
    public Purification loadPurification(Integer n) throws DataNotFoundException {
        return (Purification)this.dao.read(Purification.class, (Serializable)n);
    }

    @Override
    public Purification loadPurification(String string) throws DataNotFoundException {
        return (Purification)this.dao.read(Purification.class, "nom", (Serializable)((Object)string));
    }

    @Override
    public void updatePurification(Purification purification) throws DataConstraintException {
        LOG.info((Object)("updatePurification: " + purification.getRef()));
        try {
            this.dao.update((AbstractModel)purification);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public void refreshPurification(Purification purification) {
        this.dao.refresh((AbstractModel)purification);
    }

    @Override
    public boolean updateOrdeletePurificationEnabled(Purification purification, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == purification.getCreateur().getIdPersonne();
    }

    @Override
    public void createMethodePurification(MethodePurification methodePurification) throws DataConstraintException {
        LOG.info((Object)("createMethodePurification: " + methodePurification.getNom()));
        this.dao.create((AbstractModel)methodePurification);
    }

    @Override
    public void deleteMethodePurification(MethodePurification methodePurification) throws DataConstraintException {
        AssertTools.assertNotNull((Object)methodePurification);
        LOG.info((Object)("deleteMethodePurification: " + methodePurification.getNom()));
        try {
            this.dao.delete((AbstractModel)methodePurification);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<MethodePurification> listMethodesPurification() {
        return this.dao.readList(MethodePurification.class, new String[]{"nom"});
    }

    @Override
    public MethodePurification loadMethodePurification(Integer n) throws DataNotFoundException {
        return (MethodePurification)this.dao.read(MethodePurification.class, (Serializable)n);
    }

    @Override
    public MethodePurification loadMethodePurification(String string) throws DataNotFoundException {
        return (MethodePurification)this.dao.read(MethodePurification.class, "nom", (Serializable)((Object)string));
    }

    @Override
    public void updateMethodePurification(MethodePurification methodePurification) throws DataConstraintException {
        LOG.info((Object)("updateMethodePurification: " + methodePurification.getNom()));
        try {
            this.dao.update((AbstractModel)methodePurification);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public void refreshMethodePurification(MethodePurification methodePurification) {
        AssertTools.assertNotNull((Object)methodePurification);
        this.dao.refresh((AbstractModel)methodePurification);
    }

    @Override
    public boolean isParamMethoPuriReferenced(ParamMethoPuri paramMethoPuri) {
        AssertTools.assertNotNull((Object)paramMethoPuri);
        AssertTools.assertNotNull((Object)paramMethoPuri.getIdParamMethoPuri());
        return this.dao.count("select count(purif) from Purification purif inner join purif.paramsMetho paramsEff where paramsEff.id.pk2.idParamMethoPuri = ?", new Object[]{paramMethoPuri.getIdParamMethoPuri()}) > 0L;
    }

    @Override
    public boolean isFractionUnique(Fraction fraction) {
        Fraction fraction2;
        AssertTools.assertNotNull((Object)fraction);
        if (!this.dao.exists(Fraction.class, "ref", (Serializable)((Object)fraction.getRef()))) {
            return true;
        }
        try {
            fraction2 = (Fraction)this.dao.read(Fraction.class, "ref", (Serializable)((Object)fraction.getRef()));
            this.dao.evict((AbstractModel)fraction2);
        }
        catch (DataNotFoundException dataNotFoundException) {
            return true;
        }
        return fraction.getId() != null && fraction.getId().equals(fraction2.getId());
    }
}

