/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.CampagneDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class CampagneServiceImpl
implements CampagneService {
    private static final Log LOG = LogTools.getLog();
    @Autowired
    private GenericDao dao;

    @Override
    public long countCampagnes() {
        return this.dao.count(Campagne.class);
    }

    @Override
    public void createCampagne(Campagne campagne) throws DataConstraintException {
        LOG.info((Object)("createCampagne " + campagne.getNom()));
        this.dao.create((AbstractModel)campagne);
    }

    @Override
    public void deleteCampagne(Campagne campagne) throws DataConstraintException {
        AssertTools.assertNotNull((Object)campagne);
        LOG.info((Object)("deleteCampagne " + campagne.getIdCampagne()));
        try {
            this.dao.delete((AbstractModel)campagne);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<String> listCampagneProgrammes() {
        return this.dao.list(CampagneDao.CRITERIA_DISTINCT_CAMPAGNE_PROGRAMMES);
    }

    @Override
    public List<Campagne> listCampagnes(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.readList(Campagne.class, new String[]{"nom"});
        }
        SortedSet<Campagne> sortedSet = this.listCampagnesForUser(utilisateur);
        return new ArrayList<Campagne>(sortedSet);
    }

    @Override
    public SortedSet<Campagne> listCampagnesForUser(Utilisateur utilisateur) {
        TreeSet<Campagne> treeSet = new TreeSet<Campagne>();
        treeSet.addAll(utilisateur.getCampagnesCreees());
        treeSet.addAll(utilisateur.getCampagnesDroits().keySet());
        for (Lot lot : utilisateur.getLotsCrees()) {
            treeSet.add(lot.getCampagne());
        }
        for (Lot lot : utilisateur.getLotsDroits().keySet()) {
            treeSet.add(lot.getCampagne());
        }
        return treeSet;
    }

    @Override
    public Campagne loadCampagne(Integer n) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)n);
        return (Campagne)this.dao.read(Campagne.class, (Serializable)n);
    }

    @Override
    public Campagne loadCampagne(String string) throws DataNotFoundException {
        AssertTools.assertNotEmpty((String)string);
        return (Campagne)this.dao.read(Campagne.class, "nom", (Serializable)((Object)string));
    }

    @Override
    public void refreshCampagne(Campagne campagne) {
        AssertTools.assertNotNull((Object)campagne);
        this.dao.refresh((AbstractModel)campagne);
    }

    @Override
    public void updateCampagne(Campagne campagne) throws DataConstraintException {
        LOG.info((Object)("updateCampagne " + campagne.getIdCampagne()));
        try {
            this.dao.update((AbstractModel)campagne);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public boolean updateOrdeleteCampagneEnabled(Campagne campagne, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == campagne.getCreateur().getIdPersonne();
    }
}

