/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.init;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.init.I18nInitializer;

public class ClassPathI18nInitializer
extends I18nInitializer {
    private static final Log log = LogFactory.getLog(ClassPathI18nInitializer.class);
    protected ClassLoader loader;
    protected URL[] extraURLs;

    public ClassPathI18nInitializer() {
        this(null, null);
    }

    public ClassPathI18nInitializer(ClassLoader loader) {
        this(loader, null);
    }

    public ClassPathI18nInitializer(ClassLoader loader, URL[] extraURLs) {
        this.loader = loader == null ? this.getClass().getClassLoader() : loader;
        this.extraURLs = extraURLs;
    }

    public URL[] resolvURLs() throws Exception {
        ArrayList<URL> urlToSeek = new ArrayList<URL>();
        URLClassLoader loader = (URLClassLoader)this.getLoader();
        urlToSeek.addAll(Arrays.asList(I18nUtil.getDeepURLs(loader)));
        int size = urlToSeek.size();
        Iterator it = urlToSeek.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            if (I18nUtil.containsDirectDirectory(url, "i18n")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("skip url with no %s directory : %s", "i18n", url));
            }
            it.remove();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("detect %d i18n capable url (out of %d)", urlToSeek.size(), size));
        }
        URL[] url1 = urlToSeek.toArray(new URL[urlToSeek.size()]);
        URL[] result = I18nBundleUtil.getURLs(url1);
        if (log.isDebugEnabled()) {
            for (URL url : result) {
                log.debug((Object)url.toString());
            }
        }
        return result;
    }

    @Override
    public I18nBundle[] resolvBundles() throws Exception {
        URL[] urls = this.resolvURLs();
        return this.resolvBundles(urls);
    }

    public URL[] getExtraURLs() {
        return this.extraURLs;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }
}

