/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.plugin;

import io.takari.maven.plugins.plugin.Sorting;
import io.takari.maven.plugins.plugin.model.MojoDescriptor;
import io.takari.maven.plugins.plugin.model.MojoParameter;
import io.takari.maven.plugins.plugin.model.MojoRequirement;
import io.takari.maven.plugins.plugin.model.PluginDependency;
import io.takari.maven.plugins.plugin.model.PluginDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

class PluginDescriptorWriter {
    private static final String encoding = "UTF-8";

    PluginDescriptorWriter() {
    }

    public void writeDescriptor(OutputStream outputStream, PluginDescriptor pluginDescriptor) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, encoding);
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer, encoding, null);
        w.writeMarkup("\n<!-- Generated by takari-plugin-tools -->\n\n");
        w.startElement("plugin");
        this.element((XMLWriter)w, "name", pluginDescriptor.getName());
        this.element((XMLWriter)w, "description", pluginDescriptor.getDescription());
        this.element((XMLWriter)w, "groupId", pluginDescriptor.getGroupId());
        this.element((XMLWriter)w, "artifactId", pluginDescriptor.getArtifactId());
        this.element((XMLWriter)w, "version", pluginDescriptor.getVersion());
        this.element((XMLWriter)w, "goalPrefix", pluginDescriptor.getGoalPrefix());
        this.element((XMLWriter)w, "isolatedRealm", String.valueOf(pluginDescriptor.isIsolatedRealm()));
        this.element((XMLWriter)w, "inheritedByDefault", String.valueOf(pluginDescriptor.isInheritedByDefault()));
        this.writeMojos((XMLWriter)w, pluginDescriptor);
        this.writeDependencies((XMLWriter)w, pluginDescriptor);
        w.endElement();
        writer.flush();
    }

    private void writeMojos(XMLWriter w, PluginDescriptor pluginDescriptor) {
        w.startElement("mojos");
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>(pluginDescriptor.getMojos());
        Sorting.sortDescriptors(descriptors);
        for (MojoDescriptor descriptor : descriptors) {
            this.writeMojoDescriptor(descriptor, w);
        }
        w.endElement();
    }

    private void writeDependencies(XMLWriter w, PluginDescriptor pluginDescriptor) {
        w.startElement("dependencies");
        List<PluginDependency> deps = pluginDescriptor.getDependencies();
        for (PluginDependency dep : deps) {
            w.startElement("dependency");
            this.element(w, "groupId", dep.getGroupId());
            this.element(w, "artifactId", dep.getArtifactId());
            this.element(w, "type", dep.getType());
            this.element(w, "version", dep.getVersion());
            w.endElement();
        }
        w.endElement();
    }

    private void element(XMLWriter w, String name, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            w.startElement(name);
            w.writeText(value != null ? value : "");
            w.endElement();
        }
    }

    protected void writeMojoDescriptor(MojoDescriptor mojoDescriptor, XMLWriter w) {
        ArrayList<MojoRequirement> requirements;
        w.startElement("mojo");
        this.element(w, "goal", mojoDescriptor.getGoal());
        this.element(w, "description", mojoDescriptor.getDescription());
        this.element(w, "requiresDependencyResolution", mojoDescriptor.getRequiresDependencyResolution());
        this.element(w, "requiresDependencyCollection", mojoDescriptor.getRequiresDependencyCollection());
        this.element(w, "requiresDirectInvocation", String.valueOf(mojoDescriptor.isRequiresDirectInvocation()));
        this.element(w, "requiresProject", String.valueOf(mojoDescriptor.isRequiresProject()));
        this.element(w, "requiresReports", String.valueOf(mojoDescriptor.isRequiresReports()));
        this.element(w, "aggregator", String.valueOf(mojoDescriptor.isAggregator()));
        this.element(w, "requiresOnline", String.valueOf(mojoDescriptor.isRequiresOnline()));
        this.element(w, "inheritedByDefault", String.valueOf(mojoDescriptor.isInheritedByDefault()));
        this.element(w, "phase", mojoDescriptor.getPhase());
        this.element(w, "threadSafe", String.valueOf(mojoDescriptor.isThreadSafe()));
        this.element(w, "implementation", mojoDescriptor.getImplementation());
        this.element(w, "language", mojoDescriptor.getLanguage());
        this.element(w, "configurator", mojoDescriptor.getConfigurator());
        this.element(w, "instantiationStrategy", mojoDescriptor.getInstantiationStrategy());
        this.element(w, "executionStrategy", mojoDescriptor.getExecutionStrategy());
        this.element(w, "since", mojoDescriptor.getSince());
        this.element(w, "deprecated", mojoDescriptor.getDeprecated());
        LinkedHashSet<MojoParameter> configuration = new LinkedHashSet<MojoParameter>();
        w.startElement("parameters");
        ArrayList<MojoParameter> parameters = new ArrayList<MojoParameter>(mojoDescriptor.getParameters());
        Sorting.sortParameters(parameters);
        for (MojoParameter parameter : parameters) {
            w.startElement("parameter");
            this.element(w, "name", parameter.getName());
            this.element(w, "alias", parameter.getAlias());
            this.element(w, "type", parameter.getType());
            this.element(w, "since", parameter.getSince());
            this.element(w, "deprecated", parameter.getDeprecated());
            this.element(w, "implementation", parameter.getImplementation());
            this.element(w, "required", Boolean.toString(parameter.isRequired()));
            this.element(w, "editable", Boolean.toString(parameter.isEditable()));
            this.element(w, "description", parameter.getDescription());
            w.endElement();
            if (!StringUtils.isNotEmpty((String)parameter.getDefaultValue()) && !StringUtils.isNotEmpty((String)parameter.getExpression())) continue;
            configuration.add(parameter);
        }
        w.endElement();
        if (!configuration.isEmpty()) {
            w.startElement("configuration");
            for (MojoParameter parameter : configuration) {
                w.startElement(parameter.getName());
                String type = parameter.getType();
                if (StringUtils.isNotEmpty((String)type)) {
                    w.addAttribute("implementation", type);
                }
                if (parameter.getDefaultValue() != null) {
                    w.addAttribute("default-value", parameter.getDefaultValue());
                }
                if (StringUtils.isNotEmpty((String)parameter.getExpression())) {
                    w.writeText(parameter.getExpression());
                }
                w.endElement();
            }
            w.endElement();
        }
        if (!(requirements = new ArrayList<MojoRequirement>(mojoDescriptor.getRequirements())).isEmpty()) {
            Sorting.sortRequirements(requirements);
            w.startElement("requirements");
            for (MojoRequirement requirement : requirements) {
                w.startElement("requirement");
                this.element(w, "role", requirement.getRole());
                this.element(w, "role-hint", requirement.getRoleHint());
                this.element(w, "field-name", requirement.getFieldName());
                w.endElement();
            }
            w.endElement();
        }
        w.endElement();
    }
}

