/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.DependencyClasspathEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.osgi.framework.BundleException;

public class ClasspathDirectory
extends DependencyClasspathEntry
implements ClasspathEntry {
    private ClasspathDirectory(File directory, Set<String> packageNames, Collection<String> exportedPackages) {
        super(directory, packageNames, exportedPackages);
        try {
            directory = directory.getCanonicalFile();
        }
        catch (IOException iOException) {
            directory = directory.getAbsoluteFile();
        }
    }

    private static Set<String> getPackageNames(File directory) {
        HashSet<String> packages = new HashSet<String>();
        ClasspathDirectory.populatePackageNames(packages, directory, "");
        return packages;
    }

    private static void populatePackageNames(Set<String> packageNames, File directory, String packageName) {
        File[] files;
        if (!packageName.isEmpty()) {
            packageNames.add(packageName);
        }
        if ((files = directory.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    ClasspathDirectory.populatePackageNames(packageNames, file, ClasspathDirectory.childPackageName(packageName, file.getName()));
                }
                ++n2;
            }
        }
    }

    private static String childPackageName(String packageName, String childName) {
        return packageName.isEmpty() ? childName : String.valueOf(packageName) + "/" + childName;
    }

    @Override
    public Collection<String> getPackageNames() {
        return this.packageNames;
    }

    @Override
    public NameEnvironmentAnswer findType(String packageName, String binaryFileName, AccessRestriction accessRestriction) {
        try {
            ClassFileReader reader;
            String qualifiedFileName = String.valueOf(packageName) + "/" + binaryFileName;
            File classFile = new File(this.file, qualifiedFileName).getCanonicalFile();
            if (classFile.isFile() && this.matchQualifiedName(classFile, qualifiedFileName) && (reader = ClassFileReader.read((File)classFile, (boolean)false)) != null) {
                return new NameEnvironmentAnswer((IBinaryType)reader, accessRestriction);
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private boolean matchQualifiedName(File file, String qualifiedName) {
        return file.getAbsolutePath().replace('\\', '/').endsWith(qualifiedName);
    }

    public String toString() {
        return "Classpath for directory " + this.file;
    }

    public static ClasspathDirectory create(File directory) {
        FileInputStream is;
        Object var4_6;
        Throwable throwable;
        Set<String> packages = ClasspathDirectory.getPackageNames(directory);
        Collection<String> exportedPackages = null;
        try {
            throwable = null;
            var4_6 = null;
            try {
                is = new FileInputStream(new File(directory, "META-INF/takari/export-package"));
                try {
                    exportedPackages = ClasspathDirectory.parseExportPackage(is);
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        if (exportedPackages == null) {
            try {
                throwable = null;
                var4_6 = null;
                try {
                    is = new FileInputStream(new File(directory, "META-INF/MANIFEST.MF"));
                    try {
                        exportedPackages = ClasspathDirectory.parseBundleManifest(is);
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException | BundleException throwable4) {}
        }
        return new ClasspathDirectory(directory, packages, exportedPackages);
    }
}

