/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import io.takari.maven.plugins.compile.javac.FileObjects;
import io.takari.maven.plugins.compile.javac.IncrementalFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.tools.FileObject;
import javax.tools.ForwardingFileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

abstract class RecordingJavaFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    protected RecordingJavaFileManager(StandardJavaFileManager fileManager) {
        super(fileManager);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        FileObject fileObject = super.getFileForOutput(location, packageName, relativeName, sibling);
        this.record(sibling != null ? FileObjects.toFile(sibling) : null, FileObjects.toFile(fileObject));
        return new ForwardingFileObject<FileObject>(fileObject){

            @Override
            public OutputStream openOutputStream() throws IOException {
                return new IncrementalFileOutputStream(FileObjects.toFile(this));
            }
        };
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaFileObject fileObject = super.getJavaFileForOutput(location, className, kind, sibling);
        this.record(sibling != null ? FileObjects.toFile(sibling) : null, FileObjects.toFile(fileObject));
        return new ForwardingJavaFileObject<JavaFileObject>(fileObject){

            @Override
            public OutputStream openOutputStream() throws IOException {
                return new IncrementalFileOutputStream(FileObjects.toFile(this));
            }
        };
    }

    protected abstract void record(File var1, File var2);

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.toUri().equals(b.toUri());
    }
}

