/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class Swift4Codegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String PROJECT_NAME = "projectName";
    public static final String RESPONSE_AS = "responseAs";
    public static final String UNWRAP_REQUIRED = "unwrapRequired";
    public static final String OBJC_COMPATIBLE = "objcCompatible";
    public static final String POD_SOURCE = "podSource";
    public static final String POD_AUTHORS = "podAuthors";
    public static final String POD_SOCIAL_MEDIA_URL = "podSocialMediaURL";
    public static final String POD_DOCSET_URL = "podDocsetURL";
    public static final String POD_LICENSE = "podLicense";
    public static final String POD_HOMEPAGE = "podHomepage";
    public static final String POD_SUMMARY = "podSummary";
    public static final String POD_DESCRIPTION = "podDescription";
    public static final String POD_SCREENSHOTS = "podScreenshots";
    public static final String POD_DOCUMENTATION_URL = "podDocumentationURL";
    public static final String SWIFT_USE_API_NAMESPACE = "swiftUseApiNamespace";
    public static final String DEFAULT_POD_AUTHORS = "Swagger Codegen";
    public static final String LENIENT_TYPE_CAST = "lenientTypeCast";
    protected static final String LIBRARY_PROMISE_KIT = "PromiseKit";
    protected static final String LIBRARY_RX_SWIFT = "RxSwift";
    protected static final String[] RESPONSE_LIBRARIES = new String[]{"PromiseKit", "RxSwift"};
    protected String projectName = "SwaggerClient";
    protected boolean unwrapRequired;
    protected boolean objcCompatible = false;
    protected boolean lenientTypeCast = false;
    protected boolean swiftUseApiNamespace;
    protected String[] responseAs = new String[0];
    protected String sourceFolder = "Classes" + File.separator + "Swaggers";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "swift4";
    }

    @Override
    public String getHelp() {
        return "Generates a swift client library.";
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema additionalProperties = (Schema)schema.getAdditionalProperties();
        if (additionalProperties != null) {
            codegenModel.additionalPropertiesType = this.getSchemaType(additionalProperties);
        }
    }

    public Swift4Codegen() {
        this.outputFolder = "generated-code" + File.separator + "swift";
        this.modelTemplateFiles.put("model.mustache", ".swift");
        this.apiTemplateFiles.put("api.mustache", ".swift");
        this.templateDir = "swift4";
        this.embeddedTemplateDir = "swift4";
        this.apiPackage = File.separator + "APIs";
        this.modelPackage = File.separator + "Models";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Int", "Int32", "Int64", "Float", "Double", "Bool", "Void", "String", "Character", "AnyObject", "Any"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Data", "Date", "URL", "UUID", "Array", "Dictionary", "Set", "Any", "Empty", "AnyObject", "Any"));
        this.reservedWords = new HashSet<String>(Arrays.asList("ErrorResponse", "Response", "Int", "Int32", "Int64", "Int64", "Float", "Double", "Bool", "Void", "String", "Character", "AnyObject", "Any", "Error", "URL", "class", "Class", "break", "as", "associativity", "deinit", "case", "dynamicType", "convenience", "enum", "continue", "false", "dynamic", "extension", "default", "is", "didSet", "func", "do", "nil", "final", "import", "else", "self", "get", "init", "fallthrough", "Self", "infix", "internal", "for", "super", "inout", "let", "if", "true", "lazy", "operator", "in", "COLUMN", "left", "private", "return", "FILE", "mutating", "protocol", "switch", "FUNCTION", "none", "public", "where", "LINE", "nonmutating", "static", "while", "optional", "struct", "override", "subscript", "postfix", "typealias", "precedence", "var", "prefix", "Protocol", "required", "right", "set", "throw", "Type", "unowned", "weak", "Data", "Codable", "Encodable", "Decodable"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("Date", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "Character");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("Integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "URL");
        this.typeMapping.put("binary", "Data");
        this.typeMapping.put("ByteArray", "Data");
        this.typeMapping.put("UUID", "UUID");
        this.importMapping = new HashMap();
        this.cliOptions.add(new CliOption(PROJECT_NAME, "Project name in Xcode"));
        this.cliOptions.add(new CliOption(RESPONSE_AS, "Optionally use libraries to manage response.  Currently " + StringUtils.join((Object[])RESPONSE_LIBRARIES, (String)", ") + " are available."));
        this.cliOptions.add(new CliOption(UNWRAP_REQUIRED, "Treat 'required' properties in response as non-optional (which would crash the app if api returns null as opposed to required option specified in json schema"));
        this.cliOptions.add(new CliOption(OBJC_COMPATIBLE, "Add additional properties and methods for Objective-C compatibility (default: false)"));
        this.cliOptions.add(new CliOption(POD_SOURCE, "Source information used for Podspec"));
        this.cliOptions.add(new CliOption("podVersion", "Version used for Podspec"));
        this.cliOptions.add(new CliOption(POD_AUTHORS, "Authors used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SOCIAL_MEDIA_URL, "Social Media URL used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DOCSET_URL, "Docset URL used for Podspec"));
        this.cliOptions.add(new CliOption(POD_LICENSE, "License used for Podspec"));
        this.cliOptions.add(new CliOption(POD_HOMEPAGE, "Homepage used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SUMMARY, "Summary used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DESCRIPTION, "Description used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SCREENSHOTS, "Screenshots used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DOCUMENTATION_URL, "Documentation URL used for Podspec"));
        this.cliOptions.add(new CliOption(SWIFT_USE_API_NAMESPACE, "Flag to make all the API classes inner-class of {{projectName}}API"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "hides the timestamp when files were generated").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(LENIENT_TYPE_CAST, "Accept and cast values for simple types (string->bool, string->int, int->string)").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (!this.additionalProperties.containsKey("hideGenerationTimestamp")) {
            this.additionalProperties.put("hideGenerationTimestamp", Boolean.TRUE.toString());
        } else {
            Boolean hide = Boolean.valueOf(this.additionalProperties().get("hideGenerationTimestamp").toString());
            this.additionalProperties.put("hideGenerationTimestamp", hide);
        }
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.setProjectName((String)this.additionalProperties.get(PROJECT_NAME));
        } else {
            this.additionalProperties.put(PROJECT_NAME, this.projectName);
        }
        this.sourceFolder = this.projectName + File.separator + this.sourceFolder;
        if (this.additionalProperties.containsKey(UNWRAP_REQUIRED)) {
            this.setUnwrapRequired(this.convertPropertyToBooleanAndWriteBack(UNWRAP_REQUIRED));
        }
        this.additionalProperties.put(UNWRAP_REQUIRED, this.unwrapRequired);
        if (this.additionalProperties.containsKey(OBJC_COMPATIBLE)) {
            this.setObjcCompatible(this.convertPropertyToBooleanAndWriteBack(OBJC_COMPATIBLE));
        }
        this.additionalProperties.put(OBJC_COMPATIBLE, this.objcCompatible);
        if (this.additionalProperties.containsKey(RESPONSE_AS)) {
            Object responseAsObject = this.additionalProperties.get(RESPONSE_AS);
            if (responseAsObject instanceof String) {
                this.setResponseAs(((String)responseAsObject).split(","));
            } else {
                this.setResponseAs((String[])responseAsObject);
            }
        }
        this.additionalProperties.put(RESPONSE_AS, this.responseAs);
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)LIBRARY_PROMISE_KIT)) {
            this.additionalProperties.put("usePromiseKit", true);
        }
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)LIBRARY_RX_SWIFT)) {
            this.additionalProperties.put("useRxSwift", true);
        }
        if (this.additionalProperties.containsKey(SWIFT_USE_API_NAMESPACE)) {
            this.setSwiftUseApiNamespace(this.convertPropertyToBooleanAndWriteBack(SWIFT_USE_API_NAMESPACE));
        }
        if (!this.additionalProperties.containsKey(POD_AUTHORS)) {
            this.additionalProperties.put(POD_AUTHORS, DEFAULT_POD_AUTHORS);
        }
        this.setLenientTypeCast(this.convertPropertyToBooleanAndWriteBack(LENIENT_TYPE_CAST));
        this.supportingFiles.add(new SupportingFile("Podspec.mustache", "", this.projectName + ".podspec"));
        this.supportingFiles.add(new SupportingFile("Cartfile.mustache", "", "Cartfile"));
        this.supportingFiles.add(new SupportingFile("APIHelper.mustache", this.sourceFolder, "APIHelper.swift"));
        this.supportingFiles.add(new SupportingFile("AlamofireImplementations.mustache", this.sourceFolder, "AlamofireImplementations.swift"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.sourceFolder, "Configuration.swift"));
        this.supportingFiles.add(new SupportingFile("Extensions.mustache", this.sourceFolder, "Extensions.swift"));
        this.supportingFiles.add(new SupportingFile("Models.mustache", this.sourceFolder, "Models.swift"));
        this.supportingFiles.add(new SupportingFile("APIs.mustache", this.sourceFolder, "APIs.swift"));
        this.supportingFiles.add(new SupportingFile("CodableHelper.mustache", this.sourceFolder, "CodableHelper.swift"));
        this.supportingFiles.add(new SupportingFile("JSONEncodableEncoding.mustache", this.sourceFolder, "JSONEncodableEncoding.swift"));
        this.supportingFiles.add(new SupportingFile("JSONEncodingHelper.mustache", this.sourceFolder, "JSONEncodingHelper.swift"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
    }

    @Override
    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema inner = arraySchema.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (schema instanceof MapSchema && Swift4Codegen.hasSchemaProperties(schema)) {
            return "[String:" + this.getTypeDeclaration((Schema)schema.getAdditionalProperties()) + "]";
        }
        return super.getTypeDeclaration(schema);
    }

    @Override
    public String getSchemaType(Schema schema) {
        String type;
        String swaggerType = super.getSchemaType(schema);
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type) || this.defaultIncludes.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("URL");
    }

    @Override
    public boolean isDataTypeBinary(String dataType) {
        return dataType != null && dataType.equals("Data");
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (this.isReservedWord(name = Swift4Codegen.camelize(name))) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toDefaultValue(Schema schema) {
        return null;
    }

    @Override
    public String toInstantiationType(Schema schema) {
        if (schema instanceof MapSchema && Swift4Codegen.hasSchemaProperties(schema)) {
            return this.getSchemaType((Schema)schema.getAdditionalProperties());
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String inner = this.getSchemaType(arraySchema.getItems());
            return "[" + inner + "]";
        }
        return null;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultAPI";
        }
        return this.initialCaps(name) + "API";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)(operationId = Swift4Codegen.camelize(this.sanitizeName(operationId), true)))) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = Swift4Codegen.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return operationId;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = Swift4Codegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = Swift4Codegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel codegenModel = super.fromModel(name, schema, allSchemas);
        if (codegenModel.description != null) {
            codegenModel.imports.add("ApiModel");
        }
        if (allSchemas != null) {
            String parentSchema = codegenModel.parentSchema;
            while (parentSchema != null) {
                Schema parentModel = allSchemas.get(parentSchema);
                CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel, allSchemas);
                codegenModel = Swift4Codegen.reconcileProperties(codegenModel, parentCodegenModel);
                parentSchema = parentCodegenModel.parentSchema;
            }
        }
        return codegenModel;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setUnwrapRequired(boolean unwrapRequired) {
        this.unwrapRequired = unwrapRequired;
    }

    public void setObjcCompatible(boolean objcCompatible) {
        this.objcCompatible = objcCompatible;
    }

    public void setLenientTypeCast(boolean lenientTypeCast) {
        this.lenientTypeCast = lenientTypeCast;
    }

    public void setResponseAs(String[] responseAs) {
        this.responseAs = responseAs;
    }

    public void setSwiftUseApiNamespace(boolean swiftUseApiNamespace) {
        this.swiftUseApiNamespace = swiftUseApiNamespace;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        return String.valueOf(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        String nameLowercase;
        if (name.length() == 0) {
            return "empty";
        }
        Pattern startWithNumberPattern = Pattern.compile("^\\d+");
        Matcher startWithNumberMatcher = startWithNumberPattern.matcher(name);
        if (startWithNumberMatcher.find()) {
            String startingNumbers = startWithNumberMatcher.group(0);
            String nameWithoutStartingNumbers = name.substring(startingNumbers.length());
            return "_" + startingNumbers + Swift4Codegen.camelize(nameWithoutStartingNumbers, true);
        }
        if (this.getSymbolName(name) != null) {
            return Swift4Codegen.camelize(WordUtils.capitalizeFully((String)this.getSymbolName(name).toUpperCase()), true);
        }
        Boolean camelized = false;
        if (name.matches("[A-Z][a-z0-9]+[a-zA-Z0-9]*")) {
            name = Swift4Codegen.camelize(name, true);
            camelized = true;
        }
        if (this.isReservedWord(nameLowercase = StringUtils.lowerCase((String)name))) {
            return this.escapeReservedWord(nameLowercase);
        }
        if ("Int".equals(datatype) || "Int32".equals(datatype) || "Int64".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            String varName = "number" + Swift4Codegen.camelize(name);
            varName = varName.replaceAll("-", "minus");
            varName = varName.replaceAll("\\+", "plus");
            varName = varName.replaceAll("\\.", "dot");
            return varName;
        }
        if (camelized.booleanValue()) {
            return name;
        }
        char[] separators = new char[]{'-', '_', ' ', ':', '(', ')'};
        return Swift4Codegen.camelize(WordUtils.capitalizeFully((String)StringUtils.lowerCase((String)name), (char[])separators).replaceAll("[-_ :\\(\\)]", ""), true);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = this.toModelName(property.name);
        if (this.isReservedWord(property.datatypeWithEnum) || this.toVarName(property.name).equals(property.datatypeWithEnum)) {
            enumName = property.datatypeWithEnum + "Enum";
        }
        if (enumName.matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        boolean isSwiftScalarType;
        super.postProcessModelProperty(model, property);
        boolean isSwiftOptional = !this.unwrapRequired || !property.required;
        boolean isInteger = ExtensionHelper.getBooleanValue(property, "x-is-integer");
        boolean isLong = ExtensionHelper.getBooleanValue(property, "x-is-long");
        boolean isFloat = ExtensionHelper.getBooleanValue(property, "x-is-float");
        boolean isDouble = ExtensionHelper.getBooleanValue(property, "x-is-double");
        boolean isBoolean = ExtensionHelper.getBooleanValue(property, "x-is-boolean");
        boolean bl = isSwiftScalarType = isInteger || isLong || isFloat || isDouble || isBoolean;
        if (isSwiftOptional && isSwiftScalarType) {
            property.vendorExtensions.put("x-swift-optional-scalar", true);
        }
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private static CodegenModel reconcileProperties(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
        List<CodegenProperty> codegenProperties = codegenModel.vars;
        codegenModel.allVars = new ArrayList<CodegenProperty>(codegenProperties);
        codegenModel.parentVars = parentCodegenModel.allVars;
        boolean removedChildProperty = false;
        for (CodegenProperty parentModelCodegenProperty : parentModelCodegenProperties) {
            Iterator<CodegenProperty> iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = iterator.next();
                if (codegenProperty.baseName != parentModelCodegenProperty.baseName) continue;
                iterator.remove();
                removedChildProperty = true;
            }
        }
        if (removedChildProperty) {
            int count = 0;
            int numVars = codegenProperties.size();
            for (CodegenProperty codegenProperty : codegenProperties) {
                codegenProperty.getVendorExtensions().put("x-has-more", ++count < numVars);
            }
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }
}

