/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCppCodegen;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Qt5CPPGenerator
extends AbstractCppCodegen
implements CodegenConfig {
    public static final String CPP_NAMESPACE = "cppNamespace";
    public static final String CPP_NAMESPACE_DESC = "C++ namespace (convention: name::space::for::api).";
    protected final String PREFIX = "SWG";
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String sourceFolder = "client";
    protected String apiVersion = "1.0.0";
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Set<String> systemIncludes = new HashSet<String>();
    protected String cppNamespace = "Swagger";

    public Qt5CPPGenerator() {
        this.outputFolder = "generated-code/qt5cpp";
        if (this.modelNamePrefix == "") {
            this.modelNamePrefix = "SWG";
        }
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".cpp");
        this.templateDir = "qt5cpp";
        this.embeddedTemplateDir = "qt5cpp";
        this.addOption(CPP_NAMESPACE, CPP_NAMESPACE_DESC, this.cppNamespace);
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties().put("prefix", "SWG");
        this.additionalProperties.put(CPP_NAMESPACE, this.cppNamespace);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "qint32", "qint64", "float", "double"));
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, "SWGHelpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, "SWGHelpers.cpp"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.h.mustache", this.sourceFolder, "SWGHttpRequest.h"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.cpp.mustache", this.sourceFolder, "SWGHttpRequest.cpp"));
        this.supportingFiles.add(new SupportingFile("modelFactory.mustache", this.sourceFolder, "SWGModelFactory.h"));
        this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, "SWGObject.h"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "QDate");
        this.typeMapping.put("DateTime", "QDateTime");
        this.typeMapping.put("string", "QString");
        this.typeMapping.put("integer", "qint32");
        this.typeMapping.put("long", "qint64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "QList");
        this.typeMapping.put("map", "QMap");
        this.typeMapping.put("file", "SWGHttpRequestInputFileElement");
        this.typeMapping.put("object", "SWGObject");
        this.typeMapping.put("binary", "QString");
        this.typeMapping.put("ByteArray", "QByteArray");
        this.typeMapping.put("UUID", "QString");
        this.importMapping = new HashMap();
        this.importMapping.put("SWGHttpRequestInputFileElement", "#include \"SWGHttpRequest.h\"");
        this.namespaces = new HashMap<String, String>();
        this.foundationClasses.add("QString");
        this.systemIncludes.add("QString");
        this.systemIncludes.add("QList");
        this.systemIncludes.add("QMap");
        this.systemIncludes.add("QDate");
        this.systemIncludes.add("QDateTime");
        this.systemIncludes.add("QByteArray");
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CPP_NAMESPACE)) {
            this.cppNamespace = (String)this.additionalProperties.get(CPP_NAMESPACE);
        }
        this.additionalProperties.put("cppNamespaceDeclarations", this.cppNamespace.split("\\::"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "qt5cpp";
    }

    @Override
    public String getHelp() {
        return "Generates a qt5 C++ client library.";
    }

    @Override
    public String toModelImport(String name) {
        if (this.namespaces.containsKey(name)) {
            return "using " + this.namespaces.get(name) + ";";
        }
        if (this.systemIncludes.contains(name)) {
            return "#include <" + name + ">";
        }
        String folder = this.modelPackage().replace("::", File.separator);
        if (!folder.isEmpty()) {
            folder = folder + File.separator;
        }
        return "#include \"" + folder + name + ".h\"";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace("::", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace("::", File.separator);
    }

    @Override
    public String toModelFilename(String name) {
        return this.modelNamePrefix + this.initialCaps(name);
    }

    @Override
    public String toApiFilename(String name) {
        return "SWG" + this.initialCaps(name) + "Api";
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        String schematype = this.getSchemaType(propertySchema);
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("%s<%s>", schematype, this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && Qt5CPPGenerator.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("%s<QString, %s>", schematype, this.getTypeDeclaration(inner));
        }
        if (this.foundationClasses.contains(schematype)) {
            return schematype + "*";
        }
        if (this.languageSpecificPrimitives.contains(schematype)) {
            return this.toModelName(schematype);
        }
        return schematype + "*";
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema instanceof StringSchema) {
            return "new QString(\"\")";
        }
        if (schema instanceof BooleanSchema) {
            return "false";
        }
        if (schema instanceof DateSchema) {
            return "NULL";
        }
        if (schema instanceof DateTimeSchema) {
            return "NULL";
        }
        if (schema instanceof NumberSchema) {
            if ("float".equals(schema.getFormat())) {
                return "0.0f";
            }
            return "0.0";
        }
        if (schema instanceof IntegerSchema) {
            if ("int64".equals(schema.getFormat())) {
                return "0.0L";
            }
            return "0";
        }
        if (schema instanceof MapSchema && Qt5CPPGenerator.hasSchemaProperties(schema)) {
            String inner = this.getSchemaType((Schema)schema.getAdditionalProperties());
            if (!this.languageSpecificPrimitives.contains(inner)) {
                inner = inner + "*";
            }
            return "new QMap<QString, " + inner + ">()";
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String inner = this.getSchemaType(arraySchema.getItems());
            if (!this.languageSpecificPrimitives.contains(inner)) {
                inner = inner + "*";
            }
            return "new QList<" + inner + ">()";
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            return "new " + this.toModelName(schema.get$ref()) + "()";
        }
        return "NULL";
    }

    @Override
    public String getSchemaType(Schema schema) {
        String swaggerType = super.getSchemaType(schema);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
            if (this.foundationClasses.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.isReservedWord(name = Qt5CPPGenerator.underscore(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toApiName(String type) {
        return "SWG" + Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

