package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * Base security policy interface for handlers that provide HTTP security related headers.
 * <p>
 * Sub-interfaces help you secure your applications by setting various HTTP headers. <i>It's not a silver bullet</i>,
 * but it can help!
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.SecurityPolicyHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.SecurityPolicyHandler.class)
public interface SecurityPolicyHandler extends io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  io.vertx.ext.web.handler.SecurityPolicyHandler getDelegate();

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0);

  default public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  SecurityPolicyHandler newInstance(io.vertx.ext.web.handler.SecurityPolicyHandler arg) {
    return arg != null ? new SecurityPolicyHandlerImpl(arg) : null;
  }

}

class SecurityPolicyHandlerImpl implements SecurityPolicyHandler {
  private final io.vertx.ext.web.handler.SecurityPolicyHandler delegate;
  
  public io.vertx.ext.web.handler.SecurityPolicyHandler getDelegate() {
    return delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SecurityPolicyHandlerImpl() {
    this.delegate = null;
  }

  public SecurityPolicyHandlerImpl(io.vertx.ext.web.handler.SecurityPolicyHandler delegate) {
    this.delegate = delegate;
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

}
