package io.vertx.mutiny.ext.auth.authorization;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.Set;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * The role of an AuthorizationProvider is to return a set of Authorization.
 * Note that each AuthorizationProvider must provide its own unique Id
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.AuthorizationProvider original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.authorization.AuthorizationProvider.class)
public class AuthorizationProvider implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<AuthorizationProvider> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AuthorizationProvider((io.vertx.ext.auth.authorization.AuthorizationProvider) obj),
    AuthorizationProvider::getDelegate
  );

  private final io.vertx.ext.auth.authorization.AuthorizationProvider delegate;
  
  public AuthorizationProvider(io.vertx.ext.auth.authorization.AuthorizationProvider delegate) {
    this.delegate = delegate;
  }

  public AuthorizationProvider(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.AuthorizationProvider)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AuthorizationProvider() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.auth.authorization.AuthorizationProvider getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthorizationProvider that = (AuthorizationProvider) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param id 
   * @param authorizations 
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.authorization.AuthorizationProvider create(String id, Set<io.vertx.mutiny.ext.auth.authorization.Authorization> authorizations) { 
    io.vertx.mutiny.ext.auth.authorization.AuthorizationProvider ret = io.vertx.mutiny.ext.auth.authorization.AuthorizationProvider.newInstance((io.vertx.ext.auth.authorization.AuthorizationProvider)io.vertx.ext.auth.authorization.AuthorizationProvider.create(id, authorizations.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toSet())));
    return ret;
  }

  /**
   * @return 
   */
  public String getId() { 
    String ret = delegate.getId();
    return ret;
  }

  /**
   * Updates the user with the set of authorizations.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param user user to lookup and update
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> getAuthorizations(io.vertx.mutiny.ext.auth.User user) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getAuthorizations(user.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.authorization.AuthorizationProvider#getAuthorizations(io.vertx.mutiny.ext.auth.User)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param user user to lookup and update
   * @return the Void instance produced by the operation.
   */
  public Void getAuthorizationsAndAwait(io.vertx.mutiny.ext.auth.User user) { 
    return (Void) getAuthorizations(user).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.authorization.AuthorizationProvider#getAuthorizations(io.vertx.mutiny.ext.auth.User)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.authorization.AuthorizationProvider#getAuthorizations(io.vertx.mutiny.ext.auth.User)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.authorization.AuthorizationProvider#getAuthorizations(io.vertx.mutiny.ext.auth.User)} but you don't need to compose it with other operations.
   * @param user user to lookup and update
   */
  public void getAuthorizationsAndForget(io.vertx.mutiny.ext.auth.User user) { 
    getAuthorizations(user).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  AuthorizationProvider newInstance(io.vertx.ext.auth.authorization.AuthorizationProvider arg) {
    return arg != null ? new AuthorizationProvider(arg) : null;
  }

}
