/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime;

import io.quarkus.runtime.util.ForwardingScheduledExecutorService;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class VertxTimerAwareScheduledExecutorService
extends ForwardingScheduledExecutorService {
    private final ScheduledExecutorService delegate;

    public VertxTimerAwareScheduledExecutorService(ScheduledExecutorService delegate) {
        this.delegate = delegate;
    }

    protected ScheduledExecutorService delegate() {
        return this.delegate;
    }

    public ScheduledFuture<?> schedule(final Runnable command, long delay, TimeUnit unit) {
        Context context = Vertx.currentContext();
        if (context != null) {
            Vertx vertx = context.owner();
            long timerId = vertx.setTimer(unit.toMillis(delay), (Handler)new Handler<Long>(){

                public void handle(Long tick) {
                    command.run();
                }
            });
            return new VertxTimerScheduledFuture(vertx, timerId);
        }
        return this.delegate.schedule(command, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(final Runnable command, long initialDelay, long period, TimeUnit unit) {
        Context context = Vertx.currentContext();
        if (context != null) {
            Vertx vertx = context.owner();
            long timerId = vertx.setPeriodic(unit.toMillis(initialDelay), unit.toMillis(period), (Handler)new Handler<Long>(){

                public void handle(Long tick) {
                    command.run();
                }
            });
            return new VertxTimerScheduledFuture(vertx, timerId);
        }
        return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    private static final class VertxTimerScheduledFuture<T>
    implements ScheduledFuture<T> {
        final Vertx vertx;
        final long timerId;
        volatile boolean cancelled;

        VertxTimerScheduledFuture(Vertx vertx, long timerId) {
            this.vertx = vertx;
            this.timerId = timerId;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            throw new UnsupportedOperationException("getDelay is not implemented");
        }

        @Override
        public int compareTo(Delayed o) {
            throw new UnsupportedOperationException("compareTo is not implemented");
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            return this.vertx.cancelTimer(this.timerId);
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            throw new UnsupportedOperationException("isDone is not implemented");
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException("get is not implemented");
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException("get is not implemented");
        }
    }
}

