/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.quarkus.vertx.http.runtime.logstream.JsonFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class HistoryHandler
extends ExtHandler {
    private final int size = 50;
    private final List<ExtLogRecord> history = new LinkedList<ExtLogRecord>();

    public HistoryHandler() {
        this.setLevel(Level.INFO);
        this.setFormatter((Formatter)((Object)new JsonFormatter()));
    }

    public final void doPublish(ExtLogRecord record) {
        if (record.getMessage() == null || record.getMessage().isEmpty()) {
            return;
        }
        if (this.isLoggable((LogRecord)record)) {
            this.history.add(record);
            while (this.history.size() > 50) {
                this.history.remove(0);
            }
        }
    }

    public boolean hasHistory() {
        return !this.history.isEmpty();
    }

    public List<ExtLogRecord> getHistory() {
        return new ArrayList<ExtLogRecord>(this.history);
    }

    public void clearHistory() {
        this.history.clear();
    }
}

