/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManagerComparator;
import io.quarkus.test.common.TestClassIndexer;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;

public class TestResourceManager
implements Closeable {
    private final List<TestResourceEntry> testResourceEntries;
    private Map<String, String> oldSystemProps;

    public TestResourceManager(Class<?> testClass) {
        this.testResourceEntries = this.getTestResources(testClass);
    }

    public void init() {
        for (TestResourceEntry entry : this.testResourceEntries) {
            try {
                entry.getTestResource().init(entry.getArgs());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable initialize test resource " + entry.getTestResource(), e);
            }
        }
    }

    public Map<String, String> start() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (TestResourceEntry testResourceEntry : this.testResourceEntries) {
            try {
                Map<String, String> start = testResourceEntry.getTestResource().start();
                if (start == null) continue;
                ret.putAll(start);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to start Quarkus test resource " + testResourceEntry.getTestResource(), e);
            }
        }
        this.oldSystemProps = new HashMap<String, String>();
        for (Map.Entry entry : ret.entrySet()) {
            this.oldSystemProps.put((String)entry.getKey(), System.getProperty((String)entry.getKey()));
            if (entry.getValue() == null) {
                System.clearProperty((String)entry.getKey());
                continue;
            }
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return ret;
    }

    public void inject(Object testInstance) {
        for (TestResourceEntry entry : this.testResourceEntries) {
            entry.getTestResource().inject(testInstance);
        }
    }

    @Override
    public void close() {
        if (this.oldSystemProps != null) {
            for (Map.Entry entry : this.oldSystemProps.entrySet()) {
                if (entry.getValue() == null) {
                    System.clearProperty((String)entry.getKey());
                    continue;
                }
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.oldSystemProps = null;
        for (TestResourceEntry testResourceEntry : this.testResourceEntries) {
            try {
                testResourceEntry.getTestResource().stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to stop Quarkus test resource " + testResourceEntry.getTestResource(), e);
            }
        }
        try {
            ConfigProviderResolver cpr = ConfigProviderResolver.instance();
            cpr.releaseConfig(cpr.getConfig());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private List<TestResourceEntry> getTestResources(Class<?> testClass) {
        Index index = TestClassIndexer.readIndex(testClass);
        ArrayList<TestResourceEntry> testResourceEntries = new ArrayList<TestResourceEntry>();
        HashSet<TestResourceClassEntry> alreadyAddedEntries = new HashSet<TestResourceClassEntry>();
        for (AnnotationInstance annotation : this.findQuarkusTestResourceInstances((IndexView)index)) {
            try {
                Map<String, String> args;
                Class<?> testResourceClass = Class.forName(annotation.value().asString(), true, Thread.currentThread().getContextClassLoader());
                AnnotationValue argsAnnotationValue = annotation.value("initArgs");
                if (argsAnnotationValue == null) {
                    args = Collections.emptyMap();
                } else {
                    AnnotationInstance[] resourceArgsInstances;
                    args = new HashMap();
                    for (AnnotationInstance resourceArgsInstance : resourceArgsInstances = argsAnnotationValue.asNestedArray()) {
                        args.put(resourceArgsInstance.value("name").asString(), resourceArgsInstance.value().asString());
                    }
                }
                TestResourceClassEntry testResourceClassEntry = new TestResourceClassEntry(testResourceClass, args);
                if (alreadyAddedEntries.contains(testResourceClassEntry)) continue;
                alreadyAddedEntries.add(testResourceClassEntry);
                testResourceEntries.add(new TestResourceEntry((QuarkusTestResourceLifecycleManager)testResourceClass.getConstructor(new Class[0]).newInstance(new Object[0]), args));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Unable to instantiate the test resource " + annotation.value().asString());
            }
        }
        for (QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager : ServiceLoader.load(QuarkusTestResourceLifecycleManager.class, Thread.currentThread().getContextClassLoader())) {
            testResourceEntries.add(new TestResourceEntry(quarkusTestResourceLifecycleManager));
        }
        testResourceEntries.sort(new Comparator<TestResourceEntry>(){
            private final QuarkusTestResourceLifecycleManagerComparator lifecycleManagerComparator = new QuarkusTestResourceLifecycleManagerComparator();

            @Override
            public int compare(TestResourceEntry o1, TestResourceEntry o2) {
                return this.lifecycleManagerComparator.compare(o1.getTestResource(), o2.getTestResource());
            }
        });
        return testResourceEntries;
    }

    private Collection<AnnotationInstance> findQuarkusTestResourceInstances(IndexView index) {
        HashSet<AnnotationInstance> testResourceAnnotations = new HashSet<AnnotationInstance>(index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.class.getName())));
        for (AnnotationInstance annotation : index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.List.class.getName()))) {
            Collections.addAll(testResourceAnnotations, annotation.value().asNestedArray());
        }
        return testResourceAnnotations;
    }

    private static class TestResourceClassEntry {
        private Class<? extends QuarkusTestResourceLifecycleManager> clazz;
        private Map<String, String> args;

        public TestResourceClassEntry(Class<? extends QuarkusTestResourceLifecycleManager> clazz, Map<String, String> args) {
            this.clazz = clazz;
            this.args = args;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestResourceClassEntry that = (TestResourceClassEntry)o;
            return this.clazz.equals(that.clazz) && this.args.equals(that.args);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.args);
        }
    }

    private static class TestResourceEntry {
        private final QuarkusTestResourceLifecycleManager testResource;
        private final Map<String, String> args;

        public TestResourceEntry(QuarkusTestResourceLifecycleManager testResource) {
            this(testResource, Collections.emptyMap());
        }

        public TestResourceEntry(QuarkusTestResourceLifecycleManager testResource, Map<String, String> args) {
            this.testResource = testResource;
            this.args = args;
        }

        public QuarkusTestResourceLifecycleManager getTestResource() {
            return this.testResource;
        }

        public Map<String, String> getArgs() {
            return this.args;
        }
    }
}

