/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.eclipse.microprofile.config.Config;

public class DockerContainerLauncher
implements ArtifactLauncher {
    private static final int DEFAULT_PORT = 8081;
    private static final int DEFAULT_HTTPS_PORT = 8444;
    private static final long DEFAULT_WAIT_TIME = 60L;
    private final String containerImage;
    private final String profile;
    private Process quarkusProcess;
    private int httpPort;
    private int httpsPort;
    private final long jarWaitTime;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private boolean isSsl;

    private DockerContainerLauncher(String containerImage, Config config) {
        this(containerImage, ((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), ((OptionalLong)config.getValue("quarkus.test.jar-wait-time", OptionalLong.class)).orElse(60L), config.getOptionalValue("quarkus.test.native-image-profile", String.class).orElse(null));
    }

    public DockerContainerLauncher(String containerImage) {
        this(containerImage, LauncherUtil.installAndGetSomeConfig());
    }

    public DockerContainerLauncher(String containerImage, int httpPort, int httpsPort, long jarWaitTime, String profile) {
        this.containerImage = containerImage;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.jarWaitTime = jarWaitTime;
        this.profile = profile;
    }

    @Override
    public void start() throws IOException {
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        if (this.httpPort == 0) {
            this.httpPort = this.getRandomPort();
        }
        if (this.httpsPort == 0) {
            this.httpsPort = this.getRandomPort();
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("docker");
        args.add("run");
        args.add("--rm");
        args.add("-p");
        args.add(this.httpPort + ":" + this.httpPort);
        args.add("-p");
        args.add(this.httpsPort + ":" + this.httpsPort);
        args.addAll(this.toEnvVar("quarkus.http.port", "" + this.httpPort));
        args.addAll(this.toEnvVar("quarkus.http.ssl-port", "" + this.httpsPort));
        args.addAll(this.toEnvVar("test.url", TestHTTPResourceManager.getUri()));
        if (this.profile != null) {
            args.addAll(this.toEnvVar("quarkus.profile", this.profile));
        }
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            args.addAll(this.toEnvVar(e.getKey(), e.getValue()));
        }
        args.add(this.containerImage);
        Path logFile = PropertyTestUtil.getLogFilePath();
        Files.deleteIfExists(logFile);
        System.out.println("Executing " + args);
        this.quarkusProcess = new ProcessBuilder(args).redirectError(logFile.toFile()).redirectOutput(logFile.toFile()).start();
        ListeningAddress result = LauncherUtil.waitForCapturedListeningData(this.quarkusProcess, logFile, this.jarWaitTime);
        LauncherUtil.updateConfigForPort(result.getPort());
        this.isSsl = result.isSsl();
    }

    private int getRandomPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    @Override
    public boolean listensOnSsl() {
        return this.isSsl;
    }

    @Override
    public void addSystemProperties(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    private List<String> toEnvVar(String property, String value) {
        if (property != null && !property.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(2);
            result.add("--env");
            result.add(String.format("%s=%s", this.convertPropertyToEnVar(property), value));
            return result;
        }
        return Collections.emptyList();
    }

    private String convertPropertyToEnVar(String property) {
        return property.toUpperCase().replace('-', '_').replace('.', '_');
    }

    @Override
    public void close() {
        this.quarkusProcess.destroy();
    }
}

