/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthNotFoundHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRuntimeConfig;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthStaticHandler;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;

@Recorder
public class SmallRyeHealthRecorder {
    public void registerHealthCheckResponseProvider(Class<? extends HealthCheckResponseProvider> providerClass) {
        try {
            HealthCheckResponse.setResponseProvider((HealthCheckResponseProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate service " + providerClass + " using the no-arg constructor.");
        }
    }

    public Handler<RoutingContext> uiHandler(String healthUiFinalDestination, String healthUiPath, SmallRyeHealthRuntimeConfig runtimeConfig) {
        if (runtimeConfig.enable) {
            return new SmallRyeHealthStaticHandler(healthUiFinalDestination, healthUiPath);
        }
        return new SmallRyeHealthNotFoundHandler();
    }
}

