/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.qute.generator.ValueResolverGenerator;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

public final class TemplateDataBuildItem
extends MultiBuildItem {
    private final ClassInfo targetClass;
    private final String namespace;
    private final String[] ignore;
    private final Pattern[] ignorePatterns;
    private final boolean ignoreSuperclasses;
    private final boolean properties;
    private final AnnotationInstance annotationInstance;

    public TemplateDataBuildItem(AnnotationInstance annotationInstance, ClassInfo targetClass) {
        String namespace;
        this.annotationInstance = annotationInstance;
        AnnotationValue ignoreValue = annotationInstance.value("ignore");
        AnnotationValue propertiesValue = annotationInstance.value("properties");
        AnnotationValue namespaceValue = annotationInstance.value("namespace");
        AnnotationValue ignoreSuperclassesValue = annotationInstance.value("ignoreSuperclasses");
        this.targetClass = targetClass;
        String string = namespace = namespaceValue != null ? namespaceValue.asString() : "<<undescored fqcn>>";
        if (namespace.equals("<<undescored fqcn>>")) {
            namespace = ValueResolverGenerator.underscoredFullyQualifiedName((String)targetClass.name().toString());
        } else if (namespace.equals("<<simplename>>")) {
            namespace = ValueResolverGenerator.simpleName((ClassInfo)targetClass);
        }
        this.namespace = namespace;
        String[] stringArray = this.ignore = ignoreValue != null ? ignoreValue.asStringArray() : new String[]{};
        if (this.ignore.length > 0) {
            this.ignorePatterns = new Pattern[this.ignore.length];
            for (int i = 0; i < this.ignore.length; ++i) {
                this.ignorePatterns[i] = Pattern.compile(this.ignore[i]);
            }
        } else {
            this.ignorePatterns = null;
        }
        this.ignoreSuperclasses = ignoreSuperclassesValue != null ? ignoreSuperclassesValue.asBoolean() : false;
        this.properties = propertiesValue != null ? propertiesValue.asBoolean() : false;
    }

    public boolean isTargetAnnotatedType() {
        AnnotationValue targetValue = this.annotationInstance.value("target");
        return targetValue == null || targetValue.asClass().name().equals((Object)ValueResolverGenerator.TEMPLATE_DATA);
    }

    public ClassInfo getTargetClass() {
        return this.targetClass;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String[] getIgnore() {
        return this.ignore;
    }

    public boolean isIgnoreSuperclasses() {
        return this.ignoreSuperclasses;
    }

    public boolean isProperties() {
        return this.properties;
    }

    public AnnotationInstance getAnnotationInstance() {
        return this.annotationInstance;
    }

    boolean filter(AnnotationTarget target) {
        String name = null;
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            MethodInfo method = target.asMethod();
            if (this.properties && !method.parameterTypes().isEmpty()) {
                return false;
            }
            name = method.name();
        } else if (target.kind() == AnnotationTarget.Kind.FIELD) {
            FieldInfo field = target.asField();
            name = field.name();
        }
        if (this.ignorePatterns != null) {
            for (Pattern ignorePattern : this.ignorePatterns) {
                if (!ignorePattern.matcher(name).matches()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "TemplateDataBuildItem [targetClass=" + String.valueOf(this.targetClass) + ", namespace=" + this.namespace + ", ignore=" + Arrays.toString(this.ignore) + ", ignorePatterns=" + Arrays.toString(this.ignorePatterns) + ", ignoreSuperclasses=" + this.ignoreSuperclasses + ", properties=" + this.properties + "]";
    }
}

