/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.QualifierRegistrarBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.QualifierRegistrar;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ParserHelper;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.Variant;
import io.quarkus.qute.deployment.CheckedTemplateAdapter;
import io.quarkus.qute.deployment.CheckedTemplateAdapterBuildItem;
import io.quarkus.qute.deployment.CheckedTemplateBuildItem;
import io.quarkus.qute.deployment.GeneratedTemplateInitializerBuildItem;
import io.quarkus.qute.deployment.GeneratedValueResolverBuildItem;
import io.quarkus.qute.deployment.ImplicitValueResolverBuildItem;
import io.quarkus.qute.deployment.IncorrectExpressionBuildItem;
import io.quarkus.qute.deployment.MessageBundleMethodBuildItem;
import io.quarkus.qute.deployment.MessageBundleProcessor;
import io.quarkus.qute.deployment.Names;
import io.quarkus.qute.deployment.NativeCheckedTemplateEnhancer;
import io.quarkus.qute.deployment.TemplateDataBuildItem;
import io.quarkus.qute.deployment.TemplateDataBuilder;
import io.quarkus.qute.deployment.TemplateExpressionMatchesBuildItem;
import io.quarkus.qute.deployment.TemplateExtensionMethodBuildItem;
import io.quarkus.qute.deployment.TemplateFilePathsBuildItem;
import io.quarkus.qute.deployment.TemplateGlobalBuildItem;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import io.quarkus.qute.deployment.TemplateVariantsBuildItem;
import io.quarkus.qute.deployment.TemplatesAnalysisBuildItem;
import io.quarkus.qute.deployment.TypeCheckExcludeBuildItem;
import io.quarkus.qute.deployment.TypeInfos;
import io.quarkus.qute.deployment.Types;
import io.quarkus.qute.generator.ExtensionMethodGenerator;
import io.quarkus.qute.generator.TemplateGlobalGenerator;
import io.quarkus.qute.generator.ValueResolverGenerator;
import io.quarkus.qute.runtime.ContentTypes;
import io.quarkus.qute.runtime.EngineProducer;
import io.quarkus.qute.runtime.QuteConfig;
import io.quarkus.qute.runtime.QuteRecorder;
import io.quarkus.qute.runtime.TemplateProducer;
import io.quarkus.qute.runtime.extensions.CollectionTemplateExtensions;
import io.quarkus.qute.runtime.extensions.ConfigTemplateExtensions;
import io.quarkus.qute.runtime.extensions.MapTemplateExtensions;
import io.quarkus.qute.runtime.extensions.NumberTemplateExtensions;
import io.quarkus.qute.runtime.extensions.StringTemplateExtensions;
import io.quarkus.qute.runtime.extensions.TimeTemplateExtensions;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public class QuteProcessor {
    public static final DotName LOCATION = Names.LOCATION;
    private static final Logger LOGGER = Logger.getLogger(QuteProcessor.class);
    private static final String CHECKED_TEMPLATE_REQUIRE_TYPE_SAFE = "requireTypeSafeExpressions";
    private static final String CHECKED_TEMPLATE_BASE_PATH = "basePath";
    private static final String BASE_PATH = "templates";
    private static final Set<String> ITERATION_METADATA_KEYS = Set.of("count", "index", "indexParity", "hasNext", "odd", "isOdd", "even", "isEven", "isLast", "isFirst");
    private static final Function<FieldInfo, String> GETTER_FUN = new Function<FieldInfo, String>(){

        @Override
        public String apply(FieldInfo field) {
            String prefix = field.type().kind() == Type.Kind.PRIMITIVE && field.type().asPrimitiveType().primitive() == PrimitiveType.Primitive.BOOLEAN ? "is" : "get";
            return prefix + ValueResolverGenerator.capitalize((String)field.name());
        }
    };

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.QUTE);
    }

    @BuildStep
    void processTemplateErrors(TemplatesAnalysisBuildItem analysis, List<IncorrectExpressionBuildItem> incorrectExpressions, BuildProducer<ServiceStartBuildItem> serviceStart) {
        ArrayList<TemplateException> errors = new ArrayList<TemplateException>();
        for (IncorrectExpressionBuildItem incorrectExpression : incorrectExpressions) {
            if (incorrectExpression.reason != null) {
                errors.add(new TemplateException(incorrectExpression.origin, String.format("Incorrect expression found: {%s}\n\t- %s\n\t- at %s:%s", incorrectExpression.expression, incorrectExpression.reason, QuteProcessor.findTemplatePath(analysis, incorrectExpression.origin.getTemplateGeneratedId()), incorrectExpression.origin.getLine())));
                continue;
            }
            if (incorrectExpression.clazz != null) {
                errors.add(new TemplateException(incorrectExpression.origin, String.format("Incorrect expression found: {%s}\n\t- property/method [%s] not found on class [%s] nor handled by an extension method\n\t- at %s:%s", incorrectExpression.expression, incorrectExpression.property, incorrectExpression.clazz, QuteProcessor.findTemplatePath(analysis, incorrectExpression.origin.getTemplateGeneratedId()), incorrectExpression.origin.getLine())));
                continue;
            }
            errors.add(new TemplateException(incorrectExpression.origin, String.format("Incorrect expression found: {%s}\n\t- @Named bean not found for [%s]\n\t- at %s:%s", incorrectExpression.expression, incorrectExpression.property, QuteProcessor.findTemplatePath(analysis, incorrectExpression.origin.getTemplateGeneratedId()), incorrectExpression.origin.getLine())));
        }
        if (!errors.isEmpty()) {
            StringBuilder message = new StringBuilder("Found template problems (").append(errors.size()).append("):");
            int idx = 1;
            for (TemplateException error : errors) {
                message.append("\n").append("[").append(idx++).append("] ").append(error.getMessage());
            }
            TemplateException exception = new TemplateException(message.toString());
            for (TemplateException error : errors) {
                exception.addSuppressed((Throwable)error);
            }
            throw exception;
        }
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{EngineProducer.class, TemplateProducer.class, ContentTypes.class, Template.class, TemplateInstance.class, CollectionTemplateExtensions.class, MapTemplateExtensions.class, NumberTemplateExtensions.class, ConfigTemplateExtensions.class, TimeTemplateExtensions.class, StringTemplateExtensions.class}).build();
    }

    @BuildStep
    List<CheckedTemplateBuildItem> collectCheckedTemplates(BeanArchiveIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, List<TemplatePathBuildItem> templatePaths, List<CheckedTemplateAdapterBuildItem> templateAdaptorBuildItems, TemplateFilePathsBuildItem filePaths) {
        Object supportedAdaptors;
        ArrayList<CheckedTemplateBuildItem> ret = new ArrayList<CheckedTemplateBuildItem>();
        HashMap<DotName, CheckedTemplateAdapter> adaptors = new HashMap<DotName, CheckedTemplateAdapter>();
        for (CheckedTemplateAdapterBuildItem templateAdaptorBuildItem : templateAdaptorBuildItems) {
            adaptors.put(DotName.createSimple((String)templateAdaptorBuildItem.adapter.templateInstanceBinaryName().replace('/', '.')), templateAdaptorBuildItem.adapter);
        }
        if (adaptors.isEmpty()) {
            supportedAdaptors = Names.TEMPLATE_INSTANCE + " is supported";
        } else {
            StringBuffer strbuf = new StringBuffer(Names.TEMPLATE_INSTANCE.toString());
            ArrayList<String> adaptorsList = new ArrayList<String>(adaptors.size());
            for (DotName dotName : adaptors.keySet()) {
                adaptorsList.add(dotName.toString());
            }
            Collections.sort(adaptorsList);
            for (String string : adaptorsList) {
                strbuf.append(", ").append(string);
            }
            supportedAdaptors = strbuf.append(" are supported").toString();
        }
        HashMap<String, MethodInfo> checkedTemplateMethods = new HashMap<String, MethodInfo>();
        HashSet checkedTemplateAnnotations = new HashSet();
        checkedTemplateAnnotations.addAll(index.getIndex().getAnnotations(Names.CHECKED_TEMPLATE));
        for (AnnotationInstance annotationInstance : checkedTemplateAnnotations) {
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = annotationInstance.target().asClass();
            NativeCheckedTemplateEnhancer enhancer = new NativeCheckedTemplateEnhancer();
            for (MethodInfo methodInfo : classInfo.methods()) {
                String templatePath;
                MethodInfo checkedTemplateMethod;
                if (!Modifier.isStatic(methodInfo.flags()) || !Modifier.isNative(methodInfo.flags())) continue;
                if (methodInfo.returnType().kind() != Type.Kind.CLASS) {
                    throw new TemplateException("Incompatible checked template return type: " + methodInfo.returnType() + " only " + (String)supportedAdaptors);
                }
                DotName returnTypeName = methodInfo.returnType().asClassType().name();
                CheckedTemplateAdapter adaptor = null;
                if (!returnTypeName.equals((Object)Names.TEMPLATE_INSTANCE) && (adaptor = (CheckedTemplateAdapter)adaptors.get(returnTypeName)) == null) {
                    throw new TemplateException("Incompatible checked template return type: " + methodInfo.returnType() + " only " + (String)supportedAdaptors);
                }
                StringBuilder templatePathBuilder = new StringBuilder();
                AnnotationValue basePathValue = annotationInstance.value(CHECKED_TEMPLATE_BASE_PATH);
                if (basePathValue != null && !basePathValue.asString().equals("<<defaulted>>")) {
                    templatePathBuilder.append(basePathValue.asString());
                } else if (classInfo.enclosingClass() != null) {
                    ClassInfo enclosingClass = index.getIndex().getClassByName(classInfo.enclosingClass());
                    templatePathBuilder.append(enclosingClass.simpleName());
                }
                if (templatePathBuilder.length() > 0 && templatePathBuilder.charAt(templatePathBuilder.length() - 1) != '/') {
                    templatePathBuilder.append('/');
                }
                if ((checkedTemplateMethod = checkedTemplateMethods.putIfAbsent(templatePath = templatePathBuilder.append(methodInfo.name()).toString(), methodInfo)) != null) {
                    throw new TemplateException(String.format("Multiple checked template methods exist for the template path %s:\n\t- %s: %s\n\t- %s: %s", templatePath, methodInfo.declaringClass().name(), methodInfo, checkedTemplateMethod.declaringClass().name(), checkedTemplateMethod));
                }
                if (!filePaths.contains(templatePath)) {
                    ArrayList<String> startsWith = new ArrayList<String>();
                    for (String filePath : filePaths.getFilePaths()) {
                        if (!filePath.startsWith(templatePath)) continue;
                        startsWith.add(filePath);
                    }
                    if (startsWith.isEmpty()) {
                        throw new TemplateException("No template matching the path " + templatePath + " could be found for: " + classInfo.name() + "." + methodInfo.name());
                    }
                    throw new TemplateException(startsWith + " match the path " + templatePath + " but the file suffix is not configured via the quarkus.qute.suffixes property");
                }
                HashMap<String, String> bindings = new HashMap<String, String>();
                List parameters = methodInfo.parameters();
                ArrayList<String> parameterNames = new ArrayList<String>(parameters.size());
                for (int i = 0; i < parameters.size(); ++i) {
                    Type type = (Type)parameters.get(i);
                    String name = methodInfo.parameterName(i);
                    if (name == null) {
                        throw new TemplateException("Parameter names not recorded for " + classInfo.name() + ": compile the class with -parameters");
                    }
                    bindings.put(name, JandexUtil.getBoxedTypeName((Type)type));
                    parameterNames.add(name);
                }
                AnnotationValue requireTypeSafeExpressions = annotationInstance.value(CHECKED_TEMPLATE_REQUIRE_TYPE_SAFE);
                ret.add(new CheckedTemplateBuildItem(templatePath, bindings, methodInfo, requireTypeSafeExpressions != null ? requireTypeSafeExpressions.asBoolean() : true));
                enhancer.implement(methodInfo, templatePath, parameterNames, adaptor);
            }
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (BiFunction)enhancer));
        }
        return ret;
    }

    @BuildStep
    TemplatesAnalysisBuildItem analyzeTemplates(final List<TemplatePathBuildItem> templatePaths, final TemplateFilePathsBuildItem filePaths, final List<CheckedTemplateBuildItem> checkedTemplates, List<MessageBundleMethodBuildItem> messageBundleMethods, final List<TemplateGlobalBuildItem> globals, final QuteConfig config) {
        Template template;
        Map<String, MessageBundleMethodBuildItem> messageBundleMethodsMap;
        long start = System.nanoTime();
        this.checkDuplicatePaths(templatePaths);
        ArrayList<TemplatesAnalysisBuildItem.TemplateAnalysis> analysis = new ArrayList<TemplatesAnalysisBuildItem.TemplateAnalysis>();
        EngineBuilder builder = Engine.builder().addDefaultSectionHelpers();
        for (Object path : templatePaths) {
            if (!path.isTag()) continue;
            String tagPath = path.getPath();
            String tagName = tagPath.substring("tags/".length(), tagPath.length());
            if (tagName.contains(".")) {
                tagName = tagName.substring(0, tagName.indexOf(46));
            }
            builder.addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory(tagName, tagPath));
        }
        builder.computeSectionHelper(name -> new SectionHelperFactory<SectionHelper>(){

            public SectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
                return new SectionHelper(){

                    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
                        return ResultNode.NOOP;
                    }
                };
            }
        });
        builder.addLocator(new TemplateLocator(){

            public Optional<TemplateLocator.TemplateLocation> locate(String id) {
                final TemplatePathBuildItem found = templatePaths.stream().filter(p -> p.getPath().equals(id)).findAny().orElse(null);
                if (found != null) {
                    return Optional.of(new TemplateLocator.TemplateLocation(){

                        public Reader read() {
                            return new StringReader(found.getContent());
                        }

                        public Optional<Variant> getVariant() {
                            return Optional.empty();
                        }
                    });
                }
                return Optional.empty();
            }
        });
        if (messageBundleMethods.isEmpty()) {
            messageBundleMethodsMap = Collections.emptyMap();
        } else {
            messageBundleMethodsMap = new HashMap();
            for (MessageBundleMethodBuildItem messageBundleMethod : messageBundleMethods) {
                messageBundleMethodsMap.put(messageBundleMethod.getTemplateId(), messageBundleMethod);
            }
        }
        builder.addParserHook(new ParserHook(){

            public void beforeParsing(ParserHelper parserHelper) {
                MessageBundleMethodBuildItem messageBundleMethod;
                String templateId = parserHelper.getTemplateId();
                if (filePaths.contains(templateId)) {
                    String path = templateId;
                    for (String suffix : config.suffixes) {
                        if (!path.endsWith(suffix)) continue;
                        path = path.substring(0, path.length() - (suffix.length() + 1));
                        break;
                    }
                    for (TemplateGlobalBuildItem global : globals) {
                        parserHelper.addParameter(global.getName(), JandexUtil.getBoxedTypeName((Type)global.getVariableType()).toString());
                    }
                    for (CheckedTemplateBuildItem checkedTemplate : checkedTemplates) {
                        if (!checkedTemplate.templateId.equals(path)) continue;
                        for (Map.Entry<String, String> entry : checkedTemplate.bindings.entrySet()) {
                            parserHelper.addParameter(entry.getKey(), entry.getValue());
                        }
                    }
                }
                if ((messageBundleMethod = (MessageBundleMethodBuildItem)((Object)messageBundleMethodsMap.get(templateId))) != null) {
                    MethodInfo method = messageBundleMethod.getMethod();
                    ListIterator it = method.parameters().listIterator();
                    while (it.hasNext()) {
                        Type paramType = (Type)it.next();
                        String name = MessageBundleProcessor.getParameterName(method, it.previousIndex());
                        parserHelper.addParameter(name, JandexUtil.getBoxedTypeName((Type)paramType));
                    }
                }
            }
        }).build();
        Engine dummyEngine = builder.build();
        for (TemplatePathBuildItem path : templatePaths) {
            template = dummyEngine.getTemplate(path.getPath());
            if (template == null) continue;
            analysis.add(new TemplatesAnalysisBuildItem.TemplateAnalysis(null, template.getGeneratedId(), template.getExpressions(), path.getPath()));
        }
        for (MessageBundleMethodBuildItem messageBundleMethod : messageBundleMethods) {
            template = dummyEngine.parse(messageBundleMethod.getTemplate(), null, messageBundleMethod.getTemplateId());
            analysis.add(new TemplatesAnalysisBuildItem.TemplateAnalysis(messageBundleMethod.getTemplateId(), template.getGeneratedId(), template.getExpressions(), messageBundleMethod.getMethod().declaringClass().name() + "#" + messageBundleMethod.getMethod().name() + "()"));
        }
        LOGGER.debugf("Finished analysis of %s templates in %s ms", (long)analysis.size(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        return new TemplatesAnalysisBuildItem(analysis);
    }

    @BuildStep
    void validateExpressions(final TemplatesAnalysisBuildItem templatesAnalysis, BeanArchiveIndexBuildItem beanArchiveIndex, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<TypeCheckExcludeBuildItem> excludes, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, BuildProducer<ImplicitValueResolverBuildItem> implicitClasses, BuildProducer<TemplateExpressionMatchesBuildItem> expressionMatches, BeanDiscoveryFinishedBuildItem beanDiscovery, List<CheckedTemplateBuildItem> checkedTemplates, List<TemplateDataBuildItem> templateData, QuteConfig config) {
        IndexView index = beanArchiveIndex.getIndex();
        Function<String, String> templateIdToPathFun = new Function<String, String>(){

            @Override
            public String apply(String id) {
                return QuteProcessor.findTemplatePath(templatesAnalysis, id);
            }
        };
        Map namedBeans = (Map)beanDiscovery.beanStream().withName().collect(Collectors.toMap(BeanInfo::getName, Function.identity()));
        HashMap<DotName, Set<String>> implicitClassToMembersUsed = new HashMap<DotName, Set<String>>();
        Map<String, TemplateDataBuildItem> namespaceTemplateData = templateData.stream().filter(TemplateDataBuildItem::hasNamespace).collect(Collectors.toMap(TemplateDataBuildItem::getNamespace, Function.identity()));
        Map<String, List<TemplateExtensionMethodBuildItem>> namespaceExtensionMethods = templateExtensionMethods.stream().filter(TemplateExtensionMethodBuildItem::hasNamespace).sorted(Comparator.comparingInt(TemplateExtensionMethodBuildItem::getPriority).reversed()).collect(Collectors.groupingBy(TemplateExtensionMethodBuildItem::getNamespace));
        List<TemplateExtensionMethodBuildItem> regularExtensionMethods = templateExtensionMethods.stream().filter(Predicate.not(TemplateExtensionMethodBuildItem::hasNamespace)).collect(Collectors.toUnmodifiableList());
        FixedLookupConfig lookupConfig = new FixedLookupConfig(index, QuteProcessor.initDefaultMembersFilter(), false);
        for (TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis : templatesAnalysis.getAnalysis()) {
            CheckedTemplateBuildItem checkedTemplate = this.findCheckedTemplate(config, templateAnalysis, checkedTemplates);
            HashMap<Integer, Match> generatedIdsToMatches = new HashMap<Integer, Match>();
            for (Expression expression : templateAnalysis.expressions) {
                if (expression.isLiteral()) continue;
                Match match = QuteProcessor.validateNestedExpressions(config, templateAnalysis, null, new HashMap<String, Match>(), excludes, incorrectExpressions, expression, index, implicitClassToMembersUsed, templateIdToPathFun, generatedIdsToMatches, checkedTemplate, lookupConfig, namedBeans, namespaceTemplateData, regularExtensionMethods, namespaceExtensionMethods);
                generatedIdsToMatches.put(expression.getGeneratedId(), match);
            }
            expressionMatches.produce((BuildItem)new TemplateExpressionMatchesBuildItem(templateAnalysis.generatedId, generatedIdsToMatches));
        }
        for (Map.Entry entry : implicitClassToMembersUsed.entrySet()) {
            ClassInfo clazz = index.getClassByName((DotName)entry.getKey());
            if (clazz == null) continue;
            implicitClasses.produce((BuildItem)new ImplicitValueResolverBuildItem(clazz, new TemplateDataBuilder().addIgnore(QuteProcessor.buildIgnorePattern((Iterable)entry.getValue())).build()));
        }
    }

    static Predicate<AnnotationTarget> initDefaultMembersFilter() {
        Predicate<AnnotationTarget> filter = QuteProcessor::defaultFilter;
        Predicate<AnnotationTarget> enumConstantFilter = QuteProcessor::enumConstantFilter;
        filter = filter.and(enumConstantFilter.or(Predicate.not(QuteProcessor::staticsFilter)));
        return filter;
    }

    private CheckedTemplateBuildItem findCheckedTemplate(QuteConfig config, TemplatesAnalysisBuildItem.TemplateAnalysis analysis, List<CheckedTemplateBuildItem> checkedTemplates) {
        String path = analysis.path;
        for (String suffix : config.suffixes) {
            if (!path.endsWith(suffix)) continue;
            path = path.substring(0, path.length() - (suffix.length() + 1));
            break;
        }
        for (CheckedTemplateBuildItem item : checkedTemplates) {
            if (!item.templateId.equals(path)) continue;
            return item;
        }
        return null;
    }

    static String buildIgnorePattern(Iterable<String> names) {
        StringBuilder ignorePattern = new StringBuilder("^(?!");
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String memberName = iterator.next();
            ignorePattern.append(Pattern.quote(memberName));
            if (!iterator.hasNext()) continue;
            ignorePattern.append("|");
        }
        ignorePattern.append(").*$");
        return ignorePattern.toString();
    }

    /*
     * Unable to fully structure code
     */
    static Match validateNestedExpressions(QuteConfig config, TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, ClassInfo rootClazz, Map<String, Match> results, List<TypeCheckExcludeBuildItem> excludes, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, Expression expression, IndexView index, Map<DotName, Set<String>> implicitClassToMembersUsed, Function<String, String> templateIdToPathFun, Map<Integer, Match> generatedIdsToMatches, CheckedTemplateBuildItem checkedTemplate, LookupConfig lookupConfig, Map<String, BeanInfo> namedBeans, Map<String, TemplateDataBuildItem> namespaceTemplateData, List<TemplateExtensionMethodBuildItem> regularExtensionMethods, Map<String, List<TemplateExtensionMethodBuildItem>> namespaceExtensionMethods) {
        block51: {
            block48: {
                block49: {
                    block50: {
                        block47: {
                            for (Expression.Part part : expression.getParts()) {
                                if (!part.isVirtualMethod()) continue;
                                for (Expression param : part.asVirtualMethod().getParameters()) {
                                    if (param.isLiteral() && param.getLiteral() == null || results.containsKey(param.toOriginalString())) continue;
                                    QuteProcessor.validateNestedExpressions(config, templateAnalysis, null, results, excludes, incorrectExpressions, param, index, implicitClassToMembersUsed, templateIdToPathFun, generatedIdsToMatches, checkedTemplate, lookupConfig, namedBeans, namespaceTemplateData, regularExtensionMethods, namespaceExtensionMethods);
                                }
                            }
                            match = new Match(index);
                            namespace = expression.getNamespace();
                            templateData = null;
                            extensionMethods = null;
                            if (namespace == null) break block47;
                            if (!namespace.equals("inject") && !namespace.equals("cdi")) ** GOTO lbl20
                            bean = QuteProcessor.findBean(expression, index, incorrectExpressions, namedBeans);
                            if (bean != null) {
                                rootClazz = bean.getImplClazz();
                            } else {
                                return QuteProcessor.putResult(match, results, expression);
lbl20:
                                // 1 sources

                                templateData = namespaceTemplateData.get(namespace);
                                if (templateData != null) {
                                    rootClazz = templateData.getTargetClass();
                                    filter = (Predicate<AnnotationTarget>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, defaultFilter(org.jboss.jandex.AnnotationTarget ), (Lorg/jboss/jandex/AnnotationTarget;)Z)();
                                    filter = filter.and((Predicate<AnnotationTarget>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, staticsFilter(org.jboss.jandex.AnnotationTarget ), (Lorg/jboss/jandex/AnnotationTarget;)Z)());
                                    filter = filter.and((Predicate<AnnotationTarget>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, filter(org.jboss.jandex.AnnotationTarget ), (Lorg/jboss/jandex/AnnotationTarget;)Z)((TemplateDataBuildItem)templateData));
                                    lookupConfig = new FirstPassLookupConfig(lookupConfig, filter, true);
                                } else {
                                    extensionMethods = namespaceExtensionMethods.get(namespace);
                                    if (extensionMethods == null) {
                                        return QuteProcessor.putResult(match, results, expression);
                                    }
                                }
                            }
                        }
                        if (checkedTemplate != null && checkedTemplate.requireTypeSafeExpressions && !expression.hasTypeInfo()) {
                            if (!expression.hasNamespace() && expression.getParts().size() == 1 && QuteProcessor.ITERATION_METADATA_KEYS.contains(((Expression.Part)expression.getParts().get(0)).getName())) {
                                prefixInfo = config.iterationMetadataPrefix.equals("<alias_>") != false ? String.format("based on the iteration alias, i.e. the correct key should be something like {it_%1$s} or {element_%1$s}", new Object[]{((Expression.Part)expression.getParts().get(0)).getName()}) : (config.iterationMetadataPrefix.equals("<alias?>") != false ? String.format("based on the iteration alias, i.e. the correct key should be something like {it?%1$s} or {element?%1$s}", new Object[]{((Expression.Part)expression.getParts().get(0)).getName()}) : ": " + config.iterationMetadataPrefix + ", i.e. the correct key should be: " + config.iterationMetadataPrefix + ((Expression.Part)expression.getParts().get(0)).getName());
                                incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "An invalid iteration metadata key is probably used\n\t- The configured iteration metadata prefix is " + (String)prefixInfo + "\n\t- You can configure the prefix via the io.quarkus.qute.iteration-metadata-prefix configuration property", expression.getOrigin()));
                            } else {
                                incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "Only type-safe expressions are allowed in the checked template defined via: " + checkedTemplate.method.declaringClass().name() + "." + checkedTemplate.method.name() + "(); an expression must be based on a checked template parameter " + checkedTemplate.bindings.keySet() + ", or bound via a param declaration, or the requirement must be relaxed via @CheckedTemplate(requireTypeSafeExpressions = false)", expression.getOrigin()));
                            }
                            return QuteProcessor.putResult(match, results, expression);
                        }
                        if (rootClazz == null && !expression.hasTypeInfo()) {
                            return QuteProcessor.putResult(match, results, expression);
                        }
                        parts = TypeInfos.create(expression, index, templateIdToPathFun);
                        iterator = parts.iterator();
                        root = iterator.next();
                        if (extensionMethods == null) break block48;
                        extensionMethod = QuteProcessor.findTemplateExtensionMethod(root, null, extensionMethods, expression, index, templateIdToPathFun, results);
                        if (extensionMethod == null) break block49;
                        method = extensionMethod.getMethod();
                        returnType = index.getClassByName(method.returnType().name());
                        if (returnType == null) break block50;
                        match.setValues(returnType, method.returnType());
                        if (root.hasHints() && QuteProcessor.processHints(templateAnalysis, root.asHintInfo().hints, match, index, expression, generatedIdsToMatches, incorrectExpressions)) {
                            iterator = parts.iterator();
                        }
                        break block51;
                    }
                    return QuteProcessor.putResult(match, results, expression);
                }
                incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), String.format("no matching namespace [%s] extension method found", new Object[]{namespace}), expression.getOrigin()));
                match.clearValues();
                return QuteProcessor.putResult(match, results, expression);
            }
            if (rootClazz != null) ** GOTO lbl76
            if (root.isTypeInfo()) {
                match.setValues(root.asTypeInfo().rawClass, root.asTypeInfo().resolvedType);
                if (root.hasHints()) {
                    QuteProcessor.processHints(templateAnalysis, root.asTypeInfo().hints, match, index, expression, generatedIdsToMatches, incorrectExpressions);
                }
            } else if (root.hasHints()) {
                if (QuteProcessor.processHints(templateAnalysis, root.asHintInfo().hints, match, index, expression, generatedIdsToMatches, incorrectExpressions)) {
                    iterator = parts.iterator();
                }
            } else {
                return QuteProcessor.putResult(match, results, expression);
lbl76:
                // 1 sources

                if ("inject".equals(namespace) || "cdi".equals(namespace)) {
                    match.setValues(rootClazz, Type.create((DotName)rootClazz.name(), (Type.Kind)Type.Kind.CLASS));
                } else if (templateData != null) {
                    match.setValues(rootClazz, Type.create((DotName)rootClazz.name(), (Type.Kind)Type.Kind.CLASS));
                    iterator = parts.iterator();
                } else {
                    return QuteProcessor.putResult(match, results, expression);
                }
            }
        }
        while (iterator.hasNext()) {
            info = iterator.next();
            if (!match.isEmpty()) {
                if (match.isArray()) {
                    if (info.isProperty()) {
                        name = info.asProperty().name;
                        if (name.equals("length") || name.equals("size")) {
                            match.setValues(null, (Type)PrimitiveType.INT);
                            continue;
                        }
                        try {
                            Integer.parseInt(name);
                            match.setValues(null, match.type().asArrayType().component());
                            continue;
                        }
                        catch (NumberFormatException returnType) {
                        }
                    } else if (info.isVirtualMethod()) {
                        params = info.asVirtualMethod().part.asVirtualMethod().getParameters();
                        name = info.asVirtualMethod().name;
                        if (name.equals("get") && params.size() == 1) {
                            param = (Expression)params.get(0);
                            literalValue = param.getLiteral();
                            if (literalValue == null || literalValue instanceof Integer) {
                                match.setValues(null, match.type().asArrayType().component());
                                continue;
                            }
                        } else if (name.equals("take") || name.equals("takeLast")) continue;
                    }
                }
                member = null;
                extensionMethod = null;
                if (!match.isPrimitive()) {
                    membersUsed = implicitClassToMembersUsed.get(match.type().name());
                    if (membersUsed == null) {
                        membersUsed = new HashSet<String>();
                        implicitClassToMembersUsed.put(match.type().name(), membersUsed);
                    }
                    if (match.clazz() != null) {
                        if (info.isVirtualMethod()) {
                            member = QuteProcessor.findMethod(info.part.asVirtualMethod(), match.clazz(), expression, index, templateIdToPathFun, results, lookupConfig);
                            if (member != null) {
                                membersUsed.add(member.asMethod().name());
                            }
                        } else if (info.isProperty() && (member = QuteProcessor.findProperty(info.asProperty().name, match.clazz(), lookupConfig)) != null) {
                            membersUsed.add(member.kind() == AnnotationTarget.Kind.FIELD ? member.asField().name() : member.asMethod().name());
                        }
                    }
                }
                if (member == null && (extensionMethod = QuteProcessor.findTemplateExtensionMethod(info, match.type(), regularExtensionMethods, expression, index, templateIdToPathFun, results)) != null) {
                    member = extensionMethod.getMethod();
                }
                if (member == null && QuteProcessor.isExcluded(check = new TypeCheckExcludeBuildItem.TypeCheck(info.isProperty() != false ? info.asProperty().name : info.asVirtualMethod().name, match.clazz(), info.part.isVirtualMethod() != false ? info.part.asVirtualMethod().getParameters().size() : -1), excludes)) {
                    QuteProcessor.LOGGER.debugf("Expression part [%s] excluded from validation of [%s] against type [%s]", (Object)info.value, (Object)expression.toOriginalString(), (Object)match.type());
                    match.clearValues();
                    break;
                }
                if (member == null) {
                    incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), info.value, match.type().toString(), expression.getOrigin()));
                    match.clearValues();
                    break;
                }
                type = QuteProcessor.resolveType(member, match, index, extensionMethod);
                clazz = null;
                if (type.kind() == Type.Kind.CLASS || type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                    clazz = index.getClassByName(type.name());
                }
                match.setValues(clazz, type);
                if (info.hasHints()) {
                    QuteProcessor.processHints(templateAnalysis, info.asHintInfo().hints, match, index, expression, generatedIdsToMatches, incorrectExpressions);
                }
            } else {
                QuteProcessor.LOGGER.debugf("No match class available - skip further validation for [%s] in expression [%s] in template [%s] on line %s", new Object[]{info.part, expression.toOriginalString(), expression.getOrigin().getTemplateId(), expression.getOrigin().getLine()});
                match.clearValues();
                break;
            }
            lookupConfig.nextPart();
        }
        return QuteProcessor.putResult(match, results, expression);
    }

    private static Match putResult(Match match, Map<String, Match> results, Expression expression) {
        results.put(expression.toOriginalString(), match);
        return match;
    }

    @BuildStep
    void collectTemplateExtensionMethods(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<TemplateExtensionMethodBuildItem> extensionMethods) {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<MethodInfo, AnnotationInstance> methods = new HashMap<MethodInfo, AnnotationInstance>();
        HashMap<DotName, AnnotationInstance> classes = new HashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance annotationInstance : index.getAnnotations(ExtensionMethodGenerator.TEMPLATE_EXTENSION)) {
            if (annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD) {
                methods.put(annotationInstance.target().asMethod(), annotationInstance);
                continue;
            }
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            classes.put(annotationInstance.target().asClass().name(), annotationInstance);
        }
        for (Map.Entry entry : methods.entrySet()) {
            MethodInfo method = (MethodInfo)entry.getKey();
            AnnotationValue namespaceValue = ((AnnotationInstance)entry.getValue()).value("namespace");
            ExtensionMethodGenerator.validate((MethodInfo)method, (String)(namespaceValue != null ? namespaceValue.asString() : null));
            this.produceExtensionMethod(index, extensionMethods, method, (AnnotationInstance)entry.getValue());
            LOGGER.debugf("Found template extension method %s declared on %s", (Object)method, (Object)method.declaringClass().name());
        }
        boolean skippedMethodLevelAnnotation = false;
        for (Map.Entry entry : classes.entrySet()) {
            ClassInfo clazz = ((AnnotationInstance)entry.getValue()).target().asClass();
            AnnotationValue namespaceValue = ((AnnotationInstance)entry.getValue()).value("namespace");
            String namespace = namespaceValue != null ? namespaceValue.asString() : null;
            ArrayList<MethodInfo> found = new ArrayList<MethodInfo>();
            for (MethodInfo method : clazz.methods()) {
                if (!Modifier.isStatic(method.flags()) || method.returnType().kind() == Type.Kind.VOID || Modifier.isPrivate(method.flags()) || ValueResolverGenerator.isSynthetic((int)method.flags()) || (namespace == null || namespace.isEmpty()) && method.parameters().isEmpty()) continue;
                if (methods.containsKey(method)) {
                    skippedMethodLevelAnnotation = true;
                    continue;
                }
                found.add(method);
                LOGGER.debugf("Found template extension method %s declared on %s", (Object)method, (Object)method.declaringClass().name());
            }
            if (found.isEmpty() && !skippedMethodLevelAnnotation) {
                throw new IllegalStateException("No template extension methods declared on " + entry.getKey() + "; a template extension method must be static, non-private and must not return void");
            }
            for (MethodInfo method : found) {
                this.produceExtensionMethod(index, extensionMethods, method, (AnnotationInstance)entry.getValue());
            }
        }
    }

    private void produceExtensionMethod(IndexView index, BuildProducer<TemplateExtensionMethodBuildItem> extensionMethods, MethodInfo method, AnnotationInstance extensionAnnotation) {
        String matchName = null;
        AnnotationValue matchNameValue = extensionAnnotation.value("matchName");
        if (matchNameValue != null) {
            matchName = matchNameValue.asString();
        }
        if (matchName == null) {
            matchName = method.name();
        }
        int priority = 5;
        AnnotationValue priorityValue = extensionAnnotation.value("priority");
        if (priorityValue != null) {
            priority = priorityValue.asInt();
        }
        String namespace = "";
        AnnotationValue namespaceValue = extensionAnnotation.value("namespace");
        if (namespaceValue != null) {
            namespace = namespaceValue.asString();
        }
        String matchRegex = null;
        AnnotationValue matchRegexValue = extensionAnnotation.value("matchRegex");
        if (matchRegexValue != null) {
            matchRegex = matchRegexValue.asString();
        }
        extensionMethods.produce((BuildItem)new TemplateExtensionMethodBuildItem(method, matchName, matchRegex, namespace.isEmpty() ? (Type)method.parameters().get(0) : null, priority, namespace));
    }

    private static BeanInfo findBean(Expression expression, IndexView index, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, Map<String, BeanInfo> namedBeans) {
        Expression.Part firstPart = (Expression.Part)expression.getParts().get(0);
        if (firstPart.isVirtualMethod()) {
            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "The inject: namespace must be followed by a bean name", expression.getOrigin()));
            return null;
        }
        String beanName = firstPart.getName();
        BeanInfo bean = namedBeans.get(beanName);
        if (bean != null) {
            return bean;
        }
        incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), beanName, null, expression.getOrigin()));
        return null;
    }

    static boolean defaultFilter(AnnotationTarget target) {
        short flags;
        switch (target.kind()) {
            case METHOD: {
                flags = target.asMethod().flags();
                break;
            }
            case FIELD: {
                flags = target.asField().flags();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return Modifier.isPublic(flags) && !ValueResolverGenerator.isSynthetic((int)flags);
    }

    static boolean staticsFilter(AnnotationTarget target) {
        switch (target.kind()) {
            case METHOD: {
                return Modifier.isStatic(target.asMethod().flags());
            }
            case FIELD: {
                return Modifier.isStatic(target.asField().flags());
            }
        }
        throw new IllegalArgumentException();
    }

    static boolean enumConstantFilter(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.FIELD) {
            return target.asField().isEnumConstant();
        }
        return false;
    }

    static String findTemplatePath(TemplatesAnalysisBuildItem analysis, String id) {
        for (TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis : analysis.getAnalysis()) {
            if (!templateAnalysis.generatedId.equals(id)) continue;
            return templateAnalysis.path;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @BuildStep
    void generateValueResolvers(QuteConfig config, BuildProducer<GeneratedClassBuildItem> generatedClasses, BeanArchiveIndexBuildItem beanArchiveIndex, ApplicationArchivesBuildItem applicationArchivesBuildItem, List<TemplatePathBuildItem> templatePaths, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<ImplicitValueResolverBuildItem> implicitClasses, TemplatesAnalysisBuildItem templatesAnalysis, List<PanacheEntityClassesBuildItem> panacheEntityClasses, List<TemplateDataBuildItem> templateData, List<TemplateGlobalBuildItem> templateGlobals, BuildProducer<GeneratedValueResolverBuildItem> generatedResolvers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<GeneratedTemplateInitializerBuildItem> generatedInitializers) {
        IndexView index = beanArchiveIndex.getIndex();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, (Function)new Function<String, String>(){

            @Override
            public String apply(String name) {
                String className;
                int idx = name.lastIndexOf("_Namespace_Extension_ValueResolver");
                if (idx == -1) {
                    idx = name.lastIndexOf("_Extension_ValueResolver");
                }
                if (idx == -1) {
                    idx = name.lastIndexOf("_Namespace_ValueResolver");
                }
                if (idx == -1) {
                    idx = name.lastIndexOf("_ValueResolver");
                }
                if (idx == -1) {
                    idx = name.lastIndexOf("_Globals");
                }
                if ((className = name.substring(0, idx)).contains("$_")) {
                    className = className.replace("$_", "$");
                }
                return className;
            }
        });
        ValueResolverGenerator.Builder builder = ValueResolverGenerator.builder().setIndex(index).setClassOutput((ClassOutput)classOutput);
        if (!panacheEntityClasses.isEmpty()) {
            final HashSet entityClasses = new HashSet();
            for (PanacheEntityClassesBuildItem panacheEntityClassesBuildItem : panacheEntityClasses) {
                entityClasses.addAll(panacheEntityClassesBuildItem.getEntityClasses());
            }
            builder.setForceGettersFunction((Function)new Function<ClassInfo, Function<FieldInfo, String>>(){

                @Override
                public Function<FieldInfo, String> apply(ClassInfo clazz) {
                    if (entityClasses.contains(clazz.name().toString())) {
                        return GETTER_FUN;
                    }
                    return null;
                }
            });
        }
        HashSet<DotName> controlled = new HashSet<DotName>();
        HashMap<DotName, AnnotationInstance> uncontrolled = new HashMap<DotName, AnnotationInstance>();
        for (TemplateDataBuildItem data : templateData) {
            this.processsTemplateData(data, controlled, uncontrolled, builder);
        }
        for (ImplicitValueResolverBuildItem implicit : implicitClasses) {
            DotName implicitClassName = implicit.getClazz().name();
            if (controlled.contains(implicitClassName)) {
                LOGGER.debugf("Implicit value resolver for %s ignored: class is annotated with @TemplateData", (Object)implicitClassName);
                continue;
            }
            if (uncontrolled.containsKey(implicitClassName)) {
                LOGGER.debugf("Implicit value resolver for %d ignored: %s declared on %s", uncontrolled.get(implicitClassName), (Object)((AnnotationInstance)uncontrolled.get(implicitClassName)).target());
                continue;
            }
            builder.addClass(implicit.getClazz(), implicit.getTemplateData());
        }
        ValueResolverGenerator valueResolverGenerator = builder.build();
        valueResolverGenerator.generate();
        HashSet generatedValueResolvers = new HashSet();
        generatedValueResolvers.addAll(valueResolverGenerator.getGeneratedTypes());
        ExtensionMethodGenerator extensionMethodGenerator = new ExtensionMethodGenerator(index, (ClassOutput)classOutput);
        HashMap classToNamespaceExtensions = new HashMap();
        HashMap<String, DotName> namespaceToClass = new HashMap<String, DotName>();
        for (TemplateExtensionMethodBuildItem templateExtensionMethodBuildItem : templateExtensionMethods) {
            if (templateExtensionMethodBuildItem.hasNamespace()) {
                void var29_37;
                ArrayList<TemplateExtensionMethodBuildItem> namespaceMethods;
                DotName declaringClassName = templateExtensionMethodBuildItem.getMethod().declaringClass().name();
                DotName namespaceClassName = (DotName)namespaceToClass.get(templateExtensionMethodBuildItem.getNamespace());
                if (namespaceClassName == null) {
                    namespaceToClass.put(templateExtensionMethodBuildItem.getNamespace(), namespaceClassName);
                } else if (!namespaceClassName.equals((Object)declaringClassName)) {
                    throw new IllegalStateException("Template extension methods that share the namespace " + templateExtensionMethodBuildItem.getNamespace() + " must be declared on the same class; but declared on " + namespaceClassName + " and " + declaringClassName);
                }
                Map map = (Map)classToNamespaceExtensions.get(declaringClassName);
                if (map == null) {
                    HashMap hashMap = new HashMap();
                    classToNamespaceExtensions.put(declaringClassName, hashMap);
                }
                if ((namespaceMethods = (ArrayList<TemplateExtensionMethodBuildItem>)var29_37.get(templateExtensionMethodBuildItem.getNamespace())) == null) {
                    namespaceMethods = new ArrayList<TemplateExtensionMethodBuildItem>();
                    var29_37.put(templateExtensionMethodBuildItem.getNamespace(), namespaceMethods);
                }
                namespaceMethods.add(templateExtensionMethodBuildItem);
                continue;
            }
            extensionMethodGenerator.generate(templateExtensionMethodBuildItem.getMethod(), templateExtensionMethodBuildItem.getMatchName(), templateExtensionMethodBuildItem.getMatchRegex(), Integer.valueOf(templateExtensionMethodBuildItem.getPriority()));
        }
        for (Map.Entry entry : classToNamespaceExtensions.entrySet()) {
            Map namespaceToMethods = (Map)entry.getValue();
            for (Map.Entry entry2 : namespaceToMethods.entrySet()) {
                Map<Integer, List<TemplateExtensionMethodBuildItem>> priorityToMethods = ((List)entry2.getValue()).stream().collect(Collectors.groupingBy(TemplateExtensionMethodBuildItem::getPriority));
                for (Map.Entry<Integer, List<TemplateExtensionMethodBuildItem>> priorityEntry : priorityToMethods.entrySet()) {
                    ExtensionMethodGenerator.NamespaceResolverCreator namespaceResolverCreator = extensionMethodGenerator.createNamespaceResolver(priorityEntry.getValue().get(0).getMethod().declaringClass(), (String)entry2.getKey(), priorityEntry.getKey().intValue());
                    try {
                        ExtensionMethodGenerator.NamespaceResolverCreator.ResolveCreator resolveCreator = namespaceResolverCreator.implementResolve();
                        try {
                            for (TemplateExtensionMethodBuildItem method : priorityEntry.getValue()) {
                                resolveCreator.addMethod(method.getMethod(), method.getMatchName(), method.getMatchRegex());
                            }
                        }
                        finally {
                            if (resolveCreator == null) continue;
                            resolveCreator.close();
                        }
                    }
                    finally {
                        if (namespaceResolverCreator == null) continue;
                        namespaceResolverCreator.close();
                    }
                }
            }
        }
        generatedValueResolvers.addAll(extensionMethodGenerator.getGeneratedTypes());
        LOGGER.debugf("Generated value resolvers: %s", generatedValueResolvers);
        for (String string : generatedValueResolvers) {
            generatedResolvers.produce((BuildItem)new GeneratedValueResolverBuildItem(string));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{string}));
        }
        if (!templateGlobals.isEmpty()) {
            TemplateGlobalGenerator globalGenerator = new TemplateGlobalGenerator((ClassOutput)classOutput);
            HashMap<DotName, Map<String, AnnotationTarget>> hashMap = new HashMap<DotName, Map<String, AnnotationTarget>>();
            Map<DotName, List<TemplateGlobalBuildItem>> classToGlobals = templateGlobals.stream().collect(Collectors.groupingBy(TemplateGlobalBuildItem::getDeclaringClass));
            for (Map.Entry<Object, Object> entry : classToGlobals.entrySet()) {
                hashMap.put((DotName)entry.getKey(), ((List)entry.getValue()).stream().collect(Collectors.toMap(TemplateGlobalBuildItem::getName, TemplateGlobalBuildItem::getTarget)));
            }
            for (Map.Entry<Object, Object> entry : hashMap.entrySet()) {
                globalGenerator.generate(index.getClassByName((DotName)entry.getKey()), (Map)entry.getValue());
            }
            for (String string : globalGenerator.getGeneratedTypes()) {
                generatedInitializers.produce((BuildItem)new GeneratedTemplateInitializerBuildItem(string));
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{string}));
            }
        }
    }

    @BuildStep
    void collectTemplates(ApplicationArchivesBuildItem applicationArchives, CurateOutcomeBuildItem curateOutcome, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, QuteConfig config) throws IOException {
        HashSet basePaths = new HashSet();
        Set allApplicationArchives = applicationArchives.getAllApplicationArchives();
        List extensionArtifacts = curateOutcome.getApplicationModel().getDependencies().stream().filter(Dependency::isRuntimeExtensionArtifact).collect(Collectors.toList());
        block12: for (ResolvedDependency artifact : extensionArtifacts) {
            if (this.isApplicationArchive(artifact, allApplicationArchives)) continue;
            for (Path path : artifact.getResolvedPaths()) {
                Path basePath;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Stream<Path> paths = Files.list(path);
                    try {
                        basePath = paths.filter(QuteProcessor::isBasePath).findFirst().orElse(null);
                        if (basePath == null) continue;
                        LOGGER.debugf("Found extension templates dir: %s", (Object)path);
                        this.scan(basePath, basePath, "templates/", watchedPaths, templatePaths, nativeImageResources, config);
                        continue block12;
                    }
                    finally {
                        if (paths != null) {
                            paths.close();
                        }
                        continue block12;
                    }
                }
                try {
                    FileSystem artifactFs = ZipUtils.newFileSystem((Path)path);
                    try {
                        basePath = artifactFs.getPath(BASE_PATH, new String[0]);
                        if (!Files.exists(basePath, new LinkOption[0])) continue;
                        LOGGER.debugf("Found extension templates in: %s", (Object)path);
                        this.scan(basePath, basePath, "templates/", watchedPaths, templatePaths, nativeImageResources, config);
                    }
                    finally {
                        if (artifactFs == null) continue;
                        artifactFs.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warnf((Throwable)e, "Unable to create the file system from the path: %s", (Object)path);
                }
            }
        }
        for (ApplicationArchive archive : allApplicationArchives) {
            archive.accept(tree -> {
                for (Path rootDir : tree.getRoots()) {
                    try {
                        Stream<Path> rootDirPaths = Files.list(rootDir);
                        try {
                            Path basePath = rootDirPaths.filter(QuteProcessor::isBasePath).findFirst().orElse(null);
                            if (basePath == null) continue;
                            LOGGER.debugf("Found templates dir: %s", (Object)basePath);
                            basePaths.add(basePath);
                            this.scan(basePath, basePath, "templates/", watchedPaths, templatePaths, nativeImageResources, config);
                            break;
                        }
                        finally {
                            if (rootDirPaths == null) continue;
                            rootDirPaths.close();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
    }

    @BuildStep
    TemplateFilePathsBuildItem collectTemplateFilePaths(QuteConfig config, List<TemplatePathBuildItem> templatePaths) {
        HashSet<String> filePaths = new HashSet<String>();
        for (TemplatePathBuildItem templatePath : templatePaths) {
            String path = templatePath.getPath();
            filePaths.add(path);
            for (String suffix : config.suffixes) {
                if (!path.endsWith(suffix)) continue;
                filePaths.add(path.substring(0, path.length() - (suffix.length() + 1)));
            }
        }
        return new TemplateFilePathsBuildItem(filePaths);
    }

    @BuildStep
    void validateTemplateInjectionPoints(TemplateFilePathsBuildItem filePaths, List<TemplatePathBuildItem> templatePaths, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        for (InjectionPointInfo injectionPoint : validationPhase.getContext().getInjectionPoints()) {
            AnnotationInstance location;
            String name;
            if (!injectionPoint.getRequiredType().name().equals((Object)Names.TEMPLATE) || (name = (location = injectionPoint.getRequiredQualifier(Names.LOCATION)) != null ? location.value().asString() : (injectionPoint.hasDefaultedQualifier() ? QuteProcessor.getName(injectionPoint) : null)) == null || filePaths.contains(name)) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new TemplateException(String.format("No template found for path [%s] defined at %s\n\t- available templates: %s", name, injectionPoint.getTargetInfo(), templatePaths.stream().map(TemplatePathBuildItem::getPath).collect(Collectors.toList())))}));
        }
    }

    @BuildStep
    TemplateVariantsBuildItem collectTemplateVariants(List<TemplatePathBuildItem> templatePaths) throws IOException {
        Set allPaths = templatePaths.stream().map(TemplatePathBuildItem::getPath).collect(Collectors.toSet());
        HashMap<String, List<String>> baseToVariants = new HashMap<String, List<String>>();
        for (String path : allPaths) {
            int idx = path.indexOf(46);
            if (idx == -1) continue;
            String base = path.substring(0, idx);
            ArrayList<String> variants = (ArrayList<String>)baseToVariants.get(base);
            if (variants == null) {
                variants = new ArrayList<String>();
                baseToVariants.put(base, variants);
            }
            variants.add(path);
        }
        LOGGER.debugf("Template variants found: %s", baseToVariants);
        return new TemplateVariantsBuildItem(baseToVariants);
    }

    @BuildStep
    void excludeTypeChecks(QuteConfig config, BuildProducer<TypeCheckExcludeBuildItem> excludes) {
        final List<String> skipOperators = Arrays.asList("?:", "or", ":", "?", "ifTruthy", "&&", "||");
        excludes.produce((BuildItem)new TypeCheckExcludeBuildItem(new Predicate<TypeCheckExcludeBuildItem.TypeCheck>(){

            @Override
            public boolean test(TypeCheckExcludeBuildItem.TypeCheck check) {
                if (check.isProperty() && ("raw".equals(check.name) || "safe".equals(check.name) || "orEmpty".equals(check.name))) {
                    return true;
                }
                if (check.numberOfParameters == 1 && skipOperators.contains(check.name)) {
                    return true;
                }
                return check.numberOfParameters == 1 && check.classNameEquals(Names.COLLECTION) && check.name.equals("contains");
            }
        }));
        if (config.typeCheckExcludes.isPresent()) {
            for (String exclude : (List)config.typeCheckExcludes.get()) {
                String[] parts = exclude.split("\\.");
                if (parts.length < 2) continue;
                final String className = Arrays.stream(parts).limit(parts.length - 1).collect(Collectors.joining("."));
                final String propertyName = parts[parts.length - 1];
                excludes.produce((BuildItem)new TypeCheckExcludeBuildItem(new Predicate<TypeCheckExcludeBuildItem.TypeCheck>(){

                    @Override
                    public boolean test(TypeCheckExcludeBuildItem.TypeCheck check) {
                        if (!className.equals("*") && !check.clazz.name().toString().equals(className)) {
                            return false;
                        }
                        return propertyName.equals("*") || check.name.equals(propertyName);
                    }
                }));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initialize(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, QuteRecorder recorder, List<GeneratedValueResolverBuildItem> generatedValueResolvers, List<TemplatePathBuildItem> templatePaths, Optional<TemplateVariantsBuildItem> templateVariants, List<GeneratedTemplateInitializerBuildItem> templateInitializers) {
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        for (TemplatePathBuildItem templatePath : templatePaths) {
            if (templatePath.isTag()) {
                String tagPath = templatePath.getPath();
                tags.add(tagPath.substring("tags/".length(), tagPath.length()));
                continue;
            }
            templates.add(templatePath.getPath());
        }
        Map<Object, Object> variants = templateVariants.isPresent() ? templateVariants.get().getVariants() : Collections.emptyMap();
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(QuteRecorder.QuteContext.class).supplier(recorder.createContext(generatedValueResolvers.stream().map(GeneratedValueResolverBuildItem::getClassName).collect(Collectors.toList()), templates, tags, variants, templateInitializers.stream().map(GeneratedTemplateInitializerBuildItem::getClassName).collect(Collectors.toList()))).done());
    }

    @BuildStep
    QualifierRegistrarBuildItem turnLocationIntoQualifier() {
        return new QualifierRegistrarBuildItem(new QualifierRegistrar(){

            public Map<DotName, Set<String>> getAdditionalQualifiers() {
                return Collections.singletonMap(Names.LOCATION, Collections.singleton("value"));
            }
        });
    }

    private static Type resolveType(AnnotationTarget member, Match match, IndexView index, TemplateExtensionMethodBuildItem extensionMethod) {
        Type matchType;
        if (member.kind() == AnnotationTarget.Kind.FIELD) {
            matchType = member.asField().type();
        } else if (member.kind() == AnnotationTarget.Kind.METHOD) {
            matchType = member.asMethod().returnType();
        } else {
            throw new IllegalStateException("Unsupported member type: " + member);
        }
        if (Types.containsTypeVariable(matchType)) {
            Object typeParameters;
            Set<Type> closure = Types.getTypeClosure(match.clazz, Types.buildResolvedMap(match.getParameterizedTypeArguments(), match.getTypeParameters(), new HashMap<TypeVariable, Type>(), index), index);
            DotName declaringClassName = null;
            Type extensionMatchBase = null;
            if (member.kind() == AnnotationTarget.Kind.METHOD) {
                MethodInfo method = member.asMethod();
                typeParameters = method.typeParameters();
                if (extensionMethod != null && !extensionMethod.hasNamespace() && !typeParameters.isEmpty()) {
                    List params = method.parameters();
                    Set attributeAnnotations = Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD_PARAMETER, (DotName)ExtensionMethodGenerator.TEMPLATE_ATTRIBUTE, (Collection)method.annotations());
                    if (attributeAnnotations.isEmpty()) {
                        extensionMatchBase = (Type)params.get(0);
                    } else {
                        int i = 0;
                        while (i < params.size()) {
                            int position = i++;
                            if (!attributeAnnotations.stream().noneMatch(a -> a.target().asMethodParameter().position() == position)) continue;
                            extensionMatchBase = (Type)params.get(i);
                            break;
                        }
                    }
                    if (extensionMatchBase != null && Types.containsTypeVariable(extensionMatchBase)) {
                        declaringClassName = extensionMatchBase.name();
                    }
                } else {
                    declaringClassName = method.declaringClass().name();
                }
            } else if (member.kind() == AnnotationTarget.Kind.FIELD) {
                declaringClassName = member.asField().declaringClass().name();
            }
            Type declaringType = null;
            if (declaringClassName != null) {
                for (Type type : closure) {
                    if (!type.name().equals((Object)declaringClassName)) continue;
                    declaringType = type;
                    break;
                }
            }
            if (declaringType != null && declaringType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                typeParameters = extensionMatchBase != null ? extensionMethod.getMethod().typeParameters() : index.getClassByName(declaringType.name()).typeParameters();
                matchType = Types.resolveTypeParam(matchType, Types.buildResolvedMap(declaringType.asParameterizedType().arguments(), (List<TypeVariable>)typeParameters, Collections.emptyMap(), index), index);
            }
        }
        return matchType;
    }

    static boolean processHints(TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, List<String> helperHints, Match match, IndexView index, Expression expression, Map<Integer, Match> generatedIdsToMatches, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions) {
        if (helperHints == null || helperHints.isEmpty()) {
            return false;
        }
        for (String helperHint : helperHints) {
            if (helperHint.equals("<loop-element>")) {
                QuteProcessor.processLoopElementHint(match, index, expression, incorrectExpressions);
                continue;
            }
            if (helperHint.startsWith("<loop#")) {
                QuteProcessor.setMatchValues(match, QuteProcessor.findExpression(helperHint, "<loop#", templateAnalysis), generatedIdsToMatches, index);
                continue;
            }
            if (helperHint.startsWith("<when#")) {
                Match valueExprMatch;
                Expression valueExpr = QuteProcessor.findExpression(helperHint, "<when#", templateAnalysis);
                if (valueExpr == null || (valueExprMatch = generatedIdsToMatches.get(valueExpr.getGeneratedId())) == null || !valueExprMatch.clazz.isEnum()) continue;
                match.setValues(valueExprMatch.clazz, valueExprMatch.type);
                return true;
            }
            if (!helperHint.startsWith("<set#")) continue;
            QuteProcessor.setMatchValues(match, QuteProcessor.findExpression(helperHint, "<set#", templateAnalysis), generatedIdsToMatches, index);
        }
        return false;
    }

    private static void setMatchValues(Match match, Expression valueExpr, Map<Integer, Match> generatedIdsToMatches, IndexView index) {
        if (valueExpr != null) {
            if (valueExpr.isLiteral()) {
                Object literalValue = valueExpr.getLiteral();
                if (literalValue == null) {
                    match.clearValues();
                } else if (literalValue instanceof Boolean) {
                    match.setValues(index.getClassByName(DotNames.BOOLEAN), Types.box(PrimitiveType.Primitive.BOOLEAN));
                } else if (literalValue instanceof String) {
                    match.setValues(index.getClassByName(DotNames.STRING), Type.create((DotName)DotNames.STRING, (Type.Kind)Type.Kind.CLASS));
                } else if (literalValue instanceof Integer) {
                    match.setValues(index.getClassByName(DotNames.INTEGER), Types.box(PrimitiveType.Primitive.INT));
                } else if (literalValue instanceof Long) {
                    match.setValues(index.getClassByName(DotNames.LONG), Types.box(PrimitiveType.Primitive.LONG));
                } else if (literalValue instanceof Double) {
                    match.setValues(index.getClassByName(DotNames.DOUBLE), Types.box(PrimitiveType.Primitive.DOUBLE));
                } else if (literalValue instanceof Float) {
                    match.setValues(index.getClassByName(DotNames.FLOAT), Types.box(PrimitiveType.Primitive.FLOAT));
                }
            } else {
                Match valueExprMatch = generatedIdsToMatches.get(valueExpr.getGeneratedId());
                if (valueExprMatch != null) {
                    match.setValues(valueExprMatch.clazz, valueExprMatch.type);
                }
            }
        }
    }

    private static Expression findExpression(String helperHint, String hintPrefix, TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis) {
        return templateAnalysis.findExpression(Integer.parseInt(helperHint.substring(hintPrefix.length(), helperHint.length() - 1)));
    }

    static void processLoopElementHint(Match match, IndexView index, Expression expression, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions) {
        if (match.isEmpty() || match.type().name().equals((Object)DotNames.INTEGER) || match.type().equals((Object)PrimitiveType.INT)) {
            return;
        }
        Type matchType = null;
        if (match.isArray()) {
            matchType = match.type().asArrayType().component();
        } else if (match.isClass() || match.isParameterizedType()) {
            Function<Type, Type> firstParamType;
            Set<Type> closure = Types.getTypeClosure(match.clazz, Types.buildResolvedMap(match.getParameterizedTypeArguments(), match.getTypeParameters(), new HashMap<TypeVariable, Type>(), index), index);
            matchType = QuteProcessor.extractMatchType(closure, Names.ITERABLE, firstParamType = t -> (Type)t.asParameterizedType().arguments().get(0));
            if (matchType == null) {
                matchType = QuteProcessor.extractMatchType(closure, Names.STREAM, firstParamType);
            }
            if (matchType == null) {
                matchType = QuteProcessor.extractMatchType(closure, Names.MAP, t -> {
                    Type[] args = new Type[]{(Type)t.asParameterizedType().arguments().get(0), (Type)t.asParameterizedType().arguments().get(1)};
                    return ParameterizedType.create((DotName)Names.MAP_ENTRY, (Type[])args, null);
                });
            }
            if (matchType == null) {
                matchType = QuteProcessor.extractMatchType(closure, Names.ITERATOR, firstParamType);
            }
        }
        if (matchType != null) {
            match.setValues(index.getClassByName(matchType.name()), matchType);
        } else {
            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "Unsupported iterable type found: " + match.type, expression.getOrigin()));
            match.clearValues();
        }
    }

    static Type extractMatchType(Set<Type> closure, DotName matchName, Function<Type, Type> extractFun) {
        Type type = closure.stream().filter(t -> t.name().equals((Object)matchName)).findFirst().orElse(null);
        return type != null ? extractFun.apply(type) : null;
    }

    private static TemplateExtensionMethodBuildItem findTemplateExtensionMethod(TypeInfos.Info info, Type matchType, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, Expression expression, IndexView index, Function<String, String> templateIdToPathFun, Map<String, Match> results) {
        if (!info.isProperty() && !info.isVirtualMethod()) {
            return null;
        }
        String name = info.isProperty() ? info.asProperty().name : info.asVirtualMethod().name;
        for (TemplateExtensionMethodBuildItem extensionMethod : templateExtensionMethods) {
            List evaluatedParams;
            if (matchType != null && !Types.isAssignableFrom(extensionMethod.getMatchType(), matchType, index) || !extensionMethod.matchesName(name) || (evaluatedParams = extensionMethod.getParams().evaluated()).size() > 0 && !info.isVirtualMethod()) continue;
            if (info.isVirtualMethod()) {
                Expression.VirtualMethodPart virtualMethod = info.part.asVirtualMethod();
                boolean isVarArgs = ValueResolverGenerator.isVarArgs((MethodInfo)extensionMethod.getMethod());
                int lastParamIdx = evaluatedParams.size() - 1;
                if (isVarArgs ? evaluatedParams.size() - 1 > virtualMethod.getParameters().size() : virtualMethod.getParameters().size() != evaluatedParams.size()) continue;
                boolean matches = true;
                int idx = 0;
                for (Expression param : virtualMethod.getParameters()) {
                    Match result = results.get(param.toOriginalString());
                    if (result != null && !result.isEmpty()) {
                        Type paramType = isVarArgs && idx >= lastParamIdx ? ((ExtensionMethodGenerator.Param)evaluatedParams.get((int)lastParamIdx)).type.asArrayType().component() : ((ExtensionMethodGenerator.Param)evaluatedParams.get((int)idx)).type;
                        if (!Types.isAssignableFrom(paramType, result.type, index)) {
                            matches = false;
                            break;
                        }
                    } else {
                        LOGGER.debugf("Type info not available - skip validation for parameter [%s] of extension method [%s] for expression [%s] in template [%s] on line %s", new Object[]{extensionMethod.getMethod().parameterName(idx), extensionMethod.getMethod().declaringClass().name() + "#" + extensionMethod.getMethod(), expression.toOriginalString(), templateIdToPathFun.apply(expression.getOrigin().getTemplateId()), expression.getOrigin().getLine()});
                    }
                    ++idx;
                }
                if (!matches) continue;
            }
            return extensionMethod;
        }
        return null;
    }

    private static AnnotationTarget findProperty(String name, ClassInfo clazz, LookupConfig config) {
        HashSet<DotName> interfaceNames;
        HashSet<DotName> hashSet = interfaceNames = config.declaredMembersOnly() ? null : new HashSet<DotName>();
        while (clazz != null) {
            if (interfaceNames != null) {
                QuteProcessor.addInterfaces(clazz, config.index(), interfaceNames);
            }
            for (FieldInfo field : clazz.fields()) {
                if (!config.filter().test((AnnotationTarget)field) || !field.name().equals(name)) continue;
                return field;
            }
            for (MethodInfo method : clazz.methods()) {
                if (method.returnType().kind() == Type.Kind.VOID || !config.filter().test((AnnotationTarget)method) || !method.name().equals(name) && !ValueResolverGenerator.getPropertyName((String)method.name()).equals(name)) continue;
                return method;
            }
            DotName superName = clazz.superName();
            if (config.declaredMembersOnly() || superName == null) {
                clazz = null;
                continue;
            }
            clazz = config.index().getClassByName(clazz.superName());
        }
        if (interfaceNames != null) {
            for (DotName interfaceName : interfaceNames) {
                ClassInfo interfaceClassInfo = config.index().getClassByName(interfaceName);
                if (interfaceClassInfo == null) continue;
                for (MethodInfo method : interfaceClassInfo.methods()) {
                    if (!config.filter().test((AnnotationTarget)method) || !method.name().equals(name) && !ValueResolverGenerator.getPropertyName((String)method.name()).equals(name)) continue;
                    return method;
                }
            }
        }
        return null;
    }

    private static void addInterfaces(ClassInfo clazz, IndexView index, Set<DotName> interfaceNames) {
        if (clazz == null) {
            return;
        }
        List names = clazz.interfaceNames();
        if (!names.isEmpty()) {
            interfaceNames.addAll(names);
            for (DotName name : names) {
                QuteProcessor.addInterfaces(index.getClassByName(name), index, interfaceNames);
            }
        }
    }

    private static AnnotationTarget findMethod(Expression.VirtualMethodPart virtualMethod, ClassInfo clazz, Expression expression, IndexView index, Function<String, String> templateIdToPathFun, Map<String, Match> results, LookupConfig config) {
        HashSet<DotName> interfaceNames;
        HashSet<DotName> hashSet = interfaceNames = config.declaredMembersOnly() ? null : new HashSet<DotName>();
        while (clazz != null) {
            if (interfaceNames != null) {
                QuteProcessor.addInterfaces(clazz, index, interfaceNames);
            }
            for (MethodInfo method : clazz.methods()) {
                if (!config.filter().test((AnnotationTarget)method) || !QuteProcessor.methodMatches(method, virtualMethod, expression, index, templateIdToPathFun, results)) continue;
                return method;
            }
            DotName superName = clazz.superName();
            if (config.declaredMembersOnly() || superName == null || DotNames.OBJECT.equals((Object)superName)) {
                clazz = null;
                continue;
            }
            clazz = index.getClassByName(clazz.superName());
        }
        if (interfaceNames != null) {
            for (DotName interfaceName : interfaceNames) {
                ClassInfo interfaceClassInfo = index.getClassByName(interfaceName);
                if (interfaceClassInfo == null) continue;
                for (MethodInfo method : interfaceClassInfo.methods()) {
                    if (!config.filter().test((AnnotationTarget)method) || !QuteProcessor.methodMatches(method, virtualMethod, expression, index, templateIdToPathFun, results)) continue;
                    return method;
                }
            }
        }
        return null;
    }

    private static boolean methodMatches(MethodInfo method, Expression.VirtualMethodPart virtualMethod, Expression expression, IndexView index, Function<String, String> templateIdToPathFun, Map<String, Match> results) {
        if (!method.name().equals(virtualMethod.getName())) {
            return false;
        }
        boolean isVarArgs = ValueResolverGenerator.isVarArgs((MethodInfo)method);
        List parameters = method.parameters();
        int lastParamIdx = parameters.size() - 1;
        if (isVarArgs ? lastParamIdx > virtualMethod.getParameters().size() : virtualMethod.getParameters().size() != parameters.size()) {
            return false;
        }
        boolean matches = true;
        int idx = 0;
        for (Expression param : virtualMethod.getParameters()) {
            Match result = results.get(param.toOriginalString());
            if (result != null && !result.isEmpty()) {
                Type paramType = isVarArgs && idx >= lastParamIdx ? ((Type)parameters.get(lastParamIdx)).asArrayType().component() : (Type)parameters.get(idx);
                if (!Types.isAssignableFrom(paramType, result.type, index)) {
                    matches = false;
                    break;
                }
            } else {
                LOGGER.debugf("Type info not available - skip validation for parameter [%s] of method [%s] for expression [%s] in template [%s] on line %s", new Object[]{method.parameterName(idx), method.declaringClass().name() + "#" + method, expression.toOriginalString(), templateIdToPathFun.apply(expression.getOrigin().getTemplateId()), expression.getOrigin().getLine()});
            }
            idx = (byte)(idx + 1);
        }
        return matches;
    }

    private void processsTemplateData(TemplateDataBuildItem templateData, Set<DotName> controlled, Map<DotName, AnnotationInstance> uncontrolled, ValueResolverGenerator.Builder builder) {
        if (templateData.isTargetAnnotatedType()) {
            controlled.add(templateData.getTargetClass().name());
            builder.addClass(templateData.getTargetClass(), templateData.getAnnotationInstance());
        } else {
            uncontrolled.computeIfAbsent(templateData.getTargetClass().name(), name -> {
                builder.addClass(templateData.getTargetClass(), templateData.getAnnotationInstance());
                return templateData.getAnnotationInstance();
            });
        }
    }

    @BuildStep
    void collectTemplateGlobals(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<TemplateGlobalBuildItem> globals) {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<String, TemplateGlobalBuildItem> nameToGlobal = new HashMap<String, TemplateGlobalBuildItem>();
        block5: for (AnnotationInstance annotation : index.getAnnotations(TemplateGlobalGenerator.TEMPLATE_GLOBAL)) {
            switch (annotation.target().kind()) {
                case CLASS: {
                    this.addGlobalClass(annotation.target().asClass(), nameToGlobal);
                    continue block5;
                }
                case FIELD: {
                    this.addGlobalField(annotation.value("name"), annotation.target().asField(), nameToGlobal);
                    continue block5;
                }
                case METHOD: {
                    this.addGlobalMethod(annotation.value("name"), annotation.target().asMethod(), nameToGlobal);
                    continue block5;
                }
            }
            throw new TemplateException("Invalid annotation target for @TemplateGlobal: " + annotation);
        }
        nameToGlobal.values().forEach(arg_0 -> globals.produce(arg_0));
    }

    private void addGlobalClass(ClassInfo clazz, Map<String, TemplateGlobalBuildItem> nameToGlobal) {
        for (FieldInfo field : clazz.fields()) {
            if (!Modifier.isStatic(field.flags()) || Modifier.isPrivate(field.flags()) || field.isSynthetic() || field.hasAnnotation(TemplateGlobalGenerator.TEMPLATE_GLOBAL)) continue;
            this.addGlobalField(null, field, nameToGlobal);
        }
        for (MethodInfo method : clazz.methods()) {
            if (!Modifier.isStatic(method.flags()) || Modifier.isPrivate(method.flags()) || method.returnType().kind() == Type.Kind.VOID || method.isSynthetic() || method.hasAnnotation(TemplateGlobalGenerator.TEMPLATE_GLOBAL)) continue;
            this.addGlobalMethod(null, method, nameToGlobal);
        }
    }

    private void addGlobalMethod(AnnotationValue nameValue, MethodInfo method, Map<String, TemplateGlobalBuildItem> nameToGlobal) {
        TemplateGlobalGenerator.validate((MethodInfo)method);
        String name = "<<element name>>";
        if (nameValue != null) {
            name = nameValue.asString();
        }
        if (name.equals("<<element name>>")) {
            name = method.name();
        }
        TemplateGlobalBuildItem global = new TemplateGlobalBuildItem(name, (AnnotationTarget)method, method.returnType());
        this.addGlobalVariable(global, nameToGlobal);
    }

    private void addGlobalField(AnnotationValue nameValue, FieldInfo field, Map<String, TemplateGlobalBuildItem> nameToGlobal) {
        TemplateGlobalGenerator.validate((FieldInfo)field);
        String name = "<<element name>>";
        if (nameValue != null) {
            name = nameValue.asString();
        }
        if (name.equals("<<element name>>")) {
            name = field.name();
        }
        TemplateGlobalBuildItem global = new TemplateGlobalBuildItem(name, (AnnotationTarget)field, field.type());
        this.addGlobalVariable(global, nameToGlobal);
    }

    private void addGlobalVariable(TemplateGlobalBuildItem global, Map<String, TemplateGlobalBuildItem> nameToGlobal) {
        TemplateGlobalBuildItem prev = nameToGlobal.put(global.getName(), global);
        if (prev != null) {
            throw new TemplateException(String.format("Duplicate global variable defined via @TemplateGlobal for the name [%s]:\n\t- %s\n\t- %s", new Object[]{global.getName(), global, prev}));
        }
    }

    @BuildStep
    void collectTemplateDataAnnotations(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<TemplateDataBuildItem> templateDataAnnotations) {
        IndexView index = beanArchiveIndex.getIndex();
        HashSet<AnnotationInstance> annotationInstances = new HashSet<AnnotationInstance>();
        annotationInstances.addAll(index.getAnnotations(ValueResolverGenerator.TEMPLATE_DATA));
        for (AnnotationInstance containingInstance : index.getAnnotations(ValueResolverGenerator.TEMPLATE_DATA_CONTAINER)) {
            for (AnnotationInstance nestedInstance : containingInstance.value().asNestedArray()) {
                annotationInstances.add(AnnotationInstance.create((DotName)nestedInstance.name(), (AnnotationTarget)containingInstance.target(), (List)nestedInstance.values()));
            }
        }
        HashMap<DotName, AnnotationInstance> uncontrolled = new HashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance templateData : annotationInstances) {
            AnnotationValue targetValue = templateData.value("target");
            ClassInfo targetClass = null;
            targetClass = targetValue == null || targetValue.asClass().name().equals((Object)ValueResolverGenerator.TEMPLATE_DATA) ? templateData.target().asClass() : index.getClassByName(targetValue.asClass().name());
            if (targetClass == null) {
                LOGGER.warnf("@TemplateData declared on %s is ignored: target %s it is not available in the index", (Object)templateData.target(), (Object)targetClass);
                continue;
            }
            uncontrolled.compute(targetClass.name(), (c, v) -> {
                if (v == null) {
                    return templateData;
                }
                if (!(Objects.equals(v.value("ignore"), templateData.value("ignore")) && Objects.equals(v.value("properties"), templateData.value("properties")) && Objects.equals(v.value("ignoreSuperclasses"), templateData.value("ignoreSuperclasses")) && Objects.equals(v.value("namespace"), templateData.value("namespace")))) {
                    throw new IllegalStateException("Multiple unequal @TemplateData declared for " + c + ": " + v + " and " + templateData);
                }
                return v;
            });
            templateDataAnnotations.produce((BuildItem)new TemplateDataBuildItem(templateData, targetClass));
        }
        for (AnnotationInstance templateEnum : index.getAnnotations(Names.TEMPLATE_ENUM)) {
            ClassInfo targetEnum = templateEnum.target().asClass();
            if (!targetEnum.isEnum()) {
                LOGGER.warnf("@TemplateEnum declared on %s is ignored: the target of this annotation must be an enum type", (Object)targetEnum);
                continue;
            }
            if (targetEnum.classAnnotation(ValueResolverGenerator.TEMPLATE_DATA) != null) {
                LOGGER.debugf("@TemplateEnum declared on %s is ignored: enum is annotated with @TemplateData", (Object)targetEnum);
                continue;
            }
            AnnotationInstance uncontrolledDeclaration = (AnnotationInstance)uncontrolled.get(targetEnum.name());
            if (uncontrolledDeclaration != null) {
                LOGGER.debugf("@TemplateEnum declared on %s is ignored: %s declared on %s", (Object)targetEnum, (Object)uncontrolledDeclaration, (Object)uncontrolledDeclaration.target());
                continue;
            }
            templateDataAnnotations.produce((BuildItem)new TemplateDataBuildItem(new TemplateDataBuilder().annotationTarget(templateEnum.target()).namespace("<<simplename>>").build(), targetEnum));
        }
    }

    @BuildStep
    void validateTemplateDataNamespaces(List<TemplateDataBuildItem> templateData, BuildProducer<ServiceStartBuildItem> serviceStart) {
        Map<String, List<TemplateDataBuildItem>> namespaceToData = templateData.stream().filter(TemplateDataBuildItem::hasNamespace).collect(Collectors.groupingBy(TemplateDataBuildItem::getNamespace));
        for (Map.Entry<String, List<TemplateDataBuildItem>> e : namespaceToData.entrySet()) {
            if (e.getValue().size() <= 1) continue;
            throw new TemplateException(String.format("The namespace [%s] is defined by multiple @TemplateData and/or @TemplateEnum annotations; make sure the annotation declared on the following classes do not collide:\n\t- %s", e.getKey(), e.getValue().stream().map(TemplateDataBuildItem::getAnnotationInstance).map(AnnotationInstance::target).map(Object::toString).collect(Collectors.joining("\n\t- "))));
        }
    }

    static Map<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>> collectNamespaceExpressions(TemplatesAnalysisBuildItem analysis, String namespace) {
        HashMap<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>> namespaceExpressions = new HashMap<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>>();
        for (TemplatesAnalysisBuildItem.TemplateAnalysis template : analysis.getAnalysis()) {
            HashSet<Expression> expressions = null;
            for (Expression expr : QuteProcessor.collectNamespaceExpressions(template, namespace)) {
                if (expressions == null) {
                    expressions = new HashSet<Expression>();
                }
                expressions.add(expr);
            }
            if (expressions == null) continue;
            namespaceExpressions.put(template, expressions);
        }
        return namespaceExpressions;
    }

    static Set<Expression> collectNamespaceExpressions(TemplatesAnalysisBuildItem.TemplateAnalysis analysis, String namespace) {
        HashSet<Expression> namespaceExpressions = new HashSet<Expression>();
        for (Expression expression : analysis.expressions) {
            QuteProcessor.collectNamespaceExpressions(expression, namespaceExpressions, namespace);
        }
        return namespaceExpressions;
    }

    static void collectNamespaceExpressions(Expression expression, Set<Expression> namespaceExpressions, String namespace) {
        if (expression.isLiteral()) {
            return;
        }
        if (QuteProcessor.includeNamespaceExpression(expression, namespace)) {
            namespaceExpressions.add(expression);
        }
        for (Expression.Part part : expression.getParts()) {
            if (!part.isVirtualMethod()) continue;
            for (Expression param : part.asVirtualMethod().getParameters()) {
                QuteProcessor.collectNamespaceExpressions(param, namespaceExpressions, namespace);
            }
        }
    }

    private static boolean includeNamespaceExpression(Expression expression, String namespace) {
        if (namespace.equals(expression.getNamespace())) {
            return true;
        }
        String typeInfo = ((Expression.Part)expression.getParts().get(0)).getTypeInfo();
        return typeInfo != null ? typeInfo.startsWith(namespace) : false;
    }

    public static String getName(InjectionPointInfo injectionPoint) {
        if (injectionPoint.isField()) {
            return injectionPoint.getTarget().asField().name();
        }
        if (injectionPoint.isParam()) {
            String name = injectionPoint.getTarget().asMethod().parameterName(injectionPoint.getPosition());
            return name == null ? injectionPoint.getTarget().asMethod().name() : name;
        }
        throw new IllegalArgumentException();
    }

    private static void produceTemplateBuildItems(BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, String basePath, String filePath, Path originalPath, QuteConfig config) {
        if (filePath.isEmpty()) {
            return;
        }
        String fullPath = basePath + filePath;
        LOGGER.debugf("Produce template build items [filePath: %s, fullPath: %s, originalPath: %s", (Object)filePath, (Object)fullPath, (Object)originalPath);
        watchedPaths.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(fullPath, true));
        nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fullPath}));
        templatePaths.produce((BuildItem)new TemplatePathBuildItem(filePath, originalPath, QuteProcessor.readTemplateContent(originalPath, config.defaultCharset)));
    }

    private void scan(Path root, Path directory, String basePath, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, QuteConfig config) throws IOException {
        try (Stream<Path> files = Files.list(directory);){
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                Path filePath = (Path)iter.next();
                if (Files.isRegularFile(filePath, new LinkOption[0])) {
                    LOGGER.debugf("Found template: %s", (Object)filePath);
                    String templatePath = root.relativize(filePath).toString();
                    if (File.separatorChar != '/') {
                        templatePath = templatePath.replace(File.separatorChar, '/');
                    }
                    if (config.templatePathExclude.matcher(templatePath).matches()) {
                        LOGGER.debugf("Template file exluded: %s", (Object)filePath);
                        continue;
                    }
                    QuteProcessor.produceTemplateBuildItems(templatePaths, watchedPaths, nativeImageResources, basePath, templatePath, filePath, config);
                    continue;
                }
                if (!Files.isDirectory(filePath, new LinkOption[0])) continue;
                LOGGER.debugf("Scan directory: %s", (Object)filePath);
                this.scan(root, filePath, basePath, watchedPaths, templatePaths, nativeImageResources, config);
            }
        }
    }

    private static boolean isExcluded(TypeCheckExcludeBuildItem.TypeCheck check, List<TypeCheckExcludeBuildItem> excludes) {
        for (TypeCheckExcludeBuildItem exclude : excludes) {
            if (!exclude.getPredicate().test(check)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBasePath(Path path) {
        return path.getFileName().toString().equals(BASE_PATH);
    }

    private void checkDuplicatePaths(List<TemplatePathBuildItem> templatePaths) {
        Map<String, List<TemplatePathBuildItem>> duplicates = templatePaths.stream().collect(Collectors.groupingBy(TemplatePathBuildItem::getPath));
        Iterator<List<TemplatePathBuildItem>> it = duplicates.values().iterator();
        while (it.hasNext()) {
            List<TemplatePathBuildItem> paths = it.next();
            if (!paths.isEmpty() && paths.size() != 1) continue;
            it.remove();
        }
        if (!duplicates.isEmpty()) {
            StringBuilder builder = new StringBuilder("Duplicate templates found:");
            for (Map.Entry<String, List<TemplatePathBuildItem>> e : duplicates.entrySet()) {
                builder.append("\n\t- ").append(e.getKey()).append(": ").append(e.getValue().stream().map(TemplatePathBuildItem::getFullPath).collect(Collectors.toList()));
            }
            throw new IllegalStateException(builder.toString());
        }
    }

    private boolean isApplicationArchive(ResolvedDependency dependency, Set<ApplicationArchive> applicationArchives) {
        for (ApplicationArchive archive : applicationArchives) {
            if (archive.getKey() == null || !dependency.getGroupId().equals(archive.getKey().getGroupId()) || !dependency.getArtifactId().equals(archive.getKey().getArtifactId())) continue;
            return true;
        }
        return false;
    }

    static String readTemplateContent(Path path, Charset defaultCharset) {
        try {
            return Files.readString(path, defaultCharset);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read the template content from path: " + path, e);
        }
    }

    static class FirstPassLookupConfig
    implements LookupConfig {
        private final LookupConfig next;
        private Predicate<AnnotationTarget> filter;
        private Boolean declaredMembersOnly;

        FirstPassLookupConfig(LookupConfig next, Predicate<AnnotationTarget> filter, Boolean declaredMembersOnly) {
            this.next = next;
            this.filter = filter;
            this.declaredMembersOnly = declaredMembersOnly;
        }

        @Override
        public IndexView index() {
            return this.next.index();
        }

        @Override
        public Predicate<AnnotationTarget> filter() {
            return this.filter != null ? this.filter : this.next.filter();
        }

        @Override
        public boolean declaredMembersOnly() {
            return this.declaredMembersOnly != null ? this.declaredMembersOnly.booleanValue() : this.next.declaredMembersOnly();
        }

        @Override
        public void nextPart() {
            this.filter = null;
            this.declaredMembersOnly = null;
        }
    }

    static class FixedLookupConfig
    implements LookupConfig {
        private final IndexView index;
        private final Predicate<AnnotationTarget> filter;
        private final boolean declaredMembersOnly;

        FixedLookupConfig(IndexView index, Predicate<AnnotationTarget> filter, boolean declaredMembersOnly) {
            this.index = index;
            this.filter = filter;
            this.declaredMembersOnly = declaredMembersOnly;
        }

        @Override
        public IndexView index() {
            return this.index;
        }

        @Override
        public Predicate<AnnotationTarget> filter() {
            return this.filter;
        }

        @Override
        public boolean declaredMembersOnly() {
            return this.declaredMembersOnly;
        }
    }

    static interface LookupConfig {
        public IndexView index();

        public Predicate<AnnotationTarget> filter();

        public boolean declaredMembersOnly();

        default public void nextPart() {
        }
    }

    static class Match {
        private final IndexView index;
        private ClassInfo clazz;
        private Type type;

        Match(IndexView index) {
            this.index = index;
        }

        List<Type> getParameterizedTypeArguments() {
            return this.type.kind() == Type.Kind.PARAMETERIZED_TYPE ? this.type.asParameterizedType().arguments() : Collections.emptyList();
        }

        List<TypeVariable> getTypeParameters() {
            return this.clazz.typeParameters();
        }

        ClassInfo clazz() {
            return this.clazz;
        }

        Type type() {
            return this.type;
        }

        boolean isPrimitive() {
            return this.type != null && this.type.kind() == Type.Kind.PRIMITIVE;
        }

        boolean isArray() {
            return this.type != null && this.type.kind() == Type.Kind.ARRAY;
        }

        boolean isParameterizedType() {
            return this.type != null && this.type.kind() == Type.Kind.PARAMETERIZED_TYPE;
        }

        boolean isClass() {
            return this.type != null && this.type.kind() == Type.Kind.CLASS;
        }

        void setValues(ClassInfo clazz, Type type) {
            this.clazz = clazz;
            this.type = type;
            this.autoExtractType();
        }

        void clearValues() {
            this.clazz = null;
            this.type = null;
        }

        boolean isEmpty() {
            return this.type == null;
        }

        void autoExtractType() {
            boolean hasUni;
            boolean hasCompletionStage = ValueResolverGenerator.hasCompletionStageInTypeClosure((ClassInfo)this.clazz, (IndexView)this.index);
            boolean bl = hasUni = hasCompletionStage ? false : ValueResolverGenerator.hasClassInTypeClosure((ClassInfo)this.clazz, (DotName)Names.UNI, (IndexView)this.index);
            if (hasCompletionStage || hasUni) {
                Set<Type> closure = Types.getTypeClosure(this.clazz, Types.buildResolvedMap(this.getParameterizedTypeArguments(), this.getTypeParameters(), new HashMap<TypeVariable, Type>(), this.index), this.index);
                Function<Type, Type> firstParamType = t -> (Type)t.asParameterizedType().arguments().get(0);
                this.type = QuteProcessor.extractMatchType(closure, hasCompletionStage ? Names.COMPLETION_STAGE : Names.UNI, firstParamType);
                this.clazz = this.index.getClassByName(this.type.name());
            }
        }
    }
}

