/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.deployment.cmd.DeployCommandActionResultBuildItem;
import io.quarkus.deployment.cmd.DeployCommandDeclarationHandler;
import io.quarkus.deployment.cmd.DeployCommandDeclarationResultBuildItem;
import io.quarkus.deployment.cmd.DeployCommandHandler;
import io.quarkus.maven.AbstractDeploymentMojo;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class DeployMojo
extends AbstractDeploymentMojo {
    @Override
    protected boolean beforeExecute() throws MojoExecutionException {
        return super.beforeExecute();
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        try (CuratedApplication curatedApplication = this.bootstrapApplication();){
            final AtomicReference tooMany = new AtomicReference();
            AugmentAction action = curatedApplication.createAugmentor();
            action.performCustomBuild(DeployCommandDeclarationHandler.class.getName(), (Object)new Consumer<List<String>>(){

                @Override
                public void accept(List<String> strings) {
                    tooMany.set(strings);
                }
            }, new String[]{DeployCommandDeclarationResultBuildItem.class.getName()});
            String target = System.getProperty("quarkus.deploy.target");
            List targets = (List)tooMany.get();
            if (targets.isEmpty() && target == null) {
                this.systemProperties = new HashMap(this.systemProperties);
                boolean shouldBuildImage = this.imageBuild || this.imageBuilder != null && !this.imageBuilder.isEmpty();
                this.systemProperties.put("quarkus." + this.getDeployer().name() + ".deploy", "true");
                this.systemProperties.put("quarkus.container-image.build", String.valueOf(shouldBuildImage));
                super.doExecute();
            } else if (targets.size() > 1 && target == null) {
                this.getLog().error((CharSequence)"Too many installed extensions support quarkus:deploy.  You must choose one by setting quarkus.deploy.target.");
                this.getLog().error((CharSequence)("Extensions: " + targets.stream().collect(Collectors.joining(" "))));
            } else if (target != null && !targets.contains(target)) {
                this.getLog().error((CharSequence)("Unknown quarkus.deploy.target: " + target));
                this.getLog().error((CharSequence)("Extensions: " + targets.stream().collect(Collectors.joining(" "))));
            } else {
                this.forceDependencies = false;
                if (target == null) {
                    target = (String)targets.get(0);
                }
                AugmentAction deployAction = curatedApplication.createAugmentor();
                this.getLog().info((CharSequence)("Deploy target: " + target));
                System.setProperty("quarkus.deploy.target", target);
                deployAction.performCustomBuild(DeployCommandHandler.class.getName(), (Object)new Consumer<Boolean>(){

                    @Override
                    public void accept(Boolean success) {
                    }
                }, new String[]{DeployCommandActionResultBuildItem.class.getName()});
            }
        }
    }
}

