/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.components;

import io.quarkus.maven.BuildAnalyticsProvider;
import io.quarkus.maven.QuarkusBootstrapProvider;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@SessionScoped
@Named(value="quarkus-bootstrap")
public class BootstrapSessionListener
extends AbstractMavenLifecycleParticipant {
    private static final List<String> INJECTED_JVM_PROPS = List.of("--add-opens=java.base/java.lang.invoke=ALL-UNNAMED", "--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-exports=java.base/jdk.internal.module=ALL-UNNAMED");
    private final Logger logger;
    private final QuarkusBootstrapProvider bootstrapProvider;
    private final BuildAnalyticsProvider buildAnalyticsProvider;
    private boolean enabled;

    @Inject
    public BootstrapSessionListener(Logger logger, QuarkusBootstrapProvider bootstrapProvider, BuildAnalyticsProvider buildAnalyticsProvider) {
        this.logger = logger;
        this.bootstrapProvider = bootstrapProvider;
        this.buildAnalyticsProvider = buildAnalyticsProvider;
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        try {
            this.bootstrapProvider.close();
            this.buildAnalyticsProvider.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void afterProjectsRead(MavenSession session) {
        this.enabled = true;
        this.injectSurefireTuning(session);
    }

    private void injectSurefireTuning(MavenSession session) {
        this.logger.debug("Quarkus Maven extension: inspecting Surefire and Failsafe configurations");
        for (MavenProject project : session.getProjects()) {
            if (!this.isQuarkusPluginConfigured(project)) continue;
            this.injectSurefireArgs(project);
        }
    }

    private void injectSurefireArgs(MavenProject project) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found quarkus-maven-plugin in " + project.getArtifactId() + ": inspecting for missing Surefire and Failsafe arguments");
        }
        this.injectArgsForPlugin(project, "maven-surefire-plugin");
        this.injectArgsForPlugin(project, "maven-failsafe-plugin");
    }

    private void injectArgsForPlugin(MavenProject project, String pluginArtifactId) {
        String newValue;
        Properties props = project.getProperties();
        Plugin plugin = this.findPlugin(project, pluginArtifactId);
        if (plugin == null) {
            return;
        }
        Object configuration = plugin.getConfiguration();
        Xpp3Dom configDom = configuration instanceof Xpp3Dom ? (Xpp3Dom)configuration : null;
        Xpp3Dom argLineDom = configDom != null ? configDom.getChild("argLine") : null;
        boolean hasExplicitConfig = argLineDom != null && argLineDom.getValue() != null;
        String userDefinedArgLine = props.getProperty("argLine", "").trim();
        if (hasExplicitConfig) {
            boolean standardMarkerIsPresent;
            String standardMarker = "@{argLine}";
            String explicitValue = argLineDom.getValue();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Quarkus Maven extension: found explicit argLine configuration in " + pluginArtifactId + " with value: '" + explicitValue + "'");
            }
            if (!(standardMarkerIsPresent = explicitValue.contains("@{argLine}"))) {
                this.logger.warn("Quarkus Maven extension: an explicit 'argLine' is defined in " + pluginArtifactId + " config, but does not contain '@{argLine}': we will not be able to inject JVM parameters automatically. Please add '@{argLine}' to the argLine configuration you have defined.");
            }
        }
        if (!(newValue = this.generateNewArgLine(userDefinedArgLine)).equals(userDefinedArgLine)) {
            props.setProperty("argLine", newValue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Quarkus Maven extension: set project property 'argLine' to: '" + newValue + "'");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Quarkus Maven extension: not setting 'argLine' as its content doesn't need tuning.");
        }
    }

    private String generateNewArgLine(String userDefinedArgLine) {
        StringBuilder sb = new StringBuilder();
        for (String prop : INJECTED_JVM_PROPS) {
            if (userDefinedArgLine.contains(prop)) continue;
            sb.append(prop);
            sb.append(" ");
        }
        sb.append(userDefinedArgLine);
        return sb.toString().trim();
    }

    private Plugin findPlugin(MavenProject project, String pluginArtifactId) {
        if (project.getBuild() == null || project.getBuild().getPlugins() == null) {
            return null;
        }
        for (Plugin plugin : project.getBuild().getPlugins()) {
            if (!pluginArtifactId.equals(plugin.getArtifactId())) continue;
            return plugin;
        }
        return null;
    }

    private boolean isQuarkusPluginConfigured(MavenProject project) {
        if (project.getBuild() == null || project.getBuild().getPlugins() == null) {
            return false;
        }
        for (Plugin plugin : project.getBuild().getPlugins()) {
            if (!"quarkus-maven-plugin".equals(plugin.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

