/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.runtime.logging.LoggingSetupRecorder;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.IntegrationTestExtensionState;
import io.quarkus.test.junit.NativeDevServicesHandler;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.TestProfileAndProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.apache.commons.lang3.RandomStringUtils;
import org.jboss.jandex.Index;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;

public final class IntegrationTestUtil {
    public static final int DEFAULT_PORT = 8081;
    public static final int DEFAULT_HTTPS_PORT = 8444;
    public static final long DEFAULT_WAIT_TIME_SECONDS = 60L;
    private static final String DOCKER_BINARY = "docker";

    private IntegrationTestUtil() {
    }

    static void ensureNoInjectAnnotationIsUsed(Class<?> testClass) {
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (injectAnnotation == null) continue;
                throw new JUnitException("@Inject is not supported in @NativeImageTest and @QuarkusIntegrationTest tests. Offending field is " + field.getDeclaringClass().getTypeName() + "." + field.getName());
            }
            current = current.getSuperclass();
        }
    }

    static Class<? extends QuarkusTestProfile> findProfile(Class<?> testClass) {
        while (testClass != Object.class) {
            TestProfile annotation = testClass.getAnnotation(TestProfile.class);
            if (annotation != null) {
                return annotation.value();
            }
            testClass = testClass.getSuperclass();
        }
        return null;
    }

    static void doProcessTestInstance(Object testInstance, ExtensionContext context) {
        TestHTTPResourceManager.inject((Object)testInstance);
        ExtensionContext root = context.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        IntegrationTestExtensionState state = (IntegrationTestExtensionState)store.get((Object)IntegrationTestExtensionState.class.getName(), IntegrationTestExtensionState.class);
        state.getTestResourceManager().inject(testInstance);
    }

    static Map<String, String> getSysPropsToRestore() {
        HashMap<String, String> sysPropRestore = new HashMap<String, String>();
        sysPropRestore.put("quarkus.test.profile", System.getProperty("quarkus.test.profile"));
        return sysPropRestore;
    }

    static TestProfileAndProperties determineTestProfileAndProperties(Class<? extends QuarkusTestProfile> profile, Map<String, String> sysPropRestore) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        HashMap<String, String> properties = new HashMap<String, String>();
        QuarkusTestProfile testProfile = null;
        if (profile != null) {
            String configProfile;
            testProfile = profile.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            properties.putAll(testProfile.getConfigOverrides());
            Set<Class<?>> enabledAlternatives = testProfile.getEnabledAlternatives();
            if (!enabledAlternatives.isEmpty()) {
                properties.put("quarkus.arc.selected-alternatives", enabledAlternatives.stream().peek(c -> {
                    if (!c.isAnnotationPresent(Alternative.class)) {
                        throw new RuntimeException("Enabled alternative " + c + " is not annotated with @Alternative");
                    }
                }).map(Class::getName).collect(Collectors.joining(",")));
            }
            if ((configProfile = testProfile.getConfigProfile()) != null) {
                properties.put("quarkus.profile", configProfile);
            }
            properties.put("quarkus.configuration.build-time-mismatch-at-runtime", "fail");
            for (Map.Entry i : properties.entrySet()) {
                sysPropRestore.put((String)i.getKey(), System.getProperty((String)i.getKey()));
            }
            for (Map.Entry i : properties.entrySet()) {
                System.setProperty((String)i.getKey(), (String)i.getValue());
            }
        }
        return new TestProfileAndProperties(testProfile, properties);
    }

    static <T> List<T> getAdditionalTestResources(QuarkusTestProfile profileInstance, ClassLoader classLoader) {
        if (profileInstance == null || profileInstance.testResources().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Constructor<?> testResourceClassEntryConstructor = Class.forName(TestResourceManager.TestResourceClassEntry.class.getName(), true, classLoader).getConstructor(Class.class, Map.class, Annotation.class, Boolean.TYPE);
            List<QuarkusTestProfile.TestResourceEntry> testResources = profileInstance.testResources();
            ArrayList result = new ArrayList(testResources.size());
            for (QuarkusTestProfile.TestResourceEntry testResource : testResources) {
                Object instance = testResourceClassEntryConstructor.newInstance(Class.forName(testResource.getClazz().getName(), true, classLoader), testResource.getArgs(), null, testResource.isParallel());
                result.add(instance);
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to handle profile " + profileInstance.getClass(), e);
        }
    }

    static void startLauncher(ArtifactLauncher launcher, Map<String, String> additionalProperties, Runnable sslSetter) throws IOException {
        launcher.includeAsSysProps(additionalProperties);
        try {
            launcher.start();
        }
        catch (IOException e) {
            try {
                launcher.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        if (launcher.listensOnSsl() && sslSetter != null) {
            sslSetter.run();
        }
    }

    static ArtifactLauncher.InitContext.DevServicesLaunchResult handleDevServices(ExtensionContext context, boolean isDockerAppLaunch) throws Exception {
        Path outputDir;
        Class requiredTestClass = context.getRequiredTestClass();
        Path testClassLocation = PathTestHelper.getTestClassesLocation((Class)requiredTestClass);
        Path appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((String)testClassLocation.toString());
        PathsCollection.Builder rootBuilder = PathsCollection.builder();
        if (!appClassLocation.equals(testClassLocation)) {
            rootBuilder.add(testClassLocation);
            Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
            if (testResourcesLocation != null) {
                rootBuilder.add(testResourcesLocation);
            }
        }
        QuarkusBootstrap.Builder runnerBuilder = QuarkusBootstrap.builder().setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST);
        Object profileInstance = null;
        Path projectRoot = Paths.get("", new String[0]).normalize().toAbsolutePath();
        runnerBuilder.setProjectRoot(projectRoot);
        try {
            outputDir = projectRoot.resolve(projectRoot.relativize(testClassLocation).getName(0));
        }
        catch (Exception e) {
            outputDir = projectRoot;
        }
        runnerBuilder.setTargetDirectory(outputDir);
        rootBuilder.add(appClassLocation);
        Path appResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)appClassLocation, (String)"main");
        if (appResourcesLocation != null) {
            rootBuilder.add(appResourcesLocation);
        }
        if (System.getProperty("quarkus-internal-test.serialized-app-model.path") == null) {
            ApplicationModel model = BuildToolHelper.enableGradleAppModelForTest((Path)projectRoot);
            if (model != null && model.getApplicationModule() != null) {
                model.getApplicationModule().getTestSources().forEach(src -> {
                    Path classes;
                    if (!src.getDestinationDir().exists() && !rootBuilder.contains(classes = src.getDestinationDir().toPath())) {
                        rootBuilder.add(classes);
                    }
                });
                model.getApplicationModule().getMainSources().forEach(src -> {
                    Path classes;
                    if (!src.getDestinationDir().exists() && !rootBuilder.contains(classes = src.getDestinationDir().toPath())) {
                        rootBuilder.add(classes);
                    }
                });
            }
        } else if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
            String[] sourceDirectories;
            for (String sourceDirectory : sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",")) {
                Path directory = Paths.get(sourceDirectory, new String[0]);
                if (!Files.exists(directory, new LinkOption[0]) || rootBuilder.contains(directory)) continue;
                rootBuilder.add(directory);
            }
        }
        runnerBuilder.setApplicationRoot(rootBuilder.build());
        CuratedApplication curatedApplication = runnerBuilder.setTest(true).build().bootstrap();
        Index testClassesIndex = TestClassIndexer.indexTestClasses((Class)requiredTestClass);
        TestClassIndexer.writeIndex((Index)testClassesIndex, (Class)requiredTestClass);
        final HashMap<String, String> propertyMap = new HashMap<String, String>();
        Object networkId = null;
        AugmentAction augmentAction = isDockerAppLaunch ? curatedApplication.createAugmentor("io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem$Factory", Collections.emptyMap()) : curatedApplication.createAugmentor();
        augmentAction.performCustomBuild(NativeDevServicesHandler.class.getName(), (Object)new BiConsumer<String, String>(){

            @Override
            public void accept(String s, String s2) {
                propertyMap.put(s, s2);
            }
        }, new String[]{DevServicesLauncherConfigResultBuildItem.class.getName()});
        boolean manageNetwork = false;
        if (isDockerAppLaunch) {
            try {
                Class networkClass = curatedApplication.getAugmentClassLoader().loadClass("org.testcontainers.containers.Network");
                Object sharedNetwork = networkClass.getField("SHARED").get(null);
                networkId = (String)networkClass.getMethod("getId", new Class[0]).invoke(sharedNetwork, new Object[0]);
            }
            catch (Exception e) {
                networkId = "quarkus-integration-test-" + RandomStringUtils.random((int)5, (boolean)true, (boolean)false);
                manageNetwork = true;
            }
        }
        DefaultDevServicesLaunchResult result = new DefaultDevServicesLaunchResult((Map<String, String>)propertyMap, (String)networkId, manageNetwork, curatedApplication);
        IntegrationTestUtil.createNetworkIfNecessary(result);
        return result;
    }

    private static void createNetworkIfNecessary(final ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult) {
        if (devServicesLaunchResult.manageNetwork() && devServicesLaunchResult.networkId() != null) {
            try {
                int networkCreateResult = new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).command(DOCKER_BINARY, "network", "create", devServicesLaunchResult.networkId()).start().waitFor();
                if (networkCreateResult > 0) {
                    throw new RuntimeException("Creating container network '" + devServicesLaunchResult.networkId() + "' completed unsuccessfully");
                }
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).command(IntegrationTestUtil.DOCKER_BINARY, "network", "rm", devServicesLaunchResult.networkId()).start().waitFor();
                        }
                        catch (IOException | InterruptedException ignored) {
                            System.out.println("Unable to delete container network '" + devServicesLaunchResult.networkId() + "'");
                        }
                    }
                }));
            }
            catch (Exception e) {
                throw new RuntimeException("Creating container network '" + devServicesLaunchResult.networkId() + "' completed unsuccessfully");
            }
        }
    }

    static void activateLogging() {
        LoggingSetupRecorder.handleFailedStart();
    }

    static Properties readQuarkusArtifactProperties(ExtensionContext context) {
        Path buildOutputDirectory = IntegrationTestUtil.determineBuildOutputDirectory(context);
        Path artifactProperties = buildOutputDirectory.resolve("quarkus-artifact.properties");
        if (!Files.exists(artifactProperties, new LinkOption[0])) {
            TestLauncher testLauncher = IntegrationTestUtil.determineTestLauncher();
            Object errorMessage = "Unable to locate the artifact metadata file created that must be created by Quarkus in order to run integration tests. ";
            if (testLauncher == TestLauncher.MAVEN) {
                String testClassName;
                errorMessage = (String)errorMessage + "Make sure this test is run after 'mvn package'. ";
                if (context.getTestClass().isPresent() && (testClassName = ((Class)context.getTestClass().get()).getName()).endsWith("Test")) {
                    errorMessage = (String)errorMessage + "The easiest way to ensure this is by having the 'maven-failsafe-plugin' run the test instead of the 'maven-surefire-plugin'.";
                }
            } else {
                errorMessage = testLauncher == TestLauncher.GRADLE ? (String)errorMessage + "Make sure this test is run after the 'quarkusBuild' Gradle task." : (String)errorMessage + "Make sure this test is run after the Quarkus artifact is built from your build tool.";
            }
            throw new IllegalStateException((String)errorMessage);
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(artifactProperties.toFile()));
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read artifact metadata file created that must be created by Quarkus in order to run integration tests.", e);
        }
    }

    private static TestLauncher determineTestLauncher() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = stackTrace.length - 1;
        TestLauncher testLauncher = TestLauncher.UNKNOWN;
        do {
            StackTraceElement element;
            String className;
            if ((className = (element = stackTrace[i--]).getClassName()).startsWith("org.apache.maven")) {
                testLauncher = TestLauncher.MAVEN;
                break;
            }
            if (!className.startsWith("org.gradle")) continue;
            testLauncher = TestLauncher.GRADLE;
        } while (i != 0);
        return testLauncher;
    }

    static Path determineBuildOutputDirectory(ExtensionContext context) {
        String buildOutputDirStr = System.getProperty("build.output.directory");
        Path result = null;
        if (buildOutputDirStr != null) {
            result = Paths.get(buildOutputDirStr, new String[0]);
        } else {
            Class testClass = context.getRequiredTestClass();
            CodeSource codeSource = testClass.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL codeSourceLocation = codeSource.getLocation();
                File artifactPropertiesDirectory = IntegrationTestUtil.determineBuildOutputDirectory(codeSourceLocation);
                if (artifactPropertiesDirectory == null) {
                    throw new IllegalStateException("Unable to determine the output of the Quarkus build. Consider setting the 'build.output.directory' system property.");
                }
                result = artifactPropertiesDirectory.toPath();
            }
        }
        if (result == null) {
            throw new IllegalStateException("Unable to locate the artifact metadata file created that must be created by Quarkus in order to run tests annotated with '@QuarkusIntegrationTest'.");
        }
        if (!Files.isDirectory(result, new LinkOption[0])) {
            throw new IllegalStateException("The determined Quarkus build output '" + result.toAbsolutePath().toString() + "' is not a directory");
        }
        return result;
    }

    private static File determineBuildOutputDirectory(URL url) {
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("file") && url.getPath().endsWith("test-classes/")) {
            return IntegrationTestUtil.toPath(url).getParent().toFile();
        }
        if (url.getProtocol().equals("file") && url.getPath().endsWith("test/")) {
            return IntegrationTestUtil.toPath(url).getParent().getParent().getParent().toFile();
        }
        if (url.getProtocol().equals("file") && url.getPath().contains("/target/surefire/")) {
            String path = url.getPath();
            int index = path.lastIndexOf("/target/");
            try {
                return Paths.get(new URI("file:" + path.substring(0, index) + "/target/")).toFile();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static Path toPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum TestLauncher {
        MAVEN,
        GRADLE,
        UNKNOWN;

    }

    static class DefaultDevServicesLaunchResult
    implements ArtifactLauncher.InitContext.DevServicesLaunchResult {
        private final Map<String, String> properties;
        private final String networkId;
        private final boolean manageNetwork;
        private final CuratedApplication curatedApplication;

        DefaultDevServicesLaunchResult(Map<String, String> properties, String networkId, boolean manageNetwork, CuratedApplication curatedApplication) {
            this.properties = properties;
            this.networkId = networkId;
            this.manageNetwork = manageNetwork;
            this.curatedApplication = curatedApplication;
        }

        public Map<String, String> properties() {
            return this.properties;
        }

        public String networkId() {
            return this.networkId;
        }

        public boolean manageNetwork() {
            return this.manageNetwork;
        }

        public void close() {
            this.curatedApplication.close();
        }
    }
}

