/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.impl.RouteImpl;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import java.util.HashMap;

@ApplicationScoped
public class VertxRouteInfoService {
    private Router router;

    public void init(@Observes Router router) {
        this.router = router;
    }

    public JsonArray getInfo() {
        JsonArray allRoutes = new JsonArray();
        for (Route route : this.router.getRoutes()) {
            RouteImpl routeImpl = (RouteImpl)route;
            String routeImplJson = routeImpl.toString();
            int begin = routeImplJson.lastIndexOf("{") + 1;
            int end = routeImplJson.indexOf("}");
            routeImplJson = routeImplJson.substring(begin, end);
            String[] fields = routeImplJson.split(",");
            HashMap<String, String> routeMap = new HashMap<String, String>();
            for (String field : fields) {
                String[] kv = field.split("=");
                String key = kv[0];
                String value = "";
                if (kv.length > 1) {
                    value = kv[1];
                }
                routeMap.put(key.trim(), value.trim());
            }
            allRoutes.add((Object)new JsonObject(routeMap));
        }
        return allRoutes;
    }
}

