/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.json.JsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class CategoryImpl
implements Category {
    private final String id;
    private final String name;
    private final String description;
    private final Map<String, Object> metadata;

    private CategoryImpl(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.metadata = JsonBuilder.toUnmodifiableMap(builder.metadata);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        return CategoryImpl.categoryEquals(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.getMetadata());
    }

    public String toString() {
        return CategoryImpl.categoryToString(this);
    }

    static final boolean categoryEquals(Category c, Object o) {
        if (c == o) {
            return true;
        }
        if (!(o instanceof Category)) {
            return false;
        }
        Category category = (Category)o;
        return Objects.equals(c.getId(), category.getId()) && Objects.equals(c.getName(), category.getName()) && Objects.equals(c.getDescription(), category.getDescription()) && Objects.equals(c.getMetadata(), category.getMetadata());
    }

    static final String categoryToString(Category c) {
        return "Category{id='" + c.getId() + "', name='" + c.getName() + "', description='" + c.getDescription() + "', metadata=" + c.getMetadata() + ", builder=" + (c instanceof Builder) + "}";
    }

    public static class Builder
    implements Category.Mutable {
        protected String id;
        protected String name;
        protected String description;
        protected Map<String, Object> metadata;

        Builder() {
        }

        @JsonIgnore
        Builder(Category config) {
            this.id = config.getId();
            this.name = config.getName();
            this.description = config.getDescription();
            this.metadata = config.getMetadata();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Map<String, Object> getMetadata() {
            return this.metadata == null ? (this.metadata = new HashMap<String, Object>()) : this.metadata;
        }

        @Override
        public Builder setMetadata(Map<String, Object> newValues) {
            this.metadata = JsonBuilder.modifiableMapOrNull(newValues, HashMap::new);
            return this;
        }

        @Override
        public Builder setMetadata(String name, Object value) {
            this.getMetadata().put(name, value);
            return this;
        }

        @Override
        public Builder removeMetadata(String key) {
            this.getMetadata().remove(key);
            return this;
        }

        @Override
        public CategoryImpl build() {
            return new CategoryImpl(this);
        }

        public boolean equals(Object o) {
            return CategoryImpl.categoryEquals(this, o);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.description, this.getMetadata());
        }

        public String toString() {
            return CategoryImpl.categoryToString(this);
        }
    }
}

