/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.devtools.project.buildfile.BuildFile;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractGradleBuildFile
extends BuildFile {
    private static final Pattern DEPENDENCIES_SECTION = Pattern.compile("^[\\t ]*dependencies\\s*\\{\\s*$", 8);
    private static final String GRADLE_PROPERTIES_PATH = "gradle.properties";
    private final Path rootProjectPath;
    private final AtomicReference<Model> modelReference = new AtomicReference();

    public AbstractGradleBuildFile(Path projectDirPath, ExtensionCatalog catalog) {
        this(projectDirPath, catalog, null);
    }

    public AbstractGradleBuildFile(Path projectDirPath, ExtensionCatalog catalog, Path rootProjectPath) {
        super(projectDirPath, catalog);
        this.rootProjectPath = rootProjectPath;
    }

    abstract String getSettingsGradlePath();

    abstract String getBuildGradlePath();

    @Override
    public void writeToDisk() throws IOException {
        if (this.rootProjectPath != null) {
            Files.write(this.rootProjectPath.resolve(this.getSettingsGradlePath()), this.getModel().getRootSettingsContent().getBytes(), new OpenOption[0]);
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.getModel().getRootPropertiesContent().store(out, "Gradle properties");
                Files.write(this.rootProjectPath.resolve(GRADLE_PROPERTIES_PATH), out.toByteArray(), new OpenOption[0]);
            }
        }
        this.writeToProjectFile(this.getSettingsGradlePath(), this.getModel().getSettingsContent().getBytes());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.getModel().getPropertiesContent().store(out, "Gradle properties");
            this.writeToProjectFile(GRADLE_PROPERTIES_PATH, out.toByteArray());
        }
        this.writeToProjectFile(this.getBuildGradlePath(), this.getModel().getBuildContent().getBytes());
    }

    static String createDependencyCoordinatesString(ArtifactCoords coords, boolean managed, char quoteChar) {
        boolean isBOM;
        StringBuilder newDependency = new StringBuilder().append(quoteChar).append(coords.getGroupId()).append(":").append(coords.getArtifactId());
        if (!managed && coords.getVersion() != null && !coords.getVersion().isEmpty()) {
            newDependency.append(":").append(coords.getVersion());
        }
        if ((isBOM = "pom".equals(coords.getType())) && !managed) {
            return String.format("enforcedPlatform(%s)", newDependency.append(quoteChar).toString());
        }
        return newDependency.append(quoteChar).toString();
    }

    static boolean addDependencyInModel(Model model, String newDependency) {
        StringBuilder buildContent = new StringBuilder(model.getBuildContent());
        Matcher matcher = DEPENDENCIES_SECTION.matcher(buildContent);
        if (matcher.find()) {
            int nextLine = buildContent.indexOf("\n", matcher.start()) + 1;
            buildContent.insert(nextLine, newDependency);
        } else {
            buildContent.append("dependencies {").append(System.lineSeparator()).append(newDependency).append("}").append(System.lineSeparator());
        }
        model.setBuildContent(buildContent.toString());
        return true;
    }

    static String getProperty(Model model, String propertyName) {
        String property = model.getPropertiesContent().getProperty(propertyName);
        if (property != null || model.getRootPropertiesContent() == null) {
            return property;
        }
        return model.getRootPropertiesContent().getProperty(propertyName);
    }

    @Override
    protected void removeDependency(ArtifactKey key) {
        StringBuilder newBuildContent = new StringBuilder();
        Scanner scanner = new Scanner(this.getModel().getBuildContent());
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.contains(key.getGroupId() + ":" + key.getArtifactId())) continue;
            newBuildContent.append(line).append(System.lineSeparator());
        }
        scanner.close();
        this.getModel().setBuildContent(newBuildContent.toString());
    }

    @Override
    public String getProperty(String propertyName) {
        return AbstractGradleBuildFile.getProperty(this.getModel(), propertyName);
    }

    Model getModel() {
        return this.modelReference.updateAndGet(model -> {
            if (model == null) {
                try {
                    return this.readModel();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return model;
        });
    }

    @Override
    protected void refreshData() {
        this.modelReference.set(null);
    }

    private boolean hasRootProjectFile(String fileName) {
        if (this.rootProjectPath == null) {
            return false;
        }
        Path filePath = this.rootProjectPath.resolve(fileName);
        return Files.exists(filePath, new LinkOption[0]);
    }

    private byte[] readRootProjectFile(String fileName) throws IOException {
        if (this.rootProjectPath == null) {
            throw new IllegalStateException("There is no rootProject defined in this GradleBuildFile");
        }
        Path filePath = this.rootProjectPath.resolve(fileName);
        return Files.readAllBytes(filePath);
    }

    private Model readModel() throws IOException {
        byte[] properties;
        byte[] settings;
        String settingsContent = "";
        String buildContent = "";
        Properties propertiesContent = new Properties();
        String rootSettingsContent = null;
        Properties rootPropertiesContent = null;
        if (this.hasProjectFile(this.getSettingsGradlePath())) {
            settings = this.readProjectFile(this.getSettingsGradlePath());
            settingsContent = new String(settings, StandardCharsets.UTF_8);
        }
        if (this.hasRootProjectFile(this.getSettingsGradlePath())) {
            settings = this.readRootProjectFile(this.getSettingsGradlePath());
            rootSettingsContent = new String(settings, StandardCharsets.UTF_8);
        }
        if (this.hasProjectFile(this.getBuildGradlePath())) {
            byte[] build = this.readProjectFile(this.getBuildGradlePath());
            buildContent = new String(build, StandardCharsets.UTF_8);
        }
        if (this.hasProjectFile(GRADLE_PROPERTIES_PATH)) {
            properties = this.readProjectFile(GRADLE_PROPERTIES_PATH);
            propertiesContent.load(new ByteArrayInputStream(properties));
        }
        if (this.hasRootProjectFile(GRADLE_PROPERTIES_PATH)) {
            properties = this.readRootProjectFile(GRADLE_PROPERTIES_PATH);
            rootPropertiesContent = new Properties();
            rootPropertiesContent.load(new ByteArrayInputStream(properties));
        }
        return new Model(settingsContent, buildContent, propertiesContent, rootSettingsContent, rootPropertiesContent);
    }

    protected String getBuildContent() {
        return this.getModel().getBuildContent();
    }

    static class Model {
        private String settingsContent;
        private String buildContent;
        private final Properties propertiesContent;
        private final String rootSettingsContent;
        private final Properties rootPropertiesContent;

        public Model(String settingsContent, String buildContent, Properties propertiesContent, String rootSettingsContent, Properties rootPropertiesContent) {
            this.settingsContent = settingsContent;
            this.buildContent = buildContent;
            this.propertiesContent = propertiesContent;
            this.rootSettingsContent = rootSettingsContent;
            this.rootPropertiesContent = rootPropertiesContent;
        }

        public String getSettingsContent() {
            return this.settingsContent;
        }

        public String getBuildContent() {
            return this.buildContent;
        }

        public Properties getPropertiesContent() {
            return this.propertiesContent;
        }

        public String getRootSettingsContent() {
            return this.rootSettingsContent;
        }

        public Properties getRootPropertiesContent() {
            return this.rootPropertiesContent;
        }

        public void setSettingsContent(String settingsContent) {
            this.settingsContent = settingsContent;
        }

        public void setBuildContent(String buildContent) {
            this.buildContent = buildContent;
        }
    }
}

