/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor.loader.json;

import io.quarkus.platform.descriptor.ResourcePathConsumer;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class DirectoryResourceLoader
implements ResourceLoader {
    private final Path dir;

    public DirectoryResourceLoader(Path dir) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalStateException("Failed to locate directory " + dir);
        }
        this.dir = dir;
    }

    @Override
    public <T> T loadResourceAsPath(String name, ResourcePathConsumer<T> consumer) throws IOException {
        Path path = this.dir.resolve(name);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException("Failed to locate " + name + " dir on the classpath");
        }
        return (T)consumer.consume(path);
    }
}

