/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.dependencies.Extension;
import io.quarkus.devtools.project.extensions.ExtensionInstallPlan;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;

public abstract class BuildFile
implements ExtensionManager {
    private final Path projectDirPath;
    private final QuarkusPlatformDescriptor platformDescriptor;

    public BuildFile(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor) {
        this.projectDirPath = Objects.requireNonNull(projectDirPath, "projectPath is required");
        this.platformDescriptor = Objects.requireNonNull(platformDescriptor, "platformDescriptor is required");
    }

    @Override
    public final ExtensionManager.InstallResult install(Collection<AppArtifactCoords> coords) throws IOException {
        this.refreshData();
        Set<AppArtifactKey> existingKeys = this.getDependenciesKeys();
        List<AppArtifactCoords> installed = coords.stream().distinct().filter(a -> !existingKeys.contains(a.getKey())).collect(Collectors.toList());
        installed.forEach(e -> this.addDependency((AppArtifactCoords)e, e.getVersion() == null));
        this.writeToDisk();
        return new ExtensionManager.InstallResult(installed);
    }

    @Override
    public ExtensionManager.InstallResult install(ExtensionInstallPlan plan) throws IOException {
        ArrayList<AppArtifactCoords> installed = new ArrayList<AppArtifactCoords>();
        for (AppArtifactCoords platform : plan.getPlatforms()) {
            if (!this.addDependency(platform, false)) continue;
            installed.add(platform);
        }
        for (AppArtifactCoords managedExtension : plan.getManagedExtensions()) {
            if (!this.addDependency(managedExtension, true)) continue;
            installed.add(managedExtension);
        }
        for (AppArtifactCoords independentExtension : plan.getIndependentExtensions()) {
            if (!this.addDependency(independentExtension, false)) continue;
            installed.add(independentExtension);
        }
        this.writeToDisk();
        return new ExtensionManager.InstallResult(installed);
    }

    @Override
    public final Collection<AppArtifactCoords> getInstalled() throws IOException {
        this.refreshData();
        return this.getDependencies().stream().filter(d -> this.isQuarkusExtension(Extensions.toKey(d))).map(d -> Extensions.toCoords(d, this.extractVersion((Dependency)d))).collect(Collectors.toList());
    }

    @Override
    public final ExtensionManager.UninstallResult uninstall(Collection<AppArtifactKey> keys) throws IOException {
        this.refreshData();
        Set<AppArtifactKey> existingKeys = this.getDependenciesKeys();
        List<AppArtifactKey> uninstalled = keys.stream().distinct().filter(existingKeys::contains).filter(k -> {
            try {
                this.removeDependency((AppArtifactKey)k);
                return true;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }).collect(Collectors.toList());
        this.writeToDisk();
        return new ExtensionManager.UninstallResult(uninstalled);
    }

    protected abstract boolean addDependency(AppArtifactCoords var1, boolean var2);

    protected abstract void removeDependency(AppArtifactKey var1) throws IOException;

    protected abstract List<Dependency> getDependencies() throws IOException;

    protected abstract void writeToDisk() throws IOException;

    protected abstract String getProperty(String var1) throws IOException;

    protected abstract void refreshData();

    protected Path getProjectDirPath() {
        return this.projectDirPath;
    }

    protected boolean hasProjectFile(String fileName) throws IOException {
        Path filePath = this.projectDirPath.resolve(fileName);
        return Files.exists(filePath, new LinkOption[0]);
    }

    protected byte[] readProjectFile(String fileName) throws IOException {
        Path filePath = this.projectDirPath.resolve(fileName);
        return Files.readAllBytes(filePath);
    }

    protected void writeToProjectFile(String fileName, byte[] content) throws IOException {
        Files.write(this.projectDirPath.resolve(fileName), content, new OpenOption[0]);
    }

    private boolean isQuarkusExtension(AppArtifactKey key) {
        return BuildFile.isDefinedInRegistry(this.platformDescriptor.getExtensions(), key);
    }

    private Set<AppArtifactKey> getDependenciesKeys() throws IOException {
        return this.getDependencies().stream().map(Extensions::toKey).collect(Collectors.toSet());
    }

    private String extractVersion(Dependency d) {
        String version;
        String string = version = d != null ? d.getVersion() : null;
        if (version != null && version.startsWith("$")) {
            String value = null;
            try {
                value = this.getProperty(this.propertyName(version));
                if (value != null) {
                    return value;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (version != null) {
            return version;
        }
        return null;
    }

    private String propertyName(String variable) {
        return variable.substring(2, variable.length() - 1);
    }

    public static boolean isDefinedInRegistry(List<Extension> registry, AppArtifactKey key) {
        return Extensions.findInList(registry, key).isPresent();
    }
}

