/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartProjectDefinition;
import io.quarkus.devtools.codestarts.CodestartProjectInput;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.core.CodestartCatalogs;
import io.quarkus.devtools.codestarts.core.CodestartData;
import io.quarkus.devtools.codestarts.core.CodestartProjectGeneration;
import io.quarkus.devtools.codestarts.utils.NestedMaps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DefaultCodestartProjectDefinition
implements CodestartProjectDefinition {
    private static final Comparator<Codestart> PROCESSING_ORDER = Comparator.comparingInt(Codestart::getTypeOrder).thenComparing(Codestart::getName);
    private static final Comparator<Codestart> SHARED_DATA_MERGE_ORDER = PROCESSING_ORDER;
    private final String languageName;
    private final List<Codestart> codestarts;
    private final CodestartProjectInput projectInput;

    private DefaultCodestartProjectDefinition(CodestartProjectInput projectInput, String languageName, List<Codestart> codestarts) {
        this.projectInput = Objects.requireNonNull(projectInput, "codestartInput is required");
        this.languageName = Objects.requireNonNull(languageName, "languageName is required");
        this.codestarts = Objects.requireNonNull(codestarts, "codestarts is required");
    }

    public static CodestartProjectDefinition of(CodestartProjectInput projectInput, Collection<Codestart> codestarts) {
        String languageName = CodestartCatalogs.findLanguageName(codestarts);
        CodestartCatalogs.findRequiredCodestart(codestarts, CodestartType.PROJECT);
        List<Codestart> sorted = codestarts.stream().sorted(PROCESSING_ORDER).collect(Collectors.toList());
        return new DefaultCodestartProjectDefinition(projectInput, languageName, sorted);
    }

    @Override
    public void generate(Path targetDirectory) throws IOException {
        CodestartProjectGeneration.generateProject(this, targetDirectory);
    }

    @Override
    public List<Codestart> getCodestarts() {
        return this.codestarts;
    }

    @Override
    public CodestartProjectInput getProjectInput() {
        return this.projectInput;
    }

    @Override
    public Optional<Codestart> getCodestart(CodestartType type) {
        return CodestartCatalogs.findCodestart(this.codestarts, type);
    }

    @Override
    public Codestart getRequiredCodestart(CodestartType type) {
        return CodestartCatalogs.findRequiredCodestart(this.codestarts, type);
    }

    @Override
    public String getLanguageName() {
        return this.languageName;
    }

    @Override
    public Map<String, Object> getSharedData() {
        Stream<Map> codestartsGlobal = this.getCodestarts().stream().sorted(SHARED_DATA_MERGE_ORDER).map(c -> c.getSharedData(this.getLanguageName()));
        return NestedMaps.deepMerge(Stream.concat(codestartsGlobal, Stream.of(this.getProjectInput().getData())));
    }

    @Override
    public Map<String, Object> getDepsData() {
        return CodestartData.buildDependenciesData(this.getCodestarts().stream(), this.getLanguageName(), this.getProjectInput().getDependencies());
    }

    @Override
    public Map<String, Object> getCodestartProjectData() {
        return CodestartData.buildCodestartProjectData(this.getBaseCodestarts(), this.getExtraCodestarts());
    }

    @Override
    public List<Codestart> getBaseCodestarts() {
        return this.getCodestarts().stream().filter(c -> c.getSpec().getType().isBase()).collect(Collectors.toList());
    }

    @Override
    public List<Codestart> getExtraCodestarts() {
        return this.getCodestarts().stream().filter(c -> !c.getSpec().getType().isBase()).collect(Collectors.toList());
    }
}

