/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.graal;

import com.oracle.svm.core.annotate.AutomaticFeature;
import io.quarkus.runtime.ResourceHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class ResourcesFeature
implements Feature {
    public static final String META_INF_QUARKUS_NATIVE_RESOURCES_TXT = "META-INF/quarkus-native-resources.txt";

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(META_INF_QUARKUS_NATIVE_RESOURCES_TXT)));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) continue;
                ResourceHelper.registerResources(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

