/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.ReflectUtil;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class ConfigMappingUtils {
    public static final DotName CONFIG_MAPPING_NAME = DotName.createSimple((String)ConfigMapping.class.getName());

    private ConfigMappingUtils() {
    }

    public static void processConfigClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses, DotName configAnnotation) {
        for (AnnotationInstance instance : combinedIndex.getIndex().getAnnotations(configAnnotation)) {
            AnnotationTarget target = instance.target();
            AnnotationValue annotationPrefix = instance.value("prefix");
            if (!target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) continue;
            Class<?> configClass = ConfigMappingUtils.toClass(target.asClass().name());
            String prefix = Optional.ofNullable(annotationPrefix).map(AnnotationValue::asString).orElse("");
            ConfigClassBuildItem.Kind configClassKind = ConfigMappingUtils.getConfigClassType(instance);
            ConfigMappingUtils.processConfigClass(ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(configClass, (String)prefix), configClassKind, true, combinedIndex, generatedClasses, reflectiveClasses, configClasses);
        }
    }

    public static void processConfigMapping(CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses) {
        ConfigMappingUtils.processConfigClasses(combinedIndex, generatedClasses, reflectiveClasses, configClasses, CONFIG_MAPPING_NAME);
    }

    public static void processExtensionConfigMapping(ConfigMappings.ConfigClassWithPrefix configClass, CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses) {
        ConfigMappingUtils.processConfigClass(configClass, ConfigClassBuildItem.Kind.MAPPING, false, combinedIndex, generatedClasses, reflectiveClasses, configClasses);
    }

    private static void processConfigClass(ConfigMappings.ConfigClassWithPrefix configClassWithPrefix, ConfigClassBuildItem.Kind configClassKind, boolean isApplicationClass, CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses) {
        Class configClass = configClassWithPrefix.getKlass();
        String prefix = configClassWithPrefix.getPrefix();
        List configMappingsMetadata = ConfigMappingLoader.getConfigMappingsMetadata((Class)configClass);
        HashSet<String> generatedClassesNames = new HashSet<String>();
        configMappingsMetadata.forEach(mappingMetadata -> {
            generatedClassesNames.add(mappingMetadata.getClassName());
            generatedClasses.produce(new GeneratedClassBuildItem(isApplicationClass, mappingMetadata.getClassName(), mappingMetadata.getClassBytes()));
            reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mappingMetadata.getInterfaceType()).methods().build());
            reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mappingMetadata.getClassName()).methods().build());
            for (Class<?> parent : ConfigMappingUtils.getHierarchy(mappingMetadata.getInterfaceType())) {
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(parent).methods().build());
            }
            ConfigMappingUtils.processProperties(mappingMetadata.getInterfaceType(), reflectiveClasses);
        });
        configClasses.produce(new ConfigClassBuildItem(configClass, ConfigMappingUtils.collectTypes(combinedIndex, configClass), generatedClassesNames, prefix, configClassKind));
    }

    private static void processProperties(Class<?> configClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        ConfigMappingInterface mapping = ConfigMappingLoader.getConfigMapping(configClass);
        for (ConfigMappingInterface.Property property : mapping.getProperties()) {
            Class<?> returnType = property.getMethod().getReturnType();
            reflectiveClasses.produce(ReflectiveClassBuildItem.builder(returnType).methods().build());
            if (property.hasConvertWith()) {
                Class convertWith = property.isLeaf() ? property.asLeaf().getConvertWith() : property.asPrimitive().getConvertWith();
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(convertWith).build());
            }
            ConfigMappingUtils.registerImplicitConverter(property, reflectiveClasses);
            if (!property.isMap()) continue;
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            if (mapProperty.hasKeyConvertWith()) {
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mapProperty.getKeyConvertWith()).build());
            } else {
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mapProperty.getKeyRawType()).build());
            }
            ConfigMappingUtils.registerImplicitConverter(mapProperty.getValueProperty(), reflectiveClasses);
        }
    }

    private static void registerImplicitConverter(ConfigMappingInterface.Property property, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        if (property.isLeaf() && !property.isOptional()) {
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            if (leafProperty.hasConvertWith()) {
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(leafProperty.getConvertWith()).build());
            } else {
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(leafProperty.getValueRawType()).methods().build());
            }
        } else if (property.isOptional()) {
            ConfigMappingUtils.registerImplicitConverter((ConfigMappingInterface.Property)property.asOptional().getNestedProperty(), reflectiveClasses);
        } else if (property.isCollection()) {
            ConfigMappingUtils.registerImplicitConverter(property.asCollection().getElement(), reflectiveClasses);
        }
    }

    public static Object newInstance(Class<?> configClass) {
        if (configClass.isAnnotationPresent(ConfigMapping.class)) {
            return ReflectUtil.newInstance(ConfigMappingLoader.getImplementationClass(configClass));
        }
        return ReflectUtil.newInstance(configClass);
    }

    private static Class<?> toClass(DotName dotName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(dotName.toString());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (" + dotName + ") cannot be created during deployment.", e);
        }
    }

    private static ConfigClassBuildItem.Kind getConfigClassType(AnnotationInstance instance) {
        if (instance.name().equals((Object)CONFIG_MAPPING_NAME)) {
            return ConfigClassBuildItem.Kind.MAPPING;
        }
        return ConfigClassBuildItem.Kind.PROPERTIES;
    }

    private static List<Class<?>> getHierarchy(Class<?> mapping) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> i : mapping.getInterfaces()) {
            interfaces.add(i);
            interfaces.addAll(ConfigMappingUtils.getHierarchy(i));
        }
        return interfaces;
    }

    private static Set<Type> collectTypes(CombinedIndexBuildItem combinedIndex, Class<?> configClass) {
        DotName configIfaceName;
        IndexView index = combinedIndex.getIndex();
        ClassInfo configIfaceInfo = index.getClassByName(configIfaceName = DotName.createSimple((String)configClass.getName()));
        if (configIfaceInfo == null || configIfaceInfo.interfaceNames().isEmpty()) {
            return Collections.singleton(Type.create((DotName)configIfaceName, (Type.Kind)Type.Kind.CLASS));
        }
        HashSet<DotName> allIfaces = new HashSet<DotName>();
        allIfaces.add(configIfaceName);
        ConfigMappingUtils.collectInterfacesRec(configIfaceInfo, index, allIfaces);
        HashSet<Type> result = new HashSet<Type>(allIfaces.size());
        for (DotName iface : allIfaces) {
            result.add(Type.create((DotName)iface, (Type.Kind)Type.Kind.CLASS));
        }
        return result;
    }

    private static void collectInterfacesRec(ClassInfo current, IndexView index, Set<DotName> result) {
        List interfaces = current.interfaceNames();
        if (interfaces.isEmpty()) {
            return;
        }
        for (DotName iface : interfaces) {
            ClassInfo classByName = index.getClassByName(iface);
            if (classByName == null) continue;
            result.add(iface);
            ConfigMappingUtils.collectInterfacesRec(classByName, index, result);
        }
    }
}

