/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class ExecUtil {
    private static final Logger LOG = Logger.getLogger(ExecUtil.class);
    private static final Function<InputStream, Runnable> PRINT_OUTPUT = i -> new HandleOutput((InputStream)i);
    private static final Function<InputStream, Runnable> SILENT = i -> new HandleOutput((InputStream)i, Logger.Level.DEBUG);
    private static final int PROCESS_CHECK_INTERVAL = 500;

    public static boolean exec(String command, String ... args) {
        return ExecUtil.exec(new File("."), command, args);
    }

    public static boolean execWithTimeout(Duration timeout, String command, String ... args) {
        return ExecUtil.execWithTimeout(new File("."), timeout, command, args);
    }

    public static boolean execSilent(String command, String ... args) {
        return ExecUtil.execSilent(new File("."), command, args);
    }

    public static boolean execSilentWithTimeout(Duration timeout, String command, String ... args) {
        return ExecUtil.execSilentWithTimeout(new File("."), timeout, command, args);
    }

    public static boolean exec(File directory, String command, String ... args) {
        return ExecUtil.exec(directory, PRINT_OUTPUT, command, args);
    }

    public static boolean execWithTimeout(File directory, Duration timeout, String command, String ... args) {
        return ExecUtil.execWithTimeout(directory, PRINT_OUTPUT, timeout, command, args);
    }

    public static boolean execSilent(File directory, String command, String ... args) {
        return ExecUtil.exec(directory, SILENT, command, args);
    }

    public static boolean execSilentWithTimeout(File directory, Duration timeout, String command, String ... args) {
        return ExecUtil.execWithTimeout(directory, SILENT, timeout, command, args);
    }

    public static boolean exec(File directory, Function<InputStream, Runnable> outputFilterFunction, String command, String ... args) {
        try {
            Process process = ExecUtil.startProcess(directory, command, args);
            outputFilterFunction.apply(process.getInputStream());
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static boolean execWithTimeout(File directory, Function<InputStream, Runnable> outputFilterFunction, Duration timeout, String command, String ... args) {
        try {
            Process process = ExecUtil.startProcess(directory, command, args);
            Thread t = new Thread(outputFilterFunction.apply(process.getInputStream()));
            t.setName("Process stdout");
            t.setDaemon(true);
            t.start();
            process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
            ExecUtil.destroyProcess(process);
            return process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static Process startProcess(File directory, String command, String ... args) {
        try {
            String[] cmd = new String[args.length + 1];
            cmd[0] = command;
            if (args.length > 0) {
                System.arraycopy(args, 0, cmd, 1, args.length);
            }
            return new ProcessBuilder(new String[0]).directory(directory).command(cmd).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while executing command.", e);
        }
    }

    public static void destroyProcess(Process process) {
        process.destroy();
        int i = 0;
        while (process.isAlive() && i++ < 10) {
            try {
                process.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        if (process.isAlive()) {
            process.destroyForcibly();
        }
    }

    private static class HandleOutput
    implements Runnable {
        private final InputStream is;
        private final Logger.Level logLevel;

        HandleOutput(InputStream is) {
            this(is, Logger.Level.INFO);
        }

        HandleOutput(InputStream is, Logger.Level logLevel) {
            this.is = is;
            this.logLevel = LOG.isEnabled(logLevel) ? logLevel : null;
        }

        @Override
        public void run() {
            block14: {
                try (InputStreamReader isr = new InputStreamReader(this.is);
                     BufferedReader reader = new BufferedReader(isr);){
                    String line = reader.readLine();
                    while (line != null) {
                        if (this.logLevel != null) {
                            LOG.log(this.logLevel, (Object)line);
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    if (this.logLevel == null) break block14;
                    LOG.log(this.logLevel, (Object)"Failed to handle output", (Throwable)e);
                }
            }
        }
    }
}

