/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.logging;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ConsoleFormatterBannerBuildItem;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.LogConsoleFormatBuildItem;
import io.quarkus.deployment.builditem.LogHandlerBuildItem;
import io.quarkus.deployment.builditem.NamedLogHandlersBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.WebSocketLogHandlerBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.dev.ExceptionNotificationBuildItem;
import io.quarkus.deployment.dev.testing.TestSetupBuildItem;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.logging.LogStreamBuildItem;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.metrics.MetricsFactoryConsumerBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.dev.console.CurrentAppExceptionHighlighter;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.gizmo.AnnotationCreator;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.configuration.ConfigInstantiator;
import io.quarkus.runtime.console.ConsoleRuntimeConfig;
import io.quarkus.runtime.logging.CategoryBuildTimeConfig;
import io.quarkus.runtime.logging.CleanupFilterConfig;
import io.quarkus.runtime.logging.InheritableLevel;
import io.quarkus.runtime.logging.LogBuildTimeConfig;
import io.quarkus.runtime.logging.LogCleanupFilterElement;
import io.quarkus.runtime.logging.LogConfig;
import io.quarkus.runtime.logging.LogMetricsHandlerRecorder;
import io.quarkus.runtime.logging.LoggingSetupRecorder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.jboss.logmanager.EmbeddedConfigurator;

public final class LoggingResourceProcessor {
    private static final String LOGMANAGER_LOGGER_CLASS_NAME = "io.quarkus.runtime.generated.Target_org_jboss_logmanager_Logger";
    private static final String LOGGING_LOGGER_CLASS_NAME = "io.quarkus.runtime.generated.Target_org_jboss_logging_Logger";
    private static final String LOGGER_NODE_CLASS_NAME = "io.quarkus.runtime.generated.Target_org_jboss_logmanager_LoggerNode";
    private static final String MIN_LEVEL_COMPUTE_CLASS_NAME = "io.quarkus.runtime.generated.MinLevelCompute";
    private static final MethodDescriptor IS_MIN_LEVEL_ENABLED = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.MinLevelCompute", (String)"isMinLevelEnabled", Boolean.TYPE, (Object[])new Object[]{Integer.TYPE, String.class});
    private static final Logger log = Logger.getLogger(LoggingResourceProcessor.class);

    @BuildStep
    void setupLogFilters(BuildProducer<LogCleanupFilterBuildItem> filters) {
        filters.produce(new LogCleanupFilterBuildItem("org.jboss.threads", "JBoss Threads version"));
    }

    @BuildStep
    SystemPropertyBuildItem setProperty() {
        return new SystemPropertyBuildItem("java.util.logging.manager", "org.jboss.logmanager.LogManager");
    }

    @BuildStep
    void setUpDefaultLevels(List<LogCategoryBuildItem> categories, Consumer<RunTimeConfigurationDefaultBuildItem> configOutput) {
        for (LogCategoryBuildItem category : categories) {
            configOutput.accept(new RunTimeConfigurationDefaultBuildItem("quarkus.log.category.\"" + category.getCategory() + "\".level", category.getLevel().toString()));
        }
    }

    @BuildStep
    void setUpDefaultLogCleanupFilters(List<LogCleanupFilterBuildItem> logCleanupFilters, Consumer<RunTimeConfigurationDefaultBuildItem> configOutput) {
        for (LogCleanupFilterBuildItem logCleanupFilter : logCleanupFilters) {
            String startsWithClause = logCleanupFilter.getFilterElement().getMessageStarts().stream().map(s -> s.replace(",", "\\,")).collect(Collectors.joining(","));
            configOutput.accept(new RunTimeConfigurationDefaultBuildItem("quarkus.log.filter.\"" + logCleanupFilter.getFilterElement().getLoggerName() + "\".if-starts-with", startsWithClause));
            if (logCleanupFilter.getFilterElement().getTargetLevel() == null) continue;
            configOutput.accept(new RunTimeConfigurationDefaultBuildItem("quarkus.log.filter.\"" + logCleanupFilter.getFilterElement().getLoggerName() + "\".target-level", logCleanupFilter.getFilterElement().getTargetLevel().toString()));
        }
    }

    @BuildStep
    void miscSetup(Consumer<RuntimeInitializedClassBuildItem> runtimeInit, Consumer<NativeImageSystemPropertyBuildItem> systemProp, Consumer<ServiceProviderBuildItem> provider) {
        runtimeInit.accept(new RuntimeInitializedClassBuildItem("org.jboss.logmanager.formatters.TrueColorHolder"));
        systemProp.accept(new NativeImageSystemPropertyBuildItem("java.util.logging.manager", "org.jboss.logmanager.LogManager"));
        provider.accept(new ServiceProviderBuildItem(EmbeddedConfigurator.class.getName(), InitialConfigurator.class.getName()));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    LoggingSetupBuildItem setupLoggingRuntimeInit(LoggingSetupRecorder recorder, LogConfig log, LogBuildTimeConfig buildLog, Optional<WebSocketLogHandlerBuildItem> logStreamHandlerBuildItem, List<LogHandlerBuildItem> handlerBuildItems, List<NamedLogHandlersBuildItem> namedHandlerBuildItems, List<LogConsoleFormatBuildItem> consoleFormatItems, Optional<ConsoleFormatterBannerBuildItem> possibleBannerBuildItem, List<LogStreamBuildItem> logStreamBuildItems, LaunchModeBuildItem launchModeBuildItem, List<LogCleanupFilterBuildItem> logCleanupFilters) {
        if (!launchModeBuildItem.isAuxiliaryApplication() || launchModeBuildItem.getAuxiliaryDevModeType().orElse(null) == DevModeType.TEST_ONLY) {
            List handlers = handlerBuildItems.stream().map(LogHandlerBuildItem::getHandlerValue).collect(Collectors.toList());
            List namedHandlers = namedHandlerBuildItems.stream().map(NamedLogHandlersBuildItem::getNamedHandlersMap).collect(Collectors.toList());
            ConsoleFormatterBannerBuildItem bannerBuildItem = null;
            RuntimeValue<Optional<Supplier<String>>> possibleSupplier = null;
            if (possibleBannerBuildItem.isPresent()) {
                bannerBuildItem = possibleBannerBuildItem.get();
            }
            if (bannerBuildItem != null) {
                possibleSupplier = bannerBuildItem.getBannerSupplier();
            }
            RuntimeValue<Optional<Handler>> devUiLogHandler = null;
            if (logStreamHandlerBuildItem.isPresent()) {
                devUiLogHandler = logStreamHandlerBuildItem.get().getHandlerValue();
            }
            boolean alwaysEnableLogStream = false;
            if (!logStreamBuildItems.isEmpty()) {
                alwaysEnableLogStream = true;
            }
            recorder.initializeLogging(log, buildLog, alwaysEnableLogStream, devUiLogHandler, handlers, namedHandlers, consoleFormatItems.stream().map(LogConsoleFormatBuildItem::getFormatterValue).collect(Collectors.toList()), possibleSupplier, launchModeBuildItem.getLaunchMode());
            LogConfig logConfig = new LogConfig();
            ConfigInstantiator.handleObject((Object)logConfig);
            for (LogCleanupFilterBuildItem i : logCleanupFilters) {
                CleanupFilterConfig value = new CleanupFilterConfig();
                LogCleanupFilterElement filterElement = i.getFilterElement();
                value.ifStartsWith = filterElement.getMessageStarts();
                value.targetLevel = filterElement.getTargetLevel() == null ? org.jboss.logmanager.Level.DEBUG : filterElement.getTargetLevel();
                logConfig.filters.put(filterElement.getLoggerName(), value);
            }
            ConsoleRuntimeConfig crc = new ConsoleRuntimeConfig();
            ConfigInstantiator.handleObject((Object)crc);
            LoggingSetupRecorder.initializeBuildTimeLogging((LogConfig)logConfig, (LogBuildTimeConfig)buildLog, (ConsoleRuntimeConfig)crc, (LaunchMode)launchModeBuildItem.getLaunchMode());
            ((QuarkusClassLoader)Thread.currentThread().getContextClassLoader()).addCloseTask(new Runnable(){

                @Override
                public void run() {
                    InitialConfigurator.DELAYED_HANDLER.buildTimeComplete();
                }
            });
        }
        return new LoggingSetupBuildItem();
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    @Produce.List(value={@Produce(value=TestSetupBuildItem.class), @Produce(value=LogConsoleFormatBuildItem.class)})
    @Consume(value=ConsoleInstalledBuildItem.class)
    void setupStackTraceFormatter(ApplicationArchivesBuildItem item, EffectiveIdeBuildItem ideSupport, BuildSystemTargetBuildItem buildSystemTargetBuildItem, final List<ExceptionNotificationBuildItem> exceptionNotificationBuildItems, CuratedApplicationShutdownBuildItem curatedApplicationShutdownBuildItem) {
        ArrayList<IndexView> indexList = new ArrayList<IndexView>();
        for (ApplicationArchive i : item.getAllApplicationArchives()) {
            if (!i.getResolvedPaths().isSinglePath() || !Files.isDirectory(i.getResolvedPaths().getSinglePath(), new LinkOption[0])) continue;
            indexList.add(i.getIndex());
        }
        final CompositeIndex index = CompositeIndex.create(indexList);
        CurrentAppExceptionHighlighter.THROWABLE_FORMATTER = new BiConsumer<LogRecord, Consumer<LogRecord>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(LogRecord logRecord, Consumer<LogRecord> logRecordConsumer) {
                StackTraceElement lastUserCode = null;
                HashMap<Throwable, StackTraceElement[]> restore = new HashMap<Throwable, StackTraceElement[]>();
                for (Throwable c = logRecord.getThrown(); c != null; c = c.getCause()) {
                    StackTraceElement[] stackTrace = c.getStackTrace();
                    for (int i = 0; i < stackTrace.length; ++i) {
                        StackTraceElement elem = stackTrace[i];
                        if (index.getClassByName(DotName.createSimple((String)elem.getClassName())) == null) continue;
                        lastUserCode = stackTrace[i];
                        stackTrace[i] = new StackTraceElement(elem.getClassLoaderName(), elem.getModuleName(), elem.getModuleVersion(), "\u001b[4m\u001b[1m" + elem.getClassName() + "\u001b[24m\u001b[22m", elem.getMethodName(), elem.getFileName(), elem.getLineNumber());
                    }
                    restore.put(c, c.getStackTrace());
                    c.setStackTrace(stackTrace);
                }
                try {
                    logRecordConsumer.accept(logRecord);
                }
                finally {
                    for (Map.Entry entry : restore.entrySet()) {
                        ((Throwable)entry.getKey()).setStackTrace((StackTraceElement[])entry.getValue());
                    }
                }
                if (logRecord.getThrown() != null) {
                    for (ExceptionNotificationBuildItem i : exceptionNotificationBuildItems) {
                        i.getExceptionHandler().accept(logRecord.getThrown(), lastUserCode);
                    }
                }
            }
        };
        curatedApplicationShutdownBuildItem.addCloseTask(() -> {
            CurrentAppExceptionHighlighter.THROWABLE_FORMATTER = null;
        }, true);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupLoggingStaticInit(LoggingSetupRecorder recorder, LaunchModeBuildItem launchModeBuildItem) {
        if (!launchModeBuildItem.isAuxiliaryApplication()) {
            recorder.initializeLoggingForImageBuild();
        }
    }

    @BuildStep
    void setUpDarkeningDefault(Consumer<RunTimeConfigurationDefaultBuildItem> rtcConsumer) {
        rtcConsumer.accept(new RunTimeConfigurationDefaultBuildItem("quarkus.log.console.darken", "0"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerMetrics(LogMetricsHandlerRecorder recorder, LogBuildTimeConfig log, BuildProducer<MetricsFactoryConsumerBuildItem> metrics, BuildProducer<LogHandlerBuildItem> logHandler, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (metricsCapability.isPresent() && log.metricsEnabled) {
            recorder.initCounters();
            metrics.produce(new MetricsFactoryConsumerBuildItem(recorder.registerMetrics()));
            logHandler.produce(new LogHandlerBuildItem((RuntimeValue<Optional<Handler>>)recorder.getLogHandler()));
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void setUpMinLevelLogging(LogBuildTimeConfig log, BuildProducer<GeneratedClassBuildItem> generatedTraceLogger) {
        GeneratedClassGizmoAdaptor output = new GeneratedClassGizmoAdaptor(generatedTraceLogger, false);
        if (log.categories.isEmpty() || LoggingResourceProcessor.allMinLevelInfoOrHigher(log.minLevel.intValue(), log.categories)) {
            LoggingResourceProcessor.generateDefaultLoggers(log.minLevel, output);
        } else {
            LoggingResourceProcessor.generateCategoryMinLevelLoggers(log.categories, log.minLevel, output);
        }
    }

    private static boolean allMinLevelInfoOrHigher(int minLogLevel, Map<String, CategoryBuildTimeConfig> categories) {
        return categories.values().stream().allMatch(categoryConfig -> categoryConfig.minLevel.getLevel().intValue() >= minLogLevel);
    }

    private static void generateDefaultLoggers(Level minLevel, ClassOutput output) {
        LoggingResourceProcessor.generateDefaultLoggingLogger(minLevel, output);
        LoggingResourceProcessor.generateDefaultLoggerNode(output);
        LoggingResourceProcessor.generateLogManagerLogger(output, LoggingResourceProcessor.generateMinLevelDefault(minLevel.getName()));
    }

    private static void generateCategoryMinLevelLoggers(Map<String, CategoryBuildTimeConfig> categories, Level rootMinLevel, ClassOutput output) {
        LoggingResourceProcessor.generateMinLevelCompute(categories, rootMinLevel, output);
        LoggingResourceProcessor.generateDefaultLoggerNode(output);
        LoggingResourceProcessor.generateLogManagerLogger(output, LoggingResourceProcessor::generateMinLevelCheckCategory);
    }

    private static BranchResult generateMinLevelCheckCategory(MethodCreator method, FieldDescriptor nameAliasDescriptor) {
        ResultHandle levelIntValue = LoggingResourceProcessor.getParamLevelIntValue(method);
        ResultHandle nameAlias = method.readInstanceField(nameAliasDescriptor, method.getThis());
        return method.ifTrue(method.invokeStaticMethod(IS_MIN_LEVEL_ENABLED, new ResultHandle[]{levelIntValue, nameAlias}));
    }

    private static void generateMinLevelCompute(Map<String, CategoryBuildTimeConfig> categories, Level rootMinLevel, ClassOutput output) {
        try (ClassCreator cc = ClassCreator.builder().setFinal(true).className(MIN_LEVEL_COMPUTE_CLASS_NAME).classOutput(output).build();
             MethodCreator mc = cc.getMethodCreator(IS_MIN_LEVEL_ENABLED);){
            mc.setModifiers(8);
            ResultHandle level = mc.getMethodParam(0);
            ResultHandle name = mc.getMethodParam(1);
            MethodCreator current = mc;
            for (Map.Entry<String, CategoryBuildTimeConfig> entry : categories.entrySet()) {
                String category = entry.getKey();
                int categoryLevelIntValue = LoggingResourceProcessor.getLogMinLevel(entry.getKey(), entry.getValue(), categories, rootMinLevel).intValue();
                ResultHandle equalsResult = current.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{Object.class}), name, new ResultHandle[]{current.load(category)});
                BranchResult equalsBranch = current.ifTrue(equalsResult);
                try (BytecodeCreator false1 = equalsBranch.falseBranch();){
                    ResultHandle startsWithResult = false1.invokeVirtualMethod(MethodDescriptor.ofMethod(String.class, (String)"startsWith", Boolean.TYPE, (Class[])new Class[]{String.class}), name, new ResultHandle[]{false1.load(category + ".")});
                    BranchResult startsWithBranch = false1.ifTrue(startsWithResult);
                    BytecodeCreator startsWithTrue = startsWithBranch.trueBranch();
                    BranchResult levelCompareBranch = startsWithTrue.ifIntegerGreaterEqual(level, startsWithTrue.load(categoryLevelIntValue));
                    levelCompareBranch.trueBranch().returnValue(levelCompareBranch.trueBranch().load(true));
                    levelCompareBranch.falseBranch().returnValue(levelCompareBranch.falseBranch().load(false));
                    current = startsWithBranch.falseBranch();
                }
                equalsBranch.trueBranch().returnValue(equalsBranch.trueBranch().load(true));
            }
            ResultHandle infoLevelIntValue = LoggingResourceProcessor.getLogManagerLevelIntValue(rootMinLevel.toString(), (BytecodeCreator)current);
            BranchResult isInfoOrHigherBranch = current.ifIntegerGreaterEqual(level, infoLevelIntValue);
            isInfoOrHigherBranch.trueBranch().returnValue(isInfoOrHigherBranch.trueBranch().load(true));
            isInfoOrHigherBranch.falseBranch().returnValue(isInfoOrHigherBranch.falseBranch().load(false));
        }
    }

    private static Level getLogMinLevel(String categoryName, CategoryBuildTimeConfig categoryConfig, Map<String, CategoryBuildTimeConfig> categories, Level rootMinLevel) {
        if (Objects.isNull(categoryConfig)) {
            return rootMinLevel;
        }
        InheritableLevel inheritableLevel = categoryConfig.minLevel;
        if (!inheritableLevel.isInherited()) {
            return inheritableLevel.getLevel();
        }
        int lastDotIndex = categoryName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return rootMinLevel;
        }
        String parent = categoryName.substring(0, lastDotIndex);
        return LoggingResourceProcessor.getLogMinLevel(parent, categories.get(parent), categories, rootMinLevel);
    }

    private static void generateDefaultLoggerNode(ClassOutput output) {
        try (ClassCreator cc = ClassCreator.builder().setFinal(true).className(LOGGER_NODE_CLASS_NAME).classOutput(output).build();){
            AnnotationCreator targetClass = cc.addAnnotation("com.oracle.svm.core.annotate.TargetClass");
            targetClass.addValue("className", (Object)"org.jboss.logmanager.LoggerNode");
            MethodCreator isLoggableLevelMethod = cc.getMethodCreator("isLoggableLevel", Boolean.TYPE, new Class[]{Integer.TYPE});
            isLoggableLevelMethod.addAnnotation("com.oracle.svm.core.annotate.Alias");
            isLoggableLevelMethod.returnValue(isLoggableLevelMethod.load(false));
        }
    }

    private static void generateLogManagerLogger(ClassOutput output, BiFunction<MethodCreator, FieldDescriptor, BranchResult> isMinLevelEnabledFunction) {
        try (ClassCreator cc = ClassCreator.builder().setFinal(true).className(LOGMANAGER_LOGGER_CLASS_NAME).classOutput(output).build();){
            AnnotationCreator targetClass = cc.addAnnotation("com.oracle.svm.core.annotate.TargetClass");
            targetClass.addValue("className", (Object)"org.jboss.logmanager.Logger");
            FieldCreator nameAlias = cc.getFieldCreator("name", String.class);
            nameAlias.addAnnotation("com.oracle.svm.core.annotate.Alias");
            FieldCreator loggerNodeAlias = cc.getFieldCreator("loggerNode", LOGGER_NODE_CLASS_NAME);
            loggerNodeAlias.addAnnotation("com.oracle.svm.core.annotate.Alias");
            MethodCreator isLoggableMethod = cc.getMethodCreator("isLoggable", Boolean.TYPE, new Class[]{Level.class});
            isLoggableMethod.addAnnotation("com.oracle.svm.core.annotate.Substitute");
            ResultHandle levelIntValue = LoggingResourceProcessor.getParamLevelIntValue(isLoggableMethod);
            BranchResult levelBranch = isMinLevelEnabledFunction.apply(isLoggableMethod, nameAlias.getFieldDescriptor());
            BytecodeCreator levelTrue = levelBranch.trueBranch();
            levelTrue.returnValue(levelTrue.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)LOGGER_NODE_CLASS_NAME, (String)"isLoggableLevel", Boolean.TYPE, (Object[])new Object[]{Integer.TYPE}), levelTrue.readInstanceField(loggerNodeAlias.getFieldDescriptor(), levelTrue.getThis()), new ResultHandle[]{levelIntValue}));
            BytecodeCreator levelFalse = levelBranch.falseBranch();
            levelFalse.returnValue(levelFalse.load(false));
        }
    }

    private static ResultHandle getParamLevelIntValue(MethodCreator method) {
        ResultHandle level = method.getMethodParam(0);
        return method.invokeVirtualMethod(MethodDescriptor.ofMethod(Level.class, (String)"intValue", Integer.TYPE, (Class[])new Class[0]), level, new ResultHandle[0]);
    }

    private static BiFunction<MethodCreator, FieldDescriptor, BranchResult> generateMinLevelDefault(String defaultMinLevelName) {
        return (method, nameAliasDescriptor) -> {
            ResultHandle levelIntValue = LoggingResourceProcessor.getParamLevelIntValue(method);
            ResultHandle infoLevelIntValue = LoggingResourceProcessor.getLogManagerLevelIntValue(defaultMinLevelName, (BytecodeCreator)method);
            return method.ifIntegerGreaterEqual(levelIntValue, infoLevelIntValue);
        };
    }

    private static ResultHandle getLogManagerLevelIntValue(String levelName, BytecodeCreator method) {
        ResultHandle infoLevel = method.readStaticField(FieldDescriptor.of(org.jboss.logmanager.Level.class, (String)levelName, org.jboss.logmanager.Level.class));
        return method.invokeVirtualMethod(MethodDescriptor.ofMethod(Level.class, (String)"intValue", Integer.TYPE, (Class[])new Class[0]), infoLevel, new ResultHandle[0]);
    }

    private static void generateDefaultLoggingLogger(Level minLevel, ClassOutput output) {
        try (ClassCreator cc = ClassCreator.builder().setFinal(true).className(LOGGING_LOGGER_CLASS_NAME).classOutput(output).build();){
            AnnotationCreator targetClass = cc.addAnnotation("com.oracle.svm.core.annotate.TargetClass");
            targetClass.addValue("className", (Object)"org.jboss.logging.Logger");
            if (minLevel.intValue() >= org.jboss.logmanager.Level.INFO.intValue()) {
                LoggingResourceProcessor.generateFalseFoldMethod("isTraceEnabled", cc);
                LoggingResourceProcessor.generateFalseFoldMethod("isDebugEnabled", cc);
            } else if (minLevel.intValue() == org.jboss.logmanager.Level.DEBUG.intValue()) {
                LoggingResourceProcessor.generateFalseFoldMethod("isTraceEnabled", cc);
            }
        }
    }

    private static void generateFalseFoldMethod(String name, ClassCreator cc) {
        MethodCreator method = cc.getMethodCreator(name, Boolean.TYPE, new Class[0]);
        method.addAnnotation("com.oracle.svm.core.annotate.Substitute");
        method.addAnnotation("org.graalvm.compiler.api.replacements.Fold");
        method.returnValue(method.load(false));
    }
}

