/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.builder.Version;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.BytecodeRecorderObjectLoaderBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.JavaLibraryPathAdditionalPathBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.MainBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.ObjectSubstitutionBuildItem;
import io.quarkus.deployment.builditem.QuarkusApplicationClassBuildItem;
import io.quarkus.deployment.builditem.SslTrustStoreSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.StaticBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.NativeImageRuntimePropertiesRecorder;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.StartupContext;
import io.quarkus.runtime.StartupTask;
import io.quarkus.runtime.annotations.QuarkusMain;
import io.quarkus.runtime.configuration.ProfileManager;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.logmanager.handlers.DelayedHandler;

class MainClassBuildStep {
    static final String MAIN_CLASS = "io.quarkus.runner.GeneratedMain";
    static final String STARTUP_CONTEXT = "STARTUP_CONTEXT";
    static final String LOG = "LOG";
    static final String JAVA_LIBRARY_PATH = "java.library.path";
    static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final FieldDescriptor STARTUP_CONTEXT_FIELD = FieldDescriptor.of((String)"io.quarkus.runner.ApplicationImpl", (String)"STARTUP_CONTEXT", StartupContext.class);

    MainClassBuildStep() {
    }

    @BuildStep
    void build(List<StaticBytecodeRecorderBuildItem> staticInitTasks, List<ObjectSubstitutionBuildItem> substitutions, List<MainBytecodeRecorderBuildItem> mainMethod, List<SystemPropertyBuildItem> properties, List<JavaLibraryPathAdditionalPathBuildItem> javaLibraryPathAdditionalPaths, Optional<SslTrustStoreSystemPropertyBuildItem> sslTrustStoreSystemProperty, List<FeatureBuildItem> features, BuildProducer<ApplicationClassNameBuildItem> appClassNameProducer, List<BytecodeRecorderObjectLoaderBuildItem> loaders, BuildProducer<GeneratedClassBuildItem> generatedClass, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReloadBuildItem, ApplicationInfoBuildItem applicationInfo) {
        appClassNameProducer.produce(new ApplicationClassNameBuildItem("io.quarkus.runner.ApplicationImpl"));
        GeneratedClassGizmoAdaptor gizmoOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        ClassCreator file = new ClassCreator((ClassOutput)gizmoOutput, "io.quarkus.runner.ApplicationImpl", null, Application.class.getName(), new String[0]);
        FieldCreator logField = (FieldCreator)file.getFieldCreator(LOG, Logger.class).setModifiers(8);
        FieldCreator scField = file.getFieldCreator(STARTUP_CONTEXT_FIELD);
        scField.setModifiers(9);
        MethodCreator mv = file.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
        mv.setModifiers(9);
        for (SystemPropertyBuildItem i : properties) {
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(i.getKey()), mv.load(i.getValue())});
        }
        ResultHandle lm = mv.readStaticField(FieldDescriptor.of(LaunchMode.class, (String)launchMode.getLaunchMode().name(), LaunchMode.class));
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(ProfileManager.class, (String)"setLaunchMode", Void.TYPE, (Class[])new Class[]{LaunchMode.class}), new ResultHandle[]{lm});
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"staticInitStarted", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        mv.invokeStaticMethod(RunTimeConfigurationGenerator.C_ENSURE_INITIALIZED, new ResultHandle[0]);
        if (liveReloadBuildItem.isLiveReload()) {
            mv.invokeStaticMethod(RunTimeConfigurationGenerator.REINIT, new ResultHandle[0]);
        }
        mv.writeStaticField(logField.getFieldDescriptor(), mv.invokeStaticMethod(MethodDescriptor.ofMethod(Logger.class, (String)"getLogger", Logger.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.load("io.quarkus.application")}));
        ResultHandle startupContext = mv.newInstance(MethodDescriptor.ofConstructor(StartupContext.class, (Class[])new Class[0]), new ResultHandle[0]);
        mv.writeStaticField(scField.getFieldDescriptor(), startupContext);
        TryBlock tryBlock = mv.tryBlock();
        for (StaticBytecodeRecorderBuildItem staticBytecodeRecorderBuildItem : staticInitTasks) {
            this.writeRecordedBytecode(staticBytecodeRecorderBuildItem.getBytecodeRecorder(), null, substitutions, loaders, gizmoOutput, startupContext, (BytecodeCreator)tryBlock);
        }
        tryBlock.returnValue(null);
        CatchBlockCreator cb = tryBlock.addCatch(Throwable.class);
        cb.invokeStaticMethod(MethodDescriptor.ofMethod(ApplicationStateNotification.class, (String)"notifyStartupFailed", Void.TYPE, (Class[])new Class[]{Throwable.class}), new ResultHandle[]{cb.getCaughtException()});
        cb.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        cb.throwException(RuntimeException.class, "Failed to start quarkus", cb.getCaughtException());
        mv = file.getMethodCreator("doStart", Void.TYPE, new Class[]{String[].class});
        mv.setModifiers(20);
        for (SystemPropertyBuildItem systemPropertyBuildItem : properties) {
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(systemPropertyBuildItem.getKey()), mv.load(systemPropertyBuildItem.getValue())});
        }
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(NativeImageRuntimePropertiesRecorder.class, (String)"doRuntime", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        if (!javaLibraryPathAdditionalPaths.isEmpty()) {
            ResultHandle resultHandle = mv.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"getProperty", String.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.load(JAVA_LIBRARY_PATH)})});
            for (JavaLibraryPathAdditionalPathBuildItem javaLibraryPathAdditionalPath : javaLibraryPathAdditionalPaths) {
                ResultHandle javaLibraryPathLength = mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"length", Integer.TYPE, (Class[])new Class[0]), resultHandle, new ResultHandle[0]);
                mv.ifNonZero(javaLibraryPathLength).trueBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class}), resultHandle, new ResultHandle[]{mv.load(File.pathSeparator)});
                mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class}), resultHandle, new ResultHandle[]{mv.load(javaLibraryPathAdditionalPath.getPath())});
            }
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(JAVA_LIBRARY_PATH), mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"toString", String.class, (Class[])new Class[0]), resultHandle, new ResultHandle[0])});
        }
        if (sslTrustStoreSystemProperty.isPresent()) {
            ResultHandle resultHandle = mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"getProperty", String.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.load(JAVAX_NET_SSL_TRUST_STORE)});
            BytecodeCreator bytecodeCreator = mv.ifNonZero(mv.invokeStaticMethod(MethodDescriptor.ofMethod(ImageInfo.class, (String)"inImageRuntimeCode", Boolean.TYPE, (Class[])new Class[0]), new ResultHandle[0])).trueBranch();
            bytecodeCreator.ifNull(resultHandle).trueBranch().invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{bytecodeCreator.load(JAVAX_NET_SSL_TRUST_STORE), bytecodeCreator.load(sslTrustStoreSystemProperty.get().getPath())});
        }
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"mainStarted", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        startupContext = mv.readStaticField(scField.getFieldDescriptor());
        mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"setCommandLineArguments", Void.TYPE, (Class[])new Class[]{String[].class}), startupContext, new ResultHandle[]{mv.getMethodParam(0)});
        tryBlock = mv.tryBlock();
        for (MainBytecodeRecorderBuildItem mainBytecodeRecorderBuildItem : mainMethod) {
            this.writeRecordedBytecode(mainBytecodeRecorderBuildItem.getBytecodeRecorder(), mainBytecodeRecorderBuildItem.getGeneratedStartupContextClassName(), substitutions, loaders, gizmoOutput, startupContext, (BytecodeCreator)tryBlock);
        }
        ResultHandle resultHandle = tryBlock.load(features.stream().map(f -> f.getInfo()).sorted().collect(Collectors.joining(", ")));
        ResultHandle resultHandle2 = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(ProfileManager.class, (String)"getActiveProfile", String.class, (Class[])new Class[0]), new ResultHandle[0]);
        tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"printStartupTime", Void.TYPE, (Class[])new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.TYPE}), new ResultHandle[]{tryBlock.load(applicationInfo.getName()), tryBlock.load(applicationInfo.getVersion()), tryBlock.load(Version.getVersion()), resultHandle, resultHandle2, tryBlock.load(LaunchMode.DEVELOPMENT.equals((Object)launchMode.getLaunchMode()))});
        cb = tryBlock.addCatch(Throwable.class);
        cb.invokeVirtualMethod(MethodDescriptor.ofMethod(Logger.class, (String)"error", Void.TYPE, (Class[])new Class[]{Object.class, Throwable.class}), cb.readStaticField(logField.getFieldDescriptor()), new ResultHandle[]{cb.load("Failed to start application"), cb.getCaughtException()});
        ResultHandle delayedHandler = cb.readStaticField(FieldDescriptor.of(InitialConfigurator.class, (String)"DELAYED_HANDLER", DelayedHandler.class));
        ResultHandle isActivated = cb.invokeVirtualMethod(MethodDescriptor.ofMethod(DelayedHandler.class, (String)"isActivated", Boolean.TYPE, (Class[])new Class[0]), delayedHandler, new ResultHandle[0]);
        BytecodeCreator isActivatedFalse = cb.ifNonZero(isActivated).falseBranch();
        ResultHandle handlersArray = isActivatedFalse.newArray(Handler.class, 1);
        isActivatedFalse.writeArrayValue(handlersArray, 0, isActivatedFalse.newInstance(MethodDescriptor.ofConstructor(ConsoleHandler.class, (Class[])new Class[0]), new ResultHandle[0]));
        isActivatedFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(DelayedHandler.class, (String)"setHandlers", Handler[].class, (Class[])new Class[]{Handler[].class}), delayedHandler, new ResultHandle[]{handlersArray});
        isActivatedFalse.breakScope();
        cb.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        cb.throwException(RuntimeException.class, "Failed to start quarkus", cb.getCaughtException());
        mv.returnValue(null);
        mv = file.getMethodCreator("doStop", Void.TYPE, new Class[0]);
        mv.setModifiers(20);
        startupContext = mv.readStaticField(scField.getFieldDescriptor());
        mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        mv.returnValue(null);
        mv = file.getMethodCreator("getName", String.class, new Class[0]);
        mv.returnValue(mv.load(applicationInfo.getName()));
        file.close();
    }

    @BuildStep
    public MainClassBuildItem mainClassBuildStep(BuildProducer<GeneratedClassBuildItem> generatedClass, ApplicationArchivesBuildItem applicationArchivesBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, Optional<QuarkusApplicationClassBuildItem> quarkusApplicationClass, PackageConfig packageConfig) {
        String mainClassName = MAIN_CLASS;
        HashMap<String, String> quarkusMainAnnotations = new HashMap<String, String>();
        Collection quarkusMains = combinedIndexBuildItem.getIndex().getAnnotations(DotName.createSimple((String)QuarkusMain.class.getName()));
        for (AnnotationInstance i : quarkusMains) {
            AnnotationValue nameValue = i.value("name");
            String name = "";
            if (nameValue != null) {
                name = nameValue.asString();
            }
            if (quarkusMainAnnotations.containsKey(name)) {
                throw new RuntimeException("More than one @QuarkusMain method found with name '" + name + "': " + i.target().asClass().name() + " and " + (String)quarkusMainAnnotations.get(name));
            }
            quarkusMainAnnotations.put(name, i.target().asClass().name().toString());
        }
        if (packageConfig.mainClass.isPresent()) {
            String mainAnnotationClass = (String)quarkusMainAnnotations.get(packageConfig.mainClass.get());
            mainClassName = mainAnnotationClass != null ? mainAnnotationClass : packageConfig.mainClass.get();
        } else if (quarkusMainAnnotations.containsKey("")) {
            mainClassName = (String)quarkusMainAnnotations.get("");
        }
        if (mainClassName.equals(MAIN_CLASS)) {
            if (quarkusApplicationClass.isPresent()) {
                this.generateMainForQuarkusApplication(quarkusApplicationClass.get().getClassName(), generatedClass);
            } else {
                ClassCreator file = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true), MAIN_CLASS, null, Object.class.getName(), new String[0]);
                MethodCreator mv = file.getMethodCreator("main", Void.TYPE, new Class[]{String[].class});
                mv.setModifiers(9);
                mv.invokeStaticMethod(MethodDescriptor.ofMethod(Quarkus.class, (String)"run", Void.TYPE, (Class[])new Class[]{String[].class}), new ResultHandle[]{mv.getMethodParam(0)});
                mv.returnValue(null);
                file.close();
            }
        } else {
            Collection impls = combinedIndexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)QuarkusApplication.class.getName()));
            boolean found = false;
            for (ClassInfo i : impls) {
                if (!i.name().toString().equals(mainClassName)) continue;
                found = true;
                break;
            }
            if (found) {
                this.generateMainForQuarkusApplication(mainClassName, generatedClass);
                mainClassName = MAIN_CLASS;
            }
        }
        return new MainClassBuildItem(mainClassName);
    }

    private void generateMainForQuarkusApplication(String quarkusApplicationClassName, BuildProducer<GeneratedClassBuildItem> generatedClass) {
        ClassCreator file = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true), MAIN_CLASS, null, Object.class.getName(), new String[0]);
        MethodCreator mv = file.getMethodCreator("main", Void.TYPE, new Class[]{String[].class});
        mv.setModifiers(9);
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Quarkus.class, (String)"run", Void.TYPE, (Class[])new Class[]{Class.class, String[].class}), new ResultHandle[]{mv.loadClass(quarkusApplicationClassName), mv.getMethodParam(0)});
        mv.returnValue(null);
        file.close();
    }

    private void writeRecordedBytecode(BytecodeRecorderImpl recorder, String fallbackGeneratedStartupTaskClassName, List<ObjectSubstitutionBuildItem> substitutions, List<BytecodeRecorderObjectLoaderBuildItem> loaders, GeneratedClassGizmoAdaptor gizmoOutput, ResultHandle startupContext, BytecodeCreator bytecodeCreator) {
        if ((recorder == null || recorder.isEmpty()) && fallbackGeneratedStartupTaskClassName == null) {
            return;
        }
        if (recorder != null && !recorder.isEmpty()) {
            for (ObjectSubstitutionBuildItem sub : substitutions) {
                ObjectSubstitutionBuildItem.Holder<?, ?> holder1 = sub.holder;
                recorder.registerSubstitution(holder1.from, holder1.to, holder1.substitution);
            }
            for (BytecodeRecorderObjectLoaderBuildItem item : loaders) {
                recorder.registerObjectLoader(item.getObjectLoader());
            }
            recorder.writeBytecode(gizmoOutput);
        }
        ResultHandle dup = bytecodeCreator.newInstance(MethodDescriptor.ofConstructor((String)(recorder != null ? recorder.getClassName() : fallbackGeneratedStartupTaskClassName), (String[])new String[0]), new ResultHandle[0]);
        bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(StartupTask.class, (String)"deploy", Void.TYPE, (Class[])new Class[]{StartupContext.class}), dup, new ResultHandle[]{startupContext});
    }

    @BuildStep
    ReflectiveClassBuildItem applicationReflection() {
        return new ReflectiveClassBuildItem(false, false, "io.quarkus.runner.ApplicationImpl");
    }
}

