/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageSourceJarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarRequiredBuildItem;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jboss.logging.Logger;

public class JarResultBuildStep {
    private static final Set<String> IGNORED_ENTRIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("META-INF/INDEX.LIST", "META-INF/MANIFEST.MF", "module-info.class", "META-INF/LICENSE", "META-INF/LICENSE.txt", "META-INF/LICENSE.md", "META-INF/NOTICE", "META-INF/NOTICE.txt", "META-INF/NOTICE.md", "META-INF/README", "META-INF/README.txt", "META-INF/README.md", "META-INF/DEPENDENCIES", "META-INF/DEPENDENCIES.txt", "META-INF/beans.xml", "META-INF/io.netty.versions.properties", "META-INF/quarkus-config-roots.list", "META-INF/quarkus-javadoc.properties", "META-INF/quarkus-extension.properties", "META-INF/quarkus-extension.json", "META-INF/quarkus-extension.yaml", "META-INF/quarkus-deployment-dependency.graph", "META-INF/jandex.idx", "LICENSE")));
    private static final Logger log = Logger.getLogger(JarResultBuildStep.class);
    private static final OpenOption[] DEFAULT_OPEN_OPTIONS = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE};

    @BuildStep
    OutputTargetBuildItem outputTarget(BuildSystemTargetBuildItem bst, PackageConfig packageConfig) {
        String name = packageConfig.outputName.isPresent() ? packageConfig.outputName.get() : bst.getBaseName();
        Path path = packageConfig.outputDirectory.isPresent() ? bst.getOutputDirectory().resolve(packageConfig.outputDirectory.get()) : bst.getOutputDirectory();
        return new OutputTargetBuildItem(path, name);
    }

    @BuildStep(onlyIf={JarRequired.class})
    ArtifactResultBuildItem jarOutput(JarBuildItem jarBuildItem) {
        if (jarBuildItem.getLibraryDir() != null) {
            return new ArtifactResultBuildItem(jarBuildItem.getPath(), "jar", Collections.singletonMap("library-dir", jarBuildItem.getLibraryDir()));
        }
        return new ArtifactResultBuildItem(jarBuildItem.getPath(), "jar", Collections.emptyMap());
    }

    @BuildStep
    public JarBuildItem buildRunnerJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<UberJarRequiredBuildItem> uberJarRequired, List<GeneratedFileSystemResourceBuildItem> generatedFileSystemResources) throws Exception {
        if (!uberJarRequired.isEmpty() || packageConfig.uberJar) {
            return this.buildUberJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, generatedClasses, generatedResources, generatedFileSystemResources);
        }
        return this.buildThinJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, generatedClasses, generatedResources, generatedFileSystemResources);
    }

    private JarBuildItem buildUberJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<GeneratedFileSystemResourceBuildItem> generatedFileSystemResources) throws Exception {
        Path standardJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + ".jar");
        Path originalJar = null;
        if (standardJar.toFile().exists()) {
            originalJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + ".jar.original");
            Files.deleteIfExists(originalJar);
            Files.move(standardJar, originalJar, new CopyOption[0]);
        }
        Path runnerJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + packageConfig.runnerSuffix + ".jar");
        Files.deleteIfExists(runnerJar);
        try (final FileSystem runnerZipFs = ZipUtils.newZip((Path)runnerJar);){
            log.info((Object)("Building fat jar: " + runnerJar));
            AppModelResolver depResolver = curateOutcomeBuildItem.getResolver();
            final HashMap<String, String> seen = new HashMap<String, String>();
            final HashMap duplicateCatcher = new HashMap();
            StringBuilder classPath = new StringBuilder();
            final HashMap<String, List<byte[]>> services = new HashMap<String, List<byte[]>>();
            final HashSet<String> finalIgnoredEntries = new HashSet<String>(IGNORED_ENTRIES);
            packageConfig.userConfiguredIgnoredEntries.ifPresent(finalIgnoredEntries::addAll);
            List appDeps = curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
            AppArtifact appArtifact = curateOutcomeBuildItem.getEffectiveModel().getAppArtifact();
            this.generateManifest(runnerZipFs, classPath.toString(), packageConfig, appArtifact, applicationInfo);
            for (final AppDependency appDep : appDeps) {
                AppArtifact depArtifact = appDep.getArtifact();
                Path resolvedDep = depResolver.resolve(depArtifact);
                if (!resolvedDep.getFileName().toString().endsWith(".jar")) continue;
                final Set<String> transformedFromThisArchive = transformedClasses.getTransformedFilesByJar().get(resolvedDep);
                FileSystem artifactFs = ZipUtils.newFileSystem((Path)resolvedDep);
                Throwable throwable = null;
                try {
                    for (final Path root : artifactFs.getRootDirectories()) {
                        final Path metaInfDir = root.resolve("META-INF");
                        Files.walkFileTree(root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                String relativePath = JarResultBuildStep.toUri(root.relativize(dir));
                                if (!relativePath.isEmpty()) {
                                    JarResultBuildStep.this.addDir(runnerZipFs, relativePath);
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                boolean transformed;
                                String relativePath = JarResultBuildStep.toUri(root.relativize(file));
                                if (JarResultBuildStep.isBlockOrSF(relativePath) && file.relativize(metaInfDir).getNameCount() == 1) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Signature file " + file.toAbsolutePath() + " from app dependency " + appDep + " will not be included in uberjar"));
                                    }
                                    return FileVisitResult.CONTINUE;
                                }
                                boolean bl = transformed = transformedFromThisArchive != null && transformedFromThisArchive.contains(relativePath);
                                if (!transformed) {
                                    if (relativePath.startsWith("META-INF/services/") && relativePath.length() > 18) {
                                        services.computeIfAbsent(relativePath, u -> new ArrayList()).add(JarResultBuildStep.read(file));
                                        return FileVisitResult.CONTINUE;
                                    }
                                    if (!finalIgnoredEntries.contains(relativePath)) {
                                        duplicateCatcher.computeIfAbsent(relativePath, a -> new HashSet()).add(appDep);
                                        if (!seen.containsKey(relativePath)) {
                                            seen.put(relativePath, appDep.toString());
                                            Files.copy(file, runnerZipFs.getPath(relativePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                                        } else if (!relativePath.endsWith(".class")) {
                                            log.warn((Object)("Duplicate entry " + relativePath + " entry from " + appDep + " will be ignored. Existing file was provided by " + (String)seen.get(relativePath)));
                                        }
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (artifactFs == null) continue;
                    if (throwable != null) {
                        try {
                            artifactFs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    artifactFs.close();
                }
            }
            HashSet explained = new HashSet();
            for (Map.Entry entry : duplicateCatcher.entrySet()) {
                if (((Set)entry.getValue()).size() <= 1 || !explained.add(entry.getValue())) continue;
                log.warn((Object)("Dependencies with duplicate files detected. The dependencies " + entry.getValue() + " contain duplicate files, e.g. " + (String)entry.getKey()));
            }
            this.copyCommonContent(runnerZipFs, services, applicationArchivesBuildItem, transformedClasses, generatedClasses, generatedResources, seen);
        }
        runnerJar.toFile().setReadable(true, false);
        this.generateFileSystemResources(outputTargetBuildItem, generatedFileSystemResources);
        return new JarBuildItem(runnerJar, originalJar, null);
    }

    private JarBuildItem buildThinJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<GeneratedFileSystemResourceBuildItem> generatedFileSystemResources) throws Exception {
        Path runnerJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + packageConfig.runnerSuffix + ".jar");
        Path libDir = outputTargetBuildItem.getOutputDirectory().resolve("lib");
        Files.deleteIfExists(runnerJar);
        IoUtils.recursiveDelete((Path)libDir);
        Files.createDirectories(libDir, new FileAttribute[0]);
        try (FileSystem runnerZipFs = ZipUtils.newZip((Path)runnerJar);){
            log.info((Object)("Building thin jar: " + runnerJar));
            this.doThinJarGeneration(curateOutcomeBuildItem, transformedClasses, applicationArchivesBuildItem, applicationInfo, packageConfig, generatedResources, libDir, generatedClasses, runnerZipFs);
        }
        runnerJar.toFile().setReadable(true, false);
        this.generateFileSystemResources(outputTargetBuildItem, generatedFileSystemResources);
        return new JarBuildItem(runnerJar, null, libDir);
    }

    private void generateFileSystemResources(OutputTargetBuildItem outputTargetBuildItem, List<GeneratedFileSystemResourceBuildItem> generatedFileSystemResources) throws IOException {
        for (GeneratedFileSystemResourceBuildItem generatedFileSystemResource : generatedFileSystemResources) {
            Path outputPath = outputTargetBuildItem.getOutputDirectory().resolve(generatedFileSystemResource.getName());
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            OutputStream out = Files.newOutputStream(outputPath, new OpenOption[0]);
            Throwable throwable = null;
            try {
                out.write(generatedFileSystemResource.getData());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    @BuildStep
    public NativeImageSourceJarBuildItem buildNativeImageJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedNativeImageClassBuildItem> nativeImageResources, List<GeneratedResourceBuildItem> generatedResources) throws Exception {
        Path thinJarDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        IoUtils.recursiveDelete((Path)thinJarDirectory);
        Files.createDirectories(thinJarDirectory, new FileAttribute[0]);
        this.copyJsonConfigFiles(applicationArchivesBuildItem, thinJarDirectory);
        Path runnerJar = thinJarDirectory.resolve(outputTargetBuildItem.getBaseName() + packageConfig.runnerSuffix + ".jar");
        Path libDir = thinJarDirectory.resolve("lib");
        Files.createDirectories(libDir, new FileAttribute[0]);
        ArrayList<GeneratedClassBuildItem> allClasses = new ArrayList<GeneratedClassBuildItem>(generatedClasses);
        allClasses.addAll(nativeImageResources.stream().map(s -> new GeneratedClassBuildItem(true, s.getName(), s.getClassData())).collect(Collectors.toList()));
        try (FileSystem runnerZipFs = ZipUtils.newZip((Path)runnerJar);){
            log.info((Object)("Building native image source jar: " + runnerJar));
            this.doThinJarGeneration(curateOutcomeBuildItem, transformedClasses, applicationArchivesBuildItem, applicationInfo, packageConfig, generatedResources, libDir, allClasses, runnerZipFs);
        }
        runnerJar.toFile().setReadable(true, false);
        return new NativeImageSourceJarBuildItem(runnerJar, libDir);
    }

    private void copyJsonConfigFiles(ApplicationArchivesBuildItem applicationArchivesBuildItem, final Path thinJarDirectory) throws IOException {
        Path classesLocation = applicationArchivesBuildItem.getRootArchive().getArchiveLocation();
        Files.find(classesLocation, 1, new BiPredicate<Path, BasicFileAttributes>(){

            @Override
            public boolean test(Path path, BasicFileAttributes basicFileAttributes) {
                return basicFileAttributes.isRegularFile() && path.toString().endsWith(".json");
            }
        }, new FileVisitOption[0]).forEach(new Consumer<Path>(){

            @Override
            public void accept(Path jsonPath) {
                try {
                    Files.copy(jsonPath, thinJarDirectory.resolve(jsonPath.getFileName()), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to copy json config file from " + jsonPath + " to " + thinJarDirectory, e);
                }
            }
        });
    }

    private void doThinJarGeneration(CurateOutcomeBuildItem curateOutcomeBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedResourceBuildItem> generatedResources, Path libDir, List<GeneratedClassBuildItem> allClasses, FileSystem runnerZipFs) throws BootstrapDependencyProcessingException, AppModelResolverException, IOException {
        AppModelResolver depResolver = curateOutcomeBuildItem.getResolver();
        HashMap<String, String> seen = new HashMap<String, String>();
        StringBuilder classPath = new StringBuilder();
        HashMap<String, List<byte[]>> services = new HashMap<String, List<byte[]>>();
        List appDeps = curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
        this.copyLibraryJars(transformedClasses, libDir, depResolver, classPath, appDeps);
        AppArtifact appArtifact = curateOutcomeBuildItem.getEffectiveModel().getAppArtifact();
        this.generateManifest(runnerZipFs, classPath.toString(), packageConfig, appArtifact, applicationInfo);
        this.copyCommonContent(runnerZipFs, services, applicationArchivesBuildItem, transformedClasses, allClasses, generatedResources, seen);
    }

    private void copyLibraryJars(TransformedClassesBuildItem transformedClasses, Path libDir, AppModelResolver depResolver, StringBuilder classPath, List<AppDependency> appDeps) throws AppModelResolverException, IOException {
        for (AppDependency appDep : appDeps) {
            Path targetPath;
            String fileName;
            AppArtifact depArtifact = appDep.getArtifact();
            Path resolvedDep = depResolver.resolve(depArtifact);
            if (!resolvedDep.getFileName().toString().endsWith(".jar")) continue;
            Set<String> transformedFromThisArchive = transformedClasses.getTransformedFilesByJar().get(resolvedDep);
            if (transformedFromThisArchive == null || transformedFromThisArchive.isEmpty()) {
                fileName = depArtifact.getGroupId() + "." + resolvedDep.getFileName();
                targetPath = libDir.resolve(fileName);
                Files.copy(resolvedDep, targetPath, StandardCopyOption.REPLACE_EXISTING);
                classPath.append(" lib/" + fileName);
                continue;
            }
            fileName = "modified-" + depArtifact.getGroupId() + "." + resolvedDep.getFileName();
            targetPath = libDir.resolve(fileName);
            classPath.append(" lib/" + fileName);
            this.filterZipFile(resolvedDep, targetPath, transformedFromThisArchive);
        }
    }

    private void copyCommonContent(FileSystem runnerZipFs, Map<String, List<byte[]>> services, ApplicationArchivesBuildItem appArchives, TransformedClassesBuildItem transformedClassesBuildItem, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, Map<String, String> seen) throws IOException {
        Object out22;
        for (Set<TransformedClassesBuildItem.TransformedClass> set : transformedClassesBuildItem.getTransformedClassesByJar().values()) {
            for (TransformedClassesBuildItem.TransformedClass i : set) {
                Path target = runnerZipFs.getPath(i.getFileName(), new String[0]);
                this.handleParent(runnerZipFs, i.getFileName(), seen);
                out22 = ZipUtils.wrapForJDK8232879((OutputStream)Files.newOutputStream(target, DEFAULT_OPEN_OPTIONS));
                Throwable throwable = null;
                try {
                    ((OutputStream)out22).write(i.getData());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out22 != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)out22).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)out22).close();
                        }
                    }
                }
                seen.put(i.getFileName(), "Current Application");
            }
        }
        for (GeneratedClassBuildItem generatedClassBuildItem : generatedClasses) {
            String fileName = generatedClassBuildItem.getName().replace(".", "/") + ".class";
            seen.put(fileName, "Current Application");
            Path target = runnerZipFs.getPath(fileName, new String[0]);
            this.handleParent(runnerZipFs, fileName, seen);
            if (Files.exists(target, new LinkOption[0])) continue;
            OutputStream os = ZipUtils.wrapForJDK8232879((OutputStream)Files.newOutputStream(target, DEFAULT_OPEN_OPTIONS));
            out22 = null;
            try {
                os.write(generatedClassBuildItem.getClassData());
            }
            catch (Throwable throwable) {
                out22 = throwable;
                throw throwable;
            }
            finally {
                if (os == null) continue;
                if (out22 != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)out22).addSuppressed(throwable);
                    }
                    continue;
                }
                os.close();
            }
        }
        for (GeneratedResourceBuildItem generatedResourceBuildItem : generatedResources) {
            Path target = runnerZipFs.getPath(generatedResourceBuildItem.getName(), new String[0]);
            this.handleParent(runnerZipFs, generatedResourceBuildItem.getName(), seen);
            if (Files.exists(target, new LinkOption[0])) continue;
            if (generatedResourceBuildItem.getName().startsWith("META-INF/services")) {
                services.computeIfAbsent(generatedResourceBuildItem.getName(), u -> new ArrayList()).add(generatedResourceBuildItem.getClassData());
                continue;
            }
            OutputStream os = ZipUtils.wrapForJDK8232879((OutputStream)Files.newOutputStream(target, DEFAULT_OPEN_OPTIONS));
            Object object = null;
            try {
                os.write(generatedResourceBuildItem.getClassData());
            }
            catch (Throwable out22) {
                object = out22;
                throw out22;
            }
            finally {
                if (os == null) continue;
                if (object != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable out22) {
                        ((Throwable)object).addSuppressed(out22);
                    }
                    continue;
                }
                os.close();
            }
        }
        this.copyFiles(appArchives.getRootArchive().getArchiveRoot(), runnerZipFs, services);
        for (Map.Entry entry : services.entrySet()) {
            OutputStream os = ZipUtils.wrapForJDK8232879((OutputStream)Files.newOutputStream(runnerZipFs.getPath((String)entry.getKey(), new String[0]), DEFAULT_OPEN_OPTIONS));
            Throwable throwable = null;
            try {
                for (byte[] i : (List)entry.getValue()) {
                    os.write(i);
                    os.write(10);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (os == null) continue;
                if (throwable != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                os.close();
            }
        }
    }

    private void handleParent(FileSystem runnerZipFs, String fileName, Map<String, String> seen) throws IOException {
        for (int i = 0; i < fileName.length(); ++i) {
            String dir;
            if (fileName.charAt(i) != '/' || seen.containsKey(dir = fileName.substring(0, i))) continue;
            seen.put(dir, "Current Application");
            Files.createDirectories(runnerZipFs.getPath(dir, new String[0]), new FileAttribute[0]);
        }
    }

    private void filterZipFile(Path resolvedDep, Path targetPath, Set<String> transformedFromThisArchive) {
        try {
            byte[] buffer = new byte[10000];
            try (ZipFile in = new ZipFile(resolvedDep.toFile());
                 ZipOutputStream out = new ZipOutputStream(new FileOutputStream(targetPath.toFile()));){
                Enumeration<? extends ZipEntry> entries = in.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (transformedFromThisArchive.contains(entry.getName())) continue;
                    out.putNextEntry(entry);
                    InputStream inStream = in.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        int r = 0;
                        while ((r = inStream.read(buffer)) > 0) {
                            out.write(buffer, 0, r);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inStream == null) continue;
                        if (throwable != null) {
                            try {
                                inStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateManifest(FileSystem runnerZipFs, String classPath, PackageConfig config, AppArtifact appArtifact, ApplicationInfoBuildItem applicationInfo) throws IOException {
        String existingMainClass;
        Path manifestPath = runnerZipFs.getPath("META-INF", "MANIFEST.MF");
        Manifest manifest = new Manifest();
        if (Files.exists(manifestPath, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(manifestPath, new OpenOption[0]);){
                manifest.read(is);
            }
            Files.delete(manifestPath);
        } else {
            Files.createDirectories(runnerZipFs.getPath("META-INF", new String[0]), new FileAttribute[0]);
        }
        Files.createDirectories(manifestPath.getParent(), new FileAttribute[0]);
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (attributes.containsKey(Attributes.Name.CLASS_PATH)) {
            log.warn((Object)"Your MANIFEST.MF already defined a CLASS_PATH entry. Quarkus has overwritten this existing entry.");
        }
        attributes.put(Attributes.Name.CLASS_PATH, classPath);
        if (attributes.containsKey(Attributes.Name.MAIN_CLASS) && !config.mainClass.equals(existingMainClass = attributes.getValue(Attributes.Name.MAIN_CLASS))) {
            log.warn((Object)"Your MANIFEST.MF already defined a MAIN_CLASS entry. Quarkus has overwritten your existing entry.");
        }
        attributes.put(Attributes.Name.MAIN_CLASS, config.mainClass);
        if (config.manifest.addImplementationEntries && !attributes.containsKey(Attributes.Name.IMPLEMENTATION_TITLE)) {
            String name = "<<unset>>".equals(applicationInfo.getName()) ? appArtifact.getArtifactId() : applicationInfo.getName();
            attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, name);
        }
        if (config.manifest.addImplementationEntries && !attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
            String version = "<<unset>>".equals(applicationInfo.getVersion()) ? appArtifact.getVersion() : applicationInfo.getVersion();
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, version);
        }
        try (OutputStream os = ZipUtils.wrapForJDK8232879((OutputStream)Files.newOutputStream(manifestPath, DEFAULT_OPEN_OPTIONS));){
            manifest.write(os);
        }
    }

    private void copyFiles(final Path dir, final FileSystem fs, final Map<String, List<byte[]>> services) throws IOException {
        try (Stream<Path> fileTreeElements = Files.walk(dir, new FileVisitOption[0]);){
            fileTreeElements.forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    block8: {
                        Path file = dir.relativize(path);
                        String relativePath = JarResultBuildStep.toUri(file);
                        if (relativePath.isEmpty()) {
                            return;
                        }
                        try {
                            if (Files.isDirectory(path, new LinkOption[0])) {
                                JarResultBuildStep.this.addDir(fs, relativePath);
                                break block8;
                            }
                            if (relativePath.startsWith("META-INF/services/") && relativePath.length() > 18) {
                                byte[] content;
                                try {
                                    content = Files.readAllBytes(path);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                services.computeIfAbsent(relativePath, u -> new ArrayList()).add(content);
                                break block8;
                            }
                            Path target = fs.getPath(relativePath, new String[0]);
                            if (!Files.exists(target, new LinkOption[0])) {
                                Files.copy(path, target, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw re;
        }
    }

    private void addDir(FileSystem fs, String relativePath) throws IOException, FileAlreadyExistsException {
        block2: {
            Path targetDir = fs.getPath(relativePath, new String[0]);
            try {
                Files.createDirectory(targetDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    private static byte[] read(Path p) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try (InputStream in = Files.newInputStream(p, new OpenOption[0]);){
            int r;
            while ((r = in.read(buffer)) > 0) {
                out.write(buffer, 0, r);
            }
        }
        return out.toByteArray();
    }

    private static String toUri(Path path) {
        if (path.isAbsolute()) {
            return path.toUri().getPath();
        }
        if (path.getNameCount() == 0) {
            return "";
        }
        return JarResultBuildStep.toUri(new StringBuilder(), path, 0).toString();
    }

    private static StringBuilder toUri(StringBuilder b, Path path, int seg) {
        b.append(path.getName(seg));
        if (seg < path.getNameCount() - 1) {
            b.append('/');
            JarResultBuildStep.toUri(b, path, seg + 1);
        }
        return b;
    }

    static boolean isBlockOrSF(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(".SF") || s.endsWith(".DSA") || s.endsWith(".RSA") || s.endsWith(".EC");
    }

    static class JarRequired
    implements BooleanSupplier {
        private final PackageConfig packageConfig;

        JarRequired(PackageConfig packageConfig) {
            this.packageConfig = packageConfig;
        }

        @Override
        public boolean getAsBoolean() {
            return this.packageConfig.type.equalsIgnoreCase("jar");
        }
    }
}

